

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyToAppInsertXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyToAppInsertXML.sp,v $ $Id: archCopyToAppInsertXML.sp,v 1.1.2.5 2020/03/05 00:44:06 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopyToAppInsertXML')
BEGIN
	print '>>> Drop Stored Procedure: archCopyToAppInsertXML <<<'
	drop procedure archCopyToAppInsertXML
END
IF EXISTS (select * from GxQscripts where name='archCopyToAppInsertXML')
	delete from GxQscripts where name = 'archCopyToAppInsertXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyToAppInsertXML')
	delete from GXDBVersions where aliasname = 'archCopyToAppInsertXML'
GO
print '... Creating Procedure: archCopyToAppInsertXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archCopyToAppInsertXML
  @copyId integer,
  @inpXML XML
AS
BEGIN
	DECLARE @matchedRows INTEGER = 0
	DECLARE @insertedRows INTEGER = 0
	IF object_id('tempdb.dbo.#AppToCopy') IS NOT NULL DROP TABLE #AppToCopy
	CREATE TABLE #AppToCopy (clientId int, appTypeId int, instanceId int, backupSetId int, subClientId int, clientGroupId int default 0,exclude int default 0, assocType int default 0)
	INSERT INTO #AppToCopy
	SELECT ISNULL(N.value(N'(@clientId)[1]', N'int'),0) as clientId, ISNULL(N.value(N'(@applicationId)[1]', N'int'),0) as appTypeId, ISNULL(N.value(N'(@instanceId)[1]', N'int'),0) as instanceId,
	ISNULL(N.value(N'(@backupsetId)[1]', N'int'),0) as backupSetId, ISNULL(N.value(N'(@subclientId)[1]', N'int'),0) as subclientId, ISNULL(N.value(N'(@clientGroupId)[1]', N'int'),0) as clientGroupId,
	CASE WHEN ISNULL(N.value(N'(flags/@exclude)[1]', N'int'),0) > 0 THEN 1 ELSE 0 END, ISNULL(N.value(N'(@_type_)[1]', N'int'),0) as assocType
	FROM	@inpXML.nodes('/App_ArchGroupCopySubset/entities') AS T(N)
	SET @insertedRows = @@ROWCOUNT
	DELETE FROM #AppToCopy
	WHERE (subClientId|backupSetId|instanceId|appTypeId|clientId|clientGroupId|exclude|assocType) = 0
	-- Verify that something changed
	IF EXISTS(
		SELECT clientId, appTypeId,	instanceId,	backupSetId, subClientId, clientGroupId, exclude, assocType FROM  archCopyToApp WITH (NOLOCK) WHERE copyID = @copyId
		EXCEPT
		SELECT * FROM  #AppToCopy
		)
		OR EXISTS
		(
		SELECT * FROM  #AppToCopy
		EXCEPT
		SELECT clientId, appTypeId,	instanceId,	backupSetId, subClientId, clientGroupId, exclude, assocType FROM  archCopyToApp WITH (NOLOCK) WHERE copyID = @copyId
		)
		AND @insertedRows > 0		-- for handling the case when ok button was pressed without opening associations tab
		EXEC archCopyToAppInsert @copyId --uses #appToCopy
	ELSE
		SELECT '', '','', '', '', '', '', '', 0, 0, 1
	IF object_id('tempdb.dbo.#AppToCopy') IS NOT NULL DROP TABLE #AppToCopy
END

IF EXISTS (select * from GxQscripts where name = 'archCopyToAppInsertXML')
	delete from GxQscripts where name = 'archCopyToAppInsertXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyToAppInsertXML')
	delete from GXDBVersions where aliasname = 'archCopyToAppInsertXML'
GO

insert into GXDBVersions values(2, 'archCopyToAppInsertXML',  '00010001000200050000', 'archCopyToAppInsertXML', '00010001000200050000')
GO

