

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyToAppInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyToAppInsert.sp,v $ $Id: archCopyToAppInsert.sp,v 1.6.86.15 2020/03/30 23:29:28 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopyToAppInsert')
BEGIN
	print '>>> Drop Stored Procedure: archCopyToAppInsert <<<'
	drop procedure archCopyToAppInsert
END
IF EXISTS (select * from GxQscripts where name='archCopyToAppInsert')
	delete from GxQscripts where name = 'archCopyToAppInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyToAppInsert')
	delete from GXDBVersions where aliasname = 'archCopyToAppInsert'
GO
print '... Creating Procedure: archCopyToAppInsert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCopyToAppInsert
  @i_copyId integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #AppToCopy (
	clientId int, appTypeId int, instanceId int, backupSetId int, subClientId int, clientGroupId int default 0,exclude int default 0, assocType int default 0)
*/
IF OBJECT_ID('tempdb..#archCopyToAppOld') IS NOT NULL DROP TABLE #archCopyToAppOld
CREATE TABLE #archCopyToAppOld
(
    clientId        integer,
    appTypeId       integer,
    instanceId      integer,
    backupSetId     integer,
    subClientId     integer,
    clientGroupId   integer default 0,
    exclude         integer default 0,
    assocType       integer default 0
);;
CREATE CLUSTERED INDEX archCopyToAppOld_copyId_clientId_Idx ON #archCopyToAppOld(clientId);;
DECLARE @appSubSet TABLE( clientId INT, clientName NVARCHAR(MAX), netHostName NVARCHAR(MAX),
	appTypeId INT, appTypeName NVARCHAR(MAX), instance INT, instanceName NVARCHAR(MAX),
	backupset INT, backupsetName NVARCHAR(MAX), subId INT, subclientName NVARCHAR(MAX), isSelected INT )
SET	@retVal = 0
DECLARE @l_srcCopyId int
DECLARE @l_archGroupId INT
DECLARE @l_extendedFlags BIGINT
DECLARE @countRows INT
DECLARE @sumAssocType INT
DECLARE @xmlSTR VARCHAR(MAX)
DECLARE @xmlInpToGetAssoc XML
SELECT	@l_srcCopyId = sourceCopyId, @l_archGroupId = archGroupId , @l_extendedFlags =  extendedFlags
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	id = @i_copyId
IF ( @l_srcCopyId > 0 ) OR  EXISTS (SELECT 1 FROM archGroupCopy WITH (READUNCOMMITTED) WHERE sourceCopyId = @i_copyId)
BEGIN
	INSERT @appSubSet
	EXEC archCopyAppSubSet 	0, @l_archGroupId
END
if object_id('tempdb.dbo.#copyIdToProcess') is not null DROP TABLE #copyIdToProcess
CREATE TABLE #copyIdToProcess ( copyId  INTEGER,  isExclusionList INTEGER  DEFAULT(0), srcCopyId INTEGER DEFAULT(0) primary key 	(copyId))
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
CREATE TABLE #archCopyToAppId (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
if object_id('tempdb.dbo.#archCopyToAppIdTemp') is not null DROP TABLE #archCopyToAppIdTemp
CREATE TABLE #archCopyToAppIdTemp (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppIdTemp (copyId,AppId)
if object_id('tempdb.dbo.#misMatchingSrcDstMaps') is not null DROP TABLE #misMatchingSrcDstMaps
CREATE TABLE #misMatchingSrcDstMaps (
srcCopyId	INTEGER,
dstCopyId	INTEGER,
subClientId INTEGER
)
IF OBJECT_ID('tempdb..#tmpDisabledJob') IS NOT NULL
	DROP TABLE #tmpDisabledJob
CREATE TABLE #tmpDisabledJob
(		jobId 				INT,
		archGrpId 		INT,
		archGrpCopyId INT,
		dataType 			INT,
		commCellId 		INT,
		pickForCopy		INT,
    PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId)
)
SELECT @countRows = COUNT(*), @sumAssocType = SUM(assocType)
FROM #AppToCopy
SET @xmlInpToGetAssoc  = (
select
		clientId '@clientId',
		appTypeId '@applicationId',
		instanceId '@instanceId',
		backupsetId '@backupsetId',
		subclientId '@subclientId',
		clientGroupId '@clientGroupId',
				assocType '@_type_',
		exclude 'flags/@exclude',
		1-exclude 'flags/@include'
FROM #AppToCopy
FOR XML PATH('listEntities'), ROOT ('App_ArchGroupCopySubset')
)
SET @xmlSTR = CONVERT( varchar(MAX),@xmlInpToGetAssoc)
-- If the source copy's assocition is not for all backups,
-- do this only if something is not associated
IF	@l_srcCopyId > 0 AND
	EXISTS (SELECT 1 FROM archCopyToApp WHERE copyId = @l_srcCopyId AND assocType <> 2) AND
	(
		EXISTS (SELECT 1 FROM #AppToCopy WHERE (subClientId|backupSetId|instanceId|appTypeId|clientId|clientGroupId|exclude) <> 0)
		OR @countRows > 2 OR @sumAssocType NOT IN (2,29)
	)
BEGIN
	-- If the new assocition is not for all backups,
	-- Return an error when some subclient in #AppToCopy is not associated to the source copy.
	INSERT INTO #copyIdToProcess (copyId)
	SELECT @l_srcCopyId
	-- get associations for new assocs on this copy by using xml input
	exec archGetArchCopyToAppAssociations 0, @xmlSTR
	INSERT INTO #archCopyToAppIdTemp
	SELECT *
	FROM #archCopyToAppId
	exec archGetArchCopyToAppAssociations 0
	IF((SELECT COUNT(*) FROM #archCopyToAppIdTemp) <> (SELECT COUNT(*) FROM #archCopyToAppId))
	BEGIN
SET	@retVal = 64
		--GOTO FINISH
		-- store the missing entity tree in a temp table to be outputed later
		INSERT INTO #misMatchingSrcDstMaps
		SELECT @l_srcCopyId, @i_copyId, AIT.appId
		FROM  #archCopyToAppIdTemp AIT LEFT JOIN #archCopyToAppId AI ON AIT.copyID = AI.copyId AND AIT.appId = AI.appId
		WHERE AI.appId IS NULL
	END
END
ELSE
BEGIN
	-- If the new assocition is for all backups, insert source copy's association.
	IF(
		 NOT EXISTS (SELECT 1 FROM #AppToCopy WHERE (subClientId|backupSetId|instanceId|appTypeId|clientId|clientGroupId|exclude) <> 0)
		 AND @countRows <= 2 AND @sumAssocType  IN (2,29)
	  )
	BEGIN
		DELETE	FROM archCopyToApp
		WHERE	copyId = @i_copyId
		IF(@l_srcCopyId > 0)
			INSERT	INTO archCopyToApp -- if we make it till this line, then the only row in source would be where everything except copyId is 0
			SELECT	@i_copyId, clientId, appTypeId, instanceId, backupSetId, subClientId, clientGroupId, exclude, assocType
			FROM	archCopyToApp
			WHERE	copyId = @l_srcCopyId
		GOTO FINISH
	END
END
/*PrasadNara 4:50 PM 7/30/2012 MR#79114
 *App to Secondary Copy assoication is depends on the data in source copy
 *Below condition will fail in case
 * Copy1 <- Copy2 <-Copy3
 * 1. Intially all copies have data of clients CN1, CN2, CN3
 * 2. CN3 data got pruned in Copy1
 * 3. Now if we open Copy2 properties we show only CN1 and CN2 since it's source copy Copy1 has data of CN1 and CN2 only.
 * 4. If we try to change anything on Copy2 will fail since GUI sends CN1, CN2 to the server and
 *    server thinks that CN2 is unselected and it finds it's destination copy Copy3 has association with CN3
 * There is no harm if we skip below checking
 */
-- Return an error when some subclient associated to a destination copy is not in #AppToCopy.
IF	(
		EXISTS (SELECT 1 FROM #AppToCopy WHERE (subClientId|backupSetId|instanceId|appTypeId|clientId|clientGroupId|exclude) <> 0)
		OR @countRows > 2 OR @sumAssocType NOT IN (2,29)
	)
AND EXISTS (SELECT 1 FROM archGroupCopy WITH (READUNCOMMITTED) WHERE sourceCopyId = @i_copyId)
BEGIN
	DELETE FROM #copyIdToProcess
	DELETE FROM #archCopyToAppId
	DELETE FROM #archCopyToAppIdTemp
	INSERT INTO #copyIdToProcess (copyId)
	SELECT id
	FROM archGroupCopy WITH (READUNCOMMITTED)
	WHERE sourceCopyId = @i_copyId
AND type <> 5
AND flags & 524288 = 0
AND extendedFlags & 8 = 0
		AND isMirrorCopy = 0
		--AND EXISTS (SELECT 1 FROM archCopyToApp WHERE copyId = id AND assocType <> 2) -- ignore those copies where everything is selected)
	exec archGetArchCopyToAppAssociations 0
	INSERT INTO #archCopyToAppIdTemp -- these will be the apps on respective destCopies
	SELECT *
	FROM #archCopyToAppId
	-- remove excluded and non selected nodes on current copy that is source to other tert copies
	exec archGetArchCopyToAppAssociations 0, @xmlSTR
	DELETE #archCopyToAppIdTemp
	FROM #archCopyToAppIdTemp dest, #archCopyToAppId cur
	WHERE dest.appID = cur.appId and dest.copyId = cur.copyId
	IF EXISTS (SELECT 1	FROM #archCopyToAppIdTemp ) --something was deleted
	BEGIN
SET	@retVal = 64
		--GOTO FINISH
		INSERT INTO #misMatchingSrcDstMaps
		SELECT DISTINCT @i_copyId, AIT.copyId, AIT.appId
		FROM  #archCopyToAppIdTemp AIT
	END
END
-- capture the contents of archCopyToapp here
INSERT INTO #archCopyToAppOld
SELECT clientId, appTypeId, instanceId, backupSetId, subClientId, clientGroupId, exclude, assocType
FROM archCopyToApp WITH (READUNCOMMITTED)
WHERE	copyId = @i_copyId
IF @@ROWCOUNT = 0
BEGIN
	INSERT INTO #archCopyToAppOld
	SELECT 0, 0, 0, 0, 0, 0, 0, 2
	UNION
	SELECT 0, 0, 0, 0, 0, 0, 0, 27
END
DELETE	FROM archCopyToApp
WHERE	copyId = @i_copyId
IF	EXISTS (SELECT 1 FROM #AppToCopy WHERE (subClientId|backupSetId|instanceId|appTypeId|clientId|clientGroupId|exclude) <> 0)
	OR @countRows > 2 OR @sumAssocType NOT IN (2,29) -- we don't need to add anything in case of -> all CG and all clients, and just all clients
BEGIN
	INSERT	INTO archCopyToApp
	SELECT	@i_copyId, clientId, appTypeId, instanceId, backupSetId, subClientId, clientGroupId, exclude, assocType
	FROM	#AppToCopy
	DELETE FROM #copyIdToProcess
	DELETE FROM #archCopyToAppId
	INSERT INTO #copyIdToProcess (copyId)
	SELECT	@i_copyId
	exec archGetArchCopyToAppAssociations 0
	DECLARE @l_now	int
	SET		@l_now = dbo.GetUnixTime(GETUTCDATE())
UPDATE	JMJobDataStats SET disabled = (disabled | 1), modifiedTime = @l_now
	OUTPUT  INSERTED.JobId, INSERTED.archGrpId, INSERTED.archGrpCopyId, INSERTED.dataType, INSERTED.commCellId, 0
	INTO #tmpDisabledJob
	FROM	JMJobDataStats jds INNER JOIN #copyIdToProcess c ON c.copyId = jds.archGrpCopyId LEFT OUTER JOIN #archCopyToAppId t ON t.appId = jds.appId AND t.copyId = jds.archGrpCopyId
	WHERE	archGrpCopyId = @i_copyId
AND status IN (101, 102, 103) AND (disabled & (1 + 256)) = 0
		AND t.appId IS NULL
	--Repick linked VSA V2 parent jobs if VM jobs are picked
	UPDATE #tmpDisabledJob
	SET pickForCopy = 1
	FROM #tmpDisabledJob T, JMJobDataLink JDL WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE T.jobId = JDL.parentJobId
	AND		T.commcellId = JDL.commcellId
AND 	JDL.linkType IN (7, 8)
	AND		JDL.childJobId = JDS.jobId
	AND		JDL.commcellId = JDS.commcellId
	AND		JDS.archGrpCopyId = T.archGrpCopyId
AND		JDS.disabled & 256 = 0
AND 	((JDS.status = 100) OR (JDS.status IN (101, 102, 103) AND (disabled & 1 = 0)))
	IF (@@ROWCOUNT > 0)
	BEGIN
		UPDATE	JMJobDataStats
SET 		disabled = JDS.disabled & ~1, modifiedTime = @l_now
		FROM JMJobDataStats JDS, #tmpDisabledJob T
		WHERE	JDS.jobId = T.jobId
		AND		JDS.commcellId = T.commcellId
		AND		JDS.archGrpCopyId = T.archGrpCopyId
		AND		JDS.dataType = T.dataType
		AND 	JDS.status IN (101, 102, 103)
AND 	JDS.disabled & 1 > 0
AND 	JDS.disabled & 256 = 0
		AND		T.pickForCopy = 1
	END
END
FINISH:
IF @retVal = 64 AND EXISTS ( SELECT 1 FROM #misMatchingSrcDstMaps)
OR EXISTS
(
	SELECT 1 FROM #archCopyToAppOld OLD WHERE NOT EXISTS
	(
		SELECT 1
		FROM #AppToCopy NW WITH (READUNCOMMITTED)
		WHERE NW.clientId = OLD.ClientId
		AND NW.appTypeId = NW.appTypeId AND NW.instanceId = OLD.instanceid AND NW.backupSetId  = OLD.backupSetId AND NW.subClientId = OLD.subClientId AND NW.clientGroupId = OLD.clientGroupId AND NW.exclude = OLD.exclude AND  NW.assocType = OLD.assocType
	)
)-- something was removed
OR EXISTS
(
	SELECT 1 FROM #AppToCopy NW WITH (READUNCOMMITTED) WHERE NOT EXISTS
	(
		SELECT 1
		FROM #archCopyToAppOld OLD
		WHERE NW.clientId = OLD.ClientId
		AND NW.appTypeId = NW.appTypeId AND NW.instanceId = OLD.instanceid AND NW.backupSetId  = OLD.backupSetId AND NW.subClientId = OLD.subClientId AND NW.clientGroupId = OLD.clientGroupId AND NW.exclude = OLD.exclude AND  NW.assocType = OLD.assocType
	)
)-- something was added
BEGIN
	SELECT AGCS.name, AGCD.name, '', clientName, appTypeName, instanceName, backupsetName, subclientName, 0 exclude, 7 assocType, @retVal retCode
	FROM #misMatchingSrcDstMaps t INNER JOIN @appSubSet SS ON SS.subID = t.subClientId INNER JOIN archGroupCopy AGCS WITH (READUNCOMMITTED) ON AGCS.id = t.srcCopyId INNER JOIN archGroupCopy AGCD WITH (READUNCOMMITTED) ON AGCD.id = t.dstCopyId
	UNION
	SELECT '', AGC.name, CASE WHEN NW.clientGRoupID > 0 THEN CG.name ELSE '' END, CASE WHEN NW.clientId > 0 THEN cl.name ELSE '' END, CASE WHEN NW.appTypeId > 0 THEN aType.name ELSE '' END, CASE WHEN NW.instanceId > 0 THEN iName.name ELSE '' END, CASE WHEN NW.backupSetId > 0 THEN bsn.name ELSE '' END, CASE WHEN NW.subclIentId > 0 THEN AA.subclientName ELSE  '' END, NW.exclude, NW.assocType , 2 retCode
	FROM #AppToCopy NW WITH (READUNCOMMITTED) INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AGC.id = @i_copyId LEFT JOIN APP_Client as cl WITH (READUNCOMMITTED) ON NW.clientId = cl.Id LEFT JOIN APP_iDAType as aType WITH (READUNCOMMITTED) ON NW.appTypeId = aType.type
			 LEFT JOIN APP_InstanceName as iName WITH (READUNCOMMITTED) ON NW.instanceId = iName.id LEFT JOIN APP_BackupSetName as bsn WITH (READUNCOMMITTED) ON NW.backupSetId = bsn.id
			 LEFT JOIN APP_ClientGroup CG WITH (READUNCOMMITTED) ON CG.id = NW.clientGRoupID
			 LEFT JOIN App_Application AA WITH (READUNCOMMITTED) ON AA.Id = NW.subClientId
	WHERE NOT EXISTS
		(  SELECT 1
			FROM #archCopyToAppOld OLD
			WHERE NW.clientId = OLD.ClientId
			AND NW.appTypeId = NW.appTypeId AND NW.instanceId = OLD.instanceid AND NW.backupSetId  = OLD.backupSetId AND NW.subClientId = OLD.subClientId AND NW.clientGroupId = OLD.clientGroupId AND NW.exclude = OLD.exclude AND  NW.assocType = OLD.assocType
			)
	UNION
	SELECT '', AGC.name, CASE WHEN OLD.clientGRoupID > 0 THEN CG.name ELSE '' END, CASE WHEN OLD.clientId > 0 THEN cl.name ELSE '' END, CASE WHEN OLD.appTypeId > 0 THEN aType.name ELSE '' END, CASE WHEN OLD.instanceId > 0 THEN iName.name ELSE ''END, CASE WHEN OLD.backupSetId > 0 THEN bsn.name ELSE '' END, CASE WHEN OLD.subclIentId > 0 THEN AA.subclientName ELSE  ''END, OLD.exclude, OLD.assocType, 3 retCode
	FROM #archCopyToAppOld OLD INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AGC.id = @i_copyId LEFT JOIN APP_Client as cl WITH (READUNCOMMITTED) ON OLD.clientId = cl.Id LEFT JOIN APP_iDAType as aType WITH (READUNCOMMITTED) ON OLD.appTypeId = aType.type
			 LEFT JOIN APP_InstanceName as iName WITH (READUNCOMMITTED) ON OLD.instanceId = iName.id LEFT JOIN APP_BackupSetName as bsn WITH (READUNCOMMITTED) ON OLD.backupSetId = bsn.id
			 LEFT JOIN APP_ClientGroup CG WITH (READUNCOMMITTED) ON CG.id = OLD.clientGRoupID
			 LEFT JOIN App_Application AA WITH (READUNCOMMITTED) ON AA.Id = OLD.subClientId
	WHERE NOT EXISTS
		(SELECT 1
			FROM #AppToCopy NW WITH (READUNCOMMITTED)
			WHERE NW.clientId = OLD.ClientId
			AND NW.appTypeId = NW.appTypeId AND NW.instanceId = OLD.instanceid AND NW.backupSetId  = OLD.backupSetId AND NW.subClientId = OLD.subClientId AND NW.clientGroupId = OLD.clientGroupId AND NW.exclude = OLD.exclude AND  NW.assocType = OLD.assocType
			)
	order by retCode desc
END
if object_id('tempdb.dbo.#archCopyToAppIdTemp') is not null DROP TABLE #archCopyToAppIdTemp
if object_id('tempdb.dbo.#copyIdToProcess') is not null DROP TABLE #copyIdToProcess
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
if object_id('tempdb.dbo.#misMatchingSrcDstMaps') is not null DROP TABLE #misMatchingSrcDstMaps
IF object_id('tempdb..#tmpDisabledJob') IS NOT NULL DROP TABLE #tmpDisabledJob
IF OBJECT_ID('tempdb..#archCopyToAppOld') IS NOT NULL DROP TABLE #archCopyToAppOld
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archCopyToAppInsert')
	delete from GxQscripts where name = 'archCopyToAppInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyToAppInsert')
	delete from GXDBVersions where aliasname = 'archCopyToAppInsert'
GO

insert into GXDBVersions values(2, 'archCopyToAppInsert',  '00010006008600150000', 'archCopyToAppInsert', '00010006008600150000')
GO

