

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyStartNewSIDBStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyStartNewSIDBStore.sp,v $ $Id: archCopyStartNewSIDBStore.sp,v 1.97.2.45 2020/12/29 12:27:06 anarulkar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCopyStartNewSIDBStore')
BEGIN
	print '>>> Drop Stored Procedure: archCopyStartNewSIDBStore <<<'
	drop procedure archCopyStartNewSIDBStore
END
IF EXISTS (select * from GxQscripts where name='archCopyStartNewSIDBStore')
	delete from GxQscripts where name = 'archCopyStartNewSIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyStartNewSIDBStore')
	delete from GXDBVersions where aliasname = 'archCopyStartNewSIDBStore'
GO
print '... Creating Procedure: archCopyStartNewSIDBStore'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCopyStartNewSIDBStore
  @i_copyId int,
  @i_forceSealReason int,
		 -- 1 If sealed by user
		 -- 2 If called by CCM
		 -- 3 If called by CS DB restore
		 -- 4 If called by CCM for GRC
		 -- 5 Sealed as part of Start Over
		 -- 6 retire DDB by user
  @i_SIDBStoreId int = 0
AS
  DECLARE @o_copyId integer;
  DECLARE @o_SIDBStoreId integer;
  DECLARE @o_SIDBStoreName varchar(256);
  DECLARE @o_newSIDBStoreId integer;
  DECLARE @o_newSIDBStoreName varchar(256);
  DECLARE @o_recopyPartialAF integer;
  DECLARE @o_sealedReason integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblVol		TABLE (
		copyId INT, SIDBStoreId INT, volumeId INT, volumeFlags INT, PhysicalBytesMB BIGINT)
IF OBJECT_ID('tempdb..#tblStore') IS NOT NULL DROP TABLE #tblStore
CREATE TABLE #tblStore (
		copyId INT, SIDBStoreId INT, dedupeFlags INT, sealStoreTaskId INT,
		periodType INT, numPeriod INT, dataSizeGB BIGINT, nextEvent DATETIME,
		createTime INT, StoreStatus INT, PhysicalBytesMB BIGINT, hasPartialAF INT, SealedReason INT,
newSIDBStoreId INT, SIDBStoreName nvarchar(256), newSIDBStoreName NVARCHAR(256),
SIDBStoreAliasName NVARCHAR(256), storeFlags INT, storeExtendedFlags BIGINT)
IF object_id('tempdb.dbo.#ToBeAgedAFC') IS  NOT null DROP TABLE #ToBeAgedAFC
CREATE TABLE #ToBeAgedAFC (
		archFileId INT, commCellId INT, archCopyId INT, SIDBStoreId INT,
		PRIMARY KEY (archFileId, commCellId, archCopyId))
IF object_id('tempdb.dbo.#StoreMAList') IS  NOT null DROP TABLE #StoreMAList
CREATE TABLE #StoreMAList (
		SIDBStoreId INT, SubStoreId INT, clientId INT, releaseId INT, HighestSP INT)
DECLARE	@l_today DATETIME
SET		@l_today = GetUTCDate()
DECLARE	@l_now INT
SET		@l_now = dbo.GetUnixTime(@l_today)
DECLARE	@l_csTimeZone	VARCHAR(255)
SET		@l_csTimeZone = dbo.GetClientTimeZone(2)
SET		@l_today = dbo.UTCToLocalTime(@l_today, @l_csTimeZone)
DECLARE	@l_error INT
SET		@l_error = 0
DECLARE @l_numStores INT = 0
DECLARE @dedupeFlags INT
SET @dedupeFlags = 0
SELECT @dedupeFlags = dedupeFlags from archGroupCopy WHERE id = @i_copyId
--Retire is supported only at DDB level and there should be atleast one another active DDB
IF @i_forceSealReason = 6 AND (@i_SIDBStoreId = 0 OR NOT EXISTS(SELECT 1 FROM archCopySIDBStore WITH(READUNCOMMITTED) WHERE copyId = @i_copyId AND SIDBStoreId <> @i_SIDBStoreId AND flags & 4 > 0))
BEGIN
	SET @l_error = -7
	GOTO FINISH
END
if (@i_copyId = 0) -- from periodic admin thread
BEGIN
	--update the active SIDBStores which have met the sealing criteria based on number of substores corruption
	UPDATE	IdxSIDBStore
	SET		Status = (SELECT CASE
					WHEN (T.cnt > AT.percentCorruptLimit AND AGC.dedupeFlags & 33554432 = 0 AND AGC.dedupeFlags & 8 > 0 AND (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId) > 1 AND MAIN.SealedTime = 0)
					THEN 1
					WHEN (T.cnt >= 1 AND AGC.dedupeFlags & 33554432 = 0 AND AGC.dedupeFlags & 8 = 0 AND (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId) > 1 AND MAIN.SealedTime = 0) -- when resiliency is off check for first substore corruption
					THEN 1
					WHEN (T.cnt > AT.percentCorruptLimit AND (((SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId) = 1) OR (MAIN.SealedTime > 0))) -- with only 1 substore or for sealed stores
					THEN 1
					WHEN (AGC.dedupeFlags & 33554432 > 0 AND NOT EXISTS (SELECT * FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId AND status = 0))
					THEN 1
					ELSE 0
				END)
	FROM	IdxSIDBStore MAIN WITH (NOLOCK)
			INNER JOIN (SELECT Sub.SIDBStoreId, COUNT(*) cnt
				FROM IdxSIDBSubStore Sub WITH (NOLOCK)
				WHERE Sub.Status = 1
				GROUP BY SIDBStoreId) AS T ON T.SIDBStoreId = MAIN.SIDBStoreId
			INNER JOIN archCopySIDBStore AGCSI WITH (NOLOCK) ON AGCSI.SIDBStoreId = MAIN.SIDBStoreId
			INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = AGCSI.CopyId
			INNER JOIN archTask AT WITH (NOLOCK) ON AGC.sealStoreTaskId = AT.id
END
IF @i_copyId > 0 AND @dedupeFlags & 134217728 = 134217728
BEGIN
	--Copy is using GDSP
	SET @l_error = -200
	GOTO FINISH
END
-- Get active SIDB stores
INSERT	INTO #tblStore
SELECT	AGC.id, C2S.SIDBStoreId, AGC.dedupeFlags, AGC.sealStoreTaskId,
		AT.periodType, AT.numPeriod, AT.dataSizeGB, AT.nextEvent,
		S.FirstBackupTime, S.Status, 0, 0, 0, 0, S.SIDBStoreName, N'', S.SIDBStoreAliasName, S.flags, S.ExtendedFlags
FROM	IdxSIDBStore S WITH (NOLOCK)
		INNER JOIN archCopySIDBStore C2S WITH(NOLOCK) ON S.SIDBStoreId = C2S.SIDBStoreId
		INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = C2S.copyId
		INNER JOIN archTask AT WITH (NOLOCK) ON AT.id = AGC.sealStoreTaskId
WHERE	(@i_copyId <= 0 OR AGC.id = @i_copyId)
		AND (@i_SIDBStoreId = 0 OR C2S.SIDBStoreId = @i_SIDBStoreId)
AND (C2S.flags & 4) > 0
		AND
		(
			@i_forceSealReason > 0
OR S.status = 1 /*IDX_SIDBSTORE_STATUS_CORRUPTED*/ AND (AGC.dedupeFlags & 33554432) = 0
OR (S.status <> 1 OR (AGC.dedupeFlags & 33554432) = 0) AND (AT.periodType > 0 AND AT.numPeriod > 0 OR AT.dataSizeGB > 0)
		)
AND	(@i_forceSealReason = 6 OR S.Version <> -1) --skip uninitialized DDBs
AND (AGC.dedupeFlags & (262144|134217728)) = 262144
SET @l_numStores = @@ROWCOUNT
IF	@l_numStores = 0
BEGIN
	SET @l_error = -3
	GOTO FINISH
END
-- Remove all those stores from sealing which are undergoing reconstruction. JMJobInfo has running jobs info.
DELETE #tblStore
FROM #tblStore SIDBs,(SELECT dbo.GetJobOption(jobId, 1777365717/* DEDUPDBSYNCOPTION__SIDBSTORE_ID */) AS storeID
                            FROM JMJobInfo WITH (READUNCOMMITTED)
                            WHERE commCellId = 2 /* Local Commcell ID*/ AND opType = 80  /* DEDUPDBSYNC */ ) JobSIDBs
WHERE SIDBs.SIDBStoreId = JobSIDBs.storeID
SET @l_numStores = @l_numStores - @@ROWCOUNT
IF	@l_numStores = 0
BEGIN
	SET @l_error = -6
	GOTO FINISH
END
-- Remove all DDBs which undergoing ddb move.
IF (@i_forceSealReason <> 4) -- If store is from CCM, don't check for DDB move.
BEGIN
	DELETE 	S
	FROM 	#tblStore S, IdxSIDBSubStore SS WITH (READUNCOMMITTED)
	WHERE 	S.SIDBStoreId = SS.SIDBStoreId
AND (SS.Flags & 1024) > 0
	SET @l_numStores = @l_numStores - @@ROWCOUNT
	IF	@l_numStores = 0
	BEGIN
SET @l_error = 53049
		 GOTO FINISH
	END
END
INSERT	INTO @tblVol
SELECT	T.copyId, T.SIDBStoreId, V.VolumeId, V.VolumeFlags, V.PhysicalBytesMB
FROM	#tblStore T, MMVolume V WITH (NOLOCK)
WHERE	V.SIDBStoreId = T.SIDBStoreId
IF	@@ROWCOUNT = 0
BEGIN
IF @i_forceSealReason < 2
	BEGIN
		SET @l_error = -3
		GOTO FINISH
	END
END
UPDATE	#tblStore
SET		PhysicalBytesMB = B.PhysicalBytesMB
FROM	#tblStore A,
		(SELECT SIDBStoreId, SUM(PhysicalBytesMB) AS PhysicalBytesMB FROM @tblVol GROUP BY SIDBStoreId) B
WHERE	A.SIDBStoreId = B.SIDBStoreId
UPDATE	#tblStore
SET		SealedReason =
		CASE
WHEN @i_forceSealReason = 3
THEN 6
WHEN @i_forceSealReason = 1
THEN 1
WHEN @i_forceSealReason = 5
THEN 9
WHEN @i_forceSealReason = 6
THEN 10
WHEN (@i_forceSealReason = 2)  OR (@i_forceSealReason = 4)
THEN 7
WHEN StoreStatus = 1 AND (dedupeFlags & 33554432) = 0
THEN 2
			WHEN dataSizeGB > 0 AND PhysicalBytesMB/1024 >= dataSizeGB
THEN 3
WHEN periodType = 3 AND createTime > 0 AND createTime <= (@l_now - numPeriod*24*3600)
THEN 4
WHEN periodType IN (2, 4) AND nextEvent <= @l_today
THEN 5
			ELSE 0
		END
DELETE	#tblStore
WHERE	SealedReason = 0
SET @l_numStores = @l_numStores - @@ROWCOUNT
IF	@l_numStores = 0
BEGIN
		SET @l_error = -7
		GOTO FINISH
END
IF @i_forceSealReason <> 3
BEGIN
	DELETE	#tblStore
	WHERE	SIDBStoreId IN (
			SELECT	DISTINCT C.SIDBStoreId
			FROM	MMResource A WITH (NOLOCK), MMResourceToJob B WITH (NOLOCK), @tblVol C
			WHERE	B.ReservationId = A.ReservationId AND B.ReservationType = 2/*RESERVE_TYPE_WRITE*/
				AND C.VolumeId = A.VolumeId AND C.SIDBStoreId > 0)
	SET @l_numStores = @l_numStores - @@ROWCOUNT
	IF	@l_numStores = 0
	BEGIN
		SET @l_error = -2
		GOTO FINISH
	END
END
INSERT	INTO #ToBeAgedAFC
SELECT	D.archFileId, D.commCellId, D.archCopyId, D.SIDBStoreId
FROM	#tblStore S, archFileCopyDedup D WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
WHERE	D.SIDBStoreId = S.SIDBStoreId
	AND AFC.archFileId = D.archFileId AND AFC.commCellId = D.commCellId AND AFC.archCopyId = D.archCopyId
	AND AFC.isValid = 0 AND (AFC.flags & 256) = 0 --AND (AFC.physicalSize > 0 OR AFC.logicalSize > 0)
DELETE	#ToBeAgedAFC
FROM	#ToBeAgedAFC T, archFile AF WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK)
WHERE	AF.id = T.archFileId AND AF.commCellId = T.commCellId AND AF.fileType = J.dataType
	AND J.jobId = AF.jobId AND J.commCellId = AF.commCellId AND J.archGrpId = AF.archGroupId AND J.archGrpCopyId = T.archCopyId
AND (J.status NOT IN (102, 103) OR (J.disabled & (1+256+8192)) <> 0 OR AF.isValid <> 1)
DELETE	#ToBeAgedAFC
FROM	#ToBeAgedAFC T
		INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = T.archFileId AND AF.commCellId = T.commCellId
		LEFT OUTER JOIN JMJobInfo J WITH (NOLOCK) ON J.jobId = AF.jobId AND J.commCellId = AF.commCellId
WHERE	J.jobId IS NULL
AND	AF.isValid <> 1
/* Edge/Reusable or archive files created by fast copy will be marked for recopy */
UPDATE	#tblStore
SET		hasPartialAF = 1
WHERE	SIDBStoreId IN (SELECT DISTINCT SIDBStoreId
						FROM #ToBeAgedAFC T
							INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = T.archFileId AND AF.commCellId = T.commCellId
							INNER JOIN archGroup AG WITH (NOLOCK) ON AG.id = AF.archGroupId
							INNER JOIN JMJobDataStats J WITH (NOLOCK) ON J.jobId = AF.jobId AND J.commCellId = AF.commCellId AND AF.fileType = J.dataType AND J.archGrpCopyId = T.archCopyId
WHERE	AG.defaultCopy = T.archCopyId OR AF.flags & (32768+2097152) = 0
						)
/*Mark archvive files for recopy for both active and corrupted stores.
-- Set partial archive files in corrupted stores for recopy
DELETE	#ToBeAgedAFC
WHERE	SIDBStoreId IN (SELECT SIDBStoreId FROM #tblStore WHERE hasPartialAF = 1 AND StoreStatus <> 1)
-- Do not seal the active store if there are partially copied archive files for a copy
DELETE	#tblStore
WHERE	hasPartialAF = 1 AND StoreStatus <> 1
SET @l_numStores = @l_numStores - @@ROWCOUNT
IF	@l_numStores = 0
BEGIN
	SET @l_error = -4
	GOTO FINISH
END
*/
IF EXISTS (SELECT 1 FROM #ToBeAgedAFC)
BEGIN
	DECLARE	 @retVal		int
	DECLARE	 @magneticBytes	bigint
        -- Jai - Form 10971
        -- If recopy for dedup copy, set dummy param as below
        -- so that archFileDeleteViaTable puts large AFId in mmdeletedaf table
EXEC @retVal = archFileDeleteViaTable 1, @magneticBytes OUTPUT
	IF	@@ERROR <> 0 OR @retVal <> 0
		SET @l_error = -5
END
DECLARE @CopiesToResetFlag Table (copyId INT)
INSERT INTO @CopiesToResetFlag
SELECT distinct AGC.id
FROM archGroupCopy AGC	with (readuncommitted)
	JOIN archGroup AG with (readuncommitted)
	ON AG.defaultCopy = AGC.id
	INNER JOIN archCopySIDBStore C2S WITH(READUNCOMMITTED) ON AGC.id = C2S.copyId
	JOIN #tblStore S
	ON C2S.SIDBStoreId = S.SIDBStoreId
WHERE (AG.flags & 65536) > 0
	OR ISNULL(AG.SubclientExtensionTimeStamp, 0) >= dbo.getUnixTime(GETUTCDATE())
UPDATE	AG
SET		AG.flags = (AG.flags & ~65536),
		AG.SubclientExtensionTimeStamp = 0,
		AG.SubclientExtensionTimeStampEncrypted = ''
FROM	archGroup AG
JOIN	@CopiesToResetFlag CRF
	ON AG.defaultCopy = CRF.copyId
WHERE	(AG.flags & 65536) > 0
		OR ISNULL(AG.SubclientExtensionTimeStamp, 0) >= dbo.getUnixTime(GETUTCDATE())
DECLARE @GarbageCollectionConfig INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_DDB_GARBAGE_COLLECTION'), 0)
DECLARE	@l_dedupeFlags	INT
DECLARE	@l_storeFlags	INT
DECLARE	@l_storeExFlags	BIGINT
DECLARE	@l_SIDBStoreId	INT
DECLARE @l_SIDBStoreName nvarchar(256)
DECLARE	@l_NewStoreId	INT
DECLARE	@l_SealedReason	INT
DECLARE	@l_sealStoreTaskId	INT
DECLARE @l_periodType	INT
DECLARE @l_numPeriod	INT
DECLARE @l_nextEvent	DATETIME
DECLARE curGetSIDBCopy CURSOR FOR
SELECT	DISTINCT SIDBStoreId, SIDBStoreAliasName, dedupeFlags, sealStoreTaskId, periodType, numPeriod, nextEvent, SealedReason, storeFlags, storeExtendedFlags
FROM	#tblStore
OPEN	curGetSIDBCopy
FETCH	NEXT FROM curGetSIDBCopy
INTO	@l_SIDBStoreId, @l_SIDBStoreName, @l_dedupeFlags, @l_sealStoreTaskId, @l_periodType, @l_numPeriod, @l_nextEvent, @l_SealedReason, @l_storeFlags, @l_storeExFlags
WHILE	@@FETCH_STATUS = 0
BEGIN
-- Update sealed time, reason.
	UPDATE	IdxSIDBStore
	SET	SealedTime = @l_now,
		SealedReason = @l_SealedReason,
Flags = Flags & (~33554432)
	FROM	IdxSIDBStore
	WHERE	SIDBStoreId = @l_SIDBStoreId
--Reset Maintenance flag if reason is not upgrade
	UPDATE	ST
	SET	SealedTime = @l_now,
		SealedReason = @l_SealedReason,
Flags = Flags & (~16777216)
	FROM	IdxSIDBStore ST
	LEFT OUTER JOIN MMEntityProp EP ON ST.SIDBStoreId = EP.EntityId
AND EP.EntityType = 3
					AND EP.PropertyName = 'DDBMaintenanceReason'
					AND EP.CommCellId = ST.CommCellId
	WHERE	SIDBStoreId = @l_SIDBStoreId
	AND ISNULL(EP.intVal, 0) IN
(1,
3,
4,
7,
12)
	--update the substore info with the sealedtime
	UPDATE IdxSIDBSubStore
	SET SealedTime = @l_now
	WHERE SIDBStoreId = @l_SIDBStoreId
	-- delete MMTempDeletedAFEntries of the sealed store
	DELETE FROM MMTempDeletedAF WHERE SIDBStoreId = @l_SIDBStoreId
	--
	-- Create new DDB
	-- if retire is set then skip creation
	--
IF @i_forceSealReason <> 6
	BEGIN
SET @l_storeFlags = (@l_storeFlags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072)
SET @l_storeExFlags = (@l_storeExFlags & ~( 0 )) | ( 0 )
DECLARE @newSubStoreFlags INT = ( 536870912 | 131072)
		DECLARE @newSubStoreExFlags BIGINT = 0
		DECLARE @subStoreCount INT = 0
		SELECT @subStoreCount = COUNT(1) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = @l_SIDBStoreId
		DECLARE @maxNumOfAFsInSecondaryFile INT = 0
		DECLARE @AFPerSec INT = 0
		SET @maxNumOfAFsInSecondaryFile = ISNULL((SELECT MaxNumOfAFsInSecFile FROM IdxSIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @l_SIDBStoreId), 256)
		-- If previous setting was 256 and now the DDB MA has required release/SP level then start defaulting to new MMConfigs value.
		INSERT INTO #StoreMAList
		SELECT 	S.SIDBStoreId, S.SubStoreId, S.ClientId, C.releaseId, I.HighestSP
		FROM 	IdxSIDBSubStore S WITH (NOLOCK)
				INNER JOIN APP_Client C WITH (NOLOCK) ON S.ClientId = C.id
				INNER JOIN simInstalledPackages I ON C.id = I.ClientId
		WHERE 	S.SIDBStoreId = @l_SIDBStoreId
AND I.simPackageID IN (51, 1301)
		GROUP BY S.SIDBStoreId, S.SubStoreId, S.ClientId, C.releaseId, I.HighestSP
IF NOT EXISTS (SELECT 1 FROM #StoreMAList S WHERE (S.releaseId < 16) OR ((S.releaseId = 16) AND (S.HighestSP < 14)))
		BEGIN
			SET @maxNumOfAFsInSecondaryFile = 1
			SET @AFPerSec = @maxNumOfAFsInSecondaryFile
IF @GarbageCollectionConfig = 1 AND @l_storeExFlags & 4 = 0 AND @l_storeFlags & 8192 = 0
			BEGIN
SET @l_storeExFlags |= (4 | 8)
SET @newSubStoreExFlags |= (1 | 2)
			END
		END
ELSE IF NOT EXISTS (SELECT 1 FROM #StoreMAList S WHERE (S.releaseId < 16))
			AND (@maxNumOfAFsInSecondaryFile = 256)
		BEGIN
			--New MMConfig setting for stores which were default to 256.
SET @maxNumOfAFsInSecondaryFile = ISNULL((SELECT value FROM MMConfigs WHERE name = 'MMS2_CONFIG_DDB_MAX_NUM_OF_AF_IN_SECFILE'), 16)
			SET @AFPerSec = @maxNumOfAFsInSecondaryFile
		END
		--
		-- StoreName format - <SPName_AppTypeGroupName_StoreId>
		-- Remove old storeId from name
		--
		DECLARE @pos INT =  CHARINDEX(N'_', REVERSE(@l_SIDBStoreName))
		IF @pos > 0 AND ISNUMERIC(RIGHT(@l_SIDBStoreName, @pos - 1)) = 1
		BEGIN
			SET @l_SIDBStoreName = LEFT(@l_SIDBStoreName, LEN(@l_SIDBStoreName) - @pos)
		END
		INSERT	INTO IdxSIDBStore (SIDBStoreName, SIDBStoreAliasName, CommCellId,
								IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime,
								MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
								flags,
								TotalDataSizeBytes, InstancedDataSizeBytes, Status,
								LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId,
								Version, SIDBSnapPath, LastSnapTime, LastRecoveryTime,
								SealedReason, SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId,
								SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile,
								LastDDBVerificationTime, LastDataVerificationTime, DedupFactor, AppTypeGroupId, ExtendedFlags, FullReason, FullTime, SIDBGroupId)
		SELECT	@l_SIDBStoreName,
				SIDBStoreAliasName, 2,
				IdxCacheId, IdxAccessPathId, ClientId, -1,
				MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
				@l_storeFlags,
				0, 0, 0,
				0,	@l_now, 0, 	0,
				-1, SIDBSnapPath, 0, 0,
				0, 0, 0, 0,
				@subStoreCount, MaxAllowedConnections, (CASE WHEN @AFPerSec = 1 THEN 0 ELSE MaxNumOfAFsInSecFile END),
				0, 0, DedupFactor, AppTypeGroupId, @l_storeExFlags, FullReason, FullTime, SIDBGroupId
		FROM	IdxSIDBStore WITH (NOLOCK)
		WHERE	SIDBStoreId = @l_SIDBStoreId
		SET		@l_NewStoreId = SCOPE_IDENTITY()
		UPDATE	IdxSIDBStore
		SET		SIDBStoreName = SIDBStoreName + N'_' + CONVERT(nvarchar, @l_NewStoreId)
		WHERE	SIDBStoreId = @l_NewStoreId
		UPDATE 	T
		SET		newSIDBStoreId = S.SIDBStoreId,
				newSIDBStoreName = S.SIDBStoreName
		FROM	#tblStore T, IdxSIDBStore S
		WHERE	T.SIDBStoreId = @l_SIDBStoreId AND S.SIDBStoreId = @l_NewStoreId
		--Create new substores
		INSERT INTO IdxSIDBSubStore
					(
					SIDBStoreId, commCellId,GroupNumber,IdxCacheId,IdxAccessPathId,ClientId,FirstBackupTime,flags,TotalDataSizeBytes,
					InstancedDataSizeBytes,Status,LastAccessTime,CreatedTime,SealedTime,Version,SIDBSnapPath,LastSnapTime,origSubStoreId, ReconLevel, LastSnapJobId, DDBBackupCSGUID, PrimaryId,MemDbTimeStamp,CorruptionTime,ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence,
					MaxNumOfAFsInSecFile, ExtendedFlags, PageSize)
		SELECT @l_NewStoreId, 2, GroupNumber, IdxCacheId, IdxAccessPathId, ClientId, -1,
(@newSubStoreFlags | (flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									))), 0, 0, 0, 0,
				@l_now, 0, -1, '', 0, 0, 0, 0, '', 0, 0, 0, 0, '', '', '',
				(CASE WHEN (@AFPerSec > 0) THEN @AFPerSec ELSE MaxNumOfAFsInSecFile END),
((ExtendedFlags & ~(	4	)) | @newSubStoreExFlags),
				PageSize
		FROM IdxSIDBSubStore WITH (NOLOCK)
		WHERE SIDBStoreId = @l_SIDBStoreId
		UPDATE	archGroupCopy SET SIDBStoreId = @l_NewStoreId
		WHERE	SIDBStoreId = @l_SIDBStoreId
		INSERT	INTO archCopySIDBStore
		SELECT	copyId, @l_NewStoreId, 2, flags, 0, 0
		FROM	archCopySIDBStore WITH (NOLOCK)
		WHERE	SIDBStoreId = @l_SIDBStoreId
		UPDATE	archSubclientCopyDDBMap
		SET		SIDBStoreId = @l_NewStoreId
		WHERE	SIDBStoreId = @l_SIDBStoreId
IF EXISTS( SELECT TOP 1 1 FROM MMEntityProp WITH (READUNCOMMITTED) WHERE propertyName = 'DDBMarkAndSweepOpTime' AND EntityId = @l_SIDBStoreId AND EntityType = 3 AND CommCellId = 2)
		BEGIN
			INSERT INTO 	MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT 		@l_NewStoreId, 3, propertyName, propDataType, intVal, longlongVal, stringVal, @l_now, @l_now, 2
			FROM 		MMEntityProp WITH (READUNCOMMITTED)
WHERE 		propertyName = 'DDBMarkAndSweepOpTime' AND EntityId = @l_SIDBStoreId AND EntityType = 3 AND CommCellId = 2
		END
IF	@l_periodType IN (3, 2, 4)
		BEGIN
IF	@l_periodType = 3
				SET @l_nextEvent = DATEADD(day, @l_numPeriod, @l_nextEvent)
			ELSE
IF	@l_periodType = 2
				SET @l_nextEvent = DATEADD(week, @l_numPeriod, @l_nextEvent)
			ELSE
IF	@l_periodType = 4
				SET @l_nextEvent = DATEADD(month, @l_numPeriod, @l_nextEvent)
			UPDATE	archTask
			SET		lastEvent = @l_today, nextEvent = @l_nextEvent
			WHERE	id = @l_sealStoreTaskId
		END
		DELETE FROM #StoreMAList
	END
ELSE  --@i_forceSealReason = 6
	BEGIN
		--Check if all left over DDBs are full if so mark one DDB as non-full
		IF NOT EXISTS
		(
			SELECT 	1
			FROM 	IdxSIDBStore S,
					archCopySIDBStore CS
			WHERE   S.SIDBStoreId = CS.SIDBStoreId
					AND CS.CopyId = @i_copyId
AND CS.flags & (4 | 1) = 4
					AND S.SIDBStoreId <> @l_SIDBStoreId
		)
		BEGIN
			DECLARE @ActiveDDB int =
			(
				SELECT TOP 1 S.SIDBStoreId
				FROM 	IdxSIDBStore S,
						archCopySIDBStore CS
				WHERE   S.SIDBStoreId = CS.SIDBStoreId
						AND CS.CopyId = @i_copyId
AND CS.flags & 4 > 0
						AND S.SIDBStoreId <> @l_SIDBStoreId
				ORDER BY case when S.AppTypeGroupId = 0 then 1 else 0 end, S.AppTypeGroupId
			)
			UPDATE archCopySIDBStore
SET flags = flags & ~1
			WHERE SIDBStoreId = @ActiveDDB
			UPDATE IdxSIDBStore
SET ExtendedFlags = ExtendedFlags & ~1
			WHERE SIDBStoreId = @ActiveDDB
		END
		--Check if default DDB is getting retired then promote other active DDB to default
		IF EXISTS
		(
			SELECT 	1
			FROM 	archCopySIDBStore
			WHERE   CopyId = @i_copyId
					AND SIDBStoreId = @l_SIDBStoreId
AND flags & 2 > 0
		)
		BEGIN
			DECLARE @DefaultDDB INT =
			(
				SELECT TOP 1 S.SIDBStoreId
				FROM 	IdxSIDBStore S,
						archCopySIDBStore CS
				WHERE   S.SIDBStoreId = CS.SIDBStoreId
						AND CS.CopyId = @i_copyId
AND CS.flags & 4 > 0
						AND S.SIDBStoreId <> @l_SIDBStoreId
ORDER BY CS.flags & 1,
						 S.AppTypeGroupId
			)
			UPDATE 	archCopySIDBStore
SET 	flags = flags | 2
			WHERE 	SIDBStoreId = @DefaultDDB
			UPDATE IdxSIDBStore
SET ExtendedFlags = ExtendedFlags | 2
			WHERE SIDBStoreId = @DefaultDDB
			UPDATE	archGroupCopy
			SET 	SIDBStoreId = @DefaultDDB
			WHERE	SIDBStoreId = @l_SIDBStoreId
		END
		--Remove subclient mapping
		DELETE	archSubclientCopyDDBMap
		WHERE	SIDBStoreId = @l_SIDBStoreId
	END
	UPDATE	archCopySIDBStore
SET		flags = (flags & ~(4 | 2))
	WHERE	SIDBStoreId = @l_SIDBStoreId
	UPDATE	IdxSIDBStore
SET		ExtendedFlags = (ExtendedFlags & ~2)
	WHERE	SIDBStoreId = @l_SIDBStoreId
	FETCH	NEXT FROM curGetSIDBCopy
	INTO	@l_SIDBStoreId, @l_SIDBStoreName, @l_dedupeFlags, @l_sealStoreTaskId, @l_periodType, @l_numPeriod, @l_nextEvent, @l_SealedReason, @l_storeFlags, @l_storeExFlags
END
CLOSE		curGetSIDBCopy
DEALLOCATE	curGetSIDBCopy
IF @i_forceSealReason <> 6
BEGIN
	--
	-- Insert into TM_AssocEntity with exclude=1 when previous store has been excluded from DV2 auto schedule policy
	--
	INSERT INTO TM_AssocEntity(assocType, taskId, flags, created, clientGroupId, clientId, appTypeId, instanceId,
										  backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude,
										  trackingPolicyId, MediaagentId, agentlessPolicyId, workflowId, sidbStoreId, libraryId, logMonitoringPolicyId)
	SELECT T.assocType, T.taskId, T.flags, @l_now, T.clientGroupId, T.clientId, T.appTypeId, T.instanceId,
										  T.backupsetId, T.subclientId, T.policyId, T.copyId, T.srmReportSet, T.srmReportType, T.exclude,
										  T.trackingPolicyId, T.MediaagentId, T.agentlessPolicyId, T.workflowId, S.newSIDBStoreId, T.libraryId, T.logMonitoringPolicyId
	FROM 	TM_AssocEntity T WITH (READUNCOMMITTED),
			TM_Task TK WITH(READUNCOMMITTED), #tblStore S
	WHERE 	T.sidbStoreId = S.SIDBStoreId
			AND T.taskId = TK.taskId
AND TK.flags & 0x800 > 0
			AND T.exclude = 1
	--
	-- Update new store into TM_AssocEntity if previous store has a DV2 schedule
	--
	UPDATE 	T
	SET		sidbStoreId = S.newSIDBStoreId
	FROM 	TM_AssocEntity T WITH (READUNCOMMITTED),
			TM_Task TK WITH(READUNCOMMITTED), #tblStore S,
(SELECT DISTINCT taskId FROM TM_SubTask WITH(READUNCOMMITTED) WHERE operationType = 4007) ST
	WHERE 	T.sidbStoreId = S.SIDBStoreId
			AND T.taskId = TK.taskId
			AND TK.taskId = ST.taskId
AND TK.taskType = 2
END
UPDATE	MMVolume
SET		VolumeFlags = 2/*VOL_FULL*/,
VolumeFullReason = 42038,
		VolumeFullTime = dbo.GetUnixTime(GETUTCDATE())
FROM	(SELECT V.VolumeId
		FROM	@tblVol V, #tblStore S
		WHERE	V.SIDBStoreId = S.SIDBStoreId AND V.VolumeFlags IN (1, 7)) T
WHERE	MMVolume.VolumeId = T.VolumeId
	AND MMVolume.VolumeFlags IN (1, 7)/*VOL_ACTIVE, VOL_ACTIVE_APPEND*/
FINISH:
IF	@l_error = 0
BEGIN
	UPDATE	R
	SET		R.destSIDBStoreId = S.newSIDBStoreId
	FROM	archChunkToReplicate R INNER JOIN	JMAdminJobInfoTable J ON R.adminJobId = J.jobId
								   INNER JOIN	#tblStore S ON R.destSIDBStoreId = S.SIDBStoreId
	SELECT	S.copyId,
			S.SIDBStoreId, S.SIDBStoreName,
			S.newSIDBStoreId, S.newSIDBStoreName,
			S.hasPartialAF, S.SealedReason
	FROM	#tblStore S
END
ELSE
	SELECT	@l_error, 0, '', 0, '', 0, 0
IF object_id('tempdb.dbo.#ToBeAgedAFC') IS  NOT null DROP TABLE #ToBeAgedAFC
IF OBJECT_ID('tempdb..#tblStore') IS NOT NULL DROP TABLE #tblStore
IF object_id('tempdb.dbo.#StoreMAList') IS  NOT null DROP TABLE #StoreMAList
GO

IF EXISTS (select * from GxQscripts where name = 'archCopyStartNewSIDBStore')
	delete from GxQscripts where name = 'archCopyStartNewSIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyStartNewSIDBStore')
	delete from GXDBVersions where aliasname = 'archCopyStartNewSIDBStore'
GO

insert into GXDBVersions values(2, 'archCopyStartNewSIDBStore',  '00010097000200450000', 'archCopyStartNewSIDBStore', '00010097000200450000')
GO

