

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopySetDEDUP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopySetDEDUP')
BEGIN
	print '>>> Drop Stored Procedure: archCopySetDEDUP <<<'
	drop procedure archCopySetDEDUP
END
IF EXISTS (select * from GxQscripts where name='archCopySetDEDUP')
	delete from GxQscripts where name = 'archCopySetDEDUP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopySetDEDUP')
	delete from GXDBVersions where aliasname = 'archCopySetDEDUP'
GO
print '... Creating Procedure: archCopySetDEDUP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archCopySetDEDUP
  @sp_options XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*Local Variables*/
 DECLARE @copyname varchar(100)
 DECLARE @ClientID INT
 DECLARE @comCellID INT
 DECLARE @dedupEnable INT
 DECLARE @idxPoolID INT
 DECLARE @idxCacheID INT
 DECLARE @idxAccessPathID INT
 DECLARE @idxcacheDiskFreeWarningThreshhold INT
 DECLARE @IdxCacheType INT
 DECLARE @pathname varchar(100)
 DECLARE @ArchGroupCopyID INT
 DECLARE @spname varchar(100)
 DECLARE @siloappid INT
 DECLARE @silosincache INT
 DECLARE @SIDBStoreName VARCHAR(100)
 DECLARE @todayDate INT
 DECLARE @SIDBStoreID INT
 DECLARE @archFlags INT
 DECLARE @newSiloForSizeTB INT
BEGIN
	select  @spname = Node.value('@SPName','varchar(100)')
	FROM	@sp_options.nodes('/OpType/SPDetails') tmpxml (Node);
	select	@copyname = Node.value('@CopyName','varchar(100)')
	FROM	@sp_options.nodes('/OpType/CopyDetails/copy') Tmpxml2(Node);
	select	@dedupEnable = Node.value('@DedupEnable','INT'),
			@pathname = Node.value('@Path','varchar(100)'),
			@siloappid = Node.value('@SiloAppID','INT'),
			@silosincache = Node.value('@SilosInCache','INT')
	FROM	@sp_options.nodes('/OpType/CopyDetails/dedup') Tmpxml5(Node);
	select	@comCellID = Node.value('@CommCellID','INT'),
		@ClientID = Node.value('@ClientID','INT')
	FROM	@sp_options.nodes('/OpType/CsDetails') Tmpxml6(Node);
END
	SET @SIDBStoreName = 'SIDB_'+@spname+'_'+@copyname
	SET @SIDBStoreID = 0
	SET @idxcacheDiskFreeWarningThreshhold = 1024
	SET @IdxCacheType = 2 --  #define  IDX_CACHE_TYPE_SIDB		2 defined in mms2idxdefines.h
SET @archFlags = 262144
	SET @newSiloForSizeTB = 100
BEGIN
	select @ArchGroupCopyID = id from archGroupCopy where name = @copyname;
	select  @todayDate = dbo.GetUnixTime(GETDATE());
	insert into idxPool (Description,Enabled,IsShared,AgeingNoOfDays)
	values('SIDB Index Pool ('+@SIDBStoreName+')',1,1,35);
	select @idxPoolId = idxPoolId from idxPool where Description like '%'+@SIDBStoreName+'%';
	INSERT idxCaChe (IdxPoolId,Description,Enabled,Creationtime,SoftState,OfflineReason,AgeingPercentDiskspace,
			 FillUpOrder,FreeDiskSpaceMB,LastUpdateTime,LastUpdateAPId,DiskUsageMB,DiskUsageLastChecked,
			 DiskFreeThresholdMB,DiskFreeWarningThreshholdMB,IdxCacheType,DiskReadSpeed,DiskWriteSpeed,
			 CatalogServerClientId,flags)
		VALUES (@idxPoolId,'SIDB Index Cache ('+@SIDBStoreName+')',1,@todayDate,1,0,90,1,0,@todayDate,@idxPoolId,
			0,0,0,@idxcacheDiskFreeWarningThreshhold ,@IdxCacheType,0,0,0,0);
	select @idxCacheID = idxCacheId from idxCaChe where idxPoolId = @idxPoolId;
	INSERT idxAccessPath (IdxCacheId,ClientId,Path,Username,Password,Enabled,SoftState,OfflineReason,Priority,
				LocalIndexTimeStamp,ActualDaysIndexRetain,Flags,AgeingNoOfDays,AgeingPercentDiskspace,
				DiskFreeThresholdMB,DiskFreeWarningThreshholdMB, StagingCachePath, VolumeGUID)
		 VALUES		(@idxCacheID,@ClientID,@pathname,'','',1,1,0,1,0,0,0,0,0,0,0, '', '');
	select @idxAccessPathID = idxAccessPathId from idxAccessPath where IdxCacheId = @idxCacheID;
--use mmAddSIDBStore proc for the following later
	INSERT INTO IdxSIDBStore(SIDBStoreName,SIDBStoreAliasName,CommCellId,IdxCacheId,IdxAccessPathId,ClientId,
				FirstBackupTime,MinObjSizeKB,oldestEligibleObjArchiveTime,SignatureType,flags,
				TotalDataSizeBytes,InstancedDataSizeBytes,Status,LastAccessTime,CreatedTime,
				SealedTime,origCCSIDBStoreId,Version,SIDBSnapPath,LastSnapTime, SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile)
		  VALUES		(@SIDBStoreName+'('+CAST(getdate() AS VARCHAR(100))+')',@SIDBStoreName,@comCellID,
						@idxCacheID,@idxAccessPathID,@ClientID,-1,50,365,4,2,0,0,0,0,@todayDate,0,0,0,'',0,0,0,0);
	select @SIDBStoreID = SIDBStoreId from IdxSIDBStore where idxcacheId = @idxCacheID;
	INSERT archCopySIDBStore (CopyId,SIDBStoreId,CommCellId,flags,TotalDataSizeBytes,InstancedDataSizeBytes)
VALUES	(@ArchGroupCopyID,@SIDBStoreID,@comCellID,2|4,0,0);
	UPDATE archGroupCopy SET SIDBStoreId = @SIDBStoreID, dedupeFlags |= @archFlags WHERE id = @ArchGroupCopyID;
END

IF EXISTS (select * from GxQscripts where name = 'archCopySetDEDUP')
	delete from GxQscripts where name = 'archCopySetDEDUP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopySetDEDUP')
	delete from GXDBVersions where aliasname = 'archCopySetDEDUP'
GO

insert into GXDBVersions values(2, 'archCopySetDEDUP',  '00000000000000000000', 'archCopySetDEDUP', '00000000000000000000')
GO

