

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopySIDBProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopySIDBProp.sp,v $ $Id: archCopySIDBProp.sp,v 1.18.50.11 2019/03/29 17:27:07 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopySIDBProp')
BEGIN
	print '>>> Drop Stored Procedure: archCopySIDBProp <<<'
	drop procedure archCopySIDBProp
END
IF EXISTS (select * from GxQscripts where name='archCopySIDBProp')
	delete from GxQscripts where name = 'archCopySIDBProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopySIDBProp')
	delete from GXDBVersions where aliasname = 'archCopySIDBProp'
GO
print '... Creating Procedure: archCopySIDBProp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCopySIDBProp
  @i_copyId integer,
  @i_srcCopyId integer,
  @i_jobId integer = 0,
  @i_RCId integer = 0
AS
  DECLARE @o_archGrpFlags integer;
  DECLARE @o_copyFlags integer;
  DECLARE @o_dedupeFlags integer;
  DECLARE @o_encType integer;
  DECLARE @o_encKeyLen integer;
  DECLARE @o_SIBlockSizeKB integer;
  DECLARE @o_SIDBStoreId integer;
  DECLARE @o_SIMinObjSizeKB integer;
  DECLARE @o_SignatureType integer;
  DECLARE @o_SIDBStoreFlags integer;
  DECLARE @o_srcEncType integer;
  DECLARE @o_srcSIDBStoreId integer;
  DECLARE @o_sigCacheDBSizeMB integer;
  DECLARE @o_sigCacheBufferSizeKB integer;
  DECLARE @o_extendedFlags integer;
  DECLARE @o_srcExtendedFlags integer;
  DECLARE @o_DedupFactor integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_archGroupId	integer
DECLARE @l_srcArchGrpId 	integer = 0
DECLARE @l_srcSIBlockSize	integer = 0
DECLARE @l_srcDedupFlags	integer = 0
SET	@l_archGroupId		= 0
SET	@o_archGrpFlags		= 0
SET	@o_copyFlags		= 0
SET	@o_dedupeFlags		= 0
SET	@o_encType			= 0
SET	@o_encKeyLen		= 0
SET @o_SIBlockSizeKB	= 0
SET	@o_SIDBStoreId		= 0
SET	@o_SIMinObjSizeKB	= 0
SET	@o_SignatureType	= 0
SET	@o_SIDBStoreFlags	= 0
SET	@o_srcEncType		= 0
SET	@o_srcSIDBStoreId	= 0
SET	@o_sigCacheDBSizeMB	= 0
SET	@o_sigCacheBufferSizeKB	= 0
SELECT	@o_srcEncType		= C.encType,
		@o_srcSIDBStoreId	= ISNULL(C2S.SIDBStoreId,0),
		@o_srcExtendedFlags	= C.extendedFlags,
		@l_srcArchGrpId		= C.archGroupId,
		@l_srcDedupFlags	= C.dedupeFlags
FROM	archGroupCopy C WITH (READUNCOMMITTED) LEFT JOIN archCopySIDBStore C2S WITH(READUNCOMMITTED) ON C.id = C2S.copyId AND (C2S.flags & (2|4)) = (2|4)
WHERE   C.id = @i_srcCopyId
SELECT	@l_archGroupId		= C.archGroupId,
		@o_copyFlags		= C.flags,
		@o_dedupeFlags		= C.dedupeFlags,
		@o_encType			= C.encType,
		@o_encKeyLen		= C.encKeyLen,
		@o_SIDBStoreId		= ISNULL(C2S.SIDBStoreId,0),
		@o_sigCacheDBSizeMB	= C.maxCacheDBSizeMB,
		@o_extendedFlags	= C.extendedFlags
FROM	archGroupCopy C WITH (READUNCOMMITTED) LEFT JOIN archCopySIDBStore C2S WITH(READUNCOMMITTED) ON  C.id = C2S.copyId AND (C2S.flags & (2|4)) = (2|4)
WHERE   C.id = @i_copyId
SELECT	@o_archGrpFlags = flags, @o_SIBlockSizeKB = SIBlockSizeKB
FROM	archGroup WITH (NOLOCK)
WHERE	id = @l_archGroupId
SELECT 	@o_SIDBStoreId = destSIDBStoreId
FROM	ArchJobStreamStatus WITH(READUNCOMMITTED)
WHERE 	jobId = @i_jobId AND DestRCId = @i_RCId
		AND destSIDBStoreId > 0
IF (@o_dedupeFlags & 134217728 > 0) -- if copy pointing to GDSP then read block size from GDSP instead. Since we allow different block size in GUI now.
BEGIN
SELECT @o_SIBlockSizeKB = (CASE WHEN (AG.flags & 32) > 0 THEN AG.SIBlockSizeKB ELSE 0 END)
	FROM archGroup AG WITH (NOLOCK), archCopyToGlobalPolicy C2G WITH (NOLOCK)
	WHERE AG.id = C2G.globalPolicyId
	AND C2G.copyId = @i_copyId
END
ELSE
BEGIN
IF	@o_SIBlockSizeKB > 0 AND (@o_archGrpFlags & 32) = 0
		SET @o_SIBlockSizeKB = 0
END
IF (@o_srcSIDBStoreId > 0)
BEGIN
IF (@l_srcDedupFlags & 134217728 > 0) -- if pointing to gdsp then read from gdsp else storage policy
	BEGIN
SELECT @l_srcSIBlockSize = (CASE WHEN (AG.flags & 32) > 0 THEN AG.SIBlockSizeKB ELSE 0 END)
		FROM archGroup AG WITH (NOLOCK), archCopyToGlobalPolicy C2G WITH (NOLOCK)
		WHERE AG.id = C2G.globalPolicyId
		AND C2G.copyId = @i_srcCopyId
	END
	ELSE
	BEGIN
		SELECT @l_srcSIBlockSize = SIBlockSizeKB
		FROM	archGroup WITH (NOLOCK)
		WHERE	id = @l_srcArchGrpId
AND (flags & 32) > 0
	END
END
IF @o_SIDBStoreId > 0
BEGIN
	SELECT	@o_SIDBStoreId		= SIDBStoreId,
			@o_SIMinObjSizeKB	= MinObjSizeKB,
			@o_SignatureType	= SignatureType,
			@o_SIDBStoreFlags	= Flags,
			@o_DedupFactor		= DedupFactor
	FROM	idxSIDBStore WITH (NOLOCK)
	WHERE	SIDBStoreId = @o_SIDBStoreId
IF	(@o_dedupeFlags & 524288) <> 0
	BEGIN
		-- getting the below info from archGroupCopy table now. Hence value from MMConfig not needed
		--SELECT	@o_sigCacheDBSizeMB = value
		--FROM	MMConfigs WITH (NOLOCK)
		--WHERE	name = 'MMCONFIG_AUXCOPY_CLDEDUP_CACHE_DB_SIZE_MB'
		SELECT	@o_sigCacheBufferSizeKB = value
		FROM	MMConfigs WITH (NOLOCK)
		WHERE	name = 'MMCONFIG_AUXCOPY_CLDEDUP_CACHE_BUFFER_SIZE_KB'
	END
	-- if the source and destination blocksizes do not match then switch off the dedupfactor flags
	IF (@o_SIBlockSizeKB <> @l_srcSIBlockSize)
	BEGIN
SET @o_SIDBStoreFlags = (@o_SIDBStoreFlags & ~131072)
SET @o_dedupeFlags = (@o_dedupeFlags & ~8388608)
SET @o_dedupeFlags = @o_dedupeFlags | 524288
	END
END
SELECT	@o_archGrpFlags, @o_copyFlags, @o_dedupeFlags, @o_encType, @o_encKeyLen,
		@o_SIBlockSizeKB, @o_SIDBStoreId,
		@o_SIMinObjSizeKB, @o_SignatureType, @o_SIDBStoreFlags,
		@o_srcEncType, @o_srcSIDBStoreId,
		@o_sigCacheDBSizeMB, @o_sigCacheBufferSizeKB, @o_extendedFlags, @o_srcExtendedFlags, @o_DedupFactor
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archCopySIDBProp')
	delete from GxQscripts where name = 'archCopySIDBProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopySIDBProp')
	delete from GXDBVersions where aliasname = 'archCopySIDBProp'
GO

insert into GXDBVersions values(2, 'archCopySIDBProp',  '00010018005000110000', 'archCopySIDBProp', '00010018005000110000')
GO

