

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyGetSubclientByAppType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyGetSubclientByAppType.sp,v $ $Id: archCopyGetSubclientByAppType.sp,v 1.9.42.6 2018/03/22 01:13:46 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archCopyGetSubclientByAppType <<<'

IF EXISTS (select * from sysobjects where name='archCopyGetSubclientByAppType')
	drop procedure archCopyGetSubclientByAppType
IF EXISTS (select * from GxQscripts where name='archCopyGetSubclientByAppType')
	delete from GxQscripts where name = 'archCopyGetSubclientByAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyGetSubclientByAppType')
	delete from GXDBVersions where aliasname = 'archCopyGetSubclientByAppType'
GO
print '... Creating Procedure: archCopyGetSubclientByAppType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCopyGetSubclientByAppType
  @i_archGroupCopyId integer,
  @i_archGroupId integer,
  @i_appType integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_clientId integer
  DECLARE @o_clientName NVARCHAR(255)
  DECLARE @o_netHostName NVARCHAR(255)
  DECLARE @o_appTypeId integer
  DECLARE @o_appTypename varchar(255)
  DECLARE @o_Instanceid integer
  DECLARE @o_instanceName NVARCHAR(255)
  DECLARE @o_backupsetId integer
  DECLARE @o_backupSetName NVARCHAR(255)
  DECLARE @o_subclientId integer
  DECLARE @o_subclientName NVARCHAR(255)
  DECLARE @o_isSelected integer
	set nocount on
	if object_id('tempdb.dbo.#tmpCopyApps') is not null DROP TABLE #tmpCopyApps
	create table #tmpCopyApps (id int,
				clientId	int,
				appTypeId	int,
				instance	int,
				backupSet	int,
				subclientName nvarchar(512),
				isSelected int)
	declare @i_sourceCopyId integer
	-- set @i_sourceCopyId = (select sourceCopyId from archGroupCopy where id = @i_archGroupCopyId)
	-- if  @i_sourceCopyId = 0
	--     set @i_sourceCopyId = (select defaultCopy from archGroup where id = @i_archGroupId)
	insert into #tmpCopyApps
	select id, clientId, appTypeId, instance, backupSet, subclientName, 0
	from APP_Application
	where dataArchGrpId = @i_archGroupId or logArchGrpId = @i_archGroupId
IF (@i_appType = 1016)
	BEGIN
		insert into #tmpCopyApps
		select a.id, a.clientId, a.appTypeId, a.instance, a.backupSet, a.subclientName, 0
		from APP_Application a  inner join archgroup B
			on b.incrsp=@i_archGroupId
			and b.id=a.dataArchGrpId
			left outer join #tmpCopyApps C
	    	on a.id=c.id
	    	where c.id is  null
	END
	-- insert into #tmpCopyApps
	-- select id, clientId, appTypeId, instance, backupSet, subclientName, 0
	-- from APP_Application
	-- where id not in (select id from #tmpCopyApps)
	--       and id in (select appId from JMJobDatastats where archGrpCopyId = @i_sourceCopyId
	--                  and status in (100, 101, 102, 103) and (disabled & (1 + 256)) = 0)
	-- check the client license by app type
	IF ( @i_appType > 0 )
	BEGIN
		DELETE	#tmpCopyApps
		WHERE NOT EXISTS (
			--SELECT ID FROM	LicUsage
			--WHERE	CId = clientId AND LicType NOT IN (71, 10, 26) AND
			--		OpType = 'install' AND installFlag = 0 AND
			--		AppType = @i_appType AND
			--		LicType = ( SELECT simLicAppType FROM simAppTypeLicTypeMap WHERE appTypeId = @i_appType)
			select prop.componentNameId from
			APP_clientProp prop
where prop.attrName ='Content Indexing Enabled'
                and prop.componentNameId=clientId and prop.attrVal='1' AND prop.modified =0
			)
	END
IF @i_appType = 1016 AND EXISTS (SELECT * FROM ArchContentIndexingApp WHERE archGroupId = @i_archGroupId)
	BEGIN
		update #tmpCopyApps set isSelected = 1
		from #tmpCopyApps as B, ArchContentIndexingApp as A
		WHERE A.archGroupId = @i_archGroupId AND (A.subClientId = B.id
			and A.backupSetId = B.backupSet and A.instanceId = B.instance
			and A.appTypeId = B.appTypeId and A.clientId = B.clientId)
		update #tmpCopyApps set isSelected = 2
		from #tmpCopyApps as B, ArchContentIndexingApp as A
		WHERE A.archGroupId = @i_archGroupId AND (A.subClientId = 0 AND
			A.backupSetId = B.backupSet and A.instanceId = B.instance
			and A.appTypeId = B.appTypeId and A.clientId = B.clientId)
		update #tmpCopyApps set isSelected = 3
		from #tmpCopyApps as B, ArchContentIndexingApp as A
		WHERE A.archGroupId = @i_archGroupId AND A.subClientId = 0 AND A.backupSetId = 0
			AND (A.instanceId = B.instance and A.appTypeId = B.appTypeId
			and A.clientId = B.clientId)
		update #tmpCopyApps set isSelected = 4
		from #tmpCopyApps as B, ArchContentIndexingApp as A
		WHERE A.archGroupId = @i_archGroupId AND (A.subClientId = 0 AND A.backupSetId = 0
			AND A.instanceId = 0 AND A.appTypeId = B.appTypeId and A.clientId = B.clientId)
		update #tmpCopyApps set isSelected = 5
		from #tmpCopyApps as B, ArchContentIndexingApp as A
		WHERE A.archGroupId = @i_archGroupId AND (A.subClientId = 0 AND A.backupSetId = 0
			AND A.instanceId = 0 AND A.appTypeId = 0 AND
			A.clientId = B.clientId)
	END
ELSE IF @i_appType = 1135   -- entity extraction associated subclients
	BEGIN
		DELETE #tmpCopyApps
		FROM APP_Application AP WITH (NOLOCK)
WHERE AP.ID = #tmpCopyApps.id AND (AP.subclientstatus & 0x20000) <> 0
		DECLARE @appIdList TABLE (t_appId INT, t_clientId INT, t_appTypeId INT, t_instanceId INT, t_bkpSetId INT, t_archGroupId INT)
		INSERT INTO @appIdList (t_appId , t_clientId , t_appTypeId , t_instanceId , t_bkpSetId , t_archGroupId)
		SELECT DISTINCT  AP.id, AP.clientId, AP.appTypeId, instance, backupSet, dataArchGrpID
		FROM APP_Application AP WITH (NOLOCK)
			 INNER JOIN EntitySelection ER  WITH (NOLOCK) ON AP.id = ER.subClientId
		WHERE dataArchGrpID = @i_archGroupId AND ER.Enabled = 1
		update #tmpCopyApps set isSelected = 1
		from #tmpCopyApps as B, @appIdList  as A
		WHERE A.t_archGroupId = @i_archGroupId AND A.t_appId = B.id
	END
	ELSE
	BEGIN
		update #tmpCopyApps set isSelected = 6
	END
	select tt.clientId, cl.name as clientName, cl.net_hostname as netHostName,
	tt.appTypeId, aType.name as appTypename,
	tt.instance, iName.name as instanceName,
	tt.backupset, bsn.name as backupSetName,
	tt.id, tt.subclientName, tt.isSelected
	from #tmpCopyApps as tt, APP_Client as cl, APP_iDAType as aType,
	APP_InstanceName as iName, APP_BackupSetName as bsn
	where tt.clientId = cl.Id and tt.appTypeId = aType.type and
	tt.instance = iName.id and tt.backupSet = bsn.id
	drop table #tmpCopyApps
	set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'archCopyGetSubclientByAppType')
	delete from GxQscripts where name = 'archCopyGetSubclientByAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyGetSubclientByAppType')
	delete from GXDBVersions where aliasname = 'archCopyGetSubclientByAppType'
GO

insert into GXDBVersions values(2, 'archCopyGetSubclientByAppType',  '00010009004200060000', 'archCopyGetSubclientByAppType', '00010009004200060000')
GO

