

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyEncryptionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyEncryptionInfo.sp,v $ $Id: archCopyEncryptionInfo.sp,v 1.4.12.18 2020/05/10 01:16:41 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopyEncryptionInfo')
BEGIN
	print '>>> Drop Stored Procedure: archCopyEncryptionInfo <<<'
	drop procedure archCopyEncryptionInfo
END
IF EXISTS (select * from GxQscripts where name='archCopyEncryptionInfo')
	delete from GxQscripts where name = 'archCopyEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archCopyEncryptionInfo'
GO
print '... Creating Procedure: archCopyEncryptionInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCopyEncryptionInfo
  @i_archCopyId int,
  @i_operation int = 0,			
  @i_keyProvider NVARCHAR(1024) = ''
AS
  DECLARE @o_errorCode int;
  DECLARE @o_KeyCopyId int;
  DECLARE @o_RSAPubKey varchar(2048);
  DECLARE @o_RSAPriKey varchar(3072);
  DECLARE @o_MasterKeyId varchar(2048);
  DECLARE @o_KeyProviderId int;
  DECLARE @o_KeyProviderName nvarchar(1024)
  DECLARE @o_NewKeyProviderId int;
  DECLARE @o_EncType int;
  DECLARE @o_PriKeyLen int;
  DECLARE @o_MasterKeyLen int;
  DECLARE @o_KeyProviderType int;
  DECLARE @o_LastValidation int;
  DECLARE @o_KeyProviderGUID uniqueidentifier
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_errorCode = 0
SET @o_KeyCopyId = @i_archCopyId
SET	@o_RSAPubKey	= ''
SET	@o_RSAPriKey	= ''
SET	@o_MasterKeyId	= ''
SET @o_KeyProviderId = 0
SET @o_KeyProviderName = ''
SET @o_NewKeyProviderId = 0
SET @o_EncType = 0
SET @o_PriKeyLen = 0
SET @o_MasterKeyLen = 0
SET @o_KeyProviderType = 0
SET @o_LastValidation = 0
DECLARE @l_OldKeyProviderType INT = 0
DECLARE @l_NewKeyProviderType INT = 0
DECLARE @l_currentUtcTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @l_archGroupId INT = 0
DECLARE @l_copyType INT = 0
DECLARE @l_isSnapCopy INT = 0
DECLARE @l_dedupeFlags INT = 0
DECLARE @l_flags INT = 0
DECLARE	@l_extendedFlags INT = 0
DECLARE @l_sourceCopyId INT = 0
DECLARE @l_destMediaCopyId INT = 0
SELECT 	@l_archGroupId = archGroupId,
		@l_copyType = type,
		@l_isSnapCopy = isSnapCopy,
		@l_dedupeFlags = dedupeFlags,
		@l_flags = flags,
		@l_extendedFlags = extendedFlags,
		@l_sourceCopyId = sourceCopyId,
		@l_destMediaCopyId = destMediaCopyId
FROM	archGroupCopy WITH(READUNCOMMITTED)
WHERE 	id = @i_archCopyId
IF @i_operation NOT IN (4 /*CVA_COPY_ENC_OPERATION_UPDATE_INPUT_COPY*/, 3 /*CVA_COPY_ENC_OPERATION_GET_DEPENDENT*/)
BEGIN
	--For GDSP keyProvider is set for only primary copy of GDSP and all dependent copies shares same keyProvider.
IF (@l_dedupeFlags & 134217728) = 134217728
	BEGIN
		SELECT 	@o_KeyCopyId = AG.defaultCopy
		FROM 	archCopyToGlobalPolicy GP WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
		WHERE 	GP.copyId = @i_archCopyId
			AND GP.globalPolicyId = AG.id
	END
	--From V11 SP10 for GACP keyProvider is set on only primary copy of GACP and all dependent copies shares same keyProvider.
	--For Jobs ran prior to SP10 we should return the dependent copy RSA keys
ELSE IF (@l_extendedFlags & 2) = 2
		SET @o_KeyCopyId = @l_destMediaCopyId
ELSE IF (@l_extendedFlags & 8192) = 8192
	BEGIN
		SELECT 	@o_KeyCopyId = GAG.defaultCopy
		FROM	archCopyToGlobalPolicy DC2GC WITH(READUNCOMMITTED), archGroup GAG WITH(READUNCOMMITTED)
		WHERE	DC2GC.copyId = @i_archCopyId AND GAG.id = DC2GC.globalPolicyId
	END
	--Transitive copy should use source copy RSA keys only
ELSE IF @l_copyType = 5 /*CVA_AGCOPYTYPE_TRANSITIVE */
		SET @o_KeyCopyId = @l_sourceCopyId
END
IF @i_operation = 3 /*GET_DEPENDENT*/
	SET @i_operation = 0 /*GET*/
ELSE IF @i_operation = 4 /*CVA_COPY_ENC_OPERATION_UPDATE_INPUT_COPY*/
SET @i_operation = 2 /*CVA_COPY_ENC_OPERATION_UPDATE*/
--For dependent copies only GET operation is allowed, any modifications should be done on the parent copy itself
IF @i_operation <> 0 /*GET*/ AND @o_KeyCopyId <> @i_archCopyId
BEGIN
SET @o_errorCode = 197
	GOTO CX_EXIT
END
--Do not generate RSA keys for Snap copies
IF @i_operation = 1 /*CREATE*/ AND @l_isSnapCopy = 1
BEGIN
SET @o_errorCode = 179
	GOTO CX_EXIT
END
--Do not generate RSA keys for DR policy
IF EXISTS(SELECT 1 FROM archGroup AG WITH(READUNCOMMITTED)
WHERE AG.id = @l_archGroupId AND AG.type = 2 /*CVA_COMMSERVE_ER_SP*/)
BEGIN
	--Enabling passphrase needs rotation of all keys associated with built-in key provider so for update don't set error code
	IF @i_operation <> 2 /*UPDATE*/
SET @o_errorCode = 196
	--For GET we should still continue and return the properties since we need it for decrypting keys for jobs ran already.
	--For UPDATE also we should continue since we need to rotate the master key to enable passphrase
	IF @i_operation = 1 /*CREATE*/
		GOTO CX_EXIT
END
--Get Key provider info
IF @i_keyProvider <> ''
BEGIN
	SELECT 	@o_NewKeyProviderId = KeyProviderId, @l_NewKeyProviderType = KeyProviderType
	FROM	ArchEncKeyProvider WITH(READUNCOMMITTED)
	WHERE	KeyProviderName = @i_keyProvider
	IF @o_NewKeyProviderId = 0
	BEGIN
SET @o_errorCode = 167
		GOTO CX_EXIT
	END
END
-- i_operation  - 0 : GET, 1 : CREATE, 2: UPDATE
IF @i_operation = 1 /*CREATE*/
BEGIN
	--This will be set when creating copy or enabling encryption for the first time for existing copies.
	--We will make an entry into ArchCopyEncProperties table for the copy with keyProviderId
	--MasterKeyId will be set later when master key gets created
	--PubKey and PriKey will be set later when they are generated
	IF @o_NewKeyProviderId = 0
		SET @o_NewKeyProviderId = 1 -- 1 is default COMMVAULT encryption
	--For storage policy clone we already make an entry into this table with the keyProviderId from cloning copy
	--so if row exists don't insert new one.
	IF NOT EXISTS(SELECT 1 FROM ArchCopyEncProperties WHERE CopyId = @o_KeyCopyId)
	BEGIN
		INSERT INTO ArchCopyEncProperties (CopyId, PubKey, PriKey, MasterKeyId, KeyProviderId, EncType)
		VALUES (@o_KeyCopyId, '', '', '', @o_NewKeyProviderId, 0)
	END
END
--Get Enc Properties
SELECT	@o_RSAPubKey = EP.PubKey, @o_RSAPriKey = EP.PriKey, @o_MasterKeyId = EP.MasterKeyId, @o_KeyProviderId = EP.KeyProviderId,
		@o_KeyProviderName = KP.KeyProviderName, @o_EncType = EP.EncType, @l_OldKeyProviderType = KP.KeyProviderType, @o_KeyProviderType = KP.KeyProviderType,
		@o_LastValidation = CASE WHEN EP.LastValidatedTime > 0 THEN (@l_currentUtcTime - EP.LastValidatedTime) ELSE 0 END, @o_KeyProviderGUID = KP.GUID
FROM	ArchCopyEncProperties EP WITH(READUNCOMMITTED), ArchEncKeyProvider KP WITH(READUNCOMMITTED)
WHERE	EP.CopyId = @o_KeyCopyId AND EP.KeyProviderId = KP.KeyProviderId
IF @i_operation = 2 /*UPDATE*/
BEGIN
	-- Allow moving from third party to COMMVAULT only when config param is set
	-- This proc will just check whether change allowed or not and returns new provider id. The caller of this proc (ArchiveManagerCS::rotateMasterKeyForCopy) will do updating key provider.
	IF 	@o_NewKeyProviderId > 0
		AND @l_OldKeyProviderType <> @l_NewKeyProviderType
AND @l_NewKeyProviderType = 1 /*CVA_ENC_KEY_PROVIDER_COMMVAULT*/
		AND NOT EXISTS(SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MM_CONFIG_ALLOW_CHANGING_ENC_KEY_PROVIDER' AND value = 1)
	BEGIN
SET @o_errorCode = 175
		GOTO CX_EXIT
	END
	ELSE IF @o_NewKeyProviderId = 0
	BEGIN
		--No change in key provider, return current provider for new one also.
		SET @o_NewKeyProviderId = @o_KeyProviderId
	END
END
CX_EXIT:
SELECT @o_errorCode AS 'ErrorCode', @o_KeyCopyId AS 'KeyCopyId', @o_RSAPubKey AS 'PubKey', @o_RSAPriKey AS 'PriKey', @o_MasterKeyId AS 'MasterKeyId',
		@o_KeyProviderId AS 'KeyProviderId', @o_KeyProviderName AS 'KeyProviderName', @o_NewKeyProviderId AS 'NewKeyProviderId', @o_EncType AS 'EncType',
		len(@o_RSAPriKey) AS 'PriKeyLen', len(@o_MasterKeyId) AS 'MasterKeyLen',@o_KeyProviderType AS 'KeyProviderType', @o_LastValidation AS 'LastValidation', @o_KeyProviderGUID AS 'KeyProviderGUID'
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archCopyEncryptionInfo')
	delete from GxQscripts where name = 'archCopyEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archCopyEncryptionInfo'
GO

insert into GXDBVersions values(2, 'archCopyEncryptionInfo',  '00010004001200180000', 'archCopyEncryptionInfo', '00010004001200180000')
GO

