

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyAppSubset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyAppSubset.sp,v $ $Id: archCopyAppSubset.sp,v 1.4.34.8 2019/11/21 21:03:53 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopyAppSubset')
BEGIN
	print '>>> Drop Stored Procedure: archCopyAppSubset <<<'
	drop procedure archCopyAppSubset
END
IF EXISTS (select * from GxQscripts where name='archCopyAppSubset')
	delete from GxQscripts where name = 'archCopyAppSubset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyAppSubset')
	delete from GXDBVersions where aliasname = 'archCopyAppSubset'
GO
print '... Creating Procedure: archCopyAppSubset'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCopyAppSubset
  @archGroupCopyId integer,
  @archGroupId integer,
  @i_inputXML varchar(MAX) = ''
AS
-- Following are the "columns" returned, in the order in which they are returned
BEGIN
	set nocount on
	if object_id('tempdb.dbo.#tmpCopyApps') is not null DROP TABLE #tmpCopyApps
	create table #tmpCopyApps (id int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int)
	if object_id('tempdb.dbo.#copyIdToProcess') is not null DROP TABLE #copyIdToProcess
	CREATE TABLE #copyIdToProcess ( copyId  INTEGER,  isExclusionList INTEGER  DEFAULT(0), srcCopyId INTEGER DEFAULT(0) primary key 	(copyId))
	if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
	CREATE TABLE #archCopyToAppId (
	copyId			INTEGER,
	AppId				INTEGER
	)
	CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
	declare @l_archGroupId integer
	declare @l_archGroupCopyId integer
	declare @l_sourceCopyId integer
	declare @l_extendedFlags BIGINT
	set @l_archGroupCopyId = @archGroupCopyId
	set @l_archGroupId = @archGroupId
	select @l_sourceCopyId = sourceCopyId, @l_extendedFlags = extendedFlags  from archGroupCopy WITH (READUNCOMMITTED) where id = @l_archGroupCopyId
	if  @l_sourceCopyId = 0
	    set @l_sourceCopyId = (select defaultCopy from archGroup WITH (READUNCOMMITTED) where id = @l_archGroupId)
--
-- BEGIN: archCopyToAppGetAGApps.spb
--
		INSERT INTO #tmpCopyApps
		SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
		FROM	APP_Application A WITH (READUNCOMMITTED)
		WHERE 	EXISTS (SELECT TOP 1 1 FROM JMJobDatastats JDS WITH (READUNCOMMITTED) WHERE archGrpId = @l_archGroupId
					AND status IN (100, 101, 102, 103) AND (disabled & (1 + 256)) = 0 AND A.id = JDS.appId )
		CREATE INDEX tmpCopyApps_idx1 ON #tmpCopyApps (id)
		INSERT INTO #tmpCopyApps
		SELECT	DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
		FROM	APP_Application A WITH (READUNCOMMITTED) LEFT OUTER JOIN #tmpCopyApps B ON A.id = B.id
		WHERE	B.id IS Null
AND (A.dataArchGrpId = @l_archGroupId or (A.logArchGrpId = @l_archGroupId AND A.appTypeId in (22, 104, 61, 37, 5, 81, 3, 125)) )
AND A.appTypeId <> 1030
		INSERT INTO #tmpCopyApps
		SELECT	DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
FROM	APP_Application A WITH (READUNCOMMITTED) INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON (A.dataArchGrpId = AG.Id or (A.logArchGrpId = AG.Id AND A.appTypeId in (22, 104, 61, 37, 5, 81, 3, 125)) ) LEFT OUTER JOIN #tmpCopyApps B ON A.id = B.id
		WHERE	B.id IS Null
			AND AG.incrSP = @l_archGroupId
AND A.appTypeId <> 1030
--
-- END: archCopyToAppGetAGApps.spb
--
	IF EXISTS (SELECT 1 FROM ArchCopyToApp WHERE copyId = @l_archGroupCopyId AND assocType <> 2) OR @i_inputXML <> ''
	BEGIN
		exec  archGetArchCopyToAppAssociations @l_archGroupCopyId, @i_inputXML
		UPDATE	#tmpCopyApps
		SET		isSelected = 3
		FROM	#tmpCopyApps t LEFT JOIN #archCopyToAppId a ON a.copyId = @l_archGroupCopyId AND t.Id = a.appId
		WHERE 	a.appId IS NOT NULL
	END
	ELSE
		UPDATE	#tmpCopyApps
		SET		isSelected = 6
	if object_id('tempdb.dbo.#tmpCopyAppsOut') is not null
	BEGIN
	INSERT INTO #tmpCopyAppsOut
	SELECT * FROM #tmpCopyApps
	END
	ELSE
	BEGIN
	select	tt.clientId, cl.name as clientName, cl.net_hostname as netHostName,
			tt.appTypeId, aType.name as appTypename,
			tt.instance, iName.name as instanceName,
			tt.backupset, bsn.name as backuupSetName,
			tt.id, tt.subclientName, tt.isSelected
	from	#tmpCopyApps as tt, APP_Client as cl WITH (READUNCOMMITTED), APP_iDAType as aType WITH (READUNCOMMITTED),
			APP_InstanceName as iName WITH (READUNCOMMITTED), APP_BackupSetName as bsn WITH (READUNCOMMITTED)
	where	tt.clientId = cl.Id and tt.appTypeId = aType.type
		and tt.instance = iName.id and tt.backupSet = bsn.id
	ORDER BY clientName, appTypename, instanceName, backuupSetName, tt.subclientName
	END
	drop table #tmpCopyApps
	if object_id('tempdb.dbo.#copyIdToProcess') is not null DROP TABLE #copyIdToProcess
	set nocount off
END

IF EXISTS (select * from GxQscripts where name = 'archCopyAppSubset')
	delete from GxQscripts where name = 'archCopyAppSubset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyAppSubset')
	delete from GXDBVersions where aliasname = 'archCopyAppSubset'
GO

insert into GXDBVersions values(2, 'archCopyAppSubset',  '00010004003400080000', 'archCopyAppSubset', '00010004003400080000')
GO

