

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyAppIncludedEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyAppIncludedEntities.sp,v $ $Id: archCopyAppIncludedEntities.sp,v 1.1.2.3 2019/12/18 22:49:57 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopyAppIncludedEntities')
BEGIN
	print '>>> Drop Stored Procedure: archCopyAppIncludedEntities <<<'
	drop procedure archCopyAppIncludedEntities
END
IF EXISTS (select * from GxQscripts where name='archCopyAppIncludedEntities')
	delete from GxQscripts where name = 'archCopyAppIncludedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyAppIncludedEntities')
	delete from GXDBVersions where aliasname = 'archCopyAppIncludedEntities'
GO
print '... Creating Procedure: archCopyAppIncludedEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archCopyAppIncludedEntities
  @i_copyId integer,
  @i_archGroupId integer,
  @i_inputXML varchar(MAX) = ''
AS
-- Following are the "columns" returned, in the order in which they are returned
BEGIN
	if object_id('tempdb.dbo.#tmpCopyAppsOut') is not null DROP TABLE #tmpCopyAppsOut
	CREATE TABLE #tmpCopyAppsOut (id int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int)
	IF OBJECT_ID('tempdb.dbo.#tblarchCopyToApp') is not null DROP TABLE #tblarchCopyToApp
	create table #tblarchCopyToApp (ClientId int, appTypeId int, instanceId int, backupSetId int, subClientId int, assocType int default 0)
	IF OBJECT_ID('tempdb.dbo.#tblarchCopyToAppEx') is not null DROP TABLE #tblarchCopyToAppEx
	create table #tblarchCopyToAppEx(ClientId int, appTypeId int, instanceId int, backupSetId int, subClientId int, assocType int default 0)
	--DECLARE @i_copyId INT  = 123
	--DECLARE @i_archGroupId INT = 47
	exec archCopyAppSubset @i_copyId,@i_archGroupId, @i_inputXML
	IF OBJECT_ID('tempdb.dbo.#tempArchCopyToApp') IS NOT NULL DROP TABLE #tempArchCopyToApp
	-- This table is holding a copy of archCopyToApp or XML based on the @i_inputXML
	CREATE TABLE #tempArchCopyToApp (
		copyId		INTEGER,
		clientId 	INTEGER,
		appTypeId 	INTEGER,
		instanceId 	INTEGER,
		backupSetId INTEGER,
		subClientId INTEGER,
		clientGroupId INTEGER,
		exclude INTEGER,
		assocType INTEGER
	)
	INSERT INTO #tblarchCopyToApp
	SELECT DISTINCT clientId, 0, 0, 0,0,0
	FROM #tmpCopyAppsOut WITH (NOLOCK) where isSelected > 0
	IF @i_inputXML = ''
	BEGIN
		INSERT INTO #tempArchCopyToApp
		SELECT *
		FROM archCOpyToapp WITH (READUNCOMMITTED)
		WHERE copyId = @i_copyId
	END
	ELSE
	BEGIN
		DECLARE @i_xmlStr XML = convert(XML,@i_inputXML)
		INSERT INTO #tempArchCopyToApp
		SELECT
			@i_copyId,
			ISNULL((doc.col.value('@clientId', 'INT')),0),
			ISNULL((doc.col.value('@applicationId', 'INT')),0),
			ISNULL((doc.col.value('@instanceId', 'INT')),0),
			ISNULL((doc.col.value('@backupsetId', 'INT')),0),
			ISNULL((doc.col.value('@subclientId', 'INT')),0),
			ISNULL((doc.col.value('@clientGroupId', 'INT')),0),
			ISNULL((doc.col.value(N'(flags/@exclude)[1]', N'int')),0),
			ISNULL((doc.col.value('@_type_', 'INT')),0)
		FROM @i_xmlStr.nodes('EVGui_GetCopyToAppIncludedEntitiesReq/listEntities') doc(col)
	END
	DELETE #tblarchCopyToApp
	OUTPUT DELETED.* INTO #tblarchCopyToAppEx
	FROM #tblarchCopyToApp t, #tempArchCopyToApp A
	WHERE A.exclude = 1 AND A.copyId = @i_copyId
	AND (t.clientID = A.clientiD or (  A.clientId = 0 AND EXISTS (SELECT 1 FROM APP_ClientGroupAssoc CG WITH (READUNCOMMITTED) WHERE CG.clientGroupId = A.clientGroupId AND CG.clientId = t.ClientId)))
	DELETE #tblarchCopyToApp
	INSERT INTO #tblarchCopyToApp
	SELECT DISTINCT t2.clientId, CASE WHEN A.appTypeId > 0 THEN t2.appTypeId ELSE 0 END,
		  CASE WHEN A.appTypeId = t2.appTypeId AND A.instanceId > 0 THEN t2.instance ELSE 0 END,
		  CASE WHEN A.instanceId = t2.instance AND A.backupSetId > 0 THEN t2.backupSet ELSE 0 END,
		  CASE WHEN A.backupSetId = t2.backupSet AND A.subClientId > 0 THEN t2.Id ELSE 0 END,
		  0
	FROM #tblarchCopyToAppEx t1, #tempArchCopyToApp A,#tmpCopyAppsOut t2
	WHERE t1.ClientId = A.clientId AND t2.clientId = A.clientId
	AND T2.isSelected > 0 AND A.exclude = 1 AND A.copyId = @i_copyId
	INSERT INTO #tblarchCopyToApp
	SELECT T2.clientId, A.appTypeId, A.instanceId, A.backupSetId,A.subClientId, 0
	FROM  #tempArchCopyToApp  A WITH (NOLOCK),#tmpCopyAppsOut t2
	WHERE ((t2.clientId = A.clientId AND A.ClientId > 0) OR A.assocType = 2 )
	AND T2.isSelected > 0 AND A.copyId = @i_copyId AND NOT EXISTS (SELECT 1 FROM #tblarchCopyToAppEx t1 WHERE t1.ClientId = T2.clientId)
	AND NOT EXISTS (SELECT 1 FROM  #tmpCopyAppsOut t3 WHERE t3.clientId = t2.clientId and t3.isSelected = 0)
	UNION
	SELECT CG.clientId, A.appTypeId, A.instanceId, A.backupSetId,A.subClientId, 0
	FROM  #tempArchCopyToApp  A WITH (NOLOCK),#tmpCopyAppsOut t2, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
	WHERE t2.clientId = CG.clientId AND A.ClientId = 0  AND (A.clientGroupId = CG.clientGroupId OR A.assocType = 27)
	AND T2.isSelected > 0 AND A.copyId = @i_copyId AND not EXISTS (SELECT 1 FROM #tblarchCopyToAppEx t1 WHERE t1.ClientId = A.clientId)
	AND NOT EXISTS (SELECT 1 FROM  #tmpCopyAppsOut t3 WHERE t3.clientId = t2.clientId and t3.isSelected = 0)
	UNION
	SELECT T2.clientId, 0, 0, 0, 0, 0
	FROM #tmpCopyAppsOut T2
	WHERE NOT EXISTS (SELECT 1 FROM #tempArchCopyToApp)
	AND NOT EXISTS (SELECT 1 FROM  #tmpCopyAppsOut t3 WHERE t3.clientId = t2.clientId and t3.isSelected = 0)
	--now we should be left only with VMs that are included from the associations but there is some excluded at parent level
	-- for such entries, we will have to add the subclient level associations.
	INSERT INTO #tblarchCopyToApp
	SELECT T2.clientId, T2.appTypeId, T2.instance, T2.backupSet,T2.Id, 0
	FROM  #tempArchCopyToApp  A WITH (NOLOCK),#tmpCopyAppsOut t2
	WHERE ((t2.clientId = A.clientId AND A.ClientId > 0) OR A.assocType = 2 )
	AND T2.isSelected > 0 AND A.copyId = @i_copyId AND NOT EXISTS (SELECT 1 FROM #tblarchCopyToAppEx t1 WHERE t1.ClientId = T2.clientId)
	AND NOT EXISTS (SELECT 1 FROM #tblarchCopyToApp o WHERE o.clientId = T2.clientId)
	IF OBJECT_ID('tempdb.dbo.#tempArchCopyToApp') IS NOT NULL DROP TABLE #tempArchCopyToApp
	UPDATE #tblarchCopyToApp
	SET assocType = CASE WHEN subClientId > 0 THEN 7 WHEN backupSetId > 0 THEN 6 WHEN InstanceId > 0 THEN 5 WHEN AppTypeId > 0 THEN 4 WHEN clientId > 0 THEN 3 ELSE 0 END
	DELETE #tblarchCopyToApp
	FROM #tblarchCopyToApp ch
	WHERE EXISTS
	(SELECT 1 FROM #tblarchCopyToApp par
		WHERE ch.assocType > par.assocType
		AND ch.clientId = par.clientId
		AND	(par.apptypeID = 0 OR par.appTypeId = ch.appTypeId)
		AND (par.instanceId = 0  OR par.instanceId = ch.instanceId)
		AND (par.backupSetId = 0 OR par.backupSetId = ch.backupSetId)
		AND (par.subClientId = 0 OR par.subClientId = ch.subClientId)
	 )
	select	tt.clientId, ISNULL(cl.name,'') as clientName,
			tt.appTypeId, ISNULL(aType.name,'') as appTypename,
			tt.instanceId, ISNULL(iName.name,'') as instanceName,
			tt.backupsetId, ISNULL(bsn.name,'') as backuupSetName,
			tt.subClientId, ISNULL(aa.subclientName,'') as subclientName,
			1 as include, 0 as exclude, tt.assocType
	from	#tblarchCopyToApp as tt LEFT JOIN APP_Client as cl WITH (READUNCOMMITTED) ON tt.clientId = cl.Id LEFT JOIN APP_iDAType as aType WITH (READUNCOMMITTED) ON tt.appTypeId = aType.type
				LEFT JOIN APP_InstanceName as iName WITH (READUNCOMMITTED) ON tt.instanceId = iName.id LEFT JOIN APP_BackupSetName as bsn WITH (READUNCOMMITTED) ON tt.backupSetId = bsn.id
				LEFT JOIN app_application as aa WITH (READUNCOMMITTED) ON tt.subClientId = aa.id
END

IF EXISTS (select * from GxQscripts where name = 'archCopyAppIncludedEntities')
	delete from GxQscripts where name = 'archCopyAppIncludedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyAppIncludedEntities')
	delete from GXDBVersions where aliasname = 'archCopyAppIncludedEntities'
GO

insert into GXDBVersions values(2, 'archCopyAppIncludedEntities',  '00010001000200030000', 'archCopyAppIncludedEntities', '00010001000200030000')
GO

