

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyAppExcludedEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyAppExcludedEntities.sp,v $ $Id: archCopyAppExcludedEntities.sp,v 1.1.2.1 2020/03/17 20:41:10 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopyAppExcludedEntities')
BEGIN
	print '>>> Drop Stored Procedure: archCopyAppExcludedEntities <<<'
	drop procedure archCopyAppExcludedEntities
END
IF EXISTS (select * from GxQscripts where name='archCopyAppExcludedEntities')
	delete from GxQscripts where name = 'archCopyAppExcludedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyAppExcludedEntities')
	delete from GXDBVersions where aliasname = 'archCopyAppExcludedEntities'
GO
print '... Creating Procedure: archCopyAppExcludedEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archCopyAppExcludedEntities
  @archGroupCopyId integer,
  @l_archGroupId integer,
  @i_inputXML varchar(MAX) = ''
AS
-- Following are the "columns" returned, in the order in which they are returned
BEGIN
	if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
	CREATE TABLE #archCopyToAppId (
	copyId			INTEGER,
	AppId				INTEGER
	)
	CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
	DECLARE @entityType INT= 0
	DECLARE @entityId INT = 0
	exec archGetArchCopyToAppAssociations @archGroupCopyId, @i_inputXML
	if object_id('tempdb.dbo.#tmpCopyApps') is not null DROP TABLE #tmpCopyApps
	create table #tmpCopyApps (id int, clientGroupId int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int, assocType INT) -- isSelected = 0 means excluded, 1  selected, 2 just for population
	if object_id('tempdb.dbo.#tblExcludedEntites') is not null DROP TABLE #tblExcludedEntites
	create table #tblExcludedEntites (id int, clientGroupId int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int, assocType INT) -- isSelected = 0 means excluded, 1  selected, 2 just for population
--
-- BEGIN: archCopyToAppGetAGApps.spb
--
/*
XmlMessage/CvEntities.x
CLIENT_ENTITY = 3,
CLIENT_GROUP_ENTITY = 28,
*/
		INSERT INTO #tmpCopyApps
		SELECT	DISTINCT A.id, 0, A.clientId, A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
		FROM	APP_Application A WITH (READUNCOMMITTED)
		WHERE (@entityType IN (0, 28)OR (@entityId  = A.clientId AND @entityType = 3))
		AND EXISTS (SELECT TOP 1 1 FROM JMJobDatastats JDS WITH (READUNCOMMITTED) WHERE archGrpId = @l_archGroupId
					AND status IN (100, 101, 102, 103) AND (disabled & (1 + 256)) = 0 AND A.id = JDS.appId )
		UNION
		SELECT	DISTINCT A.id , 0, A.clientId, A.appTypeId , A.instance , A.backupSet , A.subclientName , 2, 0
		FROM	APP_Application A WITH (READUNCOMMITTED)
WHERE	(A.dataArchGrpId = @l_archGroupId or (A.logArchGrpId = @l_archGroupId AND A.appTypeId in (22, 104, 61, 37, 5, 81, 3, 125)) )
AND A.appTypeId <> 1030
			AND (@entityType IN (0, 28) OR (@entityId  = A.clientId AND @entityType = 3))
		UNION
		SELECT	DISTINCT A.id , 0, A.clientId, A.appTypeId , A.instance , A.backupSet , A.subclientName , 2, 0
FROM	APP_Application A WITH (READUNCOMMITTED) INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON (A.dataArchGrpId = AG.Id or (A.logArchGrpId = AG.Id AND A.appTypeId in  (22, 104, 61, 37, 5, 81, 3, 125)) ) LEFT OUTER JOIN #tmpCopyApps B ON A.id = B.id  LEFT OUTER JOIN APP_ClientGroupAssoc CG WITH (READUNCOMMITTED) ON CG.clientId = A.clientId
		WHERE	B.id IS Null
			AND AG.incrSP = @l_archGroupId
AND A.appTypeId <> 1030
			AND (@entityType IN (0, 28) OR (@entityId  = A.clientId AND @entityType = 3))
		CREATE INDEX tmpCopyApps_idx1 ON #tmpCopyApps (id)
		IF @entityType IN (0, 28)
		BEGIN
			INSERT INTO #tmpCopyApps
			SELECT DISTINCT A.Id, CG.clientGroupId, A.clientId , A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
			FROM #tmpCopyApps A INNER JOIN  APP_ClientGroupAssoc CG WITH (READUNCOMMITTED) ON CG.clientId = A.clientId
			WHERE @entityType = 0 OR (@entityType =28 AND @entityId = CG.clientGroupId)
			IF @entityType = 28
				DELETE #tmpCopyApps
				WHERE clientGroupId = 0
		END
--
-- END: archCopyToAppGetAGApps.spb
--
	-- delete all included entities
	delete #tmpCopyApps
	from #tmpCopyApps t1, #archCopyToAppId t2
	WHERE t2.AppId = t1.Id
	IF OBJECT_ID('tempdb.dbo.#tempArchCopyToApp') IS NOT NULL DROP TABLE #tempArchCopyToApp
	-- This table is holding a copy of archCopyToApp or XML based on the @i_inputXML
	CREATE TABLE #tempArchCopyToApp (
		copyId		INTEGER,
		clientId 	INTEGER,
		appTypeId 	INTEGER,
		instanceId 	INTEGER,
		backupSetId INTEGER,
		subClientId INTEGER,
		clientGroupId INTEGER,
		exclude INTEGER,
		assocType INTEGER
	)
	IF @i_inputXML = ''
	BEGIN
		INSERT INTO #tempArchCopyToApp
		SELECT *
		FROM archCOpyToapp WITH (READUNCOMMITTED)
		WHERE copyId = @archGroupCopyId
	END
	ELSE
	BEGIN
		DECLARE @i_xmlStr XML = convert(XML,@i_inputXML)
		INSERT INTO #tempArchCopyToApp
		SELECT
			@archGroupCopyId,
			ISNULL((doc.col.value('@clientId', 'INT')),0),
			ISNULL((doc.col.value('@applicationId', 'INT')),0),
			ISNULL((doc.col.value('@instanceId', 'INT')),0),
			ISNULL((doc.col.value('@backupsetId', 'INT')),0),
			ISNULL((doc.col.value('@subclientId', 'INT')),0),
			ISNULL((doc.col.value('@clientGroupId', 'INT')),0),
			ISNULL((doc.col.value(N'(flags/@exclude)[1]', N'int')),0),
			ISNULL((doc.col.value('@_type_', 'INT')),0)
		FROM @i_xmlStr.nodes('EVGui_GetCopyToAppExcludedEntitiesReq/listEntities') doc(col)
	END
	-- remove entities that have some exclusion but they are not being excluded themselves
		INSERT INTO #tblExcludedEntites
		SELECT t.*
		from #tmpCopyApps t,#tempArchCopyToApp A
		where A.exclude = 1
			AND	 t.clientId = A.clientId AND A.clientGroupId = t.clientGroupId AND
					(A.appTypeId = 0 OR A.appTypeId = t.appTypeId AND
				(A.instanceId = 0 OR A.instanceId = t.instance AND
				(A.backupSetId = 0 OR A.backupSetId = t.backupSet AND
				(A.subClientId = 0 OR A.subClientId = t.id))))
		UNION
		SELECT t.*
		from #tmpCopyApps t,#tempArchCopyToApp A, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
		where A.exclude = 1 AND CG.ClientGroupID = t.clientGroupID
		AND		A.clientId = 0 AND t.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
	DELETE #tmpCopyApps
	from #tmpCopyApps t, #tblExcludedEntites ex
	WHERE ex.clientId = t.clientId AND ex.appTypeId = t.appTypeId AND ex.backupSet = t.backupSet AND ex.instance = t.instance and ex.id = t.id
	AND ex.clientGroupId <> t.clientGroupId AND NOT EXISTS (SELECT 1 FROM #tblExcludedEntites ex2 WHERE ex2.clientId = t.clientId AND ex2.appTypeId = t.appTypeId AND ex2.backupSet = t.backupSet AND ex2.instance = t.instance and ex2.id = t.id
	AND ex2.clientGroupId = t.clientGroupId)
	select	DISTINCT tt.clientGroupID, ISNULL(CG.name,'') clientGroupName,
		tt.clientId ,cl.name clientName,
		tt.appTypeId, aType.name appTypename,
		tt.instance, iName.name instanceName,
		tt.backupset, bsn.name backuupSetName,
		tt.id, tt.subclientName subclientName
	from	#tmpCopyApps as tt  JOIN APP_Client as cl WITH (READUNCOMMITTED) ON tt.clientId = cl.Id  JOIN APP_iDAType as aType WITH (READUNCOMMITTED) ON tt.appTypeId = aType.type
			  JOIN APP_InstanceName as iName WITH (READUNCOMMITTED) ON tt.instance = iName.id JOIN APP_BackupSetName as bsn WITH (READUNCOMMITTED) ON tt.backupSet = bsn.id
			 LEFT JOIN APP_ClientGroup CG WITH (READUNCOMMITTED) ON CG.id = tt.clientGRoupID
	if object_id('tempdb.dbo.#tblExcludedEntites') is not null DROP TABLE #tblExcludedEntites
	IF OBJECT_ID('tempdb.dbo.#tempArchCopyToApp') IS NOT NULL DROP TABLE #tempArchCopyToApp
	IF object_id('tempdb.dbo.#tmpCopyApps')  IS NOT NULL DROP TABLE #tmpCopyApps
END

IF EXISTS (select * from GxQscripts where name = 'archCopyAppExcludedEntities')
	delete from GxQscripts where name = 'archCopyAppExcludedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyAppExcludedEntities')
	delete from GXDBVersions where aliasname = 'archCopyAppExcludedEntities'
GO

insert into GXDBVersions values(2, 'archCopyAppExcludedEntities',  '00010001000200010000', 'archCopyAppExcludedEntities', '00010001000200010000')
GO

