

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopiesForJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopiesForJob.sp,v $ $Id: archCopiesForJob.sp,v 1.33.12.24 2020/12/17 12:13:18 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCopiesForJob')
BEGIN
	print '>>> Drop Stored Procedure: archCopiesForJob <<<'
	drop procedure archCopiesForJob
END
IF EXISTS (select * from GxQscripts where name='archCopiesForJob')
	delete from GxQscripts where name = 'archCopiesForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopiesForJob')
	delete from GXDBVersions where aliasname = 'archCopiesForJob'
GO
print '... Creating Procedure: archCopiesForJob'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCopiesForJob
  @i_jobId integer,
  @i_appId integer,
  @i_appType integer,
  @i_archGroupId integer,
  @i_startDate integer,
  @i_backupLevel integer,
  @i_fullCycleNum integer,
  @i_nextFullTime integer,
  @i_today integer,
  @i_isSnap integer,
  @o_dbError integer OUTPUT
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- CREATE TABLE #CopiesForJob (copyId int)
-- This temp table is created by caller
CREATE TABLE #tempCopy (
	archGroupId int, copyId int, type int, startTime int, flags int, extendedFlags bigint, siloAppId int, isSnapCopy int, isMirrorCopy int, sourceCopyId int, defaultCopyId int, defaultSnapCopyId int,
	selectionType int, numPeriod int, dayNumber int, startPeriod int, nextPeriod int, prevPeriodBegin int, nextPeriodEnd int)
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
CREATE TABLE #archCopyToAppId (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
if object_id('tempdb.dbo.#copyIdToProcess') is not null DROP TABLE #copyIdToProcess
CREATE TABLE #copyIdToProcess ( copyId  INTEGER,  isExclusionList INTEGER  DEFAULT(0), srcCopyId INTEGER DEFAULT(0) primary key 	(copyId))
SET @o_dbError = 0
SET @retVal = 0
DECLARE	@ORACLE_RMAN_CUSTOMSCRIPT_BKP	BIGINT
SET		@ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0x2000000000000
DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
DECLARE @i_commCellId   INTEGER
SET		@i_commCellId	= 2
DECLARE @l_bkpAttributes BIGINT = 0
DECLARE @l_bkpAttributesEx BIGINT = 0
DECLARE @l_defCopyId	INTEGER = 0
DECLARE @l_defSnapCopyId INTEGER = 0
DECLARE @l_siloCopyId	INTEGER = 0
DECLARE @l_agroupFlags	INTEGER = 0
DECLARE @l_timezoneType	INTEGER = 0
DECLARE @l_TimeZone		VARCHAR(255)
DECLARE @l_csTimeZone	VARCHAR(255)
DECLARE @l_subOpType	INTEGER = 0
SET		@l_TimeZone		= ''
SET		@l_csTimeZone	= ''
DECLARE @CountPartialSuccess INT
SET		@CountPartialSuccess = 1
SELECT	@CountPartialSuccess = isCWEjobValid
FROM	APP_iDAType WITH (NOLOCK)
WHERE	type = @i_appType
SELECT	@l_bkpAttributes = bkpAttributes, @l_bkpAttributesEx = bkpAttributesEx
FROM	JMBkpJobInfo WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
SELECT	@l_subOpType = subOpType
FROM	JMJobInfo WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
DECLARE @l_AllowOracleSAPRegularFull INT = 0
SELECT @l_AllowOracleSAPRegularFull = isnull(value, 1)
FROM MMConfigs WITH(NOLOCK)
WHERE name = 'DA_CONFIG_HONOR_EXTENDED_RETENTION_FOR_ORACLE_SAP_REGULAR_FULL_JOBS'
/*
DECLARE @isCmdLineSubclient INT = 0
DECLARE @isOracleOnDemandSubclient INT = 0
DECLARE @isLogCmdLineSubclient INT = 0
SELECT @isCmdLineSubclient = CASE WHEN App.subclientStatus & 0x0040 = 0x0040 THEN 1 ELSE 0 END,
@isOracleOnDemandSubclient = CASE WHEN Ins.Status & 0x0800 = 0x0800 THEN 1 ELSE 0 END,
@isLogCmdLineSubclient = CASE WHEN App.subclientStatus & 0x1000 = 0x1000 THEN 1 ELSE 0 END
FROM App_Application App WITH(NOLOCK) INNER JOIN App_InstanceName Ins WITH(NOLOCK) ON App.instance = Ins.id
WHERE App.id = @i_appId
*/
DECLARE @isIndexSubclient INT = 0
DECLARE @l_checkSumIndexSubclient INT = CHECKSUM(N'Index SubClient')
SELECT @isIndexSubclient = 1 FROM
App_SubclientProp WITH(NOLOCK) WHERE componentNameId = @i_appId AND cs_attrName = @l_checkSumIndexSubclient
AND attrName = 'Index SubClient' AND attrVal = N'1' AND modified = 0
IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL
	DROP TABLE #tmpAppIdList
CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedOnSelAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
INSERT INTO #tmpAppIdList
SELECT @i_appId, 0, 0, 0, 0
--Set unsupported flag
EXEC ArchIsAuxiliaryCopySupportedForSubclient 0
-- Ignore unSupportedAlways for VSA V2 parent subclient, as reservation is made on parent subclient job during backup.
UPDATE	T
SET		unSupportedAlways = 0
FROM	#tmpAppIdList T WITH (NOLOCK)
		INNER JOIN APP_Application A WITH (NOLOCK) ON T.AppId = A.id
		INNER JOIN APP_InstanceProp IPROP (NOLOCK) ON IPROP.componentNameId = A.instance AND IPROP.attrName = 'Virtual Server Instance Type'  AND IPROP.attrVal <> '' AND IPROP.modified = 0
		INNER JOIN APP_ClientProp (NOLOCK) CP ON CP.componentNameId = A.clientId AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1' -- Indexing V2
WHERE	appId = @i_appId
		AND unSupportedAlways = 1
		AND @l_subOpType NOT IN (/* BACKUP_ADMIN */ 144,
								/* SNAP_BACKUP_ADMIN */ 145,
								/* BACKUP_COPY_ADMIN */ 146,
								/* SYNTH_FULL_ADMIN */ 147)
--BEGIN TRY
SELECT	@l_defCopyId = defaultCopy, @l_defSnapCopyId = defaultSnapCopy, @l_agroupFlags = flags, @l_timezoneType = TimeZoneType, @l_TimeZone	= TimeZone
FROM	archGroup WITH (NOLOCK)
WHERE	id = @i_archGroupId
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
IF ((@i_isSnap = 1) AND @i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768) AND dbo.GetBkpLevelOfSnapJobs(@i_jobId, 2, @l_defSnapCopyId) = 1)
BEGIN
	EXEC @i_nextFullTime = TM_GetNextScheduleRunTime @i_appId, 1/*BkpLevel Full*/, 0/*counDisabled*/, 0/*countRunnigJob*/
	SET @i_backupLevel = 1
END
INSERT	INTO #tempCopy
SELECT	A.archGroupId, A.id, A.type, A.startTime, A.flags, A.extendedFlags, A.siloAppId, A.isSnapCopy, A.isMirrorCopy, A.sourceCopyId, 0, 0, 0, 0, 0, 0, 0, 0, 0
FROM	archGroupCopy A WITH (NOLOCK), #tmpAppIdList T
WHERE	A.archGroupId = @i_archGroupId AND A.isSnapCopy = @i_isSnap
	AND A.isActive = 1 AND A.startTime <= @i_today AND A.startTime <= @i_startDate AND A.endTime > @i_startDate
AND (A.siloAppId = @i_appId OR (A.flags & 524288) = 0)
	AND (
((A.type = 1 AND (T.unSupportedAlways = 0 OR A.id IN (@l_defCopyId, @l_defSnapCopyId))) OR (@isIndexSubclient = 1 AND A.type = 2))
OR A.type = 4
OR A.type = 2 AND (@i_backupLevel IN (1, 64, 128, 16384, 1024, 32768)
		-- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle
		AND (
@i_appType NOT IN (2, 22, 23, 80,
61, 79)
			OR @i_backupLevel IN (1024, 32768)
OR ((@l_bkpAttributes & 0x1000) <> 0 AND @l_AllowOracleSAPRegularFull = 1 AND T.unSupportedDB = 0 /*AND @l_bkpAttributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0*/)
			)
		-- Only take FULL with data for SAP, Informix and DB2
AND (@i_appType NOT IN (3, 37, 62, 103, 128)
OR (@l_bkpAttributes & 0x1000) <> 0)
		-- Only take FULL with Attribute [JMBKP_EX_FULL_JOB_IN_CYCLE] for app aware app backups
		AND (
					(@l_bkpAttributesEx & @EX_APPAWARE_CHILD_JOB) = 0
					OR
					(@l_bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0)
				)
		AND T.unSupportedOnSelAlways = 0
		))
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
IF(@isIndexSubclient = 1)
BEGIN
    --If this is index subclient job treat selective copies as synchronous copy. Manual selective still stays as manual selective copy unless a config param is set
	DECLARE @pickIndexBackupToManualSelectiveCopy INT = 0
	SELECT @pickIndexBackupToManualSelectiveCopy = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'AUXCOPY_AUTOPICK_INDEXBACKUPS_ON_MANUAL_SELECTION_COPIES'
	UPDATE #tempCopy
SET		type = CASE WHEN B.type IN (9,8) AND @pickIndexBackupToManualSelectiveCopy = 0 THEN 2 ELSE 1 END
	FROM   #tempCopy A INNER JOIN archSelectiveCopy B WITH (NOLOCK) ON A.copyId = B.copyId
WHERE A.type = 2
	SET @o_dbError = (@@ERROR)
	IF @o_dbError <> 0
		GOTO CV_EXIT
END
IF EXISTS (SELECT 1 FROM MMEntityProp WITH(READUNCOMMITTED) WHERE propertyName = 'JobSelectionType' AND EntityType = 2 AND propDataType = 1 AND intVal <> 0) AND @i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768)
BEGIN
	DECLARE @FullJobId INT = 0
	DECLARE @FullJobCCId INT = 0
	SELECT TOP 1 @FullJobId = jobid, @FullJobCCId = commcellId from JMBkpStats WITH(READUNCOMMITTED) WHERE fullCycleNum = @i_fullCycleNum and appid = @i_appId and bkpLevel IN (1, 64, 128, 16384, 1024, 32768) AND cycleSequence = 1
	SET @o_dbError = (@@ERROR)
	IF @o_dbError <> 0
		GOTO CV_EXIT
	INSERT	INTO #tempCopy
	SELECT	DISTINCT C.archGroupId, C.id, C.type, C.startTime, C.flags, C.extendedFlags, C.siloAppId, C.isSnapCopy, C.isMirrorCopy, C.sourceCopyId, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM	JMJobDataStats JDS WITH(READUNCOMMITTED) INNER JOIN archGroupCopy C WITH (NOLOCK) ON JDS.archGrpCopyId = C.id
INNER JOIN MMEntityProp PROP WITH(READUNCOMMITTED) ON PROP.EntityId = C.id AND PROP.EntityType = 2 AND PROP.propertyName = 'JobSelectionType' AND PROP.propDataType = 1
	LEFT OUTER JOIN #tempCopy T ON C.id = T.copyId
	WHERE JDS.jobId = @FullJobId AND JDS.commCellId = @FullJobCCId AND JDS.archGrpId = @i_archGroupId AND C.type = 2 AND C.isSnapCopy = @i_isSnap
	AND (
		(PROP.intVal = 1 AND @i_backupLevel = 4) OR
		(PROP.intVal = 2 AND @i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768))
	)
AND JDS.disabled & (1+256) = 0
	AND T.copyId IS NULL
	SET @o_dbError = (@@ERROR)
	IF @o_dbError <> 0
		GOTO CV_EXIT
END
SELECT	@l_siloCopyId = copyId
FROM	#tempCopy
WHERE	siloAppId = @i_appId AND (flags & 524288) <> 0
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
UPDATE	C
SET		defaultCopyId = AG.defaultCopy, defaultSnapCopyId = AG.defaultSnapCopy, sourceCopyId = (CASE WHEN C.sourceCopyId > 0 THEN C.sourceCopyId WHEN C.isSnapCopy = 0 THEN AG.defaultCopy ELSE AG.defaultSnapCopy END)
FROM	#tempCopy C, archGroup AG
WHERE	C.archGroupId = AG.id
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
IF	EXISTS (SELECT * FROM #tempCopy WHERE isSnapCopy = 1)
BEGIN
	DELETE #tempCopy
	FROM	#tempCopy T, SMVolume V WITH (READUNCOMMITTED), SMVolSnapMap VS WITH (READUNCOMMITTED), SMSnap S WITH (READUNCOMMITTED), SMSnapShotEngine E WITH (READUNCOMMITTED)
	WHERE	V.jobId = @i_jobId AND V.commCellId = @i_commCellId
			AND VS.SMVolumeId = V.SMVolumeId AND S.SMSnapId = VS.SMSnapId
			AND S.SnapShotEngineId = E.SnapShotEngineId
AND ((( T.extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND T.isMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( T.extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND T.sourceCopyId != T.defaultSnapCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( T.extendedFlags & (256 | 512)) = 256)
OR (( T.extendedFlags & (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3, 48))))
			AND T.isSnapCopy = 1
			AND T.copyId <> @l_defSnapCopyId
	SET @o_dbError = (@@ERROR)
	IF @o_dbError <> 0
	DELETE #tempCopy
	FROM	#tempCopy T, JMVSAAppJobLink J WITH (READUNCOMMITTED)
				LEFT OUTER JOIN  SMVolume V WITH (READUNCOMMITTED)
					ON V.jobId = J.parentJobId AND V.commCellId = @i_commCellId
				LEFT OUTER JOIN SMVolSnapMap VS WITH (READUNCOMMITTED)
					ON VS.SMVolumeId = V.SMVolumeId
				LEFT OUTER JOIN SMSnap S WITH (READUNCOMMITTED)
					ON S.SMSnapId = VS.SMSnapId
				LEFT OUTER JOIN SMSnapShotEngine E WITH (READUNCOMMITTED)
					ON S.SnapShotEngineId = E.SnapShotEngineId
	WHERE	J.childJobId = @i_jobId AND J.commCellId = @i_commCellId
			-- AND NOT EXISTS (SELECT * FROM JMJobDataStats JDS WHERE JDS.JobId =  J.ParentJobId AND JDS.CommCellId = @i_commCellId AND JDS.archGrpCopyId = T.copyId AND JDS.dataType != 6 AND JDS.Status != 100)
			AND NOT EXISTS (SELECT TOP 1 SMVolumeID FROM SMVolume V2 WITH (READUNCOMMITTED) WHERE V2.jobId = J.parentJobId AND V2.commCellId = @i_commCellId AND V2.CopyId = T.CopyId)
			AND (V.SMVolumeId IS NULL
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND T.isMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( T.extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND T.sourceCopyId != T.defaultSnapCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( T.extendedFlags & (256 | 512)) = 256)
--OR ((( T.extendedFlags & (256 | 512)) = 256) AND EXISTS (SELECT * FROM JMJobDataStats JDS WHERE JDS.JobId =  J.ParentJobId AND JDS.CommCellId = @i_commCellId AND JDS.archGrpCopyId = T.copyId AND JDS.dataType != 6 AND JDS.Status != 100))
OR (( T.extendedFlags & (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3))))
			AND T.isSnapCopy = 1
			AND T.copyId <> @l_defSnapCopyId
	SET @o_dbError = (@@ERROR)
	IF @o_dbError <> 0
	GOTO CV_EXIT
END
UPDATE	#tempCopy
SET		selectionType=B.type, numPeriod=B.numPeriod, dayNumber=B.dayNumber,
		startPeriod=B.startPeriod, nextPeriod=B.nextPeriod, prevPeriodBegin=B.prevPeriodBegin, nextPeriodEnd=B.nextPeriodEnd
FROM	#tempCopy A, archSelectiveCopy B WITH (NOLOCK)
WHERE	A.type = 2 AND A.copyId = B.copyId
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
DELETE #tempCopy
WHERE  selectionType IN (8, 9)
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
INSERT INTO #copyIdToProcess(copyId)
SELECT DISTINCT copyId
FROM #tempCopy t
WHERE EXISTS (SELECT 1 FROM ArchCopyToApp A WITH (READUNCOMMITTED) WHERE A.copyId = t.copyId AND A.assocType <> 2)
INSERT INTO #archCopyToAppId
SELECT DISTINCT copyId , @i_appId
FROM #copyIdToProcess
EXEC archGetArchCopyToAppAssociations 0
DELETE #tempCopy
FROM   #tempCopy A INNER JOIN #copyIdToProcess C ON C.copyId = A.copyId LEFT JOIN #archCopyToAppId B WITH (NOLOCK) ON A.copyId = B.copyId
		AND B.appId = @i_appId
WHERE   B.appID IS NULL
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
IF	(@i_backupLevel IN (1, 64, 128, 16384, 1024, 32768) AND EXISTS (SELECT * FROM #tempCopy
WHERE selectionType IN (10, 3, 2, 4, 6)))
BEGIN
	IF @l_timezoneType > 0
	BEGIN
		DECLARE	@l_clientId INT
		SET		@l_clientId = 0
		IF @l_timezoneType > 0
			SELECT	@l_clientId = clientId FROM APP_Application WITH (NOLOCK) WHERE id = @i_appId
		SET	@l_TimeZone		= dbo.ArchGroupTimeZone(@i_archGroupId, @l_clientId)
		SET	@l_csTimeZone	= dbo.GetClientTimeZone(2)
		IF	@l_TimeZone <> '' AND @l_TimeZone <> @l_csTimeZone
		BEGIN
			SET	@i_startDate = @i_startDate + dbo.GetDiffFromCSTimeZone(@i_startDate, @l_TimeZone, @l_csTimeZone)
			IF	@i_nextFullTime > 0 AND @i_nextFullTime < 0x7FFFFFFF
				SET @i_nextFullTime = @i_nextFullTime + dbo.GetDiffFromCSTimeZone(@i_nextFullTime, @l_TimeZone, @l_csTimeZone)
		END
	END
	DELETE	#tempCopy
WHERE	selectionType IN (10, 3, 2, 4, 6)
AND (flags & 4096) > 0 AND (
(flags & 8192) > 0
			OR	@i_nextFullTime >= prevPeriodBegin AND @i_nextFullTime < startPeriod AND
				@i_startDate    >= prevPeriodBegin AND @i_startDate    < startPeriod
			OR	@i_nextFullTime >= startPeriod	   AND @i_nextFullTime < nextPeriod AND
				@i_startDate    >= startPeriod     AND @i_startDate    < nextPeriod
			OR	@i_nextFullTime >= nextPeriod      AND @i_nextFullTime < nextPeriodEnd AND
				@i_startDate    >= nextPeriod      AND @i_startDate    < nextPeriodEnd )
END
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
-- Only take full backups for selective copies
IF	(@i_backupLevel IN (1, 64, 128, 16384, 1024, 32768)
	AND EXISTS (SELECT * FROM #tempCopy
WHERE selectionType IN (1, 10, 3, 2, 4, 6)))
BEGIN
    IF OBJECT_ID('tempdb.dbo.#tempFullJob') IS NOT NULL
   		DROP TABLE #tempFullJob
	CREATE TABLE #tempFullJob (
		jobId int, commCellId int, servStartDate int, fullCycleNum int)
    IF OBJECT_ID('tempdb.dbo.#tempLastJob') IS NOT NULL
   		DROP TABLE #tempLastJob
	CREATE TABLE #tempLastJob (
		archGrpCopyId int, servStartDate int)
-- Filter out selective copies that this job does not satisfy their selection rules.
INSERT	INTO #tempFullJob
SELECT	jobId, commCellId, servStart, fullCycleNum
FROM	JMAdminJobStatsTable WITH (NOLOCK)
WHERE	appId = @i_appId AND (status IN (1, 14) OR status = 3 AND @CountPartialSuccess = 1)
	AND ER_BkpLevel = 1 AND opType IN (11, 64)
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
INSERT	INTO #tempFullJob
SELECT	jobId, commCellId, servStartDate, fullCycleNum
FROM	JMBkpStats WITH (NOLOCK), #tmpAppIdList T
WHERE	JMBkpStats.appId = @i_appId AND (status IN (1, 14) OR status = 3 AND @CountPartialSuccess = 1)
	AND (bkpLevel IN (1, 64, 128, 16384, 1024, 32768) OR (@i_isSnap = 1 AND dbo.GetBkpLevelOfSnapJobs(JobId, CommCellId, @l_defSnapCopyId)=1))
	-- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle
	AND (
appType NOT IN (2, 22, 23, 80,
61, 79)
		OR (bkpLevel IN (1024, 32768) AND ((bkpAttributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP) = 0 OR @l_AllowOracleSAPRegularFull = 1))
OR (openChain = 0 AND (bkpAttributes & 0x1000) <> 0 AND @l_AllowOracleSAPRegularFull = 1 AND T.unSupportedDB = 0 /*AND bkpAttributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0*/)
		)
	-- Only take FULL with data for SAP, Informix and DB2
AND (appType NOT IN (3, 5, 37, 62, 103, 128, 135) OR
openChain = 0 AND ((bkpAttributes & 0x1000) <> 0 OR appType IN (5, 135)))
	AND	T.unSupportedOnSelAlways = 0
	-- Only take FULL with Attribute [JMBKP_EX_FULL_JOB_IN_CYCLE] for app aware app backups
	AND (
				(JMBkpStats.bkpAttributesEx & @EX_APPAWARE_CHILD_JOB = 0)
				OR
				(JMBkpStats.bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0)
			)
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
INSERT	INTO #tempLastJob
SELECT	B.archGrpCopyId, MAX(A.servStartDate)
FROM	#tempFullJob A, JMJobDataStats B WITH (NOLOCK)
WHERE	B.jobId = A.jobId AND B.commCellId = A.commCellId AND B.archGrpCopyId IN (SELECT copyId FROM #tempCopy)
	AND B.status >= 100 AND (B.disabled & (1+256)) = 0
GROUP BY archGrpCopyId
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
	IF	@l_TimeZone <> '' AND @l_TimeZone <> @l_csTimeZone
AND EXISTS (SELECT * FROM #tempCopy WHERE selectionType IN (10, 3, 2, 4, 6))
		UPDATE	#tempLastJob
		SET		servStartDate = servStartDate + dbo.GetDiffFromCSTimeZone(servStartDate, @l_TimeZone, @l_csTimeZone)
	DELETE	#tempCopy
	FROM	#tempCopy A, #tempLastJob B
	WHERE	A.copyId = B.archGrpCopyId
AND ((A.selectionType = 1 AND @i_appType <> 79
			AND @i_fullCycleNum < (SELECT top 1 (fullCycleNum + A.numPeriod) FROM #tempFullJob WHERE servStartDate = B.servStartDate ORDER BY jobId desc))
OR (A.selectionType IN (10, 3, 2, 4, 6)
				AND (	@i_startDate <  A.startPeriod AND B.servStartDate >= A.prevPeriodBegin
					OR	@i_startDate >= A.startPeriod AND B.servStartDate >= A.startPeriod AND @i_startDate < A.nextPeriod
					OR	@i_startDate >= A.nextPeriod  AND B.servStartDate >= A.nextPeriod	)))
END
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
FINISH:
IF	@l_siloCopyId > 0
BEGIN
	DECLARE @tblDestCopy TABLE (
			copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
	INSERT INTO @tblDestCopy
	EXEC ArchDestinationCopyList @l_siloCopyId
	SET @o_dbError = (@@ERROR)
	IF @o_dbError <> 0
	GOTO CV_EXIT
	DELETE	FROM #tempCopy
	WHERE	copyId NOT IN (SELECT copyId FROM @tblDestCopy)
	SET @o_dbError = (@@ERROR)
	IF @o_dbError <> 0
	GOTO CV_EXIT
END
ELSE
BEGIN
	DECLARE @rowCnt integer = 0
	DELETE #tempCopy
	FROM   #tempCopy C
	WHERE  C.sourceCopyId NOT IN (defaultCopyId, defaultSnapCopyId)
	   AND NOT EXISTS (SELECT * FROM #tempCopy WHERE copyId = C.sourceCopyId)
	SELECT @o_dbError = (@@ERROR), @rowCnt = (@@ROWCOUNT)
	IF @o_dbError <> 0
		GOTO CV_EXIT
	IF	@rowCnt > 0
		GOTO FINISH
END
INSERT	INTO #CopiesForJob
SELECT	A.copyId
FROM	#tempCopy A
SET @o_dbError = (@@ERROR)
IF @o_dbError <> 0
	GOTO CV_EXIT
--END TRY
--BEGIN CATCH
--	SET	@o_dbError = (SELECT ERROR_NUMBER())
--END CATCH
--DROP TABLE #tempFullJob
--DROP TABLE #tempLastJob
--DROP TABLE #tempCopy
CV_EXIT:
IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL
	DROP TABLE #tmpAppIdList
IF OBJECT_ID('tempdb.dbo.#archCopyToAppId') IS NOT NULL
	DROP TABLE #archCopyToAppId
IF OBJECT_ID('tempdb.dbo.#copyIdToProcess') IS NOT NULL
	DROP TABLE #copyIdToProcess
SELECT	@o_dbError
RETURN	@o_dbError;
GO

IF EXISTS (select * from GxQscripts where name = 'archCopiesForJob')
	delete from GxQscripts where name = 'archCopiesForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopiesForJob')
	delete from GXDBVersions where aliasname = 'archCopiesForJob'
GO

insert into GXDBVersions values(2, 'archCopiesForJob',  '00010033001200240000', 'archCopiesForJob', '00010033001200240000')
GO

