

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingTotalDataSizeByOperationType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingTotalDataSizeByOperationType.sp,v $ $Id: archContentIndexingTotalDataSizeByOperationType.sp,v 1.1.4.2 2018/05/11 22:34:41 bkharabe Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingTotalDataSizeByOperationType <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingTotalDataSizeByOperationType')
	drop procedure archContentIndexingTotalDataSizeByOperationType
IF EXISTS (select * from GxQscripts where name='archContentIndexingTotalDataSizeByOperationType')
	delete from GxQscripts where name = 'archContentIndexingTotalDataSizeByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingTotalDataSizeByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingTotalDataSizeByOperationType'
GO
print '... Creating Procedure: archContentIndexingTotalDataSizeByOperationType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingTotalDataSizeByOperationType
  @i_archGroupId int,
  @i_copyId int,
  @i_operationType int
AS
  DECLARE @o_totalDataSize bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblDataSize		TABLE
	(archCopyId int, streamNum int, mediaGroupId int, commCellId int, archChunkId bigint, physicalSize bigint)
DECLARE	@tblDataSizeAdjust	TABLE
	(archCopyId int, streamNum int, mediaGroupId int, commCellId int, physicalSize bigint)
INSERT	INTO @tblDataSizeAdjust
SELECT	A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId, SUM(R.physicalOffset - A.physicalOffset)
FROM	archContentIndexingAF A, archContentIndexingRestart R
WHERE	A.archGroupId = @i_archGroupId
	AND (@i_copyId = 0 OR A.archCopyId = @i_copyId)
	AND A.archFileId = R.archFileId AND A.commCellId = R.commCellId
	AND A.physicalOffset < R.physicalOffset AND (A.physicalOffset + A.physicalSize) >= R.physicalOffset
    AND A.operationType = @i_operationType
    AND R.operationType = @i_operationType
GROUP BY A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId
INSERT	INTO @tblDataSize
SELECT	archCopyId, streamNum, mediaGroupId, commCellId, MIN(archChunkId), SUM(physicalSize)
FROM	archContentIndexingAF
WHERE	archGroupId = @i_archGroupId
	AND (@i_copyId = 0 OR archCopyId = @i_copyId)
    AND operationType = @i_operationType
GROUP BY archCopyId, streamNum, mediaGroupId, commCellId
UPDATE	@tblDataSize
SET		physicalSize = (A.physicalSize - B.physicalSize)
FROM	@tblDataSize A, @tblDataSizeAdjust B
WHERE	A.archCopyId = B.archCopyId AND A.streamNum = B.streamNum AND A.mediaGroupId = B.mediaGroupId
select sum(physicalSize) from @tblDataSize
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingTotalDataSizeByOperationType')
	delete from GxQscripts where name = 'archContentIndexingTotalDataSizeByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingTotalDataSizeByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingTotalDataSizeByOperationType'
GO

insert into GXDBVersions values(2, 'archContentIndexingTotalDataSizeByOperationType',  '00010001000400020000', 'archContentIndexingTotalDataSizeByOperationType', '00010001000400020000')
GO

