

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingSetStream.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingSetStream.sp,v $ $Id: archContentIndexingSetStream.sp,v 1.3.200.2 2018/03/22 00:59:41 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingSetStream <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingSetStream')
	drop procedure archContentIndexingSetStream
IF EXISTS (select * from GxQscripts where name='archContentIndexingSetStream')
	delete from GxQscripts where name = 'archContentIndexingSetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingSetStream')
	delete from GXDBVersions where aliasname = 'archContentIndexingSetStream'
GO
print '... Creating Procedure: archContentIndexingSetStream'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archContentIndexingSetStream
  @i_archGroupId int,
  @i_archCopyId int,
  @i_streamNum int,
  @i_maxConcurrency int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRAN archCISetStream_tran
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	IF	@i_streamNum > 0
			AND EXISTS (SELECT * FROM ArchContentIndexingAF WITH (NOLOCK)
						WHERE archGroupId = @i_archGroupId
						and (@i_archCopyId = 0 or archCopyId = @i_archCopyId)
and operationType = 1 --only for classical ci jobs
						AND streamNum = @i_streamNum and segmentId > 0)
		GOTO CX_EXIT
	DECLARE @tblSegmentStream TABLE (
		streamNum			integer,
		segmentId			integer
	)
	DECLARE @max_streamNum	INTEGER
	IF @i_maxConcurrency > 0
		SET @max_streamNum = @i_maxConcurrency
	ELSE
		SELECT	@max_streamNum = maxStreams
		FROM	archGroup WITH (NOLOCK)
		WHERE	id = @i_archGroupId
	DECLARE @streamNum		INTEGER
	DECLARE @nextStream		INTEGER
	SET @nextStream = 0
	SET @streamNum = 1
	IF	@i_streamNum > 0
	BEGIN
		SET @streamNum = @i_streamNum
	END
	INSERT INTO @tblSegmentStream
	SELECT DISTINCT streamNum, segmentId
	FROM ArchContentIndexingAF WITH (NOLOCK)
	WHERE archGroupId = @i_archGroupId
	and (@i_archCopyId = 0 or archCopyId = @i_archCopyId)
	and archCopyId not in (select id from ArchGroupCopy where isSnapCopy = 1)
	AND segmentId > 0
AND operationType = 1 --only for classical ci jobs
	WHILE 1 = 1
	BEGIN
		IF NOT EXISTS (SELECT * FROM @tblSegmentStream WHERE streamNum = 0)
			BREAK
		IF EXISTS (SELECT * FROM @tblSegmentStream WHERE streamNum = @streamNum)
			SET @nextStream = 1
		IF @nextStream > 0
		BEGIN
			IF	@i_streamNum > 0
				BREAK
			SET @streamNum = @streamNum + 1
			IF @streamNum > @max_streamNum
				BREAK
			SET @nextStream = 0
			CONTINUE
		END
		DECLARE @t_segmentId INTEGER
		SET @t_segmentId = (SELECT MIN(segmentId) FROM @tblSegmentStream WHERE streamNum = 0)
		IF @t_segmentId IS NOT null
		BEGIN
				UPDATE @tblSegmentStream
				SET streamNum = @streamNum
				WHERE segmentId = @t_segmentId
				UPDATE ArchContentIndexingAF
				SET streamNum = @streamNum
				FROM ArchContentIndexingAF
				WHERE segmentId = @t_segmentId
				AND archGroupId = @i_archGroupId
AND operationType = 1 --only for classical ci jobs
				SELECT @errVal = @@ERROR
				IF @errVal <> 0
				BEGIN
						SET @errStr = 'Failed to update StreamNum for archive files in ArchContentIndexingAF: DB error!'
						GOTO CX_EXIT_ERROR
				END
				CONTINUE
		END
		SET @nextStream = 1
	END
CX_EXIT:
	SET @errStr = 'All streams are assigned for copy with max stream: [' + convert(varchar(10), @max_streamNum) + ']'
	COMMIT TRAN archCISetStream_tran
	SELECT 0, ''
	RETURN
CX_EXIT_ERROR:
	ROLLBACK TRAN archCISetStream_tran
	SELECT @errVal, @errStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingSetStream')
	delete from GxQscripts where name = 'archContentIndexingSetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingSetStream')
	delete from GXDBVersions where aliasname = 'archContentIndexingSetStream'
GO

insert into GXDBVersions values(2, 'archContentIndexingSetStream',  '00010003020000020000', 'archContentIndexingSetStream', '00010003020000020000')
GO

