

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingSetStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingSetStats.sp,v $ $Id: archContentIndexingSetStats.sp,v 1.4.2.7 2019/08/01 15:30:18 washraf Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
-- Expected tables: #AF and #JOB
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archContentIndexingSetStats')
BEGIN
	print '>>> Drop Stored Procedure: archContentIndexingSetStats <<<'
	drop procedure archContentIndexingSetStats
END
IF EXISTS (select * from GxQscripts where name='archContentIndexingSetStats')
	delete from GxQscripts where name = 'archContentIndexingSetStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingSetStats')
	delete from GXDBVersions where aliasname = 'archContentIndexingSetStats'
GO
print '... Creating Procedure: archContentIndexingSetStats'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingSetStats
  @i_archGroupId int
AS
--
SET NOCOUNT ON
--
DECLARE @now		int
DECLARE @l_cloudId 	int
DECLARE @nrows		int
--
SET @now = dbo.GetUnixTime(GETUTCDATE())
DECLARE @i_appId int = 0
SELECT TOP 1 @i_appId = appId from ArchFile AF WITH(NOLOCK) INNER JOIN #AF AFT ON AF.id = AFT.archFileId AND AF.commcellid = AFT.commcellId
IF EXISTS (SELECT 1 FROM APP_Application WITH(NOLOCK) WHERE id = @i_appId AND appTypeId = 106) -- VSA Cloud fetch differently
BEGIN
	IF OBJECT_ID('tempdb..#tempCurrentClouds') IS NOT NULL
		DROP TABLE #tempCurrentClouds
	CREATE TABLE #tempCurrentClouds (ciEnabled INT,  cloudId INT, engineType nvarchar(max))
	INSERT INTO #tempCurrentClouds
	EXEC AppGetCloudId @i_appId, 0
	-- CloudId is missing from ArchFile table, which needs to be updated
	SELECT TOP 1 @l_cloudId = cloudId
	FROM    #tempCurrentClouds
	IF OBJECT_ID('tempdb..#tempCurrentClouds') IS NOT NULL
		DROP TABLE #tempCurrentClouds
END
ELSE
BEGIN
	SELECT @l_cloudId = cloudId FROM archContentIndexingRules WHERE archGroupId = @i_archGroupId
END
--
-- Edge drive treatment
-- For Edge backups, an single archive file maybe used for multiple backups by adding new chunks.
-- If we are working with Edge backup AFs, we need to maintain the restart offset and also refrain
-- from marking the AF are complete so that these AFs will be looked at in the next CI run.
-- These are the archive files which are from Edge backups.
declare @EdgeArchiveFiles table
(
	ArchFileId int,
	CommCellId int,
	CopyId int,
	StreamNum int,
	PhysicalOffset bigint,
	NewChunkPresent bit,
	NewAFOnStream bit,
        AppId int,
	Primary Key (ArchFileId, CommCellId)
);
--
insert into @EdgeArchiveFiles (ArchFileId, CommCellId, CopyId, StreamNum, PhysicalOffset, NewChunkPresent, NewAFOnStream, AppId)
select af.ArchFileId, af.CommCellId, null, null, af.physicalOffset, 0, 0, a.appId from #AF af
inner join archFile a with (nolock) on a.id = af.archFileId and a.commCellId = af.commCellId
where af.Completed = 1 and dbo.IsBackupLevelFull(a.backupLevel) = 0 and a.flags & (32768|2097152) <> 0
--
update @EdgeArchiveFiles set CopyId = g.defaultCopy, StreamNum = afc.streamNum, NewChunkPresent = (case when afc.physicalSize > e.PhysicalOffset then 1 else 0 end)
from @EdgeArchiveFiles e
inner join archFile a on a.id = e.ArchFileId and a.commCellId = e.CommCellId
inner join archGroup g on g.id = a.archGroupId
inner join archFileCopy afc on afc.archFileId = e.ArchFileId and afc.commCellId = e.CommCellId and afc.archCopyId = g.defaultCopy
--
update @EdgeArchiveFiles set NewAFOnStream = 1 from @EdgeArchiveFiles e
inner join archFile af on af.appId = e.AppId and af.Id > e.ArchFileId and af.commCellId = e.CommCellId
inner join archFileCopy c on c.archFileId = af.Id and c.commCellId = af.CommCellId and c.streamNum = e.StreamNum
--
-- End selection of Edge Afs
-- Unset CVA_AF_CI_BITMAP (=496) and set CVA_AF_CI_SUCCESS_FLAG (=64) (ArMgr/amcsDefs.h)
IF EXISTS (SELECT * FROM #AF WHERE completed = 1)
UPDATE  archFile
SET     flags = ((archFile.flags & ~496) | 64), cloudId = @l_cloudId, contentIndexTime = @now, nPushedItems = T.nPushedItems
FROM    #AF T
WHERE   archFile.id = T.archFileId AND archFile.commCellId = T.commCellId AND T.completed = 1
--
SET @nRows = (@nRows + @@ROWCOUNT)
--
-- Unset CVA_AF_CI_BITMAP (=496) and set CVA_AF_CI_PARTIAL_FLAG (=32) (ArMgr/amcsDefs.h)
IF EXISTS (SELECT * FROM #AF WHERE completed = 0 AND physicalOffset > 0)
UPDATE  archFile
SET     flags = ((archFile.flags & ~496) | 32), cloudId = @l_cloudId, contentIndexTime = @now, nPushedItems = T.nPushedItems
FROM    #AF T
WHERE   archFile.id = T.archFileId AND archFile.commCellId = T.commCellId AND archFile.flags & 32 = 0
    AND T.completed = 0 AND T.physicalOffset > 0
--
SET @nRows = (@nRows + @@ROWCOUNT)
--
DELETE  archContentIndexingRestart
FROM    #AF T
WHERE   archContentIndexingRestart.archFileId = T.archFileId AND archContentIndexingRestart.commCellId = T.commCellId AND T.completed = 1 AND archContentIndexingRestart.operationType = 1
AND NOT EXISTS (select * from @EdgeArchiveFiles k where k.ArchFileId = T.ArchFileId and k.CommCellId = T.CommCellId and (k.NewChunkPresent = 1 or k.NewAFOnStream = 0)) -- Added for Edge
--
UPDATE  archContentIndexingRestart
SET     physicalOffset = T.physicalOffset, status = T.completed, flags = (CASE WHEN T.completed = 2 THEN 1 ELSE 0 END), modifiedTime = @now
FROM    #AF T
WHERE   (archContentIndexingRestart.archFileId = T.archFileId AND archContentIndexingRestart.commCellId = T.commCellId AND archContentIndexingRestart.operationType = 1)
AND
(
	T.completed IN (0, 2)
	OR
	EXISTS (select * from @EdgeArchiveFiles k where k.ArchFileId = T.ArchFileId and k.CommCellId = T.CommCellId and (k.NewChunkPresent = 1 or k.NewAFOnStream = 0)) -- Added for Edge
)
--
INSERT  INTO archContentIndexingRestart
SELECT  @i_archGroupId, @l_cloudId, T.archFileId, T.commCellId, T.physicalOffset, T.completed, (CASE WHEN T.completed = 2 THEN 1 ELSE 0 END), T.ciEngineClientId, T.streamNum, @now, 1
FROM    #AF T LEFT OUTER JOIN archContentIndexingRestart R
    ON  T.archFileId = R.archFileId AND T.commCellId = R.commCellId
WHERE   R.archFileId IS NULL
		AND
		(
			(T.completed = 0 AND T.physicalOffset > 0 OR T.completed = 2)
			OR EXISTS
			(select * from @EdgeArchiveFiles k where T.completed = 1 and k.ArchFileId = T.ArchFileId and k.CommCellId = T.CommCellId and (k.NewChunkPresent = 1 or k.NewAFOnStream = 0)) -- Added for Edge)
		)
--
INSERT  INTO #JOB
SELECT  DISTINCT AF.jobId, AF.commCellId
FROM    #AF T, archFile AF WITH (NOLOCK)
WHERE   AF.id = T.archFileId AND AF.commCellId = T.commCellId
--
DELETE  #JOB
FROM    archFile AF WITH (NOLOCK)
WHERE   AF.id = #JOB.jobId AND AF.commCellId = #JOB.commCellId
    AND (AF.flags & 496) NOT IN (0, 64)
--
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingSetStats')
	delete from GxQscripts where name = 'archContentIndexingSetStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingSetStats')
	delete from GXDBVersions where aliasname = 'archContentIndexingSetStats'
GO

insert into GXDBVersions values(2, 'archContentIndexingSetStats',  '00010004000200070000', 'archContentIndexingSetStats', '00010004000200070000')
GO

