

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingSetIndexedForVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingSetIndexedForVM.sp,v $ $Id: archContentIndexingSetIndexedForVM.sp,v 1.1.2.6 2020/02/26 02:59:16 sbonilla Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archContentIndexingSetIndexedForVM')
BEGIN
	print '>>> Drop Stored Procedure: archContentIndexingSetIndexedForVM <<<'
	drop procedure archContentIndexingSetIndexedForVM
END
IF EXISTS (select * from GxQscripts where name='archContentIndexingSetIndexedForVM')
	delete from GxQscripts where name = 'archContentIndexingSetIndexedForVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingSetIndexedForVM')
	delete from GXDBVersions where aliasname = 'archContentIndexingSetIndexedForVM'
GO
print '... Creating Procedure: archContentIndexingSetIndexedForVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archContentIndexingSetIndexedForVM
  @i_CIJobId integer,
  @i_commCellId integer,
  @i_lastBackupJobId integer,
  @i_appId integer,
  @i_appType integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @retVal = 0
SET @i_commcellId = CASE WHEN @i_commCellId = 0 Then 2 ELSE @i_commCellId END
CREATE TABLE #JOB_TO_CI(jobId INT, commCellId INT, appId INT)
CREATE CLUSTERED INDEX idx_temp_job_to_ci ON #JOB_TO_CI (commCellId, jobId)
CREATE INDEX idx_temp_job_to_ci_app ON #JOB_TO_CI (appId)
INSERT INTO #JOB_TO_CI
(jobId, commCellId, appId)
SELECT	@i_lastBackupJobId, @i_commCellId, @i_appId
IF EXISTS (SELECT 1 FROM JMBkpStats WITH (NOLOCK)
			WHERE jobId = @i_lastBackupJobId AND commCellId = @i_commCellId
AND (bkpAttributesEx & 0x40000000) > 0
			)
BEGIN
	-- If it is VSA V2 backup job ( attribute JMBKP_EX_PSEUDO_PARENT_JOB wil be set in bkpAttributesEx)
	-- Find all the child VM jobs from table JMJobDataLink with linktype 7 LINK_TYPE_FOR_VSA_V2_PARENT_CHILD_DEF.
	-- Join with JMQinetixUpdateStatus table with CI jobid and look for status is successful. Status values in (0, 3). (see valid values in enum VMClientBkupStatus in JobManager.x)
	-- Mark all the afiles and VM jobs also as CI done and set cloud Id also.
	-- According to stored procedure archGetVSAChildJobs, there should be check for JMJobSnapShotStats table with status.
	-- This is skipped for now.
	INSERT	INTO #JOB_TO_CI
	(jobId, commCellId, appId)
	SELECT	DISTINCT a.childJobId, a.commCellId, a.childAppId
	FROM	(
				SELECT	DISTINCT childJobId, commCellId, childAppId
				FROM	JMJobDataLink job WITH (NOLOCK)
				WHERE	job.commCellId = @i_commCellId
				AND		job.parentJobId = @i_lastBackupJobId
AND		job.linkType = 7
			)a,
			JMQinetixUpdateStatus status WITH (NOLOCK),
			App_Application app WITH (NOLOCK)
	WHERE	status.jobId = @i_CIJobId
	AND		a.childAppId = app.Id
	AND		a.commCellId = status.commCellId
	AND		status.clientId = app.clientId
	AND		status.status in (0, 3)
END
SELECT  @retVal = @@ERROR
IF @retVal = 0
BEGIN
	INSERT	INTO #JOB_TO_CI
	(jobId, commCellId, appId)
	SELECT B.jobIdActedOn, B.commCellId, job.appId
	FROM #JOB_TO_CI job
	JOIN JMBkpStats B (NOLOCK) ON B.jobId = job.jobId AND B.commCellId = job.commCellId
END
SELECT  @retVal = @@ERROR
IF @retVal = 0
BEGIN
	UPDATE	JMBkpStats
SET		bkpAttributes = bkpAttributes | 0x4000000
	FROM	#JOB_TO_CI job
	WHERE	JMBkpStats.commCellId = job.commCellId
	AND		JMBkpStats.jobId = job.jobId
	SELECT	@retVal = @@ERROR
END
SELECT  @retVal
IF OBJECT_ID('tempdb.dbo.#JOB_TO_CI') IS NOT NULL
	DROP TABLE #JOB_TO_CI
IF OBJECT_ID('tempdb.dbo.#AF_TO_CI') IS NOT NULL
	DROP TABLE #AF_TO_CI
IF OBJECT_ID('tempdb.dbo.#tempCurrentClouds') IS NOT NULL
	DROP TABLE #tempCurrentClouds
RETURN	@retVal;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingSetIndexedForVM')
	delete from GxQscripts where name = 'archContentIndexingSetIndexedForVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingSetIndexedForVM')
	delete from GXDBVersions where aliasname = 'archContentIndexingSetIndexedForVM'
GO

insert into GXDBVersions values(2, 'archContentIndexingSetIndexedForVM',  '00010001000200060000', 'archContentIndexingSetIndexedForVM', '00010001000200060000')
GO

