

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingSetFlag.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingSetFlag.sp,v $ $Id: archContentIndexingSetFlag.sp,v 1.6.48.8 2019/10/11 16:34:18 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archContentIndexingSetFlag')
BEGIN
	print '>>> Drop Stored Procedure: archContentIndexingSetFlag <<<'
	drop procedure archContentIndexingSetFlag
END
IF EXISTS (select * from GxQscripts where name='archContentIndexingSetFlag')
	delete from GxQscripts where name = 'archContentIndexingSetFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingSetFlag')
	delete from GXDBVersions where aliasname = 'archContentIndexingSetFlag'
GO
print '... Creating Procedure: archContentIndexingSetFlag'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingSetFlag
  @i_jobId integer,
  @i_commCellId integer,
  @i_flag integer
AS
  DECLARE @retVal INTEGER;
DECLARE	@l_flag	INT
SET	@l_flag = (@i_flag & 496)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE	TABLE #AF_TO_CI (id INT, commCellId INT, cloudId INT, flags INT, jobId INT)
INSERT	INTO #AF_TO_CI
SELECT  AF.id, AF.commCellId, AF.cloudId, AF.flags, AF.jobId
FROM	archFile AF WITH(NOLOCK), APP_Application APP WITH(NOLOCK)
WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId
AND AF.isValid = 1 AND AF.fileType = 1
AND APP.id = AF.appId AND (App.appTypeId <> 128 OR (AF.flags & 512) <> 0)
AND( AF.flags & (32768|2097152) ) =0  --Prevent CI of EDGE/reusable archive file data
SELECT  @retVal = @@ERROR
--
IF @retVal = 0
BEGIN
	UPDATE	archFile
SET		flags = ((archFile.flags & (~496)) | @l_flag)
	FROM	#AF_TO_CI T
	WHERE	archFile.id = T.id AND archFile.commCellId = T.commCellId
AND (archFile.flags & 496) <> @l_flag
	SELECT  @retVal = @@ERROR
END
--
IF @retVal = 0
BEGIN
	--prune partial CIed jobs
	INSERT INTO archContentIndexingAged (archFileId, commCellId, cloudId, appId, pruneType, agedFlag, operationType, jobId)
SELECT id , commCellId, cloudId, 0, 1, 0, 1, jobId
	FROM #AF_TO_CI
WHERE (flags & 64) > 0 OR (flags & 32) >0
	DELETE	archContentIndexingRestart
	FROM	#AF_TO_CI
	WHERE	archContentIndexingRestart.archFileId = #AF_TO_CI.id
		AND archContentIndexingRestart.commCellId = #AF_TO_CI.commCellId
AND archContentIndexingRestart.operationType = 1
	SELECT  @retVal = @@ERROR
END
--
IF @retVal = 0
BEGIN
	DELETE	archContentIndexingSecondary
	FROM	#AF_TO_CI
	WHERE	archContentIndexingSecondary.ArchFileId = #AF_TO_CI.id
			AND archContentIndexingSecondary.CommCellId = #AF_TO_CI.commCellId
	SELECT  @retVal = @@ERROR
END
SELECT  @retVal
DROP TABLE #AF_TO_CI
RETURN	@retVal;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingSetFlag')
	delete from GxQscripts where name = 'archContentIndexingSetFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingSetFlag')
	delete from GXDBVersions where aliasname = 'archContentIndexingSetFlag'
GO

insert into GXDBVersions values(2, 'archContentIndexingSetFlag',  '00010006004800080000', 'archContentIndexingSetFlag', '00010006004800080000')
GO

