

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingPruneByOperationType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingPruneByOperationType.sp,v $ $Id: archContentIndexingPruneByOperationType.sp,v 1.1.4.5 2019/10/11 16:34:18 pkrishnan Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archContentIndexingPruneByOperationType')
BEGIN
	print '>>> Drop Stored Procedure: archContentIndexingPruneByOperationType <<<'
	drop procedure archContentIndexingPruneByOperationType
END
IF EXISTS (select * from GxQscripts where name='archContentIndexingPruneByOperationType')
	delete from GxQscripts where name = 'archContentIndexingPruneByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingPruneByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingPruneByOperationType'
GO
print '... Creating Procedure: archContentIndexingPruneByOperationType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archContentIndexingPruneByOperationType
  @i_dummy integer,
  @i_operationType int
AS
  DECLARE @retVal integer;
  DECLARE @numRow integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @err	INT
DECLARE @now	INT
DECLARE @CONTENTINDEXED	INT
DECLARE	@numAgedBackupJobRow	INT
SET @err = 0
SET @now = dbo.GetUnixTime(GETUTCDATE())
SET @CONTENTINDEXED = (32 + 64 + 128)
SET @retVal = 0
SET @numRow = 0
SET @numAgedBackupJobRow =0
/* This is called in MM before calling this stored proc
-- Call the JM Stored Procedure to populate the jobs pending to be processed by each available Compliance Policy
EXEC @retVal = JMFillCompPolicyQualifiedJobs 0
SET	@err = @@ERROR
IF	@retVal  = 0 SET @retVal = @err
IF	@retVal != 0 GOTO CX_EXIT
*/
IF (OBJECT_ID('tempdb.dbo.#ExpiredCIAF') IS NOT NULL) DROP TABLE #ExpiredCIAF
CREATE TABLE #ExpiredCIAF (id INT, commCellId INT, cloudId INT, flags INT, appId INT, jobId INT, PRIMARY KEY( ID, commCellId))
INSERT INTO #ExpiredCIAF (id, commCellId, cloudId, flags, appId, jobId)
SELECT AF.id, AF.commCellId, AF.cloudId, 256, AF.appId, AF.jobId
FROM	archFile AF (NOLOCK)
		INNER JOIN archContentIndexingRules CI (NOLOCK) ON AF.archGroupId = CI.archGroupId AND CI.retentionDays >= 0 AND CI.operationType = @i_operationType
		LEFT JOIN JMCompliancePolicyQualifiedJobs CP (NOLOCK) ON CP.jobId = AF.jobId AND CP.commCellId = AF.commCellId
WHERE	CP.jobId IS NULL
	AND AF.flags & @CONTENTINDEXED <> 0
AND AF.flags & 256 = 0
	AND AF.contentIndexTime < (@now - 24*60*60*CI.retentionDays)
	AND AF.cloudId > 0
AND AF.FileType = 1
SELECT @retVal = @@ERROR, @numRow = @@ROWCOUNT
IF	@retVal != 0 GOTO CX_EXIT
IF @i_dummy = 1
BEGIN
	--query optimization for scale db
	INSERT INTO #ExpiredCIAF (id, commCellId, cloudId, flags, appId, jobId)
	SELECT Id, commCellId,  cloudId, @CONTENTINDEXED, appId, jobId
       FROM   archFile WITH (NOLOCK)
WHERE  FileType = 1
       AND   cloudId > 0
       AND   flags & @CONTENTINDEXED <> 0
	   OPTION (MAXDOP 1)
	DELETE #ExpiredCIAF
	FROM #ExpiredCIAF T, archFileCopy AFC WITH (NOLOCK)
	WHERE T.id = AFC.archFileId
	AND   T.commCellId = AFC.commCellId
AND   AFC.flags & 256 = 0  --CVA_AGED_DATA_FLAG  =256
	SELECT @retVal = @@ERROR, @numAgedBackupJobRow = @@ROWCOUNT
	IF	@retVal != 0 GOTO CX_EXIT
END
IF @retVal = 0 AND ( @numRow > 0 OR @numAgedBackupJobRow >0)
BEGIN
	INSERT INTO archContentIndexingAged (archFileId, commCellId, cloudId, appId, pruneType, agedFlag, operationType, jobId)
SELECT	id, commCellId, cloudId, appId, (CASE WHEN (flags & 256) > 0  THEN 1
WHEN (flags & @CONTENTINDEXED) > 0 THEN 3
										END) , 0, @i_operationType, jobId
	FROM	#ExpiredCIAF
	SELECT @retVal = @@ERROR, @numRow = @@ROWCOUNT
	IF	@retVal != 0 GOTO CX_EXIT
	IF @retVal = 0 AND @numRow > 0
	BEGIN
		UPDATE	archFile
SET     flags = (archFile.flags | 256)
		FROM	#ExpiredCIAF T
WHERE	archFile.id = T.id AND archFile.commCellId = T.commCellId AND (T.flags & 256) >0 AND archFile.FileType = 1
		SELECT @retVal = @@ERROR, @numRow = @@ROWCOUNT
		IF	@retVal != 0 GOTO CX_EXIT
	END
	IF @retVal = 0 AND @numAgedBackupJobRow > 0
	BEGIN
		UPDATE	archFile
		SET     flags = (archFile.flags & ~@CONTENTINDEXED)
		FROM	#ExpiredCIAF T
WHERE	archFile.id = T.id AND archFile.commCellId = T.commCellId AND (T.flags & @CONTENTINDEXED) > 0 AND archFile.FileType = 1
		SELECT @retVal = @@ERROR, @numRow = @@ROWCOUNT
		IF	@retVal != 0 GOTO CX_EXIT
	END
END
IF (OBJECT_ID('tempdb.dbo.#ExpiredCIAF') IS NOT NULL) DROP TABLE #ExpiredCIAF
CX_EXIT:
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingPruneByOperationType')
	delete from GxQscripts where name = 'archContentIndexingPruneByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingPruneByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingPruneByOperationType'
GO

insert into GXDBVersions values(2, 'archContentIndexingPruneByOperationType',  '00010001000400050000', 'archContentIndexingPruneByOperationType', '00010001000400050000')
GO

