

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingPickJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingPickJobs.sp,v $ $Id: archContentIndexingPickJobs.sp,v 1.42.34.6 2018/03/22 01:10:14 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingPickJobs <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingPickJobs')
	drop procedure archContentIndexingPickJobs
IF EXISTS (select * from GxQscripts where name='archContentIndexingPickJobs')
	delete from GxQscripts where name = 'archContentIndexingPickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingPickJobs')
	delete from GXDBVersions where aliasname = 'archContentIndexingPickJobs'
GO
print '... Creating Procedure: archContentIndexingPickJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingPickJobs
  @i_archGroupId integer,
  @i_today integer,
  @i_order integer
AS
  DECLARE @r_appId integer;
  DECLARE @r_jobId integer;
  DECLARE @r_commCellId integer;
  DECLARE @r_startDate integer;
  DECLARE @r_selected integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@FULL_BITS		INT
SET		@FULL_BITS		= (1+64+128+1024+32768)
DECLARE	@l_enabled		INT
DECLARE	@l_type			INT
DECLARE	@l_flags		INT
DECLARE	@l_startTime	INT
DECLARE	@l_numPeriod	INT
DECLARE	@l_dayNumber	INT
DECLARE	@l_startPeriod	INT
DECLARE	@l_nextPeriod	INT
DECLARE	@l_prevPeriodBegin	INT
DECLARE	@l_nextPeriodEnd	INT
DECLARE	@l_clientId		INT
DECLARE	@l_sourceCopyId	INT
CREATE TABLE #notSelectedJob (appId INT, appType INT, clientId INT, jobId INT, commCellId INT, bkpLevel INT, startDate INT, fullCycleNum INT, selected INT)
CREATE TABLE #AppCIFlags (appId INT, selected INT, cTime INT)
CREATE TABLE #App (appId INT, clientId INT, appTypeId INT, backupSet INT, cTime INT, fullCycleNum INT)
CREATE TABLE #AF_TO_CI (id INT, commCellId INT)
SET @l_enabled = 0
SELECT	@l_enabled = enabled, @l_type = type, @l_flags = flags, @l_startTime = startTime,
		@l_numPeriod = numPeriod, @l_dayNumber = dayNumber, @l_sourceCopyId = sourceCopyId,
		@l_startPeriod = startPeriod, @l_nextPeriod = nextPeriod, @l_prevPeriodBegin = prevPeriodBegin, @l_nextPeriodEnd = nextPeriodEnd
FROM	archContentIndexingRules WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId AND operationType = 1
IF	@l_enabled = 0 OR @l_type = 9 OR @l_startTime > @i_today
	GOTO OUTPUT_EXIT
-- Get all subclients in this storage policy which have valid data archive files created after the effective date of Content Indexing
INSERT	INTO #AppCIFlags
SELECT	appId, (flags & 496), ISNULL(MAX(cTime), 0)
FROM	archFile WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
AND fileType = 1 AND isValid = 1
AND (flags & 2) = 0
GROUP BY appId, (flags & 496)
-- Check if Content Indexing is supported for each iDA.
-- Check if Content Indexing is enabled at client level.
-- TO DO: Check if there is a valid Content Indexing license for each client.
INSERT	INTO #App
SELECT	B.appId, A.clientId, A.appTypeId, A.backupSet, 0, 0
FROM	APP_Application A WITH (NOLOCK),
		(SELECT DISTINCT appId FROM #AppCIFlags) B,
		APP_ClientProp C WITH (NOLOCK)
WHERE	A.id = B.appId
	AND A.appTypeId IN (
		-- From OffliineCI-SupportedApptypes.doc
		-- 1.1	File System apptypes
1,
11,
13,
17,
18,
19,
20,
21,
29,
33,
34,
36,
38,
42,
43,
63,
64,
74,
73,
86,
106,
128,
124,
		-- 1.2	File System Archiver apptypes
58,
66,
		-- 1.3	Exchange application apptypes
8,
14,
35,
44,
45,
54,
55,
56,
57,
67,
68,
82,
		-- 1.4	Share point application apptypes
46,
78,
89,
		-- 1.5	Lotus notes application apptypes
52,
90,
		--gmail / gdrive
134
		)
	AND C.ComponentNameId = A.clientId
	AND C.attrName = N'Content Indexing Enabled' AND C.attrVal = N'1' AND C.modified = 0
	AND A.subclientName <> 'IndexBackup'  -- Filter out IndexBackup Subclients
AND (A.subclientStatus & 0x20000) = 0  -- Filter out Edge Subclients
DELETE	#App
FROM	APP_BackupSetName B WITH (NOLOCK)
WHERE	#App.appTypeId IN (46, 78)
AND B.id = #App.backupSet AND (B.status & 0x0800) <> 0
-- Filter out Silo subclients
DELETE	#App
FROM	archGroupCopy C WITH (NOLOCK)
WHERE	appId = C.siloAppId AND C.archGroupId = @i_archGroupId
-- Filter out DDB backup sub-clients.
DELETE	#App
FROM	APP_Application	APP, APP_SubClientProp	ASP
WHERE	#App.appId = APP.id AND APP.id = ASP.componentNameId AND RTRIM(LTRIM(ASP.attrName)) = N'DDB Backup'
		AND RTRIM(LTRIM(ASP.attrVal)) = N'1'
UPDATE	#App
SET		cTime = A.cTime
FROM	#AppCIFlags A
WHERE	#App.appId = A.appId AND A.selected <> 0
SELECT	TOP 1 @l_clientId = clientId
FROM	archContentIndexingApp WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
-- Filter out subclients which are not in the subset for Content Indexing
IF	@@ERROR = 0 AND @@ROWCOUNT > 0
BEGIN
	IF	@l_clientId = -1
		GOTO OUTPUT_EXIT
	DELETE	#App
	WHERE	appId NOT IN (
			SELECT	DISTINCT D.id
			FROM	archContentIndexingApp C WITH (NOLOCK), APP_Application D WITH (NOLOCK)
			WHERE	C.archGroupId = @i_archGroupId
				AND C.clientId = D.clientId AND (C.appTypeId = 0
					OR C.appTypeId = D.appTypeId AND (C.instanceId = 0
						OR C.instanceId = D.instance AND (C.backupSetId = 0
							OR C.backupSetId = D.backupSet AND (C.subClientId = 0
								OR C.subClientId = D.id))))
			)
END
-- Get qualified candidates for Content Indexing
INSERT INTO	#notSelectedJob
SELECT	B.appId, B.appType, A.clientId, B.jobId, B.commCellId, B.bkpLevel, B.servStartDate, B.fullCycleNum, 0
FROM	JMBkpStats B WITH (NOLOCK), #App A
WHERE	B.appId = A.appId AND B.status IN (1, 3, 14)
	AND (B.dataArchGrpId = @i_archGroupId OR B.logArchGrpId = @i_archGroupId)
	AND B.servStartDate > @l_startTime AND B.servStartDate > A.cTime
AND (@l_type = 0 OR B.bkpLevel & @FULL_BITS <> 0)
	-- CI for VMWare iDA is supported only for File Level backup
AND (B.appType <> 106 OR (B.bkpAttributes & 0x18000000000) = 0x08000000000)
INSERT INTO	#notSelectedJob
SELECT	B.appId, 1000, A.clientId, B.jobId, B.commCellId, B.ER_BkpLevel, B.servStart, B.fullCycleNum, 0
FROM	JMAdminJobStatsTable B WITH (NOLOCK), #App A
WHERE	B.appId = A.appId AND B.status IN (1, 3, 14)
	AND B.archGrpID = @i_archGroupId
	AND B.servStart > @l_startTime AND B.servStart > A.cTime
AND (@l_type = 0 OR B.ER_BkpLevel & @FULL_BITS <> 0)
IF	@l_type = 0 AND (@l_flags & 2) <> 0
AND (@l_sourceCopyId = 0 OR NOT EXISTS (SELECT id FROM archGroupCopy WHERE id = @l_sourceCopyId AND type = 2))
	DELETE	#notSelectedJob
	WHERE	bkpLevel IN (64, 128)
-- Go to set CI flag if it's for all backups or for all full backups
IF	@l_type = 0 OR @l_type = 1 AND @l_numPeriod = 1
	GOTO SET_CI_FLAG
DECLARE	@t_appId	INT
IF	@l_type IN (3, 2, 4, 6)
BEGIN
	INSERT INTO #notSelectedJob
	SELECT	B.appId, B.appType, D.clientId, B.jobId, B.commCellId, B.bkpLevel, B.servStartDate, B.fullCycleNum, 1
	FROM	archFile A WITH (NOLOCK), JMBkpStats B WITH (NOLOCK), #AppCIFlags C, #App D
	WHERE	A.archGroupId = @i_archGroupId AND A.appId = C.appId AND A.cTime = C.cTime AND C.selected <> 0
		AND B.jobId = A.jobId AND B.commCellId = A.commCellId
		AND C.appId = D.appId
	DECLARE	@now			INT
	DECLARE	@l_TimeZoneType	INT
	DECLARE @l_TimeZone		VARCHAR(255)
	DECLARE @l_csTimeZone	VARCHAR(255)
	SET		@now = dbo.GetUnixTime(GETUTCDATE())
	SELECT	@l_TimeZoneType = TimeZoneType, @l_TimeZone = TimeZone
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @i_archGroupId
	CREATE TABLE #tempClient (clientId int, TimeZone varchar(255))
	SET @l_csTimeZone = dbo.GetClientTimeZone(2)
	IF	@l_TimeZoneType = 0
	BEGIN
		INSERT	INTO #tempClient
		SELECT	T.clientId, @l_csTimeZone
		FROM	(SELECT DISTINCT clientId FROM #App) T
	END
	ELSE
	IF	@l_TimeZoneType = 1
	BEGIN
		INSERT	INTO #tempClient
		SELECT	T.clientId, dbo.ArchGroupTimeZone(@i_archGroupId, T.clientId)
		FROM	(SELECT DISTINCT clientId FROM #App) T
		UPDATE	#notSelectedJob
		SET		startDate = J.startDate + dbo.GetDiffFromCSTimeZone(J.startDate, C.TimeZone, @l_csTimeZone)
		FROM	#notSelectedJob J, #tempClient C
		WHERE	J.clientId = C.clientId AND C.TimeZone <> '' AND C.TimeZone <> @l_csTimeZone
	END
	ELSE
	IF	@l_TimeZoneType = 2 AND @l_TimeZone <> @l_csTimeZone
	BEGIN
		INSERT	INTO #tempClient
		SELECT	T.clientId, @l_TimeZone
		FROM	(SELECT DISTINCT clientId FROM #App) T
		UPDATE	#notSelectedJob
		SET		startDate = startDate + dbo.GetDiffFromCSTimeZone(startDate, @l_TimeZone, @l_csTimeZone)
	END
IF (@l_flags & 4096) <> 0
	BEGIN
IF (@l_flags & 8192) = 0
		BEGIN
			DECLARE	@nextFullTime	INT
			DECLARE @t_startDate	INT
			DECLARE @t_TimeZone		VARCHAR(255)
			DECLARE getLastFullJobsForApp CURSOR FOR
			SELECT	J.appId, MAX(J.startDate), C.TimeZone
			FROM	#notSelectedJob J, #tempClient C
			WHERE	J.selected = 0 AND J.clientId = C.clientId
			GROUP BY J.appId, C.TimeZone
			OPEN  getLastFullJobsForApp
			FETCH NEXT FROM getLastFullJobsForApp INTO @t_appId, @t_startDate, @t_TimeZone
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DECLARE	@tblNextFullTime TABLE (nextFullTime int)
				INSERT	INTO @tblNextFullTime
				EXEC	@nextFullTime = TM_GetNextScheduleRunTime @t_appId, 1/*BkpLevel Full*/, 1/*counDisabled*/, 1/*countRunnigJob*/
				IF	@nextFullTime > 0 AND @t_TimeZone <> ''
					SET	@nextFullTime = @nextFullTime + dbo.GetDiffFromCSTimeZone(@nextFullTime, @t_TimeZone, @l_csTimeZone)
				IF	@nextFullTime > 0 AND @nextFullTime < @l_prevPeriodBegin
				AND @t_startDate  < @l_prevPeriodBegin
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId
				ELSE
				IF	@nextFullTime >= @l_prevPeriodBegin AND @nextFullTime < @l_startPeriod
				AND @t_startDate  >= @l_prevPeriodBegin AND @t_startDate  < @l_startPeriod
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId AND startDate >= @l_prevPeriodBegin
				ELSE
				IF	@nextFullTime >= @l_startPeriod AND @nextFullTime < @l_nextPeriod
				AND @t_startDate  >= @l_startPeriod AND @t_startDate  < @l_nextPeriod
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId AND startDate >= @l_startPeriod
				ELSE
				IF	@nextFullTime >= @l_nextPeriod AND @nextFullTime < @l_nextPeriodEnd
				AND @t_startDate  >= @l_nextPeriod AND @t_startDate  < @l_nextPeriodEnd
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId AND startDate >= @l_nextPeriod
				ELSE
				IF	@nextFullTime >= @l_nextPeriodEnd
				AND @t_startDate  >= @l_nextPeriodEnd
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId AND startDate >= @l_nextPeriodEnd
				FETCH NEXT FROM getLastFullJobsForApp INTO @t_appId, @t_startDate, @t_TimeZone
			END
			CLOSE getLastFullJobsForApp
			DEALLOCATE getLastFullJobsForApp
		END
		ELSE
		BEGIN
			CREATE	TABLE #ActiveFullStartDate (appId INT, startDate INT)
			INSERT	INTO #ActiveFullStartDate
			EXEC	MMS2startDateOfActiveBackupForApp @i_archGroupId
			UPDATE	#ActiveFullStartDate
			SET		startDate = A.startDate + dbo.GetDiffFromCSTimeZone(A.startDate, T.TimeZone, @l_csTimeZone)
			FROM	#ActiveFullStartDate A,
					(SELECT DISTINCT J.appId, C.TimeZone FROM #notSelectedJob J, #tempClient C WHERE J.clientId = C.clientId AND C.TimeZone <> '') T
			WHERE	A.appId = T.appId
			DELETE	#notSelectedJob
			FROM	#notSelectedJob J, #ActiveFullStartDate A
			WHERE	J.appId = A.appId
				AND (	A.startDate <  @l_prevPeriodBegin AND J.startDate <  @l_prevPeriodBegin
					 OR	A.startDate >= @l_prevPeriodBegin AND J.startDate >= @l_prevPeriodBegin AND
						A.startDate <  @l_startPeriod     AND J.startDate <  @l_startPeriod
					 OR A.startDate >= @l_startPeriod     AND J.startDate >= @l_startPeriod AND
						A.startDate <  @l_nextPeriod      AND J.startDate <  @l_nextPeriod
					 OR A.startDate >= @l_nextPeriod      AND J.startDate >= @l_nextPeriod AND
						A.startDate <  @l_nextPeriodEnd   AND J.startDate <  @l_nextPeriodEnd
					 OR	A.startDate >= @l_nextPeriodEnd   AND J.startDate >= @l_nextPeriodEnd)
			DROP	TABLE #ActiveFullStartDate
			DELETE	#notSelectedJob
			FROM	#notSelectedJob J, #tempClient C
			WHERE	J.clientId = C.clientId
				AND	(	J.startDate >= @l_prevPeriodBegin AND (@now + dbo.GetDiffFromCSTimeZone(@now, C.TimeZone, @l_csTimeZone)) < @l_startPeriod
					OR	J.startDate >= @l_startPeriod     AND (@now + dbo.GetDiffFromCSTimeZone(@now, C.TimeZone, @l_csTimeZone)) < @l_nextPeriod
					OR	J.startDate >= @l_nextPeriod      AND (@now + dbo.GetDiffFromCSTimeZone(@now, C.TimeZone, @l_csTimeZone)) < @l_nextPeriodEnd
					OR	J.startDate >= @l_nextPeriodEnd)
		END
	END
	DROP TABLE #tempClient
	GOTO OUTPUT_EXIT
END
-- Apply cycle-based rule
UPDATE	#App
SET		fullCycleNum = B.fullCycleNum
FROM	archFile A WITH (NOLOCK), JMBkpStats B WITH (NOLOCK)
WHERE	#App.appId = A.appId AND #App.cTime = A.cTime
	AND B.jobId = A.jobId AND B.commCellId = A.commCellId
DELETE	#notSelectedJob
FROM	#App
WHERE	#notSelectedJob.appId = #App.appId
	AND #notSelectedJob.fullCycleNum < (#App.fullCycleNum + @l_numPeriod)
DECLARE checkJobsForApp CURSOR FOR
SELECT	appId, jobId, commCellId, fullCycleNum
FROM	#notSelectedJob
ORDER BY appId, fullCycleNum
DECLARE @t_jobId		INTEGER
DECLARE @t_commCellId	INTEGER
DECLARE @t_fullCycleNum	INTEGER
DECLARE @currAppId		INTEGER
DECLARE @currCycleNum	INTEGER
SET @currAppId       = 0
SET @currCycleNum    = 0
OPEN  checkJobsForApp
FETCH NEXT FROM checkJobsForApp
INTO  @t_appId, @t_jobId, @t_commCellId, @t_fullCycleNum
WHILE @@FETCH_STATUS = 0
BEGIN
    IF	@t_appId <> @currAppId
    BEGIN
        SET @currAppId    = @t_appId
        SET @currCycleNum = @t_fullCycleNum
    END
	ELSE
    IF	@t_fullCycleNum	< @currCycleNum
    BEGIN
        DELETE	#notSelectedJob
        WHERE	jobId = @t_jobId AND commCellId = @t_commCellId
    END
    ELSE
        SET @currCycleNum = (@t_fullCycleNum + @l_numPeriod)
	FETCH NEXT FROM checkJobsForApp
	INTO  @t_appId, @t_jobId, @t_commCellId, @t_fullCycleNum
END
CLOSE checkJobsForApp
DEALLOCATE checkJobsForApp
SET_CI_FLAG:
INSERT	INTO #AF_TO_CI
SELECT	AF.id, AF.commCellId
FROM	#notSelectedJob T, archFile AF WITH(NOLOCK)
WHERE	AF.jobId = T.jobId AND AF.commCellId = T.commCellId
AND AF.isValid = 1 AND AF.fileType = 1
AND (T.appType <> 128 OR (AF.flags & 512) <> 0)
-- Do not set CI required flag if the job was already content indexed or selected for content index
UPDATE	archFile
SET		flags = (flags | 16)
FROM	#AF_TO_CI
WHERE	archFile.id = #AF_TO_CI.id AND archFile.commCellId = #AF_TO_CI.commCellId
AND (archFile.flags & 496) = 0
DELETE	archContentIndexingAged
FROM	#AF_TO_CI
WHERE	archContentIndexingAged.archFileId = #AF_TO_CI.id
	AND archContentIndexingAged.commCellId = #AF_TO_CI.commCellId
AND archContentIndexingAged.operationType = 1
TRUNCATE TABLE #notSelectedJob
OUTPUT_EXIT:
-- Output for selective copies
IF	@i_order = 0
	SELECT	appId, jobId, commCellId, startDate, selected
	FROM	#notSelectedJob
	ORDER BY appId ASC, jobId ASC
ELSE
	SELECT	appId, jobId, commCellId, startDate, selected
	FROM	#notSelectedJob
	ORDER BY appId ASC, selected DESC, jobId DESC
DROP TABLE #App
DROP TABLE #AppCIFlags
DROP TABLE #notSelectedJob
DROP TABLE #AF_TO_CI
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingPickJobs')
	delete from GxQscripts where name = 'archContentIndexingPickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingPickJobs')
	delete from GXDBVersions where aliasname = 'archContentIndexingPickJobs'
GO

insert into GXDBVersions values(2, 'archContentIndexingPickJobs',  '00010042003400060000', 'archContentIndexingPickJobs', '00010042003400060000')
GO

