

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingNewJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingNewJob.sp,v $ $Id: archContentIndexingNewJob.sp,v 1.28.14.6 2018/03/22 01:18:22 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingNewJob <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingNewJob')
	drop procedure archContentIndexingNewJob
IF EXISTS (select * from GxQscripts where name='archContentIndexingNewJob')
	delete from GxQscripts where name = 'archContentIndexingNewJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingNewJob')
	delete from GXDBVersions where aliasname = 'archContentIndexingNewJob'
GO
print '... Creating Procedure: archContentIndexingNewJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingNewJob
  @i_jobId integer,
  @i_appId integer,
  @i_appType integer,
  @i_startDate integer,
  @i_backupLevel integer,
  @i_fullCycleNum integer,
  @i_nextFullTime integer,
  @i_today integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #tempAFile(
	id int, commCellId int, archGroupId int,
	PRIMARY KEY(id, commCellId))
DECLARE	@i_commCellId   INTEGER
SET	@i_commCellId = 2
-- Filter out Silo subclients
IF EXISTS (SELECT TOP 1 1 FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId = @i_appId)
	GOTO RETURN_PROC
BEGIN TRY
DECLARE @TranCounter INT
SET @TranCounter = @@TRANCOUNT
IF @TranCounter > 0
	SAVE TRANSACTION CI_NEWJOB_TRAN
ELSE
	BEGIN TRANSACTION
-- CI for SharePoint iDA is supported only for Document backupSet
IF @i_appType IN (46, 78)
BEGIN
	IF EXISTS (
		SELECT TOP 1 B.id
		FROM APP_BackupSetName B (NOLOCK)
		JOIN APP_Application A (NOLOCK) ON B.id = A.backupSet
WHERE A.id = @i_appId AND (B.status & 0x0800) <> 0)
		GOTO RETURN_PROC
END
-- CI for VMWare iDA is supported only for File Level backup
IF @i_appType = 106
BEGIN
	IF NOT EXISTS (
		SELECT	jobId FROM JMBkpStats WITH (NOLOCK)
		WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
			AND (bkpAttributes & 0x18000000000) = 0x08000000000)
		GOTO RETURN_PROC
END
-- Check if Content Indexing Enabled at client level.
-- TO DO: Check if there is a valid Content Indexing license for each client.
IF NOT EXISTS (
	SELECT TOP 1 1
	FROM APP_ClientProp CP (NOLOCK)
	JOIN APP_Application A (NOLOCK) ON CP. ComponentNameId = A.clientId
	WHERE A.id = @i_appId
		AND CP.attrName = N'Content Indexing Enabled' AND CP.attrVal = N'1' AND CP.modified = 0)
	GOTO RETURN_PROC
--
-- DDB Backup jobs & Index backup jobs should not be picked for CI.
IF EXISTS (
	SELECT TOP 1 1
	FROM APP_Application APP (NOLOCK)
	inner join 	APP_SubClientProp ASP (NOLOCK) on ASP.componentNameId = APP.id
	WHERE	APP.id = @i_appId
		AND
		(
			( RTRIM(LTRIM(ASP.attrName)) = N'DDB Backup' or RTRIM(LTRIM(ASP.attrName)) = N'Index SubClient'	)
			AND
			RTRIM(LTRIM(ASP.attrVal)) = N'1'
		)
)
begin
	GOTO RETURN_PROC
end
INSERT	INTO #tempAFile
SELECT	id, commCellId, archGroupId
FROM	archFile WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
AND fileType = 1 AND isValid = 1
AND (flags & 2) = 0
AND (@i_appType <> 128 OR (flags & 512) <> 0)
AND( flags & (32768|2097152) ) =0
DECLARE	@l_archGroupId	INT = 0
DECLARE	@l_enabled		INT = 0
DECLARE	@l_type			INT = 0
DECLARE	@l_flags		INT = 0
DECLARE	@l_startTime	INT = 0
DECLARE	@l_numPeriod	INT = 0
DECLARE	@l_dayNumber	INT = 0
DECLARE	@l_startPeriod	INT = 0
DECLARE	@l_nextPeriod	INT = 0
DECLARE	@l_prevPeriodBegin	INT = 0
DECLARE	@l_nextPeriodEnd	INT = 0
DECLARE	@l_clientId		INT = 0
DECLARE	@l_sourceCopyId	INT = 0
SELECT	TOP 1 @l_archGroupId = ISNULL(archGroupId, 0) FROM #tempAFile
IF	@l_archGroupId = 0
	GOTO RETURN_PROC
SELECT	@l_enabled = enabled, @l_type = type, @l_flags = flags, @l_startTime = startTime,
		@l_numPeriod = numPeriod, @l_dayNumber = dayNumber, @l_sourceCopyId = sourceCopyId,
		@l_startPeriod = startPeriod, @l_nextPeriod = nextPeriod, @l_prevPeriodBegin = prevPeriodBegin, @l_nextPeriodEnd = nextPeriodEnd
FROM	archContentIndexingRules (NOLOCK)
WHERE	archGroupId = @l_archGroupId AND operationType = 1
IF	@l_enabled = 0
OR @l_type = 9
OR @l_type <> 0 AND @i_backupLevel NOT IN (1, 64, 128, 1024, 32768)
 OR @i_startDate < @l_startTime
	GOTO RETURN_PROC
--
SELECT	TOP 1 @l_clientId = clientId
FROM	archContentIndexingApp WITH (NOLOCK)
WHERE	archGroupId = @l_archGroupId
--
IF	@@ERROR = 0 AND @@ROWCOUNT > 0
BEGIN
	IF	@l_clientId = -1
	 OR NOT EXISTS (
			SELECT TOP 1 1 FROM archContentIndexingApp C WITH (NOLOCK)
			JOIN  APP_Application D WITH (NOLOCK) ON C.clientId = D.clientId
			WHERE	C.archGroupId = @l_archGroupId AND D.id = @i_appId
				 AND (C.appTypeId = 0
				 OR C.appTypeId = D.appTypeId AND (C.instanceId = 0
				 OR C.instanceId = D.instance AND (C.backupSetId = 0
				 OR C.backupSetId = D.backupSet AND (C.subClientId = 0
				 OR C.subClientId = D.id))))
			)
		GOTO RETURN_PROC
END
IF	@l_type = 0
	GOTO SELECT_JOB
-- Apply selection rules.
IF	@l_type IN (1, 3, 2, 4, 6)
BEGIN
	DECLARE @l_startDate	INT = 0
	DECLARE @l_fullCycleNum	INT = 0
	DECLARE @l_jobId		INT = 0
	DECLARE @l_commCellId	INT = 0
	SELECT	TOP 1 @l_jobId = jobId, @l_commCellId = commCellId
	FROM	archFile WITH (NOLOCK)
WHERE	appId = @i_appId AND fileType = 1 AND isValid = 1
AND flags & 496 <> 0
AND (@i_appType <> 128 OR (flags & 512) <> 0)
	ORDER BY id DESC
	IF	@@ROWCOUNT > 0
	BEGIN
		SELECT	@l_startDate = servStartDate, @l_fullCycleNum = fullCycleNum
		FROM	JMBkpStats WITH (NOLOCK)
		WHERE	jobId = @l_jobId AND commCellId = @l_commCellId
		IF	@@ROWCOUNT = 0
			SELECT	@l_startDate = servStart, @l_fullCycleNum = fullCycleNum
			FROM	JMAdminJobStatsTable WITH (NOLOCK)
			WHERE	jobId = @l_jobId AND commCellId = @l_commCellId
	END
IF	@l_type = 1
	BEGIN
		IF	@i_fullCycleNum < (@l_numPeriod + @l_fullCycleNum)
			GOTO RETURN_PROC
	END
	ELSE
IF	@l_type IN (3, 2, 4, 6)
	BEGIN
		SELECT	@l_clientId = clientId FROM APP_Application WITH (NOLOCK) WHERE id = @i_appId
		DECLARE	@l_TimeZone varchar(255)
		SET		@l_TimeZone = dbo.ArchGroupTimeZone(@l_archGroupId, @l_clientId)
		DECLARE	@now INT
		SET		@now = dbo.GetUnixTime(GETUTCDATE())
		IF @l_TimeZone <> ''
		BEGIN
			DECLARE	@l_csTimeZone varchar(255)
			SET		@l_csTimeZone = dbo.GetClientTimeZone(2)
			IF	@l_TimeZone <> @l_csTimeZone
			BEGIN
				SET @now = @now + dbo.GetDiffFromCSTimeZone(@now, @l_TimeZone, @l_csTimeZone)
				SET	@i_startDate = @i_startDate + dbo.GetDiffFromCSTimeZone(@i_startDate, @l_TimeZone, @l_csTimeZone)
				IF	@l_startDate > 0
					SET	@l_startDate = @l_startDate + dbo.GetDiffFromCSTimeZone(@l_startDate, @l_TimeZone, @l_csTimeZone)
IF	@i_nextFullTime > 0 AND (@l_flags & 4096) <> 0 AND (@l_flags & 8192) = 0
					SET	@i_nextFullTime = @i_nextFullTime + dbo.GetDiffFromCSTimeZone(@i_nextFullTime, @l_TimeZone, @l_csTimeZone)
			END
		END
		IF	@l_startDate > 0 AND
			(	@i_startDate >= @l_prevPeriodBegin AND @l_startDate >= @l_prevPeriodBegin AND @i_startDate < @l_startPeriod   AND @l_startDate < @l_startPeriod
			OR	@i_startDate >= @l_startPeriod     AND @l_startDate >= @l_startPeriod     AND @i_startDate < @l_nextPeriod    AND @l_startDate < @l_nextPeriod
			OR	@i_startDate >= @l_nextPeriod      AND @l_startDate >= @l_nextPeriod      AND @i_startDate < @l_nextPeriodEnd AND @l_startDate < @l_nextPeriodEnd
			OR  @i_startDate >= @l_nextPeriodEnd   AND @l_startDate >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
IF	(@l_flags & 4096) <> 0 AND (@l_flags & 8192) = 0 AND @i_nextFullTime > 0 AND
			(	@i_startDate <  @l_prevPeriodBegin AND @i_nextFullTime <  @l_prevPeriodBegin
			OR  @i_startDate >= @l_prevPeriodBegin AND @i_nextFullTime >= @l_prevPeriodBegin AND @i_startDate < @l_startPeriod   AND @i_nextFullTime < @l_startPeriod
			OR	@i_startDate >= @l_startPeriod     AND @i_nextFullTime >= @l_startPeriod     AND @i_startDate < @l_nextPeriod    AND @i_nextFullTime < @l_nextPeriod
			OR	@i_startDate >= @l_nextPeriod      AND @i_nextFullTime >= @l_nextPeriod      AND @i_startDate < @l_nextPeriodEnd AND @i_nextFullTime < @l_nextPeriodEnd
			OR  @i_startDate >= @l_nextPeriodEnd   AND @i_nextFullTime >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
IF	(@l_flags & 4096) <> 0 AND (@l_flags & 8192) <> 0 AND
			(	@i_startDate >= @l_prevPeriodBegin AND @now < @l_startPeriod
			OR	@i_startDate >= @l_startPeriod     AND @now < @l_nextPeriod
			OR	@i_startDate >= @l_nextPeriod      AND @now < @l_nextPeriodEnd
			OR	@i_startDate >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
	END
END
SELECT_JOB:
UPDATE	archFile
SET		flags = (flags | 16)
FROM	#tempAFile
WHERE	archFile.id = #tempAFile.id AND archFile.commCellId = #tempAFile.commCellId
SET @retVal = @@ERROR
IF @retVal !=0
	GOTO RETURN_PROC
DELETE	archContentIndexingAged
FROM	#tempAFile
WHERE	archContentIndexingAged.archFileId = #tempAFile.id
	AND archContentIndexingAged.commCellId = #tempAFile.commCellId
AND archContentIndexingAged.operationType = 1
SET @retVal = @@ERROR
IF @TranCounter = 0
	COMMIT TRANSACTION
ELSE
	COMMIT TRANSACTION CI_NEWJOB_TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = @@ERROR
END CATCH
RETURN_PROC:
IF @retVal !=0
BEGIN
	IF @TranCounter = 0
		ROLLBACK TRANSACTION
	ELSE
         IF XACT_STATE() <> -1
			ROLLBACK TRANSACTION CI_NEWJOB_TRAN
END
DROP TABLE #tempAFile
SELECT   @retVal
RETURN   @retVal;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingNewJob')
	delete from GxQscripts where name = 'archContentIndexingNewJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingNewJob')
	delete from GXDBVersions where aliasname = 'archContentIndexingNewJob'
GO

insert into GXDBVersions values(2, 'archContentIndexingNewJob',  '00010028001400060000', 'archContentIndexingNewJob', '00010028001400060000')
GO

