

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingListMediaByOperationType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingListMediaByOperationType.sp,v $ $Id: archContentIndexingListMediaByOperationType.sp,v 1.1.4.2 2018/05/11 22:34:52 bkharabe Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingListMediaByOperationType <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingListMediaByOperationType')
	drop procedure archContentIndexingListMediaByOperationType
IF EXISTS (select * from GxQscripts where name='archContentIndexingListMediaByOperationType')
	delete from GxQscripts where name = 'archContentIndexingListMediaByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingListMediaByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingListMediaByOperationType'
GO
print '... Creating Procedure: archContentIndexingListMediaByOperationType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingListMediaByOperationType
  @i_archGroupId int,
  @i_copyId int,
  @i_stream int,
  @i_operationType int
AS
  DECLARE @o_srcCopyId int;
  DECLARE @o_srcStream int;
  DECLARE @o_volumeId int;
  DECLARE @o_mediaId int;
  DECLARE @o_mediaGroupId int;
  DECLARE @o_barcode varchar(256);
  DECLARE @o_firstChunkId bigint;
  DECLARE @o_lastChunkId bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SELECT	archCopyId, streamNum, volumeId, mediaId, mediaGroupId,
		(SELECT barcode FROM MMMedia WITH (NOLOCK) WHERE MediaId = archContentIndexingAF.mediaId),
		MIN(archChunkId) AS firstChunkId, MAX(archChunkId) AS lastChunkId
FROM	archContentIndexingAF WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId AND (@i_copyId = 0 OR archCopyId = @i_copyId) AND (@i_stream = 0 OR streamNum = @i_stream)
AND		(@i_stream = 0 AND streamNum > 0 OR @i_stream > 0 AND @i_stream = streamNum)
AND operationType = @i_operationType --only for classical ci jobs
GROUP BY archCopyId, streamNum, volumeId, mediaId, mediaGroupId
ORDER BY archCopyId, streamNum, firstChunkId, lastChunkId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingListMediaByOperationType')
	delete from GxQscripts where name = 'archContentIndexingListMediaByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingListMediaByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingListMediaByOperationType'
GO

insert into GXDBVersions values(2, 'archContentIndexingListMediaByOperationType',  '00010001000400020000', 'archContentIndexingListMediaByOperationType', '00010001000400020000')
GO

