

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingListMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingListMedia.sp,v $ $Id: archContentIndexingListMedia.sp,v 1.3.202.3 2018/03/22 01:07:31 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingListMedia <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingListMedia')
	drop procedure archContentIndexingListMedia
IF EXISTS (select * from GxQscripts where name='archContentIndexingListMedia')
	delete from GxQscripts where name = 'archContentIndexingListMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingListMedia')
	delete from GXDBVersions where aliasname = 'archContentIndexingListMedia'
GO
print '... Creating Procedure: archContentIndexingListMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingListMedia
  @i_archGroupId int,
  @i_copyId int,
  @i_stream int
AS
  DECLARE @o_srcCopyId int;
  DECLARE @o_srcStream int;
  DECLARE @o_volumeId int;
  DECLARE @o_mediaId int;
  DECLARE @o_mediaGroupId int;
  DECLARE @o_barcode varchar(256);
  DECLARE @o_firstChunkId bigint;
  DECLARE @o_lastChunkId bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SELECT	archCopyId, streamNum, volumeId, mediaId, mediaGroupId,
		(SELECT barcode FROM MMMedia WITH (NOLOCK) WHERE MediaId = archContentIndexingAF.mediaId),
		MIN(archChunkId) AS firstChunkId, MAX(archChunkId) AS lastChunkId
FROM	archContentIndexingAF WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId AND (@i_copyId = 0 OR archCopyId = @i_copyId) AND (@i_stream = 0 OR streamNum = @i_stream)
AND		(@i_stream = 0 AND streamNum > 0 OR @i_stream > 0 AND @i_stream = streamNum)
AND operationType = 1 --only for classical ci jobs
GROUP BY archCopyId, streamNum, volumeId, mediaId, mediaGroupId
ORDER BY archCopyId, streamNum, firstChunkId, lastChunkId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingListMedia')
	delete from GxQscripts where name = 'archContentIndexingListMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingListMedia')
	delete from GXDBVersions where aliasname = 'archContentIndexingListMedia'
GO

insert into GXDBVersions values(2, 'archContentIndexingListMedia',  '00010003020200030000', 'archContentIndexingListMedia', '00010003020200030000')
GO

