

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingInsertByOperationType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingInsertByOperationType.sp,v $ $Id: archContentIndexingInsertByOperationType.sp,v 1.1.4.13 2020/07/24 03:29:08 bkharabe Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archContentIndexingInsertByOperationType')
BEGIN
	print '>>> Drop Stored Procedure: archContentIndexingInsertByOperationType <<<'
	drop procedure archContentIndexingInsertByOperationType
END
IF EXISTS (select * from GxQscripts where name='archContentIndexingInsertByOperationType')
	delete from GxQscripts where name = 'archContentIndexingInsertByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingInsertByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingInsertByOperationType'
GO
print '... Creating Procedure: archContentIndexingInsertByOperationType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingInsertByOperationType
  @i_archGroupId int,
  @i_endBefore int,
  @i_srcCopyId int,
  @i_srcStream int,
  @i_CIJobId int,
  @i_dataSourceId int,
  @i_operationType int
AS
  DECLARE @retVal integer;
  DECLARE @secondaryCIPresent integer;
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tblAPP') IS NOT NULL DROP TABLE #tblAPP
 CREATE TABLE #tblAPP (appId int, appTypeId int, clientId int, hasErasedData int ,
 PRIMARY KEY (appId, appTypeId, clientId))
DECLARE	@tblClient	TABLE (
	clientId int primary key, needPassPhrase int)
IF object_id('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
 CREATE TABLE #tblAFC (
	jobId int, appId int, backupStartTime int, backupEndTime int, fullCycleNum int,
	archFileId int, commCellId int, archCopyId int, streamNum int, lastChunkNumber int,
	encKeyType int, encRSA int, flags int, isMag int, copyPrec int, BkpLevel int,
	PRIMARY KEY (archFileId, commCellId, archCopyId)
)
IF object_id('tempdb.dbo.#tblAFChunk') IS NOT NULL DROP TABLE #tblAFChunk
CREATE TABLE	#tblAFChunk	(
	acCommCellId int, archChunkId bigint, afCommCellId int, archFileId int, archCopyId int, chunkNumber int,
	physicalOffset bigint, logicalOffset bigint, physicalSize bigint, logicalSize bigint,
	fileMarkerNo int, chunkCreateTime int, chunkVersion int, chunkPhysicalSize bigint, chunkLogicalSize bigint,
chunkHwEncKey varchar(114),
	volumeId int, mediaId int, mediaGroupId int, RecordingFormatId int,
	PRIMARY KEY (acCommCellId, archChunkId, afCommCellId, archFileId)
)
IF object_id('tempdb.dbo.#tblCopyMA') IS NOT NULL DROP TABLE #tblCopyMA
CREATE TABLE	#tblCopyMA
(
	CopyId int,
	HostClientId int
	PRIMARY KEY (CopyId, HostClientId)
)
--
IF OBJECT_ID('tempdb..#tblJobTimes') IS NOT NULL drop table #tblJobTimes
create table #tblJobTimes
(
	jobId int,
	commCellId int,
	archCopyId int,
	jobCopiedTime int,
	primary key (jobId, commCellId, archCopyId)
);
--
DECLARE	@CIJobStartTime 	INT = 0
DECLARE @skippedPartialAFs 	INT = 0
DECLARE @skippedAFs		INT = 0
DECLARE @isSolrCloud 		BIT = 0
DECLARE @debug				BIT = 0
DECLARE @tempFlag           INT = 0
DECLARE @ciRulesType        INT = 0
DECLARE @flags              INT = 0
DECLARE @cloudId            INT = 0
DECLARE @defferedDays       INT = 0
--
DECLARE @l_ignoreDVFailedJobs INTEGER = ISNULL((SELECT cast(value as INT) from GXGlobalParam WITH (NOLOCK) where name = N'SkipFailedDataVerificationJobForCI' and Modified = 0), 0)
IF @i_operationType = 1
BEGIN
SELECT  @ciRulesType = type, @flags = flags, @defferedDays= deferredDays FROM archContentIndexingRules WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND operationType = 1
END
SET @secondaryCIPresent = 0
IF (@ciRulesType = 0 AND (@flags & 2) <> 0 )
BEGIN
	SET @flags = 1
END
ELSE
BEGIN
	SET @flags = 0
END
--
SELECT @CIJobStartTime = jobStartTime FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @i_CIJobId
--
IF @i_srcCopyId = 0
	INSERT	INTO #tblCopyMA
	SELECT	DISTINCT CopyId, MMDrivePool.ClientId
	FROM	MMDataPath WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), MMDrivePool WITH (NOLOCK)
	WHERE	MMDataPath.CopyId = AGC.id AND AGC.archGroupId = @i_archGroupId AND AGC.isSnapCopy = 0
			AND	MMDataPath.DrivePoolId = MMDrivePool.DrivePoolId
ELSE
	INSERT	INTO #tblCopyMA
	SELECT	DISTINCT CopyId, MMDrivePool.ClientId
	FROM	MMDataPath WITH (NOLOCK), MMDrivePool WITH (NOLOCK)
	WHERE	MMDataPath.CopyId = @i_srcCopyId
			AND	MMDataPath.DrivePoolId = MMDrivePool.DrivePoolId
-- Exclude copies which do not have a datapath for Windows MA. Only Content Indexing on a Windows Media Agent is supported.
DELETE	#tblCopyMA
FROM	#tblCopyMA MA, APP_Client CLNT WITH (NOLOCK), simOperatingSystem SOS WITH (NOLOCK)
WHERE	CLNT.id = MA.HostClientId
	AND SOS.id = CLNT.simOperatingSystemId
	AND NOT ( SOS.type = 'Windows' OR SOS.SubType = 'Linux')
IF	NOT EXISTS (SELECT * FROM #tblCopyMA)
BEGIN
DECLARE @l_srcMAId INTEGER = ISNULL(dbo.GetOptionInt(1564054677, @i_CIJobId, 0, 0), 0)
	IF @l_srcMAId > 0 AND EXISTS (SELECT TOP 1 CLNT.id
								  FROM APP_Client CLNT WITH (NOLOCK), simOperatingSystem SOS WITH (NOLOCK)
								  WHERE	CLNT.id = @l_srcMAId
										AND SOS.id = CLNT.simOperatingSystemId
										AND SOS.type = 'Windows')
	BEGIN
		IF @i_srcCopyId = 0
		BEGIN
			INSERT INTO #tblCopyMA
			SELECT	DISTINCT DP.CopyId, DC.ClientId
			FROM	archGroupCopy AGC WITH (READUNCOMMITTED)
						INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON AGC.id = DP.CopyId
						INNER JOIN MMDrivePool DRP WITH (READUNCOMMITTED) ON DP.DrivePoolId = DRP.DrivePoolId
						-- INNER JOIN MMMasterPool MRP WITH (READUNCOMMITTED) ON DRP.MasterPoolId = MRP.MasterPoolId
						INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON DRP.MasterPoolId = MP.MasterPoolId
						-- INNER JOIN MMLibrary L WITH (READUNCOMMITTED) ON MRP.LibraryId = L.LibraryId
						INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MP.MountPathId = MSD.MountPathId
						INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON MSD.DeviceId = DC.DeviceId
			WHERE	AGC.archGroupId = @i_archGroupId
					AND AGC.isSnapCopy = 0
					AND DC.ClientId = @l_srcMAId
		END
		ELSE
		BEGIN
			INSERT INTO #tblCopyMA
			SELECT	DISTINCT DP.CopyId, DC.ClientId
			FROM	MMDataPath DP WITH (READUNCOMMITTED)
						INNER JOIN MMDrivePool DRP WITH (READUNCOMMITTED) ON DP.DrivePoolId = DRP.DrivePoolId
						-- INNER JOIN MMMasterPool MRP WITH (READUNCOMMITTED) ON DRP.MasterPoolId = MRP.MasterPoolId
						INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON DRP.MasterPoolId = MP.MasterPoolId
						-- INNER JOIN MMLibrary L WITH (READUNCOMMITTED) ON MRP.LibraryId = L.LibraryId
						INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MP.MountPathId = MSD.MountPathId
						INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON MSD.DeviceId = DC.DeviceId
			WHERE	DP.CopyId = @i_srcCopyId
					AND DC.ClientId = @l_srcMAId
		END
	END
	IF	NOT EXISTS (SELECT * FROM #tblCopyMA)
SET @retVal = 68
END
IF	@retVal <> 0 GOTO FINISH
--
IF @i_operationType = 1
BEGIN
SELECT @cloudId = cloudId FROM archContentIndexingRules WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND operationType = 1
    SET @retVal = @@ERROR
    IF @retVal <> 0 GOTO FINISH
END
ELSE IF @i_operationType = 2
BEGIN
    SELECT @cloudId = CI.CloudID FROM SEDataSource AS DS WITH (NOLOCK)
        INNER JOIN SECollectionInfo AS CI WITH (NOLOCK)
        ON DS.coreId = CI.coreId
        WHERE DS.dataSourceId = @i_dataSourceId
END
--
if exists(select componentId from APP_ComponentProp (NOLOCK)  where propertyTypeId = 1014
and componentType = 2 and stringVal like '%Solr%' AND modified = 0 AND componentId = @cloudId)
begin
    set @isSolrCloud = 1
end
--
--
IF @i_srcStream > 0
	DELETE FROM archContentIndexingAF WHERE archGroupId = @i_archGroupId AND streamNum = @i_srcStream AND operationType = @i_operationType
ELSE
	DELETE FROM archContentIndexingAF WHERE archGroupId = @i_archGroupId AND operationType = @i_operationType
--
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--
-- Edge backups. If any edge afs have new chunks, then pick them for CI.
-- If any edge afs have no new chunks but newer afs, delete the restart offset.
if object_id('tempdb..#EdgeArchiveFiles') is not null drop table #EdgeArchiveFiles
create table #EdgeArchiveFiles
(
	ArchFileId int,
	CommCellId int,
	CopyId int,
	StreamNum int,
	PhysicalOffset bigint,
	NewChunkPresent bit,
	NewAFOnStream bit,
        AppId int
	Primary Key (ArchFileId, CommCellId)
);
--
insert into #EdgeArchiveFiles (ArchFileId, CommCellId, CopyId, StreamNum, PhysicalOffset, NewChunkPresent, NewAFOnStream, AppId)
select r.ArchFileId, r.CommCellId, null, null, r.physicalOffset, 0, 0, a.appId from archContentIndexingRestart r with (nolock)
inner join archFile a  with (nolock) on a.id = r.archFileId and a.commCellId = r.commCellId
where a.fileType = 1 and dbo.IsBackupLevelFull(a.backupLevel) = 0 and a.flags & (32768|2097152) <> 0
and a.archGroupId = @i_archGroupId AND r.operationType = @i_operationType
--
update #EdgeArchiveFiles set CopyId = g.defaultCopy, StreamNum = afc.streamNum, NewChunkPresent = (case when afc.physicalSize > e.PhysicalOffset then 1 else 0 end)
from #EdgeArchiveFiles e
inner join archFile a with (nolock) on a.id = e.ArchFileId and a.commCellId = e.CommCellId
inner join archGroup g with (nolock) on g.id = a.archGroupId
inner join archFileCopy afc with (nolock) on afc.archFileId = e.ArchFileId and afc.commCellId = e.CommCellId and afc.archCopyId = g.defaultCopy
--
update #EdgeArchiveFiles set NewAFOnStream = 1 from #EdgeArchiveFiles e
inner join archFile af on af.appId = e.AppId and af.Id > e.ArchFileId and af.commCellId = e.CommCellId
inner join archFileCopy c on c.archFileId = af.Id and c.commCellId = af.CommCellId and c.streamNum = e.StreamNum
--
IF @i_operationType = 1
SET @tempFlag = 64
ELSE IF @i_operationType =  2
SET @tempFlag = 33554432
delete archContentIndexingRestart from archContentIndexingRestart r
inner join archFile a with (nolock) on a.Id = r.archFileId and a.commCellId = r.commCellId and a.Flags & @tempFlag <> 0
inner join #EdgeArchiveFiles e on e.ArchFileId = r.ArchFileId and e.CommCellId = e.commCellId and e.NewChunkPresent = 0 and e.NewAFOnStream = 1 AND r.operationType = @i_operationType
--
IF @i_operationType = 1
BEGIN
update archFile set flags = flags | 32 from archFile af
    inner join #EdgeArchiveFiles e on e.ArchFileId = af.id and e.CommCellId = af.commCellId and e.NewChunkPresent = 1
where af.flags & (32 + 16) = 0
END
--
-- End of edge processing
--
INSERT INTO #tblAFC
SELECT	AF.jobId, AF.appId, 0, 0, 0,
		AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.streamNum,
		AFC.lastChunkNumber, AFC.encKeyType, AFC.encRSA, AFC.flags, 0, 0, NULL
FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), App_Application SC WITH (NOLOCK), #CI_Client C
WHERE	AF.archGroupId = @i_archGroupId AND AF.fileType = 1
    AND AF.appId = SC.id AND SC.clientId = C.clientId
AND ((@i_operationType = 1) AND (AF.flags & (2 + 16 + 32) <> 0 )
OR ((@i_operationType = 2) AND (AF.flags & 33554432 = 0)))
	AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
AND AFC.isValid > 0 AND AFC.flags & 256 = 0
	AND AFC.archCopyId IN (SELECT DISTINCT CopyId FROM #tblCopyMA)
AND (AF.flags & (32768|2097152|512)) =0  --Prevent CI of EDGE Data, unsupported types (block level backup)
DELETE AF
FROM #tblAFC AF
INNER JOIN JMBkpStats BKPJSTATS WITH (NOLOCK)
ON AF.jobId = BKPJSTATS.jobId AND BKPJSTATS.agedTime <> 0
-- pick up only relevant app type sub clients
IF @i_operationType = 2
BEGIN
    DECLARE @dsType VARCHAR(20)
    SELECT TOP 1 @dsType = DST.TypeName from SEDataSource DS WITH (NOLOCK)
        INNER JOIN SEDataSourceType DST WITH (NOLOCK)
        ON DS.DataSourceType = DST.TypeId
        WHERE DS.DataSourceId = @i_dataSourceId
    IF @dsType = 'file'
    BEGIN
        DELETE SC
        FROM #tblAFC SC
        INNER JOIN APP_Application App WITH (NOLOCK)
            ON SC.appId = App.id
        INNER JOIN App_AppTypeGroups AppTypGr WITH (NOLOCK)
            ON App.appTypeId = AppTypGr.appTypeId
        WHERE AppTypGr.App <> 'File System'
    END
    --delete the older cycles
	DECLARE @dsCreateTime INT  = 0
	SELECT @dsCreateTime = dbo.GetUnixTime(CreateTime) FROM SEDataSource WITH (NOLOCK) WHERE DataSourceId = @i_dataSourceId
	DECLARE @tblAppidFullCycle TABLE (appId INT, fullCycle INT)
	INSERT INTO @tblAppidFullCycle
	SELECT appId, MAX ( fullCycleNum) FROM JMBkpStats WITH (NOLOCK) WHERE appId in (SELECT appId FROM #tblAFC) AND servEndDate <= @dsCreateTime GROUP BY appId
	DELETE AF from #tblAFC AF
		INNER JOIN JMBkpStats BKP ON AF.appId = BKP.appId AND AF.jobId = BKP.jobId
		INNER JOIN @tblAppidFullCycle CYC ON BKP.appId = CYC.appId
		WHERE BKP.fullCycleNum < CYC.fullCycle
END
-- Changes: 1. Do not pick jobs for CI whose copied time is greater than CI job's start time.
--			2. Do not pick partially copied jobs (on a secondary copy) for CI.
INSERT INTO #tblJobTimes
SELECT DISTINCT TAFC.jobId,TAFC.commCellId, TAFC.archCopyId,JMDS.copiedTime
FROM	#tblAFC	TAFC
JOIN	JMJobDataStats	JMDS (NOLOCK)
	ON	TAFC.jobId = JMDS.jobId AND TAFC.archCopyId = JMDS.archGrpCopyId AND TAFC.commCellId = JMDS.commCellId
WHERE	JMDS.copiedTime <=  @CIJobStartTime AND JMDS.dataType = 1 AND JMDS.status = 100
-- Delete jobs which are not in tblJobTimes
DELETE #tblAFC
FROM  #tblAFC	AFC
LEFT OUTER JOIN	#tblJobTimes JT
	ON AFC.jobId = JT.jobId AND AFC.commCellId = JT.commCellId
WHERE JT.jobId IS NULL AND JT.commCellId IS NULL
--
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--
--
-- In case of afcore, we need to only content index the latest synthetic full and not previous synthetic fulls
-- for each subclient.
-- We would also like to control the frequency of content indexing SF jobs - this is done by reading a value
-- from GxGLobalParam. Once if the time difference between the latest SF and the last content indexed SF is
-- greater then we content index the later SF. All SFs found in between as marked as NOT PICKED.
--
if exists(select top 1 1 from GxGlobalParam (NOLOCK) where Name = N'AutoMarkOldSynthfullsCompleteForCI' and Value = N'1' and Modified = 0)
begin
	declare @sfIntervalDays int = 30
	select @sfIntervalDays = cast(value as INT) from GXGlobalParam (NOLOCK) where name = N'ContentIndexingSynthfullIntervalDays' and Modified = 0
	--
	if OBJECT_ID('tempdb..#AppIds') is not null drop table #AppIds
	create table #AppIds
	(
		Id int,
		CommCellId int,
		ClientId int,
		LatestSFJobId int,
		LatestSFJobTime int,
		RecentSFJobId int default(0), -- Most recent SF job which has been content indexed.
		RecentSFJobTime int default(0),
		ContentIndex bit default(0),
		Primary Key(Id, CommCellId)
	);
	--
	insert into #AppIds (Id, CommCellId, ClientId)
	select distinct afc.appId, afc.CommCellId, app.clientId from #tblAFC afc inner join APP_Application app with (nolock) on app.Id = afc.appId
	--
	if @debug  = 1 select 'Step1', * from #AppIds order by ClientId, Id
	update #AppIds set LatestSFJobId = T.LastSF, LatestSFJobTime = jts.jobCopiedTime
	from #AppIds app
	inner join
	(
		select a.Id, a.CommCellId, max(j.JobId) as LastSF from #AppIds a
		inner join JMBkpStats j with (nolock) on j.appId = a.Id
		inner join #tblJobTimes jt on jt.jobId = j.jobId and jt.commCellId = j.commCellId
		where
		j.bkpLevel in (0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
		group by a.Id, a.CommCellId
	) T
	on
		T.Id = app.Id and T.CommCellId = app.CommCellId
	inner join #tblJobTimes jts on jts.jobId = T.LastSF and jts.commCellId = T.CommCellId
	--
	if @debug  = 1 select 'Step2', * from #AppIds order by ClientId, Id
	update #AppIds set RecentSFJobId = T.JobId, RecentSFJobTime = JMDS.copiedTime
	from #AppIds app
	inner join
	(
		select af.appId, af.CommCellId, max(af.JobId) JobId from #AppIds a
		inner join archFile af with (nolock) on af.appId = a.Id and af.commCellId = a.commCellId
		inner join JMBkpStats j with (nolock) on j.jobId = af.jobId  and j.commCellId = af.CommCellId
		where
		j.bkpLevel in (0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
		and af.fileType = 1
and ((@i_operationType = 1 AND ((af.flags & 64 /*CVA_AF_CI_SUCCESS_FLAG*/) > 0 OR (af.flags & 32 /*CVA_AF_CI_PARTIAL_FLAG*/) > 0))
OR (@i_operationType = 2 AND ((af.flags & 33554432 /*CVA_AF_EE_SUCCESS_FLAG*/) > 0 OR (af.flags & 134217728 /*CVA_AF_EE_PARTIAL_FLAG*/) > 0)))
		group by af.appId, af.commCellId
	) T
	on
		T.appId = app.Id
	inner join JMJobDataStats JMDS (NOLOCK) on JMDS.jobId = T.JobId and JMDS.commCellId = T.CommCellId
	--
	if @debug  = 1 select 'Step3', *, DATEDIFF(DAY, dbo.getdatetime(RecentSFJobTime), dbo.getdatetime(LatestSFJobTime)) as DiffDays, @sfIntervalDays IntervalDays from #AppIds order by ClientId, Id
	IF OBJECT_ID('tempdb..#AffectedArchFileIds') IS NOT NULL drop table #AffectedArchFileIds
	create table #AffectedArchFileIds
	(
		ArchFileId int,
		CommCellId int
		Primary Key (ArchFileId, CommCellId)
	)
	--
	if OBJECT_ID('tempdb..#PartialJobs') is not null drop table #PartialJobs
	create table #PartialJobs
	(
		JobId int,
		CommCellId int,
		Primary Key (JobId, CommCellId)
	);
	--
	-- Any jobs which have one successful AF or a partial AF should be allowed to complete normally
	-- and not be marked Unpicked.
IF @i_operationType = 1
SET @tempFlag = 64
ELSE IF @i_operationType =  2
SET @tempFlag = 134217728
    insert into #PartialJobs (JobId, CommCellId)
	select distinct A.jobId, A.CommCellId from archFile A with (nolock)
	inner join 	#tblAFC T
	on
		T.jobId = A.jobId and T.commCellId = A.commCellId
	where
A.archGroupId = @i_archGroupId and ((@i_operationType = 1 AND ((af.flags & 64 /*CVA_AF_CI_SUCCESS_FLAG*/) > 0 OR (af.flags & 32 /*CVA_AF_CI_PARTIAL_FLAG*/) > 0))
OR (@i_operationType = 2 AND ((af.flags & 33554432 /*CVA_AF_EE_SUCCESS_FLAG*/) > 0 OR (af.flags & 134217728 /*CVA_AF_EE_PARTIAL_FLAG*/) > 0)))
	--
update archFile set flags = A.flags & (~496)
	output
		inserted.id, inserted.commCellId
	into #AffectedArchFileIds
	from 	archFile a with (nolock)
	inner join 	#tblAFC ta
	on
		ta.archFileId = a.id and ta.commCellId = a.commCellId
	inner join
		JMBkpStats j with (nolock)
	on
		j.jobId = a.jobId and j.commCellId = a.commCellId
	inner join #AppIds app
	on
		app.Id = a.appId and app.CommCellId = a.commCellId
	left outer join #PartialJobs pj
	on
		pj.JobId = a.jobId and pj.CommCellId = a.CommCellId
	where
		a.flags & 16 <> 0 and a.filetype = 1
		and
		j.bkpLevel in (0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
		and
		(
			a.jobId < app.LatestSFJobId
			or
			(
				app.RecentSFJobTime > 0 and DATEDIFF(DAY, dbo.getdatetime(app.RecentSFJobTime), dbo.getdatetime(app.LatestSFJobTime)) < @sfIntervalDays
			)
		)
		and
		pj.JobId IS NULL
	--
	--
	delete #tblAFC from #tblAFC afc inner join #AffectedArchFileIds a on a.ArchFileId = afc.archFileId and a.CommCellId = afc.commCellId
	--
	if OBJECT_ID('tempdb..#AppIds') is not null drop table #AppIds
end
--
IF NOT EXISTS (SELECT 1 FROM #tblAFC)
BEGIN
SET @retVal = 63
	GOTO FINISH
END
--
UPDATE	archFile SET flags = (flags & (~496))
FROM	archFile AF, (SELECT archFileId, commCellId FROM #tblAFC WHERE lastChunkNumber = 0) T
WHERE	AF.id = T.archFileId AND AF.commCellId = T.commCellId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Filter out Silo subclients
DELETE	#tblAFC
FROM	archGroupCopy C WITH (NOLOCK)
WHERE	appId = C.siloAppId AND C.archGroupId = @i_archGroupId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--Delete all the chunks on transitive copy
DELETE	#tblAFC
FROM	#tblAFC AFC, archGroupCopy AGC WITH (NOLOCK)
WHERE	AFC.archCopyId = AGC.id
		AND	AGC.type = 5 -- KEEP only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Check if Content Indexing Enabled at client level.
-- TO DO: Check if there is a valid Content Indexing license for each client.
INSERT INTO #tblAPP
SELECT	APP.id, APP.appTypeId, APP.clientId, 0
FROM	(SELECT DISTINCT appId FROM #tblAFC) AFC,
		APP_Application APP WITH (NOLOCK), #CI_Client CL WITH (NOLOCK)
WHERE	APP.id = AFC.appId
	AND CL.clientId = APP.clientId
    and APP.subclientName not in ('IndexBackUp','DDBBackup')
-- remove arch files for omitted sub clients
DELETE FROM #tblAFC WHERE appId NOT IN (SELECT appId FROM #tblAPP )
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Remove encrypted archive files which need user pass phrase for decrypting the key
INSERT	INTO @tblClient
SELECT	DISTINCT clientId, 0
FROM	#tblAFC AFC, #tblAPP APP
WHERE	AFC.encKeyType > 0 AND (AFC.encRSA & 1) > 0
	AND AFC.appId = APP.appId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
UPDATE	@tblClient
SET		needPassPhrase = CONVERT(int, b.attrVal)
FROM	@tblClient a, APP_ClientProp b
WHERE	b.ComponentNameId = a.clientId
	AND b.attrName = N'Encrypt: restoreAccess'
	AND b.modified = 0
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
DELETE	#tblAFC
FROM	#tblAFC AFC, #tblAPP APP, @tblClient CL
WHERE	AFC.encKeyType > 0 AND (AFC.encRSA & 1) > 0
	AND AFC.appId = APP.appId
	AND APP.clientId = CL.clientId
	AND CL.needPassPhrase = 1
IF @@ROWCOUNT  > 0
SET @skippedAFs = 140
IF NOT EXISTS (SELECT * FROM #tblAFC)
BEGIN
SET @retVal = 139
	GOTO FINISH
END
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Erase Migrated Data has been done for the subclient
UPDATE	#tblAPP SET hasErasedData = 2
FROM	#tblAPP APP, archFile AF WITH (NOLOCK)
WHERE	AF.appId = APP.appId
AND AF.fileType = 34
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Erase Backup Data has been done for the client & apptype
UPDATE	#tblAPP SET hasErasedData = 2
FROM	#tblAPP T,
		(SELECT	DISTINCT A.clientId, A.appTypeId
		FROM	archFile AF WITH (NOLOCK), APP_Application A WITH (NOLOCK)
WHERE	AF.archGroupId = @i_archGroupId AND AF.fileType = 5 AND AF.AppId = A.id) B
WHERE	T.clientId = B.clientId AND T.appTypeId = B.appTypeId
AND T.hasErasedData != 2
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
INSERT INTO #tblAFChunk
SELECT	ACM.chunkCommCellId, ACM.archChunkId, ACM.commCellId,  ACM.archFileId, ACM.archCopyId, ACM.chunkNumber,
		ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize,
		AC.fileMarkerNo, AC.createTime, AC.version, AC.physicalSize, AC.logicalSize, AC.hwEncKey,
		V.volumeId, V.mediaId, V.mediaGroupId, V.RecordingFormatId
FROM	#tblAFC AFC, archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
WHERE	ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = AFC.archCopyId
	AND ACM.physicalSize > 0 AND AFC.lastChunkNumber > 0
	AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
	AND V.volumeId = AC.volumeId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	#tblAFChunk R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.MediaId = M.MediaId
		AND R.chunkHwEncKey = ''
		AND M.MediaTypeId != 10001
		AND R.ArchChunkId = chunk.Id
		AND	R.acCommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
IF @i_srcCopyId = 0
BEGIN
	-- Prefer non-encrypted archive files
	DELETE	#tblAFC
	FROM	#tblAFC a,
			(SELECT archFileId, commCellId FROM #tblAFC WHERE encKeyType = 0) b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.encKeyType <> 0
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#tblAFC
	SET		isMag = 1
	FROM	#tblAFC AFC,
			(SELECT DISTINCT archFileId, afCommCellId, archCopyId FROM #tblAFChunk WHERE RecordingFormatId = 10001) ACM
	WHERE	ACM.archFileId = AFC.archFileId AND ACM.afCommCellId = AFC.commCellId AND ACM.archCopyId = AFC.archCopyId
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	-- Prefer magnetic archive files
	DELETE	#tblAFC
	FROM	#tblAFC a,
			(SELECT archFileId, commCellId FROM #tblAFC WHERE isMag = 1) b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.isMag = 0
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#tblAFC
	SET		copyPrec = AGC.copy
	FROM	#tblAFC AFC, archGroupCopy AGC WITH (NOLOCK)
	WHERE	AFC.archCopyId = AGC.id
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	-- Apply copy precedence
	DELETE	#tblAFC
	FROM	#tblAFC a,
			(SELECT archFileId, commCellId, MIN(copyPrec) AS copyPrec FROM #tblAFC GROUP BY archFileId, commCellId) b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.copyPrec > b.copyPrec
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
UPDATE	#tblAFC
SET		backupStartTime = BKP.servStartDate,
		backupEndTime = A.cTime,
		fullCycleNum = BKP.fullCycleNum,
		BkpLevel = BKP.BkpLevel
FROM	#tblAFC AFC, JMBkpStats BKP WITH (NOLOCK),
		(SELECT AF.jobId, AF.commCellId, MAX(AF.cTime)as cTime FROM archFile AF WITH (NOLOCK), #tblAFC T
WHERE AF.jobId = T.jobId AND AF.commCellId = T.commCellId AND AF.fileType = 2 and AF.isValid = 1
		GROUP BY AF.jobId, AF.commCellId) A
WHERE	BKP.jobId = AFC.jobId AND BKP.commCellId = AFC.commCellId
	AND A.jobId = AFC.jobId AND A.commCellId = AFC.commCellId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--EDGE backup job does not have rows for fileType= CVA_DATATYPE_INDEX into archfile table
UPDATE	#tblAFC
	SET		backupStartTime = BKP.servStartDate,
			backupEndTime = A.cTime,
			fullCycleNum = BKP.fullCycleNum,
			BkpLevel = BKP.BkpLevel
	FROM	#tblAFC AFC, JMBkpStats BKP WITH (NOLOCK),
			(SELECT AF.jobId, AF.commCellId, MAX(AF.cTime)as cTime FROM archFile AF WITH (NOLOCK), #tblAFC T
WHERE AF.jobId = T.jobId AND AF.commCellId = T.commCellId AND AF.fileType = 1 and AF.isValid = 1 AND AF.flags & (32768|2097152) <> 0
			GROUP BY AF.jobId, AF.commCellId) A
	WHERE	BKP.jobId = AFC.jobId AND BKP.commCellId = AFC.commCellId
		AND A.jobId = AFC.jobId AND A.commCellId = AFC.commCellId
		AND AFC.BkpLevel IS NULL
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--Legal Hold  backup job does not have entry into jmbkpstats table but in jmadminjobstatstable
UPDATE	#tblAFC
	SET		backupStartTime = AJ.servStart,
			backupEndTime = AJ.servEnd,
			fullCycleNum = AJ.fullCycleNum,
			BkpLevel = AJ.ER_BkpLevel
	FROM	#tblAFC AFC, JMAdminJobStatsTable AJ WITH (NOLOCK)
	WHERE	AJ.jobId = AFC.jobId AND AJ.commCellId = AFC.commCellId
		AND AJ.optype = 64 AND AJ.archGrpId > 0   --INFOMGMT =64
		AND AFC.BkpLevel IS NULL
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--MR 149937:  Defer CI by Specific Number of Days' is not honored
DELETE #tblAFC
FROM  #tblAFC	AFC
WHERE  (dbo.GetUnixTime( GETUTCDATE()) - AFC.backupEndTime) < (@defferedDays *60*60*24)
--
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--MR 143823: CI option 'Skip jobs that failed verification'
DELETE  #tblAFC
FROM    #tblAFC AFC LEFT JOIN JMJobDataStats J WITH (NOLOCK)
     ON  J.jobId = AFC.jobId AND J.commCellId = AFC.commCellId
AND J.archGrpCopyId = AFC.archCopyId AND J.dataType = 1
    AND (@l_ignoreDVFailedJobs = 0 OR J.archCheckStatus != 6/*ACS_FAILED */)
WHERE   J.jobId IS NULL
--
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--
IF object_id('tempdb.dbo.#syntheticFullJobsId') IS NOT NULL DROP TABLE #syntheticFullJobsId
create table #syntheticFullJobsId -- synthfull jobs which will be treated as full jobs
(
	jobId int,
    commCellId int,
	appId int,
	Primary key (jobId, commCellId, appId)
)
--
declare @ciTurboOption bit = 1
--
if (@isSolrCloud = 0)
begin
	set @ciTurboOption = 0
end
else if exists (select 1 from GXGlobalParam (NOLOCK) where name = N'Content Indexing Turbo Option' and value = N'0')
begin
	set @ciTurboOption = 0
end
--
--
if (@ciTurboOption = 1)
begin
	-- Assume all synthfull need to be flagged as fulls. Keep deleting rows which
	-- don't match the actual condition.
	insert into #syntheticFullJobsId(jobId, appId, commCellId)
	select
		distinct afc.jobId, afc.appId, afc.commCellId
	from #tblAFC afc
	where
		afc.bkpLevel in (0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
	--
	-- Remove all synthfull jobs which executed after any full for a subclient
	delete from #syntheticFullJobsId from #syntheticFullJobsId d
	where exists (
	select
		afc.appId
	from 	#tblAFC afc
	where
		afc.bkpLevel = 0x1 /*FULL*/
		and afc.appId = d.appId
		and afc.jobId < d.jobId
		and afc.commCellId = d.commCellId
	)
    --
	-- Keep only the oldest synthfull if more than one synthfull is present for each subclient
    delete from #syntheticFullJobsId
	from #syntheticFullJobsId d
	inner join
	(
		select
			appId, CommCellId, min(jobId) as jobId
		from	#syntheticFullJobsId
		group by
			appId, CommCellId
	) T
	on
		d.appId = T.appId
		and d.CommCellId = T.CommCellId
	where
		d.JobID <> T.jobId
	IF object_id('tempdb.dbo.#SubclientInfo') IS NOT NULL DROP TABLE #SubclientInfo
	-- Remove all entries where the subclient has previously done a successful CI on a Synth Full or Full
	create table #SubclientInfo
	(
		AppId int,
		CommCellId int,
		JobId int,
		primary key(AppId, CommCellId, JobId)
	)
	--
IF @i_operationType = 1
SET @tempFlag = 64
ELSE IF @i_operationType =  2
SET @tempFlag = 33554432
	insert into #SubclientInfo(AppId, CommCellId, JobId)
	select a.appId, a.commCellId, a.jobId from (SELECT DISTINCT appId, commcellId FROM #tblAFC) afc
	inner join archFile a with (nolock) on a.appId = afc.appId and a.commCellId = afc.commCellId and a.fileType = 1
	inner join JMBkpStats j with (nolock) on j.jobId = a.jobId and j.commCellId = a.commCellId
	where j.bkpLevel in (0x1 /*FULL*/, 0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
	and a.cloudId = @cloudId
	group by a.appId, a.commCellId, a.jobId
	having min(a.flags) & @tempFlag <> 0 and max(a.flags) & @tempFlag <> 0
	--
	delete from #syntheticFullJobsId from #syntheticFullJobsId d
	where exists
	(
		select appId from #SubclientInfo sci where sci.AppId = d.appId and sci.CommCellId = d.commCellId and sci.JobId < d.jobId
	)
	-- There may be older jobs which are now in aged table because of which we still need to
	-- treat the current SF job as af-core and not a full. Since the system was never designed for this,
	-- and there isn't enough information to conclusively find this out, we will best guess this.
	IF object_id('tempdb.dbo.#SynthfullMinAF') IS NOT NULL DROP TABLE #SynthfullMinAF
	create table #SynthfullMinAF
	(
		AppId int primary key,
		MinArchFileId int
	)
	--
	insert into #SynthfullMinAF(AppId, MinArchFileId)
	select
		SF.AppId, min(AF.archFileId)
	from #syntheticFullJobsId SF
	inner join	#tblAFC AF on AF.jobId =  SF.jobId and AF.commCellId = SF.commCellId
	group by
		SF.appId
	--
	delete from #syntheticFullJobsId from #syntheticFullJobsId SF
	inner join	#SynthfullMinAF SFM
	on
		SFM.AppId = SF.appId
	where exists
	(
		select TOP 1 1 from archContentIndexingAged AGED (NOLOCK)  where AGED.appId = SF.appId and AGED.commCellId = SF.commCellId and
		AGED.cloudId = @cloudId and AGED.archFileId < SFM.MinArchFileId
	)
end
--
BEGIN TRY
	BEGIN TRANSACTION
	if (@ciTurboOption = 1)
	begin
		declare @secondaryCIEnabled bit
		--
		if exists (select TOP 1 1 from GXGlobalParam where name = N'Enable secondary content indexing' and value = N'1' and modified = 0)
			--MR 148113 Enable Secondary Content Indexing should be OFF on V10  or older search engines which are not upgraded to V11.
			AND NOT EXISTS (SELECT TOP 1 1 FROM  APP_CLIENT C WITH (NOLOCK)
							INNER JOIN  DM2SearchServerCoreInfo S WITH (NOLOCK) ON C.id = S.ClientId AND S.CloudId = @cloudId
							WHERE C.RELEASEID <16)
			set @secondaryCIEnabled = 1
		else
			set @secondaryCIEnabled = 0
		--
		if @secondaryCIEnabled = 0
		begin
		INSERT	INTO
			archContentIndexingAF
		SELECT
			@i_archGroupId, 0, 0, AFC.appId, AFC.fullCycleNum,
			AFC.jobId, AFC.backupStartTime, AFC.backupEndTime, ACM.archChunkId, AFC.archFileId, AFC.commCellId,
			AFC.archCopyId, AFC.streamNum, AFC.encKeyType, AFC.flags, AFC.lastChunkNumber,
			ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize,
			ACM.volumeId, ACM.mediaId, ACM.mediaGroupId,
			ACM.fileMarkerNo, ACM.chunkCreateTime, ACM.chunkVersion, ACM.chunkPhysicalSize, ACM.chunkLogicalSize, ACM.chunkHwEncKey,
			/*APP.hasErasedData |*/ (case when AFC.bkpLevel in( 0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/) and AFC.jobId not in (select jobId from #syntheticFullJobsId) then 8 /*CVA_AUXCOPY_SYNTHFULL_JOB_FLAG*/ else 0 end),
			0, @i_operationType
		FROM #tblAFC AFC
		INNER JOIN 	#tblAFChunk ACM
		ON
			ACM.archFileId = AFC.archFileId
			AND ACM.afCommCellId = AFC.commCellId
			AND ACM.archCopyId = AFC.archCopyId
		WHERE
			(@i_endBefore = 0 OR AFC.backupEndTime <= @i_endBefore)
			AND (@i_srcStream = 0 OR AFC.streamNum = @i_srcStream)
		end
		else begin
			INSERT	INTO
				archContentIndexingAF
			SELECT
				@i_archGroupId, 0, 0, AFC.appId, AFC.fullCycleNum,
				AFC.jobId, AFC.backupStartTime, AFC.backupEndTime, ACM.archChunkId, AFC.archFileId, AFC.commCellId,
				AFC.archCopyId, AFC.streamNum, AFC.encKeyType, AFC.flags, AFC.lastChunkNumber,
				ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize,
				ACM.volumeId, ACM.mediaId, ACM.mediaGroupId,
				ACM.fileMarkerNo, ACM.chunkCreateTime, ACM.chunkVersion, ACM.chunkPhysicalSize, ACM.chunkLogicalSize, ACM.chunkHwEncKey,
				0, 0, @i_operationType
			FROM 	#tblAFC AFC
			INNER JOIN		#tblAFChunk ACM
			ON
				ACM.archFileId = AFC.archFileId
				AND ACM.afCommCellId = AFC.commCellId
				AND ACM.archCopyId = AFC.archCopyId
			WHERE
				(@i_endBefore = 0 OR AFC.backupEndTime <= @i_endBefore)
				AND (@i_srcStream = 0 OR AFC.streamNum = @i_srcStream)
				AND -- filter out secondary CI records
				(
					AFC.bkpLevel not in( 0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
					or
					AFC.jobId in (select jobId from #syntheticFullJobsId)
				)
			--
			-- Insert eligible records for synthfull processed for secondary CI
			--
			insert into archContentIndexingSecondary (ArchFileId, CommCellId, AppId, CIJobId, StartTime, EndTime, BackupJobId)
			select
				AFC.archFileId, AFC.commCellId, AFC.appId, @i_CIJobId, AFC.backupStartTime, AFC.backupEndTime, AFC.jobId
			from #tblAFC AFC
			inner join
			(
				select distinct archFileId, afCommCellId from #tblAFChunk
			) ACM
			on
				ACM.archFileId = AFC.archFileId AND ACM.afCommCellId = AFC.commCellId
			INNER JOIN 	#tblAPP APP
			ON
				AFC.appId = APP.appId
			where
			(
				AFC.bkpLevel in( 0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
				and AFC.jobId not in (select jobId from #syntheticFullJobsId)
				and not exists (select archFileId from archContentIndexingSecondary S where S.ArchFileId = AFC.archFileId and S.CommCellId = AFC.commCellId)
			)
			--
			if @@ROWCOUNT > 0 SET @secondaryCIPresent = 1
		end
	end
	else
	begin
		INSERT	INTO archContentIndexingAF
		SELECT
			@i_archGroupId, 0, 0, AFC.appId, AFC.fullCycleNum,
			AFC.jobId, AFC.backupStartTime, AFC.backupEndTime, ACM.archChunkId, AFC.archFileId, AFC.commCellId,
			AFC.archCopyId, AFC.streamNum, AFC.encKeyType, AFC.flags, AFC.lastChunkNumber,
			ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize,
			ACM.volumeId, ACM.mediaId, ACM.mediaGroupId,
			ACM.fileMarkerNo, ACM.chunkCreateTime, ACM.chunkVersion, ACM.chunkPhysicalSize, ACM.chunkLogicalSize, ACM.chunkHwEncKey,
			0,
			0,
			@i_operationType
		FROM	#tblAFC AFC
		INNER JOIN 	#tblAFChunk ACM
		ON
			ACM.archFileId = AFC.archFileId
			AND ACM.afCommCellId = AFC.commCellId
			AND ACM.archCopyId = AFC.archCopyId
		WHERE
			(@i_endBefore = 0 OR AFC.backupEndTime <= @i_endBefore)
			AND (@i_srcStream = 0 OR AFC.streamNum = @i_srcStream)
	end
	UPDATE	AF
	SET		clientId = APP.clientId, appType = APP.appTypeId, extraFlags = extraFlags | APP.hasErasedData
	FROM	archContentIndexingAF AF, #tblAPP APP
	WHERE	AF.archGroupId = @i_archGroupId
			AND AF.appId = APP.appId
            AND AF.operationType = @i_operationType
	--
	-- Redo content indexing for partially content indexed AFs when cloudId is changed
IF @i_operationType = 1
    BEGIN
    DELETE	archContentIndexingRestart
	    --WHERE	archGroupId = @i_archGroupId AND cloudId <> @cloudId AND operationType = @i_operationType AND dataSourceId = @i_dataSourceId
        WHERE	archGroupId = @i_archGroupId AND cloudId <> @cloudId AND operationType = @i_operationType
    end
	-- Fix for MRs: 92171 & 85223
	-- Repopulation of skipped/failed chunks within an archive file in a CI job's iteration seems to make AuxCopy/CIReader on MA read wrong offset.
	-- Fix here is that we skip repopulating chunks from failed archive files. MRs description may not reflect the expected fix that we have here.
	IF	(@i_srcStream > 0 )
	BEGIN
		DECLARE @timeval_t int
		SELECT TOP 1 @timeval_t = endTime FROM JMAdminJobAttemptInfoTable (NOLOCK) WHERE jobId = @i_CIJobId ORDER BY attemptNum DESC
		IF @timeval_t IS NULL
		BEGIN
			SELECT @timeval_t = jobStartTime FROM JMJobInfo (NOLOCK) WHERE jobId = @i_CIJobId
		END
		IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..archContentIndexingAFHistory') IS NOT NULL)
		BEGIN
			DELETE	archContentIndexingAF
			FROM	(SELECT DISTINCT archGroupId,archFileId,commCellId
					 FROM	HistoryDB..archContentIndexingAFHistory (NOLOCK)
					 WHERE	modifiedTime > @timeval_t ) T
			WHERE
					archContentIndexingAF.archGroupId = @i_archGroupId
					AND archContentIndexingAF.archGroupId = T.archGroupId
					AND archContentIndexingAF.archFileId = T.archFileId
					AND archContentIndexingAF.commCellId = T.commCellId
					AND archContentIndexingAF.streamNum = @i_srcStream
					AND archContentIndexingAF.operationType = @i_operationType
			IF @@ROWCOUNT  > 0
			BEGIN
				SET @skippedPartialAFs = 1
			END
		END
	END
	-- Delete chunks in which contents have been indexed
	DELETE	archContentIndexingAF
	FROM	archContentIndexingAF AF, archContentIndexingRestart R (NOLOCK)
	WHERE	AF.archGroupId = @i_archGroupId AND AF.archFileId = R.archFileId AND AF.commCellId = R.commCellId AND AF.operationType = @i_operationType
AND (R.status = 2 OR
((AF.appType <> 13 AND ((AF.physicalOffset + AF.physicalSize) < R.physicalOffset)) OR
(AF.appType = 13 AND ((AF.logicalOffset + AF.logicalSize) < R.physicalOffset))))
	--
	-- Remove dangling archContentIndexingRestart entries.
IF	@i_srcStream = 0 AND @i_operationType = 1
		DELETE	archContentIndexingRestart FROM	archContentIndexingRestart R LEFT OUTER JOIN archContentIndexingAF AF (NOLOCK)
		ON	AF.archFileId = R.archFileId AND AF.commCellId = R.commCellId
        AND AF.operationType = R.operationType
		LEFT OUTER JOIN #EdgeArchiveFiles k ON k.ArchFileId = R.ArchFileId and k.CommCellId = R.CommCellId and (k.NewChunkPresent = 1 or k.NewAFOnStream = 0) -- For Edge
WHERE	R.archGroupId = @i_archGroupId AND R.status <> 2 AND AF.archFileId IS NULL
		AND k.ArchFileId IS NULL -- Added for Edge
        AND R.operationType = @i_operationType
	--
	UPDATE	archContentIndexingRestart
SET		flags = (R.flags & ~1),
			modifiedTime = dbo.GetUnixTime(GETUTCDATE())
	FROM	archContentIndexingAF AF (NOLOCK), archContentIndexingRestart R (NOLOCK)
	WHERE	AF.archGroupId = @i_archGroupId AND AF.archFileId = R.archFileId AND AF.commCellId = R.commCellId AND AF.operationType = @i_operationType
		AND (@i_srcStream = 0 OR AF.streamNum = @i_srcStream)
AND (R.flags & 1) <> 0
	--
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = ERROR_NUMBER()
	ROLLBACK TRANSACTION
END	CATCH
FINISH:
IF @retVal = 0
BEGIN
    IF @skippedPartialAFs = 1
SET @retVal = 127
ELSE IF @skippedAFs = 140
SET @retVal = 140
END
IF object_id('tempdb.dbo.#tblAPP') IS NOT NULL DROP TABLE #tblAPP
IF object_id('tempdb.dbo.#tblAFC') IS NOT NULL DROP TABLE #tblAFC
IF object_id('tempdb.dbo.#tblAFChunk') IS NOT NULL DROP TABLE #tblAFChunk
IF object_id('tempdb.dbo.#tblCopyMA') IS NOT NULL DROP TABLE #tblCopyMA
IF OBJECT_ID('tempdb..#tblJobTimes') IS NOT NULL drop table #tblJobTimes
IF OBJECT_ID('tempdb..#AffectedArchFileIds') IS NOT NULL drop table #AffectedArchFileIds
if OBJECT_ID('tempdb..#PartialJobs') is not null drop table #PartialJobs
if object_id('tempdb..#EdgeArchiveFiles') is not null drop table #EdgeArchiveFiles
IF object_id('tempdb.dbo.#syntheticFullJobsId') IS NOT NULL DROP TABLE #syntheticFullJobsId
IF object_id('tempdb.dbo.#SubclientInfo') IS NOT NULL DROP TABLE #SubclientInfo
IF object_id('tempdb.dbo.#SynthfullMinAF') IS NOT NULL DROP TABLE #SynthfullMinAF
SELECT @retVal, @secondaryCIPresent
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingInsertByOperationType')
	delete from GxQscripts where name = 'archContentIndexingInsertByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingInsertByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingInsertByOperationType'
GO

insert into GXDBVersions values(2, 'archContentIndexingInsertByOperationType',  '00010001000400130000', 'archContentIndexingInsertByOperationType', '00010001000400130000')
GO

