

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingGetNextByOperationType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingGetNextByOperationType.sp,v $ $Id: archContentIndexingGetNextByOperationType.sp,v 1.1.4.2 2018/05/11 22:35:20 bkharabe Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingGetNextByOperationType <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingGetNextByOperationType')
	drop procedure archContentIndexingGetNextByOperationType
IF EXISTS (select * from GxQscripts where name='archContentIndexingGetNextByOperationType')
	delete from GxQscripts where name = 'archContentIndexingGetNextByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingGetNextByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingGetNextByOperationType'
GO
print '... Creating Procedure: archContentIndexingGetNextByOperationType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingGetNextByOperationType
  @i_archCopyId int,
  @i_streamNum int,
  @i_volumeId int,
  @i_numOfChunks int,
  @i_operationType int
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_encType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_chunkHwEncKey varchar(2048);
  DECLARE @o_extraFlags integer;
  DECLARE @o_startPhysicalOffset bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblNextChunks	TABLE (archChunkId bigint, commCellId int)
DECLARE @tblAFChunk TABLE
(
	archGroupId			integer,
	clientId			integer,
	appType				integer,
	appId				integer,
	fullCycleNum		integer,
	backupJobId			integer,
	backupStartTime		integer,
	backupEndTime		integer,
	archChunkId			bigint,
	archFileId			integer,
	commCellId			integer,
	archCopyId			integer,
	streamNum			integer,
	encKeyType			integer,
	archFileCopyFlags	integer,
	lastChunkNumber		integer,
	chunkNumber			integer,
	physicalOffset		bigint,
	logicalOffset		bigint,
	physicalSize		bigint,
	logicalSize			bigint,
	volumeId			integer,
	mediaId				integer,
	mediaGroupId		integer,
	fileMarkerNo		integer,
	chunkCreateTime		integer,
	chunkVersion		integer,
	chunkPhysicalSize	bigint,
	chunkLogicalSize	bigint,
chunkHwEncKey		varchar(2048),
	extraFlags			integer,
	segmentId			integer,
    operationType       integer,
	primary key (archChunkId, archFileId, commCellId)
)
DECLARE	@l_error	INT
DECLARE	@l_rowcount	INT
DECLARE	@l_nAFChunk	INT
declare @SolrCloud table
(
	cloudId int primary key
)
insert into @SolrCloud(cloudId)
select componentId from APP_ComponentProp where propertyTypeId = 1014
and componentType = 2 and stringVal not in (N'4.3', N'5.1.5')
-- FIX MR 88825 Infinite Loop Fix.
DELETE
	archContentIndexingAF
FROM
	archContentIndexingAged CIA
INNER JOIN
	@SolrCloud CP
ON
	CP.cloudId = CIA.cloudId
WHERE
	CIA.appId = archContentIndexingAF.appId
	AND CIA.commCellId = archContentIndexingAF.commCellId
	AND CIA.archFileId = archContentIndexingAF.archFileId
    AND CIA.operationType = @i_operationType
--
INSERT	INTO @tblAFChunk
SELECT	*
FROM	archContentIndexingAF WITH (NOLOCK)
WHERE	volumeId = @i_volumeId
AND		archCopyId = @i_archCopyId
AND		streamNum = @i_streamNum
AND     operationType = @i_operationType
--
DELETE	@tblAFChunk
FROM	@tblAFChunk a, archContentIndexingAF b WITH (NOLOCK)
WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId
	AND a.volumeId <> b.volumeId AND a.chunkNumber > b.chunkNumber
--
INSERT	INTO @tblNextChunks
SELECT	DISTINCT TOP(@i_numOfChunks) archChunkId, commCellId
FROM	@tblAFChunk
ORDER BY archChunkId
IF @@ERROR = 0 AND @@ROWCOUNT > 0
BEGIN
	SELECT	a.appId, a.appType, a.clientId, a.fullCycleNum, a.backupJobId, a.backupStartTime, a.backupEndTime,
			a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
a.streamNum, 1, a.archFileCopyFlags, a.encKeyType, a.lastChunkNumber,
			a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
			a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
			a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags,
			ISNULL((SELECT	physicalOffset FROM archContentIndexingRestart
					WHERE	archFileId = a.archFileId AND commCellId = a.commCellId AND operationType = @i_operationType), a.physicalOffset)
	FROM	@tblNextChunks b, archContentIndexingAF a
	WHERE	a.archChunkId = b.archChunkId AND a.commCellId = b.commCellId AND a.operationType = @i_operationType
	ORDER BY a.archChunkId, a.archFileId
	DELETE	archContentIndexingAF
	FROM	@tblNextChunks b, archContentIndexingAF a
	WHERE	a.archChunkId = b.archChunkId AND a.commCellId = b.commCellId AND a.operationType = @i_operationType
END
ELSE
BEGIN
	SELECT
		TOP 1 a.appId, a.appType, a.clientId, a.fullCycleNum, a.backupJobId, a.backupStartTime, a.backupEndTime,
		a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
a.streamNum, 1, a.archFileCopyFlags, a.encKeyType, a.lastChunkNumber,
		a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
		a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
		a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags, -1
	FROM
		archContentIndexingAF a WITH (NOLOCK)
	WHERE
		a.volumeId = @i_volumeId
		AND		a.archCopyId = @i_archCopyId
		AND		a.streamNum = @i_streamNum
        AND     a.operationType = @i_operationType
	ORDER BY
		a.archChunkId, a.archFileId
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingGetNextByOperationType')
	delete from GxQscripts where name = 'archContentIndexingGetNextByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingGetNextByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingGetNextByOperationType'
GO

insert into GXDBVersions values(2, 'archContentIndexingGetNextByOperationType',  '00010001000400020000', 'archContentIndexingGetNextByOperationType', '00010001000400020000')
GO

