

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingGetNext.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingGetNext.sp,v $ $Id: archContentIndexingGetNext.sp,v 1.20.88.6 2018/03/22 00:58:25 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingGetNext <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingGetNext')
	drop procedure archContentIndexingGetNext
IF EXISTS (select * from GxQscripts where name='archContentIndexingGetNext')
	delete from GxQscripts where name = 'archContentIndexingGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingGetNext')
	delete from GXDBVersions where aliasname = 'archContentIndexingGetNext'
GO
print '... Creating Procedure: archContentIndexingGetNext'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingGetNext
  @i_archCopyId int,
  @i_streamNum int,
  @i_volumeId int,
  @i_numOfChunks int
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_encType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_chunkHwEncKey varchar(2048);
  DECLARE @o_extraFlags integer;
  DECLARE @o_startPhysicalOffset bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblNextChunks	TABLE (archChunkId bigint, commCellId int)
DECLARE @tblAFChunk TABLE
(
	archGroupId			integer,
	clientId			integer,
	appType				integer,
	appId				integer,
	fullCycleNum		integer,
	backupJobId			integer,
	backupStartTime		integer,
	backupEndTime		integer,
	archChunkId			bigint,
	archFileId			integer,
	commCellId			integer,
	archCopyId			integer,
	streamNum			integer,
	encKeyType			integer,
	archFileCopyFlags	integer,
	lastChunkNumber		integer,
	chunkNumber			integer,
	physicalOffset		bigint,
	logicalOffset		bigint,
	physicalSize		bigint,
	logicalSize			bigint,
	volumeId			integer,
	mediaId				integer,
	mediaGroupId		integer,
	fileMarkerNo		integer,
	chunkCreateTime		integer,
	chunkVersion		integer,
	chunkPhysicalSize	bigint,
	chunkLogicalSize	bigint,
chunkHwEncKey		varchar(2048),
	extraFlags			integer,
	segmentId			integer,
    operationType       integer,
	primary key (archChunkId, archFileId, commCellId)
)
DECLARE	@l_error	INT
DECLARE	@l_rowcount	INT
DECLARE	@l_nAFChunk	INT
declare @SolrCloud table
(
	cloudId int primary key
)
insert into @SolrCloud(cloudId)
select componentId from APP_ComponentProp where propertyTypeId = 1014
and componentType = 2 and stringVal not in (N'4.3', N'5.1.5')
-- FIX MR 88825 Infinite Loop Fix.
DELETE
	archContentIndexingAF
FROM
	archContentIndexingAged CIA
INNER JOIN
	@SolrCloud CP
ON
	CP.cloudId = CIA.cloudId
WHERE
	CIA.appId = archContentIndexingAF.appId
	AND CIA.commCellId = archContentIndexingAF.commCellId
	AND CIA.archFileId = archContentIndexingAF.archFileId
AND CIA.operationType = 1 --only for classical ci jobs
--
INSERT	INTO @tblAFChunk
SELECT	*
FROM	archContentIndexingAF WITH (NOLOCK)
WHERE	volumeId = @i_volumeId
AND		archCopyId = @i_archCopyId
AND		streamNum = @i_streamNum
AND     operationType = 1 --only for classical ci jobs
--
DELETE	@tblAFChunk
FROM	@tblAFChunk a, archContentIndexingAF b WITH (NOLOCK)
WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId
	AND a.volumeId <> b.volumeId AND a.chunkNumber > b.chunkNumber
--
INSERT	INTO @tblNextChunks
SELECT	DISTINCT TOP(@i_numOfChunks) archChunkId, commCellId
FROM	@tblAFChunk
ORDER BY archChunkId
IF @@ERROR = 0 AND @@ROWCOUNT > 0
BEGIN
	SELECT	a.appId, a.appType, a.clientId, a.fullCycleNum, a.backupJobId, a.backupStartTime, a.backupEndTime,
			a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
a.streamNum, 1, a.archFileCopyFlags, a.encKeyType, a.lastChunkNumber,
			a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
			a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
			a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags,
			ISNULL((SELECT	physicalOffset FROM archContentIndexingRestart
WHERE	archFileId = a.archFileId AND commCellId = a.commCellId AND operationType = 1), a.physicalOffset)
	FROM	@tblNextChunks b, archContentIndexingAF a
WHERE	a.archChunkId = b.archChunkId AND a.commCellId = b.commCellId AND a.operationType = 1 --only for classical ci jobs
	ORDER BY a.archChunkId, a.archFileId
	DELETE	archContentIndexingAF
	FROM	@tblNextChunks b, archContentIndexingAF a
WHERE	a.archChunkId = b.archChunkId AND a.commCellId = b.commCellId AND a.operationType = 1 --only for classical ci jobs
END
ELSE
BEGIN
	SELECT
		TOP 1 a.appId, a.appType, a.clientId, a.fullCycleNum, a.backupJobId, a.backupStartTime, a.backupEndTime,
		a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
a.streamNum, 1, a.archFileCopyFlags, a.encKeyType, a.lastChunkNumber,
		a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
		a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
		a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags, -1
	FROM
		archContentIndexingAF a WITH (NOLOCK)
	WHERE
		a.volumeId = @i_volumeId
		AND		a.archCopyId = @i_archCopyId
		AND		a.streamNum = @i_streamNum
AND     a.operationType = 1 --only for classical ci jobs
	ORDER BY
		a.archChunkId, a.archFileId
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingGetNext')
	delete from GxQscripts where name = 'archContentIndexingGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingGetNext')
	delete from GXDBVersions where aliasname = 'archContentIndexingGetNext'
GO

insert into GXDBVersions values(2, 'archContentIndexingGetNext',  '00010020008800060000', 'archContentIndexingGetNext', '00010020008800060000')
GO

