

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingGetFirstByOperationType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingGetFirstByOperationType.sp,v $ $Id: archContentIndexingGetFirstByOperationType.sp,v 1.1.4.2 2018/05/11 22:35:33 bkharabe Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingGetFirstByOperationType <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingGetFirstByOperationType')
	drop procedure archContentIndexingGetFirstByOperationType
IF EXISTS (select * from GxQscripts where name='archContentIndexingGetFirstByOperationType')
	delete from GxQscripts where name = 'archContentIndexingGetFirstByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingGetFirstByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingGetFirstByOperationType'
GO
print '... Creating Procedure: archContentIndexingGetFirstByOperationType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingGetFirstByOperationType
  @i_archGroupId int,
  @i_copyId int,
  @i_stream int,
  @i_operationType int
AS
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_totalPhysicalSize bigint;
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tblDataSize') IS NOT NULL DROP TABLE #tblDataSize
 CREATE TABLE #tblDataSize (archCopyId int, streamNum int, mediaGroupId int, commCellId int, archChunkId bigint, physicalSize bigint,
							PRIMARY KEY (archCopyId, streamNum, mediaGroupId, commCellId))
 IF object_id('tempdb.dbo.#tblDataSizeAdjust') IS NOT NULL DROP TABLE #tblDataSizeAdjust
CREATE TABLE	#tblDataSizeAdjust	(archCopyId int, streamNum int, mediaGroupId int, commCellId int, physicalSize bigint ,
								PRIMARY KEY (archCopyId, streamNum, mediaGroupId, commCellId))
INSERT	INTO #tblDataSizeAdjust
SELECT	A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId, SUM(R.physicalOffset - A.physicalOffset)
FROM	archContentIndexingAF A (NOLOCK), archContentIndexingRestart R (NOLOCK)
WHERE	A.archGroupId = @i_archGroupId
	AND (@i_copyId = 0 OR A.archCopyId = @i_copyId)
	AND (@i_stream = 0 AND A.streamNum > 0 OR @i_stream > 0 AND @i_stream = A.streamNum)
	AND A.archFileId = R.archFileId AND A.commCellId = R.commCellId
	AND A.physicalOffset < R.physicalOffset AND (A.physicalOffset + A.physicalSize) >= R.physicalOffset
    AND A.operationType = @i_operationType
    AND R.operationType = @i_operationType
GROUP BY A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId
--
declare @SolrCloud table
(
	cloudId int primary key
)
--
insert into @SolrCloud(cloudId)
select componentId from APP_ComponentProp (NOLOCK) where propertyTypeId = 1014
and componentType = 2 and stringVal not in (N'4.3', N'5.1.5')
--
INSERT	INTO #tblDataSize
SELECT	archCopyId, streamNum, mediaGroupId, commCellId, MIN(archChunkId), SUM(physicalSize)
FROM	archContentIndexingAF (NOLOCK)
WHERE	archGroupId = @i_archGroupId
    AND operationType = @i_operationType
	AND (@i_copyId = 0 OR archCopyId = @i_copyId)
	AND (@i_stream = 0 AND streamNum > 0 OR @i_stream > 0 AND @i_stream = streamNum)
	AND
	(
		@i_stream = 0 OR  @i_stream > 0 AND NOT EXISTS
		(
			SELECT TOP 1 1 FROM archContentIndexingAged A (NOLOCK) INNER JOIN @SolrCloud CP ON CP.cloudId = A.cloudId
			WHERE ArchFileId = archContentIndexingAF.archFileId AND CommCellId = archContentIndexingAF.CommcellId AND AgedFlag = 0
            AND operationType = @i_operationType
		)
	)
GROUP BY archCopyId, streamNum, mediaGroupId, commCellId
UPDATE  a
SET	MediaGroupId = b.mediaGroupId
FROM	#tblDataSize a, ArchStream b with (NOLOCK)
WHERE	a.archCopyId = b.ArchGroupCopyId
AND		a.streamNum = b.stream
--AND	a.MediaGroupId = 0
UPDATE	#tblDataSize
SET		physicalSize = (A.physicalSize - B.physicalSize)
FROM	#tblDataSize A, #tblDataSizeAdjust B
WHERE	A.archCopyId = B.archCopyId AND A.streamNum = B.streamNum
SELECT	archCopyId, streamNum, mediaGroupId, commCellId, archChunkId, physicalSize
FROM	#tblDataSize
ORDER BY archCopyId, streamNum, mediaGroupId, commCellId
IF object_id('tempdb.dbo.#tblDataSize') IS NOT NULL DROP TABLE #tblDataSize
IF object_id('tempdb.dbo.#tblDataSizeAdjust') IS NOT NULL DROP TABLE #tblDataSizeAdjust
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingGetFirstByOperationType')
	delete from GxQscripts where name = 'archContentIndexingGetFirstByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingGetFirstByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingGetFirstByOperationType'
GO

insert into GXDBVersions values(2, 'archContentIndexingGetFirstByOperationType',  '00010001000400020000', 'archContentIndexingGetFirstByOperationType', '00010001000400020000')
GO

