

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingGetFirst.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingGetFirst.sp,v $ $Id: archContentIndexingGetFirst.sp,v 1.10.56.6 2020/03/30 17:02:06 pankajkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archContentIndexingGetFirst')
BEGIN
	print '>>> Drop Stored Procedure: archContentIndexingGetFirst <<<'
	drop procedure archContentIndexingGetFirst
END
IF EXISTS (select * from GxQscripts where name='archContentIndexingGetFirst')
	delete from GxQscripts where name = 'archContentIndexingGetFirst'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingGetFirst')
	delete from GXDBVersions where aliasname = 'archContentIndexingGetFirst'
GO
print '... Creating Procedure: archContentIndexingGetFirst'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingGetFirst
  @i_archGroupId int,
  @i_copyId int,
  @i_stream int
AS
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_totalPhysicalSize bigint;
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tblDataSize') IS NOT NULL DROP TABLE #tblDataSize
 CREATE TABLE #tblDataSize (archCopyId int, streamNum int, mediaGroupId int, commCellId int, archChunkId bigint, physicalSize bigint,
							PRIMARY KEY (archCopyId, streamNum, mediaGroupId, commCellId))
 IF object_id('tempdb.dbo.#tblDataSizeAdjust') IS NOT NULL DROP TABLE #tblDataSizeAdjust
CREATE TABLE	#tblDataSizeAdjust	(archCopyId int, streamNum int, mediaGroupId int, commCellId int, physicalSize bigint ,
								PRIMARY KEY (archCopyId, streamNum, mediaGroupId, commCellId))
INSERT	INTO #tblDataSizeAdjust
SELECT	A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId, SUM(R.physicalOffset - A.physicalOffset)
FROM	archContentIndexingAF A (NOLOCK), archContentIndexingRestart R (NOLOCK)
WHERE	A.archGroupId = @i_archGroupId
	AND (@i_copyId = 0 OR A.archCopyId = @i_copyId)
	AND (@i_stream = 0 AND A.streamNum > 0 OR @i_stream > 0 AND @i_stream = A.streamNum)
	AND A.archFileId = R.archFileId AND A.commCellId = R.commCellId
	AND A.physicalOffset < R.physicalOffset AND (A.physicalOffset + A.physicalSize) >= R.physicalOffset
AND A.operationType = 1 --only for classical ci jobs
AND R.operationType = 1 --only for classical ci jobs
GROUP BY A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId
--
declare @SolrCloud table
(
	cloudId int primary key
)
--
insert into @SolrCloud(cloudId)
select componentId from APP_ComponentProp (NOLOCK) where propertyTypeId = 1014
and componentType = 2 and stringVal not in (N'4.3', N'5.1.5')
--
INSERT	INTO #tblDataSize
SELECT	archCopyId, streamNum, mediaGroupId, commCellId, MIN(archChunkId), SUM(physicalSize)
FROM	archContentIndexingAF (NOLOCK)
WHERE	archGroupId = @i_archGroupId
AND operationType = 1 --only for classical ci jobs
	AND (@i_copyId = 0 OR archCopyId = @i_copyId)
	AND (@i_stream = 0 AND streamNum > 0 OR @i_stream > 0 AND @i_stream = streamNum)
	AND
	(
		@i_stream = 0 OR  @i_stream > 0 AND NOT EXISTS
		(
			SELECT TOP 1 1 FROM archContentIndexingAged A (NOLOCK) INNER JOIN @SolrCloud CP ON CP.cloudId = A.cloudId
			WHERE ArchFileId = archContentIndexingAF.archFileId AND CommCellId = archContentIndexingAF.CommcellId AND AgedFlag = 0
AND operationType = 1 --only for classical ci jobs
		)
	)
GROUP BY archCopyId, streamNum, mediaGroupId, commCellId
--prevent primary key violation
UPDATE  a
SET	MediaGroupId = b.mediaGroupId
FROM	#tblDataSize a, ArchStream b with (NOLOCK)
WHERE	a.archCopyId = b.ArchGroupCopyId
AND		a.streamNum = b.stream
AND		b.mediaGroupId NOT IN ( SELECT T.mediaGroupId FROM  #tblDataSize T  JOIN ArchStream S (NOLOCK) ON  T.archCopyId = S.ArchGroupCopyId and  T.streamNum = S.stream)
--AND	a.MediaGroupId = 0
UPDATE	#tblDataSize
SET		physicalSize = (A.physicalSize - B.physicalSize)
FROM	#tblDataSize A, #tblDataSizeAdjust B
WHERE	A.archCopyId = B.archCopyId AND A.streamNum = B.streamNum
SELECT	archCopyId, streamNum, mediaGroupId, commCellId, archChunkId, physicalSize
FROM	#tblDataSize
ORDER BY archCopyId, streamNum, mediaGroupId, commCellId
IF object_id('tempdb.dbo.#tblDataSize') IS NOT NULL DROP TABLE #tblDataSize
IF object_id('tempdb.dbo.#tblDataSizeAdjust') IS NOT NULL DROP TABLE #tblDataSizeAdjust
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingGetFirst')
	delete from GxQscripts where name = 'archContentIndexingGetFirst'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingGetFirst')
	delete from GXDBVersions where aliasname = 'archContentIndexingGetFirst'
GO

insert into GXDBVersions values(2, 'archContentIndexingGetFirst',  '00010010005600060000', 'archContentIndexingGetFirst', '00010010005600060000')
GO

