

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingClientsByOperationType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingClientsByOperationType.sp,v $ $Id: archContentIndexingClientsByOperationType.sp,v 1.1.4.7 2020/02/28 14:38:17 bkharabe Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archContentIndexingClientsByOperationType')
BEGIN
	print '>>> Drop Stored Procedure: archContentIndexingClientsByOperationType <<<'
	drop procedure archContentIndexingClientsByOperationType
END
IF EXISTS (select * from GxQscripts where name='archContentIndexingClientsByOperationType')
	delete from GxQscripts where name = 'archContentIndexingClientsByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingClientsByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingClientsByOperationType'
GO
print '... Creating Procedure: archContentIndexingClientsByOperationType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archContentIndexingClientsByOperationType
  @i_archGroupId integer,
  @i_operationType integer,
  @i_jobId integer
AS
  DECLARE @o_clientId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #APP(appId INT)
CREATE TABLE #CLIENT(clientId INT)
CREATE TABLE #JOBCLIENT(clientId INT)
DECLARE	@l_error		INT
DECLARE	@l_rowcount		INT
DECLARE	@l_now			INT
DECLARE	@l_enabled		INT
DECLARE	@l_startTime	INT
DECLARE @l_ciPropName   NVARCHAR(52) = 'Content Indexing Enabled'
DECLARE @l_dsId			INT = 0
DECLARE @l_dcPlanId		INT = 0
DECLARE @l_eePolicyId		INT = 0
DECLARE @l_ciPolicyId		INT = 0
SET @l_now = dbo.GetUnixTime(GetUTCDate())
IF (@i_operationType = 2)
BEGIN
    SET @l_enabled = 1
    SET @l_startTime = 0
END
ELSE
BEGIN
    SELECT	@l_enabled = enabled, @l_startTime = startTime
    FROM	archContentIndexingRules
    WHERE	archGroupId = @i_archGroupId
    SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
    IF	@l_error <> 0
	    GOTO FINISH
    ELSE
    IF	@l_rowcount = 0
    BEGIN
SET @l_error = 58
	    GOTO FINISH
    END
    ELSE
    IF	@l_enabled = 0
    BEGIN
SET @l_error = 59
	    GOTO FINISH
    END
    ELSE
    IF	@l_startTime > @l_now
    BEGIN
SET @l_error = 60
	    GOTO FINISH
    END
END
IF @i_jobId > 0
BEGIN
		-- Try populating clientId from TM_JobOption
		INSERT INTO #JOBCLIENT
		SELECT T.x.value('@clientId', 'integer')
		FROM
		(
			SELECT CAST(TM.value AS XML) AS xmlValue
			FROM TM_JobOptions TM
WHERE jobId = @i_jobId AND optionId = 1810277523
		) AS TB
		CROSS APPLY xmlValue.nodes('clients') AS T(x)
		WHERE T.x.value('@clientId', 'integer') IS NOT NULL
    DECLARE @cgId int
    SELECT @cgId = CAST(value AS INT) FROM TM_JobOptions
WHERE jobId = @i_jobId AND optionId = 1152211801
    IF @cgId > 0
    BEGIN
        IF EXISTS (SELECT * FROM App_SCGRule where scgId  = @cgId)
        BEGIN
            DECLARE @cgquery NVARCHAR(MAX)
            SELECT @cgquery = ruleQuery FROM App_SCGRule WHERE scgId  = @cgId
            INSERT INTO #JOBCLIENT
            EXEC  (@cgquery)
        END
        ELSE
        BEGIN
            INSERT INTO #JOBCLIENT
            SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = @cgId
        END
    END
END
IF (@i_operationType = 2)
BEGIN
	-- try populating from TM_JobOption
	SELECT @l_dsId = CAST(TM.value AS INT)
	FROM TM_JobOptions TM
WHERE jobId = @i_jobId AND optionId = 608389867
	IF (@l_dsId <> 0)
	BEGIN
	SELECT @l_dcPlanId = DSP.PropertyValue
	FROM SEDataSourceProperty DSP WITH (NOLOCK)
	WHERE DSP.DataSourceId  = @l_dsId
		AND DSP.PropertyId = (SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'dcplanid')
	END
	IF @l_dcPlanId <> 0
	BEGIN
		SET @l_eePolicyId = dbo.AppPlanGetEntityValue(@l_dcPlanId, 'Data classification policy', default)
		SET @l_ciPolicyId = dbo.AppPlanGetEntityValue(@l_dcPlanId, 'Content Indexing Policy', default)
	END
END
INSERT	INTO #APP
SELECT	DISTINCT appId
FROM	archFile WITH(NOLOCK)
WHERE	archGroupId = @i_archGroupId AND isValid = 1 AND cTime > @l_startTime
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0
	GOTO FINISH
ELSE
IF	@l_rowcount = 0
BEGIN
SET @l_error = 63
	GOTO FINISH
END
INSERT	INTO #CLIENT
SELECT	DISTINCT A.clientId
FROM	APP_ClientProp C WITH(NOLOCK), APP_Application A WITH(NOLOCK), #APP T
WHERE	A.id = T.appId
	AND A.appTypeId IN (
		-- From OffliineCI-SupportedApptypes.doc
		-- 1.1	File System apptypes
1,
11,
13,
17,
18,
19,
20,
21,
29,
33,
34,
36,
38,
42,
43,
63,
64,
74,
73,
86,
106,
128,
124,
		-- 1.2	File System Archiver apptypes
58,
66,
		-- 1.3	Exchange application apptypes
8,
14,
35,
44,
45,
54,
55,
56,
57,
67,
68,
82,
		-- 1.4	Share point application apptypes
46,
78,
89,
		-- 1.5	Lotus notes application apptypes
52,
90,
		--gmail / gdrive
134
		)
	AND C.ComponentNameId = A.clientId
	AND ( (C.attrName = @l_ciPropName AND C.attrVal = N'1' AND C.modified = 0 AND @i_operationType <> 2) OR (@i_operationType = 2 AND (@l_eePolicyId <> 0 OR @l_ciPolicyId <> 0)))
IF EXISTS(SELECT * FROM #JOBCLIENT)
    DELETE FROM #CLIENT WHERE  clientId not in (select clientId from #JOBCLIENT)
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	EXISTS (SELECT * FROM #CLIENT)
	SELECT	clientId FROM #CLIENT
ELSE
SET @l_error = 61
FINISH:
IF	@l_error <> 0
	SELECT	-@l_error
DROP TABLE #APP
DROP TABLE #CLIENT
DROP TABLE #JOBCLIENT
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingClientsByOperationType')
	delete from GxQscripts where name = 'archContentIndexingClientsByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingClientsByOperationType')
	delete from GXDBVersions where aliasname = 'archContentIndexingClientsByOperationType'
GO

insert into GXDBVersions values(2, 'archContentIndexingClientsByOperationType',  '00010001000400070000', 'archContentIndexingClientsByOperationType', '00010001000400070000')
GO

