

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexingClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexingClients.sp,v $ $Id: archContentIndexingClients.sp,v 1.16.210.3 2018/03/22 01:11:30 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexingClients <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexingClients')
	drop procedure archContentIndexingClients
IF EXISTS (select * from GxQscripts where name='archContentIndexingClients')
	delete from GxQscripts where name = 'archContentIndexingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingClients')
	delete from GXDBVersions where aliasname = 'archContentIndexingClients'
GO
print '... Creating Procedure: archContentIndexingClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexingClients
  @i_archGroupId integer
AS
  DECLARE @o_clientId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #APP(appId INT)
CREATE TABLE #CLIENT(clientId INT)
DECLARE	@l_error		INT
DECLARE	@l_rowcount		INT
DECLARE	@l_now			INT
DECLARE	@l_enabled		INT
DECLARE	@l_startTime	INT
SET @l_now = dbo.GetUnixTime(GetUTCDate())
SELECT	@l_enabled = enabled, @l_startTime = startTime
FROM	archContentIndexingRules
WHERE	archGroupId = @i_archGroupId
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0
	GOTO FINISH
ELSE
IF	@l_rowcount = 0
BEGIN
SET @l_error = 58
	GOTO FINISH
END
ELSE
IF	@l_enabled = 0
BEGIN
SET @l_error = 59
	GOTO FINISH
END
ELSE
IF	@l_startTime > @l_now
BEGIN
SET @l_error = 60
	GOTO FINISH
END
INSERT	INTO #APP
SELECT	DISTINCT appId
FROM	archFile WITH(NOLOCK)
WHERE	archGroupId = @i_archGroupId AND isValid = 1 AND cTime > @l_startTime
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0
	GOTO FINISH
ELSE
IF	@l_rowcount = 0
BEGIN
SET @l_error = 63
	GOTO FINISH
END
INSERT	INTO #CLIENT
SELECT	DISTINCT A.clientId
FROM	APP_ClientProp C WITH(NOLOCK), APP_Application A WITH(NOLOCK), #APP T
WHERE	A.id = T.appId
	AND A.appTypeId IN (
		-- From OffliineCI-SupportedApptypes.doc
		-- 1.1	File System apptypes
1,
11,
13,
17,
18,
19,
20,
21,
29,
33,
34,
36,
38,
42,
43,
63,
64,
74,
73,
86,
106,
128,
124,
		-- 1.2	File System Archiver apptypes
58,
66,
		-- 1.3	Exchange application apptypes
8,
14,
35,
44,
45,
54,
55,
56,
57,
67,
68,
82,
		-- 1.4	Share point application apptypes
46,
78,
89,
		-- 1.5	Lotus notes application apptypes
52,
90,
		--gmail / gdrive
134
		)
	AND C.ComponentNameId = A.clientId
	AND C.attrName = N'Content Indexing Enabled' AND C.attrVal = N'1' AND C.modified = 0
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	EXISTS (SELECT * FROM #CLIENT)
	SELECT	clientId FROM #CLIENT
ELSE
SET @l_error = 61
FINISH:
IF	@l_error <> 0
	SELECT	-@l_error
DROP TABLE #APP
DROP TABLE #CLIENT
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexingClients')
	delete from GxQscripts where name = 'archContentIndexingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexingClients')
	delete from GXDBVersions where aliasname = 'archContentIndexingClients'
GO

insert into GXDBVersions values(2, 'archContentIndexingClients',  '00010016021000030000', 'archContentIndexingClients', '00010016021000030000')
GO

