

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archContentIndexFallenBehindAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archContentIndexFallenBehindAlert.sp,v $ $Id: archContentIndexFallenBehindAlert.sp,v 1.3.72.4 2018/03/20 19:53:45 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archContentIndexFallenBehindAlert <<<'

IF EXISTS (select * from sysobjects where name='archContentIndexFallenBehindAlert')
	drop procedure archContentIndexFallenBehindAlert
IF EXISTS (select * from GxQscripts where name='archContentIndexFallenBehindAlert')
	delete from GxQscripts where name = 'archContentIndexFallenBehindAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexFallenBehindAlert')
	delete from GXDBVersions where aliasname = 'archContentIndexFallenBehindAlert'
GO
print '... Creating Procedure: archContentIndexFallenBehindAlert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archContentIndexFallenBehindAlert
AS
  DECLARE @o_policyId INT
  DECLARE @o_policyName NVARCHAR(255)
  DECLARE @o_bytesNotContentIndexed BIGINT
  DECLARE @o_nJobsNotContentIndexed INT
  DECLARE @o_oldestJobEndTime INT
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @archGroup TABLE ( archGroupId INT, name NVARCHAR(255), commCellId INT, CIAlertGB BIGINT, CIAlertDays INT, sourceCopyId INT)
IF (OBJECT_ID('tempdb.dbo.#jobsAFData') IS NOT NULL) DROP TABLE #jobsAFData
CREATE TABLE #jobsAFData (archGroupId INT, jobId INT, commCellId INT, archFileId INT, physicalSize BIGINT, flags INT, copyPrec INT, archCopyId INT,
	PRIMARY KEY (archGroupId, commcellId, archFileId, archCopyId) )
IF (OBJECT_ID('tempdb.dbo.#resultJobsTable') IS NOT NULL) DROP TABLE #resultJobsTable
CREATE TABLE #resultJobsTable (archGroupId INT, jobId INT, commCellId INT, jobEndTime INT, physicalSize BIGINT, ApplicationSize BIGINT)
DECLARE @resultTable TABLE( archGroupId INT, commCellID INT, jobEndTime INT, jobsCount INT, ApplicationSize BIGINT)
-- Getting all the eligible storage policies which have Content Index Fallen Behind Alert enabled
INSERT @archGroup
SELECT AG.id, AG.name, CASE WHEN AG.origCCcommCellID = 0 THEN 2 ELSE AG.origCCcommCellID END, MMEP1.intVal, MMEP2.intVal, ACIR.sourceCopyId
FROM archGroup AG WITH (NOLOCK), archContentIndexingRules ACIR WITH (NOLOCK), MMEntityProp MMEP1 WITH (NOLOCK), MMEntityProp MMEP2 WITH (NOLOCK)
WHERE AG.id = ACIR.archGroupId
	AND ACIR.enabled = 1
	AND ACIR.archGroupId = MMEP1.EntityId AND MMEP1.EntityType = 1 AND MMEP1.propertyName = 'CIAlertGB'
	AND ACIR.archGroupId = MMEP2.EntityId AND MMEP2.EntityType = 1 AND MMEP2.propertyName = 'CIAlertDays'
	AND (MMEP1.intVal > 0 OR MMEP2.intVal > 0)
AND ACIR.operationType = 1
INSERT #jobsAFData
SELECT	AG.archGroupId, AF.jobId, AF.commCellId, AF.id, AFC.physicalSize, AF.flags, AGC.copy, AGC.id
FROM	archFile AF WITH (NOLOCK), @archGroup AG, archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), JMBkpStats JB (NOLOCK)
WHERE	AF.archGroupId = AG.archGroupId AND AF.commCellId = AG.commCellId
	AND AF.id = AFC.archFileId 	AND AF.commcellId = AFC.commcellId
	AND AFC.archCopyId = AGC.id AND AG.archGroupId = AGC.archGroupId
	AND JB.jobId = AF.jobId AND AF.commcellId = JB.commcellId
	AND (AG.sourceCopyId = AFC.archCopyId OR AG.sourceCopyId = 0)   -- if the sourcecopy is available the we pick only those archfiles from archfileCopy table  otherwise all the archfiles
AND AF.fileType = 1
AND AF.flags & (16 + 32) <> 0
	AND AFC.isValid > 0
AND AFC.flags & 256 = 0
	AND AGC.type <> 5    -- copy should not be transitive copy
-- only considering the highest copy precedence archfiles. In case of sourcecopy available it will always be only one copy.
DELETE  #jobsAFData
FROM    #jobsAFData a,
        (SELECT archFileId, commCellId, MIN(copyPrec) AS copyPrec
			FROM #jobsAFData GROUP BY archGroupId, archFileId, commCellId) b
WHERE   a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.copyPrec > b.copyPrec
-- Updating the archFile Size in case of partially content indexed.
UPDATE JD
SET physicalSize = JD.physicalSize - ACIR.physicalOffset
FROM #jobsAFData JD , archContentIndexingRestart ACIR WITH (NOLOCK)
WHERE JD.archGroupId = ACIR.archGroupId
	AND JD.archFileId = ACIR.archFileId
	AND JD.commCellId = ACIR.commCellId
AND JD.flags & 32 > 0
AND ACIR.flags & 1 = 0
AND ACIR.operationType = 1
-- Consolidating the archfiles into job.
INSERT #resultJobsTable
SELECT archGroupId, jobId, commCellId,  0, SUM(physicalSize), SUM(physicalSize)
FROM #jobsAFData
GROUP BY archGroupId, jobId, commCellId
-- updating the end date of each jobs.
UPDATE RT
SET RT.jobEndTime = JBK.servEndDate
FROM #resultJobsTable RT, JMBkpStats JBK WITH (NOLOCK)
WHERE RT.jobId = JBK.jobId
	AND RT.commCellId = JBK.commCellId
-- Getting the final result data for each storage policy.
INSERT @resultTable
SELECT RJT.archGroupId , RJT.commCellId, MIN(jobEndTime), COUNT(jobId), SUM(RJT.physicalSize)
FROM #resultJobsTable RJT
GROUP BY RJT.archGroupId, RJT.commCellId
-- Deleting the storage policies data whose criteria do not satisfies with configured content index fallen behind alert.
DELETE RT
FROM @resultTable RT, @archGroup AG
WHERE RT.archGroupId = AG.archGroupId AND RT.commCellID = AG.commCellId
AND ((AG.CIAlertGB = 0) OR (AG.CIAlertGB > 0 AND RT.ApplicationSize < AG.CIAlertGB*1024*1024*1024))
AND ((AG.CIAlertDays = 0)  OR (AG.CIAlertDays > 0  AND RT.jobEndTime >  dbo.GetUnixTime(GETDATE() - AG.CIAlertDays)))
SELECT  RT.archGroupId, AG.name, RT.ApplicationSize, RT.jobsCount, RT.jobEndTime
FROM @resultTable RT, @archGroup AG
WHERE RT.archGRoupId = AG.archGroupId
	AND RT.commcellId = AG.commCellId
IF (OBJECT_ID('tempdb.dbo.#jobsAFData') IS NOT NULL) DROP TABLE #jobsAFData
IF (OBJECT_ID('tempdb.dbo.#resultJobsTable') IS NOT NULL) DROP TABLE #resultJobsTable
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archContentIndexFallenBehindAlert')
	delete from GxQscripts where name = 'archContentIndexFallenBehindAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archContentIndexFallenBehindAlert')
	delete from GXDBVersions where aliasname = 'archContentIndexFallenBehindAlert'
GO

insert into GXDBVersions values(2, 'archContentIndexFallenBehindAlert',  '00010003007200040000', 'archContentIndexFallenBehindAlert', '00010003007200040000')
GO

