

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCompanyEncryptionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCompanyEncryptionInfo.sp,v $ $Id: archCompanyEncryptionInfo.sp,v 1.1.2.2 2020/05/16 00:49:34 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCompanyEncryptionInfo')
BEGIN
	print '>>> Drop Stored Procedure: archCompanyEncryptionInfo <<<'
	drop procedure archCompanyEncryptionInfo
END
IF EXISTS (select * from GxQscripts where name='archCompanyEncryptionInfo')
	delete from GxQscripts where name = 'archCompanyEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCompanyEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archCompanyEncryptionInfo'
GO
print '... Creating Procedure: archCompanyEncryptionInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCompanyEncryptionInfo
  @i_companyId int,
  @i_isNew int = 0
AS
  DECLARE @o_ErrorCode int;
  DECLARE @o_RSAPubKey varchar(2048);
  DECLARE @o_RSAPriKey varchar(3072);
  DECLARE @o_MasterKeyId varchar(2048);
  DECLARE @o_EncType int;
  DECLARE @o_KeyProviderId int;
  DECLARE @o_KeyProviderType int;
  DECLARE @o_KeyProviderGUID uniqueidentifier;
  DECLARE @o_LastValidation int
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_ErrorCode = 0
SET	@o_RSAPubKey	= ''
SET	@o_RSAPriKey	= ''
SET	@o_MasterKeyId	= ''
SET @o_EncType = 0
SET @o_KeyProviderId = 0
SET @o_KeyProviderType = 0
SET @o_LastValidation = 0
DECLARE @l_currentUtcTime INT = dbo.GetUnixTime(GETUTCDATE())
SELECT	@o_RSAPubKey 		= EP.PubKey,
		@o_RSAPriKey 		= EP.PriKey,
		@o_MasterKeyId 		= EP.MasterKeyId,
		@o_EncType 			= EP.EncType,
		@o_KeyProviderId 	= EP.KeyProviderId,
		@o_KeyProviderType 	= KP.KeyProviderType,
		@o_KeyProviderGUID 	= KP.GUID,
		@o_LastValidation 	= (@l_currentUtcTime - EP.LastValidatedTime)
FROM	ArchCompanyEncProperties EP WITH(READUNCOMMITTED), ArchEncKeyProvider KP WITH(READUNCOMMITTED)
WHERE	EP.CompanyId = @i_companyId AND EP.KeyProviderId = KP.KeyProviderId
--
-- When KMS is set at company level we encrypt data keys using company RSA
-- if a storage pool is shared between companies then we should not reference blocks of one company with other
-- if not we can't recover data since data encryption keys may not get unlocked if block belongs to other company
-- for this purpose we add company GUID to dedupe signature so that signature of one company block doesn't match with other company blockcompany RSA
-- Once CS upgrades to v11 SP12 or higher, user can enable KMS at company, if user sets it then we lock keys using company RSA
-- but client and MA may not be at v11 SP12 or higher where signature module comes into picture
-- So we should allow setting KMS at company level only when
-- 1. All clients in the company are v11 SP12 or higher
-- 2. MediaAgents of associated storage pools are v11 SP12 or higher
--
IF @i_isNew = 1 AND @o_KeyProviderId = 0
BEGIN
DECLARE @l_cs_assocScg int = checksum('Associated Smart Client Group')
	IF EXISTS
	(
		SELECT	1
		FROM	App_ClientGroupAssoc CN2CG WITH(READUNCOMMITTED)
				INNER JOIN App_CompanyProp CP WITH(READUNCOMMITTED)
					ON CP.cs_attrName = @l_cs_assocScg
					AND CP.componentNameId = @i_companyId
AND CP.attrName = 'Associated Smart Client Group'
					AND CP.modified = 0
					AND CP.attrValInt = CN2CG.clientGroupId
AND CP.cs_attrName = CHECKSUM('Associated Smart Client Group')
				INNER JOIN App_Client CN WITH(READUNCOMMITTED)
					ON CN2CG.clientId = CN.id
				INNER JOIN simInstalledPackages CNV WITH(READUNCOMMITTED)
ON CN.id = CNV.clientId AND CNV.simPackageId IN (1, 1002)
				INNER JOIN App_Application SC WITH(READUNCOMMITTED)
					ON CN.id = SC.clientId
				INNER JOIN ArchGroupCopy AGC WITH(READUNCOMMITTED)
					ON SC.dataArchGrpId = AGC.archGroupId OR SC.logArchGrpId = AGC.archGroupId
				INNER JOIN MMDataPath DPath WITH(READUNCOMMITTED)
					ON AGC.id = DPath.copyId
				INNER JOIN MMDrivePool DPool WITH(READUNCOMMITTED)
					ON DPath.DrivePoolId = DPool.DrivePoolId
				INNER JOIN App_Client MA WITH(READUNCOMMITTED)
					ON DPool.clientId = MA.id
				INNER JOIN simInstalledPackages MAV WITH(READUNCOMMITTED)
ON MA.id = MAV.clientId AND MAV.simPackageId IN (51, 1301)
WHERE 	CN.releaseId < 16
OR (CN.releaseId = 16 AND CNV.HighestSP < 12)
OR MA.releaseId < 16
OR (MA.releaseId = 16 AND MAV.HighestSP < 12)
	)
	BEGIN
SET @o_ErrorCode = 218
	END
END
SELECT 	@o_ErrorCode		AS 'ErrorCode',
		@o_RSAPubKey 		AS 'PubKey',
		@o_RSAPriKey 		AS 'PriKey',
		@o_MasterKeyId 		AS 'MasterKeyId',
		@o_EncType 			AS 'EncType',
		@o_KeyProviderId 	AS 'KeyProviderId',
		@o_KeyProviderType 	AS 'KeyProviderType',
		@o_KeyProviderGUID 	AS 'KeyProviderGUID',
		@o_LastValidation 	AS 'LastValidation'
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archCompanyEncryptionInfo')
	delete from GxQscripts where name = 'archCompanyEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCompanyEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archCompanyEncryptionInfo'
GO

insert into GXDBVersions values(2, 'archCompanyEncryptionInfo',  '00010001000200020000', 'archCompanyEncryptionInfo', '00010001000200020000')
GO

