

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCleanChunksInAgedMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +==========================================================================+
--  |   Procedure:  archCleanChunksInAgedMedia
--  |
--  | Description:  It removes chunks and archive files in a non-magnetic media
--	|		which has only aged archive files. It marks jobs as "Deleted From Media"
--  |		if they have no archive file left. It removes archive files which no
--	|		longer exist in any copy. It does not touch any archive file not in
--  |		this media.	If this media has any non-aged archive file, it will do
--	|		nothing and will return notAged = 1. If a chunk has only aged archive
--	|		files but is not marked as aged, consider this chunk as aged.
--  |
--  |		When an aged archive file is deleted from multiple media, we don't
--  |		do anything about chunks in other media because deleting aged archive
--  |		files in a chunk does not change whether this chunk is aged or not.
--  |
--  |
--  |       Input:  media ID
--	|
--  |      Output:  notAged, retVal
--  |      Return:  xxx
--  |
--  |   Revisions	Author		Description
--	|	1.0			Jun Lu
--  |   ---------	---------	-----------------------------------------------
--  +==========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchCleanChunksInAgedMedia.sp,v $ $Id: ArchCleanChunksInAgedMedia.sp,v 1.26.14.2 2018/03/22 01:08:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCleanChunksInAgedMedia')
BEGIN
	print '>>> Drop Stored Procedure: archCleanChunksInAgedMedia <<<'
	drop procedure archCleanChunksInAgedMedia
END
IF EXISTS (select * from GxQscripts where name='archCleanChunksInAgedMedia')
	delete from GxQscripts where name = 'archCleanChunksInAgedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCleanChunksInAgedMedia')
	delete from GXDBVersions where aliasname = 'archCleanChunksInAgedMedia'
GO
print '... Creating Procedure: archCleanChunksInAgedMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCleanChunksInAgedMedia
  @i_mediaId integer
AS
  DECLARE @notAged integer;
  DECLARE @retVal integer;
DECLARE @l_notAged	integer
DECLARE @l_now		integer
DECLARE @l_dateTime	datetime
DECLARE	@magneticBytes	bigint
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @l_notAged = 0
SET @l_dateTime = GetUTCDate()
SET @l_now = dbo.GetUnixTime(@l_dateTime)
--********************** Create table variables **********************************/
DECLARE @tblVol	TABLE
	(volumeId INT, recordingFormatId INT)
DECLARE @tblAC	TABLE
	(id bigint, commCellId INT, flags INT,
	PRIMARY KEY (id, commCellId))
DECLARE @tblJobCopy TABLE
	(jobId INT, archGroupId INT, archCopyId INT, fileType INT, commCellId INT, hasValidAF INT,
	PRIMARY KEY (jobId, archCopyId, fileType, commCellId))
CREATE TABLE #ToBeAgedAFC
	(archFileId INT, commCellId INT, archCopyId INT, jobId INT, fileType INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
--********************** Populate table variables ********************************/
INSERT	INTO @tblVol
SELECT	VolumeId, RecordingFormatId FROM MMVolume WITH (NOLOCK)
WHERE	MediaId = @i_mediaId
IF @@ERROR <> 0 GOTO CX_EXIT
-- If this media is magnetic, do nothing!!!
IF EXISTS (SELECT * FROM @tblVol WHERE recordingFormatId = 10001)
	GOTO CX_EXIT
-- Get all chunks in this media
INSERT	INTO @tblAC
SELECT	A.id, A.commCellId, A.flags
FROM	archChunk A WITH (NOLOCK), @tblVol B
WHERE	A.volumeId = B.volumeId
IF @@ERROR <> 0 OR @@ROWCOUNT = 0
	GOTO CX_EXIT
-- Get all archive files in this media
INSERT	INTO #ToBeAgedAFC
SELECT	DISTINCT A.archFileId, A.commCellId, A.archCopyId, 0, 0
FROM	archChunkMapping A WITH (NOLOCK), @tblAC B
WHERE	A.archChunkId = B.id AND A.chunkCommCellId = B.commCellId
IF @@ERROR <> 0 GOTO CX_EXIT
-- If this media has any not-aged archive file, do nothing!!!
IF EXISTS (
	SELECT *
	FROM	archFileCopy a WITH (NOLOCK), #ToBeAgedAFC b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.archCopyId = b.archCopyId
AND (a.flags & 256) = 0)
BEGIN
	SET	@l_notAged = 1
	GOTO CX_EXIT
END
-- Get all jobs in this media
INSERT	INTO @tblJobCopy
SELECT	A.jobId, A.archGroupId, B.archCopyId, A.fileType, A.commCellId, MAX(A.isValid)
FROM	archFile A WITH (NOLOCK), #ToBeAgedAFC B
WHERE	A.id = B.archFileId AND A.commCellId = B.commCellId
GROUP BY A.jobId, A.archGroupId, B.archCopyId, A.fileType, A.commCellId
IF @@ERROR <> 0 GOTO CX_EXIT
-- Get zero-size archive files in these jobs
INSERT	INTO #ToBeAgedAFC
SELECT	A.archFileId, A.commCellId, A.archCopyId, 0, 0
FROM	archFileCopy A WITH (NOLOCK), archFile B WITH (NOLOCK), @tblJobCopy C
WHERE	B.jobId = C.jobId AND B.commCellId = C.commCellId AND B.fileType = C.fileType
	AND	A.archFileId = B.id AND A.commCellId = B.commCellId AND A.archCopyId = C.archCopyId
AND A.physicalSize = 0 AND A.flags & 256 <> 0
IF @@ERROR <> 0 GOTO CX_EXIT
--******************** Delete from archive tables ********************/
EXEC @retVal = archFileDeleteViaTable 0, @magneticBytes	OUTPUT
IF @@ERROR <> 0 OR @retVal <> 0 GOTO CX_EXIT
-- Delete chunks which have no archive file.
DELETE	archChunk
FROM	archChunk a, @tblAC b
WHERE	a.id = b.id AND a.commCellId = b.commCellId
--******************** Update JMJobDataStats tables ********************/
-- Mark jobs with "CVA_ONE_OR_MORE_MEDIA_RECYCLED_FLAG" if atleast one archive file of the job is been deleted
UPDATE	JMJobDataStats WITH (PAGLOCK)
SET		disabled = (a.disabled | 33554432), modifiedTime = @l_now
FROM	JMJobDataStats a, @tblJobCopy b
WHERE	a.jobId = b.jobId AND a.archGrpCopyId = b.archCopyId AND a.dataType = b.fileType AND a.commCellId = b.commCellId
AND		b.hasValidAF = 1
IF @@ERROR <> 0 GOTO CX_EXIT
TRUNCATE TABLE #ToBeAgedAFC
-- Get all archive files of jobs in this media
INSERT	INTO #ToBeAgedAFC
SELECT	DISTINCT A.id, A.commCellId, B.archCopyId, B.jobId, A.fileType
FROM	archFile A WITH (NOLOCK), @tblJobCopy B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND A.archGroupId = B.archGroupId
IF @@ERROR <> 0 GOTO CX_EXIT
-- Filter out jobs which still have archive files (in this copy)
DELETE	@tblJobCopy
FROM	@tblJobCopy J,
		(SELECT	DISTINCT b.jobId, b.archCopyId, b.fileType, b.commCellId
		FROM	archFileCopy a WITH (NOLOCK), #ToBeAgedAFC b
		WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.archCopyId = b.archCopyId) F
WHERE	J.jobId = F.jobId AND J.archCopyId = F.archCopyId AND J.fileType = F.fileType AND J.commCellId = F.commCellId
IF @@ERROR <> 0 GOTO CX_EXIT
-- Mark jobs as "Deleted From Media" if no more archive files exist
UPDATE	JMJobDataStats WITH(PAGLOCK)
SET		status = 1000, disabled = (a.disabled | 256), agedBy = (agedBy | 33554432),
		mediaDeletedTime = @l_now, modifiedTime = @l_now
FROM	JMJobDataStats a, @tblJobCopy b
WHERE	a.jobId = b.jobId AND a.archGrpCopyId = b.archCopyId AND a.dataType = b.fileType AND a.commCellId = b.commCellId
IF @@ERROR <> 0 GOTO CX_EXIT
-- Set dataStatus = 2 when a job has been deleted from media from all copies
DELETE	@tblJobCopy
FROM	JMJobDataStats A WITH (NOLOCK), @tblJobCopy B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
	AND A.status NOT IN (101, 1000)
IF @@ERROR <> 0 GOTO CX_EXIT
UPDATE	JMBkpStats WITH (PAGLOCK)
SET		dataStatus = 2, mediaDeletedTime = @l_now, modifiedTime = @l_now
FROM	JMBkpStats J, (SELECT DISTINCT jobId, commCellId FROM @tblJobCopy) T
WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
	AND J.dataStatus <> 2
IF @@ERROR <> 0 GOTO CX_EXIT
UPDATE	JMAdminJobStatsTable WITH (PAGLOCK)
SET		dataStatus = 2
FROM	JMAdminJobStatsTable J, (SELECT DISTINCT jobId, commCellId FROM @tblJobCopy) T
WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
	AND J.dataStatus <> 2
--*********************************** Going to exit **********************************/
CX_EXIT:
SELECT @l_notAged, @@ERROR
DROP TABLE #ToBeAgedAFC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archCleanChunksInAgedMedia')
	delete from GxQscripts where name = 'archCleanChunksInAgedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCleanChunksInAgedMedia')
	delete from GXDBVersions where aliasname = 'archCleanChunksInAgedMedia'
GO

insert into GXDBVersions values(2, 'archCleanChunksInAgedMedia',  '00010026001400020000', 'archCleanChunksInAgedMedia', '00010026001400020000')
GO

