

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunktoVerify2CopyProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunktoVerify2CopyProperties.sp,v $ $Id: archChunktoVerify2CopyProperties.sp,v 1.2.2.4 2018/12/28 19:22:49 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunktoVerify2CopyProperties')
BEGIN
	print '>>> Drop Stored Procedure: archChunktoVerify2CopyProperties <<<'
	drop procedure archChunktoVerify2CopyProperties
END
IF EXISTS (select * from GxQscripts where name='archChunktoVerify2CopyProperties')
	delete from GxQscripts where name = 'archChunktoVerify2CopyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunktoVerify2CopyProperties')
	delete from GXDBVersions where aliasname = 'archChunktoVerify2CopyProperties'
GO
print '... Creating Procedure: archChunktoVerify2CopyProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunktoVerify2CopyProperties
  @i_AdminJobId integer,
  @i_ArchGroupId integer,
  @i_ArchGroupCopyId integer
AS
  DECLARE @errorCode integer;	-- newly added for error code.
  DECLARE @id integer; -- -- copy id
  DECLARE @policyName VARCHAR(1024);
  DECLARE @copyName VARCHAR(1024);
  DECLARE @archGroupId integer;
  DECLARE @srcCopyId integer;
  DECLARE @copyStartTime integer;
  DECLARE @copyType integer;
  DECLARE @spFlags integer;
  DECLARE @copyFlags integer;
  DECLARE @copyFlagsExt integer;
  DECLARE @copyLevel integer;
  DECLARE @deferredDays integer;
--:DECLARE--  startReadTime integer;
  DECLARE @markCopiedTime integer;
  DECLARE @archCheckValidPeriod integer;
  DECLARE @archCheckValidPeriodType integer;
  DECLARE @maxMultiplex integer;
  DECLARE @dedupeFlags integer;
  DECLARE @encType integer;
  DECLARE @encKeyLen integer;
  DECLARE @isSnapCopy integer;
  DECLARE @isMirrorCopy integer;
  DECLARE @isNasCopy integer;
  DECLARE @isActive integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--#define  MAX_DEFAULT_REC_SIZE              64
--#define CVA_SIDB_STORE_ENABLED_FLAG        262144
--#define CVA_BACKUP_SILO_ENABLED_FLAG		2097152
--- Start Code
IF object_id('tempdb.dbo.#archGroupCopyTemp') IS NOT null DROP TABLE #archGroupCopyTemp
-- Define errocodes for time being HERE. Need to put them into some header.
-- success 0
-- copy not active 1
-- copy does not exists 2
-- snapcopy DataVerification can't be run 3
-- no secondary copy for sp      4
-- These are defined in AuxCopyDefs.h
-- /* getJonParameters sp return codes. */
--#define CVA_AUXCOPY_COPY_NOT_ACTIVE					1
--#define CVA_AUXCOPY_POLICY_COPY_NOT_EXISTS			2
--#define CVA_AUXCOPY_AUXCOPY_NOT_RUN_DUETO_SNAP		3
--#define CVA_AUXCOPY_SQL_ERROR							5
-- We need to get copy properties in an map.
-- Given copyid, we need to get its poperties and its srcopy properties.
-- If the copy id is 0 then we need to get all copy propertie except snapcopies.
-- remove the unneccessary fields in #archGroupCopyTemp
CREATE TABLE #archGroupCopyTemp
	(
	errorCode			integer, -- newly added for error code.
	id					integer, -- copy id
    policyName VARCHAR(1024),
    copyName VARCHAR(1024),
    archGroupId integer,
    srcCopyId integer,
    copyStartTime integer,
    copyType integer,
    spFlags integer,
    copyFlags integer,
    copyFlagsExt integer,
    copyLevel integer,
    deferredDays integer,
--  startReadTime integer;
    markCopiedTime integer,
    archCheckValidPeriod integer,
	archCheckValidPeriodType integer,
    maxMultiplex integer,
    dedupeFlags integer,
    encType integer,
    encKeyLen integer,
    isSnapCopy integer,
    isMirrorCopy integer,
    isNasCopy integer,
    isActive integer
	);;
DECLARE @l_SIDBStoreId INTEGER = dbo.GetOptionInt(229570007, @i_adminJobId, 0, 0)
DECLARE @mediaTable TABLE (mediaId INTEGER)
DECLARE @copyTable TABLE (copyId INTEGER)
DECLARE @jobOptionXML XML = NULL
SET @jobOptionXML = (SELECT dbo.GetXMLJobOptions(@i_AdminJobId))
IF (@jobOptionXML IS NULL OR LEN(CAST(@jobOptionXML AS NVARCHAR(MAX))) = 0)
BEGIN
SET	@errorCode = 5
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (5, 0);
	GOTO ERR_EXIT
END
--Declare @jobOptionXML xml = '<TMMsg_JobOption>
--  <backupOpts>
--    <mediaOpt>
--      <auxcopyJobOption maxNumberOfStreams="0" useMaximumStreams="1" allCopies="1">
--        <mediaAgent _type_="11" mediaAgentId="0" mediaAgentName="" />
--      </auxcopyJobOption>
--    </mediaOpt>
--  </backupOpts>
--  <restoreOptions />
--  <adminOpts>
--    <updateOption invokeLevel="0" />
--    <archiveCheckOption jobsToVerify="0" allCopies="1">
--      <mediaToVerify mediaId="69" mediaName="VT0032" _type_="46" />
--      <mediaToVerify mediaId="60" mediaName="VT0023" _type_="46" />
--    </archiveCheckOption>
--  </adminOpts>
--  <commonOpts jobDescription="" />
--</TMMsg_JobOption>'
INSERT @mediaTable
SELECT mediaToVerify.Col.value('(@mediaId)[1]','INTEGER') AS MediaId
FROM  @jobOptionXML.nodes('/TMMsg_JobOption/adminOpts/archiveCheckOption/mediaToVerify') AS mediaToVerify(Col)
SELECT	@errorCode = @@ERROR
IF	@errorCode <> 0
BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (6, @errorCode);
	GOTO ERR_EXIT
END
IF EXISTS (SELECT * FROM @mediaTable)
BEGIN
	INSERT INTO @copyTable
	SELECT DISTINCT archGroupCopyId
	FROM	archStream
	WHERE	mediaGroupId IN (	SELECT	MediaGroupId
								FROM	MMVolume MV, @mediaTable M
								WHERE	MV.MediaId = M.mediaId)
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0
	BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (6, @errorCode);
		GOTO ERR_EXIT
	END
	INSERT INTO #archGroupCopyTemp
	SELECT 0, AGC.id,
	AG.name, AGC.name,AG.id,
	/*AGC.sourceCopyId, */
	CASE
	   WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId
	   ELSE CASE
			WHEN (((AGC.sourceCopyId ) <=0 AND AGC.isSnapCopy > 0 )) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END
	   END,
	AGC.startTime, AGC.type, AG.flags /*spFlags*/, AGC.flags, AGC.extendedFlags,
	1 /* copyLevel*/, 0 /* defered days */, dbo.GetUnixTime(GetUTCDate()) /* markCopiedTime */,
	AGC.archCheckValidPeriod, AGC.archCheckValidPeriodType, CASE WHEN (((AGC.dedupeFlags & (262144 | 2097152)) = 262144)) THEN 1 ELSE AGC.maxMultiplex END,
	AGC.dedupeFlags, AGC.encType, AGC.encKeyLen, AGC.isSnapCopy,
	AGC.isMirrorCopy,
	0, /* isNasCopy */ -- need to update after this
	AGC.isActive
	FROM archGroupCopy AGC, archGroup AG, @copyTable T
	WHERE	AGC.id = T.copyId
			AND AGC.archGroupId = AG.id
			AND @i_ArchGroupId = AG.id
			AND (@i_ArchGroupCopyId = 0 OR @i_ArchGroupCopyId = AGC.id)
			AND AGC.type != 5 -- Filter Transitive Copies
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0
	BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (6, @errorCode);
		GOTO ERR_EXIT
	END
END
ELSE IF (@l_SIDBStoreId != 0)
BEGIN
	INSERT INTO #archGroupCopyTemp
	SELECT 0, AGC.id,
	AG.name, AGC.name,AG.id,
	/*AGC.sourceCopyId, */
	CASE
	   WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId
	   ELSE CASE
			WHEN (((AGC.sourceCopyId ) <=0 AND AGC.isSnapCopy > 0 )) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END
	   END,
	AGC.startTime, AGC.type, AG.flags /*spFlags*/, AGC.flags, AGC.extendedFlags,
	1 /* copyLevel*/, 0 /* defered days */, dbo.GetUnixTime(GetUTCDate()) /* markCopiedTime */,
	AGC.archCheckValidPeriod, AGC.archCheckValidPeriodType, CASE WHEN (((AGC.dedupeFlags & (262144 | 2097152)) = 262144)) THEN 1 ELSE AGC.maxMultiplex END,
	AGC.dedupeFlags, AGC.encType, AGC.encKeyLen, AGC.isSnapCopy,
	AGC.isMirrorCopy,
	0, /* isNasCopy */ -- need to update after this
	AGC.isActive
	FROM archGroupCopy AGC, archGroup AG, archCopySIDBStore S
	WHERE	S.SIDBStoreId = @l_SIDBStoreId
			AND S.CopyId = AGC.id
			AND AGC.archGroupId = AG.id
			AND AGC.type != 5 -- Filter Transitive Copies
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0
	BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (6, @errorCode);
		GOTO ERR_EXIT
	END
END
ELSE
BEGIN
	INSERT INTO #archGroupCopyTemp
	SELECT 0, AGC.id,
	AG.name, AGC.name,AG.id,
	/*AGC.sourceCopyId, */
	CASE
	   WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId
	   ELSE CASE
			WHEN (((AGC.sourceCopyId ) <=0 AND AGC.isSnapCopy > 0 )) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END
	   END,
	AGC.startTime, AGC.type, AG.flags /*spFlags*/, AGC.flags, AGC.extendedFlags,
	1 /* copyLevel*/, 0 /* defered days */, dbo.GetUnixTime(GetUTCDate()) /* markCopiedTime */,
	AGC.archCheckValidPeriod, AGC.archCheckValidPeriodType, CASE WHEN (((AGC.dedupeFlags & (262144 | 2097152)) = 262144)) THEN 1 ELSE AGC.maxMultiplex END,
	AGC.dedupeFlags, AGC.encType, AGC.encKeyLen, AGC.isSnapCopy,
	AGC.isMirrorCopy,
	0, /* isNasCopy */ -- need to update after this
	AGC.isActive
	FROM archGroupCopy AGC, archGroup AG
	WHERE	AGC.archGroupId = AG.id
			AND @i_ArchGroupId = AG.id
			AND (@i_ArchGroupCopyId = 0 OR @i_ArchGroupCopyId = AGC.id)
			AND AGC.type != 5 -- Filter Transitive Copies
			AND AGC.isSnapCopy != 1 -- Filter Snap Copies
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0
	BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (6, @errorCode);
		GOTO ERR_EXIT
	END
END
-- Send error when there are no active copies.
-- Check whether any copy exists?
IF NOT EXISTS (SELECT * from #archGroupCopyTemp )
BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (4, @i_ArchGroupCopyId);
	GOTO ERR_EXIT
END
-- Check whether there are active copies
IF (SELECT count(*) from #archGroupCopyTemp WHERE isActive = 1 ) <= 0
BEGIN
	UPDATE #archGroupCopyTemp SET errorCode = 1 WHERE isActive = 0
	--INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (CVA_AUXCOPY_COPY_NOT_ACTIVE, @i_ArchGroupCopyId);
	GOTO ERR_EXIT
END
-- Find whether copy is nasCopy. If it is a nasCopy set the flag isNasCopy to true.
UPDATE #archGroupCopyTemp SET isNasCopy = 1
FROM #archGroupCopyTemp AGCT
JOIN archGroupCopy AGC ON AGCT.id = AGC.id
JOIN MMDataPath MMD ON MMD.CopyId = AGCT.id
JOIN MMDrivePool MMDP ON MMDP.DrivePoolId = MMD.DrivePoolId
WHERE MMDP.DrivePoolType = 3 --3
ERR_EXIT:
-- order by errorCode so that caller can check error first.
SELECT *
FROM #archGroupCopyTemp
ORDER BY errorCode
GO
-- End code

IF EXISTS (select * from GxQscripts where name = 'archChunktoVerify2CopyProperties')
	delete from GxQscripts where name = 'archChunktoVerify2CopyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunktoVerify2CopyProperties')
	delete from GXDBVersions where aliasname = 'archChunktoVerify2CopyProperties'
GO

insert into GXDBVersions values(2, 'archChunktoVerify2CopyProperties',  '00010002000200040000', 'archChunktoVerify2CopyProperties', '00010002000200040000')
GO

