

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunktoRecoverDDBCopyProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunktoRecoverDDBCopyProperties.sp,v $ $Id: archChunktoRecoverDDBCopyProperties.sp,v 1.1.2.4 2018/12/05 07:02:56 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchChunkToRecoverDDBCopyProperties')
BEGIN
	print '>>> Drop Stored Procedure: ArchChunkToRecoverDDBCopyProperties <<<'
	drop procedure ArchChunkToRecoverDDBCopyProperties
END
IF EXISTS (select * from GxQscripts where name='ArchChunkToRecoverDDBCopyProperties')
	delete from GxQscripts where name = 'ArchChunkToRecoverDDBCopyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchChunkToRecoverDDBCopyProperties')
	delete from GXDBVersions where aliasname = 'ArchChunkToRecoverDDBCopyProperties'
GO
print '... Creating Procedure: ArchChunkToRecoverDDBCopyProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchChunkToRecoverDDBCopyProperties
  @i_AdminJobId integer,
  @i_ArchGroupId integer,
  @i_ArchGroupCopyId integer
AS
  DECLARE @errorCode integer;	-- newly added for error code.
  DECLARE @id integer; -- -- copy id
  DECLARE @policyName VARCHAR(1024);
  DECLARE @copyName VARCHAR(1024);
  DECLARE @archGroupId integer;
  DECLARE @srcCopyId integer;
  DECLARE @copyStartTime integer;
  DECLARE @copyType integer;
  DECLARE @spFlags integer;
  DECLARE @copyFlags integer;
  DECLARE @copyFlagsExt integer;
  DECLARE @copyLevel integer;
  DECLARE @deferredDays integer;
--:DECLARE--  startReadTime integer;
  DECLARE @markCopiedTime integer;
  DECLARE @maxMultiplex integer;
  DECLARE @SIDBStoreId integer;
  DECLARE @dedupeFlags integer;
  DECLARE @encType integer;
  DECLARE @encKeyLen integer;
  DECLARE @isSnapCopy integer;
  DECLARE @isMirrorCopy integer;
  DECLARE @isNasCopy integer;
  DECLARE @isActive integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--#define  MAX_DEFAULT_REC_SIZE              64
--#define CVA_SIDB_STORE_ENABLED_FLAG        262144
--#define CVA_BACKUP_SILO_ENABLED_FLAG		2097152
--- Start Code
IF object_id('tempdb.dbo.#archGroupCopyTemp') IS NOT null DROP TABLE #archGroupCopyTemp
-- Define errocodes for time being HERE. Need to put them into some header.
-- success 0
-- copy not active 1
-- copy does not exists 2
-- snapcopy DataVerification can't be run 3
-- no secondary copy for sp      4
-- These are defined in AuxCopyDefs.h
-- /* getJonParameters sp return codes. */
--#define CVA_AUXCOPY_COPY_NOT_ACTIVE					1
--#define CVA_AUXCOPY_POLICY_COPY_NOT_EXISTS			2
--#define CVA_AUXCOPY_AUXCOPY_NOT_RUN_DUETO_SNAP		3
--#define CVA_AUXCOPY_SQL_ERROR							5
-- We need to get copy properties in an map.
-- Given copyid, we need to get its poperties and its srcopy properties.
-- If the copy id is 0 then we need to get all copy propertie except snapcopies.
-- remove the unneccessary fields in #archGroupCopyTemp
CREATE TABLE #archGroupCopyTemp
	(
	errorCode			integer, -- newly added for error code.
	id					integer, -- copy id
    policyName VARCHAR(1024),
    copyName VARCHAR(1024),
    archGroupId integer,
    srcCopyId integer,
    copyStartTime integer,
    copyType integer,
    spFlags integer,
    copyFlags integer,
    copyFlagsExt integer,
    copyLevel integer,
    deferredDays integer,
--  startReadTime integer;
    markCopiedTime integer,
    maxMultiplex integer,
    SIDBStoreId integer,
    dedupeFlags integer,
    encType integer,
    encKeyLen integer,
    isSnapCopy integer,
    isMirrorCopy integer,
    isNasCopy integer,
    isActive integer
	);;
DECLARE @l_SIDBStoreId INTEGER = dbo.GetOptionInt(1777365717, @i_adminJobId, 0, 0)
DECLARE @mediaTable TABLE (mediaId INTEGER)
DECLARE @copyTable TABLE (copyId INTEGER)
DECLARE @jobOptionXML XML = NULL
IF (@l_SIDBStoreId != 0)
BEGIN
	INSERT INTO #archGroupCopyTemp
	SELECT 0, AGC.id,
	AG.name, AGC.name,AG.id,
	/*AGC.sourceCopyId, */
	CASE
	   WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId
	   ELSE CASE
			WHEN (((AGC.sourceCopyId ) <=0 AND AGC.isSnapCopy > 0 )) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END
	   END,
	AGC.startTime, AGC.type, AG.flags /*spFlags*/, AGC.flags, AGC.extendedFlags,
	1 /* copyLevel*/, 0 /* defered days */, dbo.GetUnixTime(GetUTCDate()) /* markCopiedTime */,
	CASE WHEN (((AGC.dedupeFlags & (262144 | 2097152)) = 262144)) THEN 1 ELSE AGC.maxMultiplex END,
	AGC.SIDBStoreId, AGC.dedupeFlags, AGC.encType, AGC.encKeyLen, AGC.isSnapCopy,
	AGC.isMirrorCopy,
	0, /* isNasCopy */ -- need to update after this
	AGC.isActive
	FROM archGroupCopy AGC, archGroup AG, archCopySIDBStore S
	WHERE	S.SIDBStoreId = @l_SIDBStoreId
			AND S.CopyId = AGC.id
			AND AGC.archGroupId = AG.id
			AND AGC.type != 5 -- Filter Transitive Copies
	SELECT	@errorCode = @@ERROR
	IF	@errorCode <> 0
	BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (6, @errorCode);
		GOTO ERR_EXIT
	END
END
-- Send error when there are no active copies.
-- Check whether any copy exists?
IF NOT EXISTS (SELECT * from #archGroupCopyTemp )
BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (2, @i_ArchGroupCopyId);
	GOTO ERR_EXIT
END
ERR_EXIT:
-- order by errorCode so that caller can check error first.
SELECT *
FROM #archGroupCopyTemp
ORDER BY errorCode
GO
-- End code

IF EXISTS (select * from GxQscripts where name = 'archChunktoRecoverDDBCopyProperties')
	delete from GxQscripts where name = 'archChunktoRecoverDDBCopyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunktoRecoverDDBCopyProperties')
	delete from GXDBVersions where aliasname = 'archChunktoRecoverDDBCopyProperties'
GO

insert into GXDBVersions values(2, 'archChunktoRecoverDDBCopyProperties',  '00010001000200040000', 'archChunktoRecoverDDBCopyProperties', '00010001000200040000')
GO

