

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyUpdateVerifyTimeOnStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyUpdateVerifyTimeOnStore.sp,v $ $Id: archChunkToVerifyUpdateVerifyTimeOnStore.sp,v 1.5.2.8 2020/06/27 00:14:43 kjaiswal Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerifyUpdateVerifyTimeOnStore')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyUpdateVerifyTimeOnStore <<<'
	drop procedure archChunkToVerifyUpdateVerifyTimeOnStore
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyUpdateVerifyTimeOnStore')
	delete from GxQscripts where name = 'archChunkToVerifyUpdateVerifyTimeOnStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyUpdateVerifyTimeOnStore')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyUpdateVerifyTimeOnStore'
GO
print '... Creating Procedure: archChunkToVerifyUpdateVerifyTimeOnStore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToVerifyUpdateVerifyTimeOnStore
  @i_adminJobId int,
  @i_DDBValidatePhaseLevel int 
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION
DECLARE @l_SIDBStoreId INTEGER = ISNULL(dbo.GetOptionInt(229570007, @i_adminJobId, 0, 0), 0)
DECLARE @l_ddbVerificationLevel INTEGER = ISNULL(dbo.GetOptionInt(1616894445, @i_adminJobId, 0, 0), 0)
DECLARE @l_ddbVerificationBkpLevel INTEGER = ISNULL(dbo.GetOptionInt(1492218294, @i_adminJobId, 0, 0), 0)
DECLARE @l_currentPhase INTEGER = (SELECT currentPhase FROM JMJobInfo WITH (NOLOCK) WHERE	jobId = @i_adminJobId)
DECLARE @l_jobStartTime INTEGER = (SELECT servStart FROM JMAdminJobInfoTable WITH (NOLOCK) WHERE	jobId = @i_adminJobId)
DECLARE	@l_now INT
SET		@l_now = dbo.GetUnixTime(GetUTCDate())
DECLARE @dedupeValidate INT = 0
DECLARE @dataVerification INT = 0
DECLARE	@opId INT = 0
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	 @dedupeValidate = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Validate Dedupe Data'
SELECT	 @dataVerification = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Verify Data'
IF (@l_ddbVerificationLevel = 1 /*QUICK_DDB_VERIFICATION*/)
BEGIN
	IF @l_ddbVerificationLevel = 1 AND @l_currentPhase = @dataVerification -- no need to update in dedupevalidate phase as they always run together
	BEGIN
		UPDATE	IdxSIDBStore
		SET		LastQuickDDBVerificationTime = @l_jobStartTime
		FROM	IdxSIDBStore S
		WHERE	S.SIDBStoreId = @l_SIDBStoreId
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
	END
END
ELSE IF (@l_ddbVerificationLevel IN (2, 3) /*DDB_VERIFICATION, DDB_AND_DATA_VERIFICATION*/)
BEGIN
	IF (@l_currentPhase = @dedupeValidate) -- DEDUPVALIDATE
	BEGIN
		UPDATE	S
		SET		LastDDBVerificationTime = @l_jobStartTime,
				LastDataVerificationTime = (CASE WHEN @l_ddbVerificationLevel = 3 /*DDB_AND_DATA_VERIFICATION*/ AND @i_DDBValidatePhaseLevel = 3 /*DV_PHASE_1_VERF_TYPE_INCR_MADE_FULL*/ THEN 0 ELSE LastDataVerificationTime END) -- When incremental job is converted to full by DDB
		FROM	IdxSIDBStore S
		WHERE	S.SIDBStoreId = @l_SIDBStoreId
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
	END
	ELSE IF (@l_currentPhase = @dataVerification) -- ARCHCHECK
	BEGIN
		UPDATE	S
		SET		LastDataVerificationTime = @l_jobStartTime
		FROM	IdxSIDBStore S
		WHERE	S.SIDBStoreId = @l_SIDBStoreId
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
	END
	ELSE
	BEGIN
		/*Unknown Phase number*/
		SET @retVal = -2
		IF  @retVal <> 0 GOTO FINISH
	END
END
IF @l_ddbVerificationBkpLevel = 1
	AND @l_ddbVerificationLevel IN (1,3)
BEGIN
	UPDATE MMEntityProp
	SET longlongVal = @l_jobStartTime, modified = @l_now
WHERE propertyName = 'DDBLastFullVerificationTime' AND EntityId = @l_SIDBStoreId AND EntityType = 3 AND CommCellId = 2
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO 	MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT 		@l_SIDBStoreId, 3,  'DDBLastFullVerificationTime',  2, 0, @l_jobStartTime, '', @l_now, @l_now, 2
	END
END
FINISH:
IF  @retVal = 0
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
SELECT @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyUpdateVerifyTimeOnStore')
	delete from GxQscripts where name = 'archChunkToVerifyUpdateVerifyTimeOnStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyUpdateVerifyTimeOnStore')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyUpdateVerifyTimeOnStore'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyUpdateVerifyTimeOnStore',  '00010005000200080000', 'archChunkToVerifyUpdateVerifyTimeOnStore', '00010005000200080000')
GO

