

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyTotalDataSize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyTotalDataSize.sp,v $ $Id: archChunkToVerifyTotalDataSize.sp,v 1.5.80.9 2018/03/22 01:02:32 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archChunkToVerifyTotalDataSize <<<'

IF EXISTS (select * from sysobjects where name='archChunkToVerifyTotalDataSize')
	drop procedure archChunkToVerifyTotalDataSize
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyTotalDataSize')
	delete from GxQscripts where name = 'archChunkToVerifyTotalDataSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyTotalDataSize')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyTotalDataSize'
GO
print '... Creating Procedure: archChunkToVerifyTotalDataSize'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToVerifyTotalDataSize
  @i_archCopyId int,
  @i_sidbStoreId int,
  @i_adminJobId int,
  @i_jobPhaseNum int
AS
  DECLARE @o_totalDataSize bigint;
  DECLARE @o_totalUnCompBytesDataSize bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @totalSize bigint
DECLARE @totalUnCompBytesSize bigint
SET @totalSize = 0;
SET @totalUnCompBytesSize = 0;
DECLARE @dedupeValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE	@opId INT = 0
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	 @dedupeValidate = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Validate Dedupe Data'
SELECT	 @orphanListing = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Orphan Chunk listing'
SELECT	 @defragment = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Defragment Data'
if (@i_jobPhaseNum = @dedupeValidate) -- DEDUPVALIDATE
BEGIN
	-- For GDSP case, some copies may not have any chunks
	IF EXISTS (SELECT 1	FROM archChunkToVerify WHERE adminJobId = @i_adminJobId )
	BEGIN
		-- We are tracking progress for store based DV on phase 1 based on primary entries (unique blocks)
		-- @totalSize and @totalUnCompBytesSize will have total number of primary entries present on this store
		SELECT	@totalSize = SUM(ISNULL(PrimaryEntries, 0))
		FROM	IdxSIDBUsageHistory H WITH (READUNCOMMITTED),
				(SELECT	SIDBStoreId, SubStoreId, MAX(ISNULL(ModifiedTime, 0)) MaxModifiedTime
				FROM	IdxSIDBUsageHistory WITH (READUNCOMMITTED)
				WHERE	SIDBStoreId = @i_sidbStoreId
				GROUP BY SIDBStoreId, SubStoreId) MH
		WHERE	H.SIDBStoreId = MH.SIDBStoreId
				AND H.SubStoreId = MH.SubStoreId
				AND H.ModifiedTime = MH.MaxModifiedTime
		SELECT	@totalUnCompBytesSize = @totalSize
	END
END
ELSE IF (@i_jobPhaseNum = @orphanListing) -- ORPHANLISTING
BEGIN
	DECLARE @l_maxVolumeId INTEGER = 0
    SELECT @l_maxVolumeId = attributeValueInt
	FROM JMJobOptions WITH (READUNCOMMITTED)
    WHERE jobId = @i_adminJobId AND commcellId = 2
AND attributeId = 65
	IF (@l_maxVolumeId = 0)
	BEGIN
		DECLARE @l_jobStartTime INTEGER = (SELECT servStart FROM JMAdminJobInfoTable WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
		SELECT	@totalSize = COUNT(*),  @l_maxVolumeId = MAX(VolumeId)
		FROM	MMVolume WITH (READUNCOMMITTED)
		WHERE	SIDBStoreID = @i_sidbStoreId
				AND CreationTime < @l_jobStartTime
		INSERT INTO JMJobOptions(jobId, commCellId, attributeId, attributeName, attributeValueInt, attributeValue)
VALUES (@i_adminJobId, 2, 65, 'Maximum Volume id for Deduplication Database', @l_maxVolumeId, N'')
	END
	ELSE
	BEGIN
		SELECT	@totalSize = COUNT(*),  @l_maxVolumeId = MAX(VolumeId)
		FROM	MMVolume WITH (READUNCOMMITTED)
		WHERE	SIDBStoreID = @i_sidbStoreId
				AND VolumeId <= @l_maxVolumeId
	END
	SELECT	@totalUnCompBytesSize = @totalSize
END
ELSE IF (@i_jobPhaseNum = @defragment) -- DEFRAGMENT
BEGIN
    SELECT @totalSize = attributeValueInt
	FROM JMJobOptions WITH (READUNCOMMITTED)
    WHERE jobId = @i_adminJobId AND commcellId = 2
AND attributeId = 54
	IF @totalSize = 0 AND @@ROWCOUNT = 0
	BEGIN
		-- We are tracking progress for store based DV on phase 1 based on primary entries (unique blocks)
		-- @totalSize and @totalUnCompBytesSize will have total number of primary entries present on this store
		-- We are changing the code to populated fewer number of rows
		SELECT	@totalSize = COUNT(*)
		FROM	archFileCopyDedup AFCD WITH (READUNCOMMITTED), archChunkMapping ACM WITH (READUNCOMMITTED)
		WHERE	AFCD.SIDBStoreId = @i_sidbStoreId
				AND AFCD.archFileId = ACM.archFileid
				AND AFCD.commCellId = ACM.commCellId
				AND AFCD.archCopyId = ACM.archCopyId
	END
	SELECT	@totalUnCompBytesSize = @totalSize
END
ELSE
BEGIN
	SELECT @totalSize = ISNULL(SUM(physicalSize), 0), @totalUnCompBytesSize = ISNULL(SUM(unCompBytesSize), 0)
	from archChunkToVerify WITH (READUNCOMMITTED)
	where adminJobId = @i_adminJobId AND archCopyId = @i_archCopyId
END
SELECT @totalSize, @totalUnCompBytesSize
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyTotalDataSize')
	delete from GxQscripts where name = 'archChunkToVerifyTotalDataSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyTotalDataSize')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyTotalDataSize'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyTotalDataSize',  '00010005008000090000', 'archChunkToVerifyTotalDataSize', '00010005008000090000')
GO

