

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifySetStream.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifySetStream.sp,v $ $Id: archChunkToVerifySetStream.sp,v 1.2.202.5 2019/05/10 07:17:04 sjohnson Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerifySetStream')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifySetStream <<<'
	drop procedure archChunkToVerifySetStream
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifySetStream')
	delete from GxQscripts where name = 'archChunkToVerifySetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifySetStream')
	delete from GXDBVersions where aliasname = 'archChunkToVerifySetStream'
GO
print '... Creating Procedure: archChunkToVerifySetStream'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerifySetStream
  @i_adminJobId int,
  @i_archCopyId int,
  @i_streamNum int,
  @i_maxConcurrency int,
  @i_currMediaAgentId int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
  DECLARE @o_streamNum integer;
  DECLARE @o_mediaAgentId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRAN VerifySetStream_tran
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	DECLARE @mpAffinityEnabled INT = 0
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	IF	@i_streamNum > 0
			AND EXISTS (SELECT 1 FROM ArchChunkToVerify WITH (NOLOCK)
						WHERE adminJobId = @i_adminJobId AND archCopyId = @i_archCopyId
						AND streamNum = @i_streamNum AND segmentId > 0)
		GOTO CX_EXIT
	DECLARE @tblSegmentStream TABLE (
		streamNum			integer,
		segmentId			integer,
		MPId				integer,
		isSet				integer,
		mediaAgentId		integer
	)
	DECLARE @tblLocalMediaAgentStreamInfo  TABLE(
		MAId				integer,
		nActiveStreams		integer
	)
	SELECT @mpAffinityEnabled = value FROM MMConfigs WHERE name = 'MMCONFIG_ENABLE_MP_AFFINITY_FOR_DATA_VERIFICATION'
	INSERT INTO @tblLocalMediaAgentStreamInfo
	SELECT DISTINCT MAId, dbo.MMS2FUNC_GetReadStreamCountForMA(MAId, 1 /*notReserved*/)
	FROM archChunkToVerifyMPToMAMap mpm WITH (READUNCOMMITTED)
	WHERE adminJobId = @i_adminJobId AND copyId = @i_archCopyId
	-- Do not support dynamic stream allocation for snap copy
	IF EXISTS (SELECT 1 FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_archCopyId AND isSnapCopy = 1)
		GOTO CX_EXIT
	DECLARE @max_streamNum	INTEGER
	IF @i_maxConcurrency > 0
		SET @max_streamNum = @i_maxConcurrency
	ELSE
		SELECT	@max_streamNum = B.maxStreams
		FROM	archGroupCopy A WITH (NOLOCK), archGroup B WITH (NOLOCK)
		WHERE	A.id = @i_archCopyId
		AND		A.archGroupId = B.id
	DECLARE @streamNum		INTEGER
	DECLARE @nextStream		INTEGER
	SET @nextStream = 0
	SET @streamNum = 1
	IF	@i_streamNum > 0
	BEGIN
		SET @streamNum = @i_streamNum
	END
	INSERT INTO @tblSegmentStream
	SELECT DISTINCT streamNum, segmentId, mp.mountPathId, 0, 0
	FROM ArchChunkToVerify av WITH (NOLOCK) , MMVolume v WITH (NOLOCK), MMMountPath mp WITH (NOLOCK)
	WHERE adminJobId = @i_adminJobId
	AND archCopyId = @i_archCopyId
	AND (@i_streamNum = 0 OR @i_streamNum > 0 AND streamNum = 0)
	AND segmentId > 0
	AND mp.mediaSideId= v.mediaSideId
	AND v.volumeId = av.volumeId
	WHILE 1 = 1
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM @tblSegmentStream WHERE streamNum = 0)
			BREAK
		IF EXISTS (SELECT 1 FROM @tblSegmentStream WHERE streamNum = @streamNum)
			SET @nextStream = 1
		IF @nextStream > 0
		BEGIN
			IF	@i_streamNum > 0
				BREAK
			SET @streamNum = @streamNum + 1
			IF @streamNum > @max_streamNum
				BREAK
			SET @nextStream = 0
			CONTINUE
		END
		DECLARE @t_segmentId INTEGER = NULL
		DECLARE @mediaAgentId INTEGER = 0
		IF @mpAffinityEnabled = 1
		BEGIN
PICK_MA:
			IF	(@i_streamNum = 0 OR @i_currMediaAgentId = 0)
			BEGIN
				SELECT TOP 1 @t_segmentId = segmentId, @mediaAgentId = MSI.MAId
				FROM @tblSegmentStream ss, @tblLocalMediaAgentStreamInfo MSI, archChunkToVerifyMPToMAMap MPM WITH (READUNCOMMITTED)
				WHERE streamNum = 0
				AND	ss.MPId = MPM.MPId AND MSI.MAId = MPM.MAId AND MPM.isLocal = 1  AND MPM.adminJobId = @i_adminJobId AND MPM.copyId = @i_archCopyId
				ORDER BY MSI.nActiveStreams ASC,  segmentId ASC
				UPDATE @tblLocalMediaAgentStreamInfo
				SET nActiveStreams+= 1
				FROM @tblLocalMediaAgentStreamInfo t
				WHERE MAId = @mediaAgentId
			END
			ELSE
			BEGIN
				--getLast MAId
				--getNext segment that is having mp local to that MAId if possible
				SET @mediaAgentId = @i_currMediaAgentId
				SET @t_segmentId = (
									SELECT MIN(segmentId)
									FROM @tblSegmentStream ss,  archChunkToVerifyMPToMAMap MPM  WITH (READUNCOMMITTED)
									WHERE streamNum = 0
									AND isLocal = 1 AND MPM.MPId = ss.MPId AND MPM.MAId = @mediaAgentId  AND MPM.adminJobId = @i_adminJobId AND MPM.copyId = @i_archCopyId
									)
				IF @t_segmentId IS NULL
				BEGIN
					SET @i_currMediaAgentId = 0
					GOTO PICK_MA
				END
			END
		END
		IF @t_segmentId IS NULL -- use the old logic if we don't get anys segments using our lookups(Non Data-Validate phases)
			SET @t_segmentId = (SELECT MIN(segmentId) FROM @tblSegmentStream WHERE streamNum = 0)
		IF @t_segmentId IS NOT null
		BEGIN
				UPDATE @tblSegmentStream
				SET streamNum = @streamNum, isSet = 1, mediaAgentId = @mediaAgentId
				WHERE segmentId = @t_segmentId
				CONTINUE
		END
		SET @nextStream = 1
	END
	UPDATE ArchChunkToVerify
	SET streamNum = b.streamNum, srcMAId = ISNULL(b.mediaAgentId, 0)
	FROM ArchChunkToVerify a, @tblSegmentStream b
	WHERE a.adminJobId = @i_adminJobId
	AND a.archCopyId = @i_archCopyId
	AND a.streamNum <> b.streamNum
	AND a.segmentId = b.segmentId
	AND b.isSet = 1
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to update StreamNum for segment in ArchChunkToVerify: DB error!'
			GOTO CX_EXIT_ERROR
	END
CX_EXIT:
	IF @i_streamNum = 0
		SET @errStr = 'All streams are assigned for copy with max stream: [' + convert(varchar(10), @max_streamNum) + ']'
	ELSE
		SET @errStr = 'A segment is assigned to given stream'
	COMMIT TRAN VerifySetStream_tran
	SELECT 0, '', streamNum, mediaAgentId
	FROM @tblSegmentStream
	WHERE isSet = 1 AND mediaAgentId > 0
	RETURN
CX_EXIT_ERROR:
	ROLLBACK TRAN VerifySetStream_tran
	SELECT @errVal, @errStr, 0, 0
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifySetStream')
	delete from GxQscripts where name = 'archChunkToVerifySetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifySetStream')
	delete from GXDBVersions where aliasname = 'archChunkToVerifySetStream'
GO

insert into GXDBVersions values(2, 'archChunkToVerifySetStream',  '00010002020200050000', 'archChunkToVerifySetStream', '00010002020200050000')
GO

