

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifySegment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifySegment.sp,v $ $Id: archChunkToVerifySegment.sp,v 1.4.48.9 2019/06/04 10:33:14 kjaiswal Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerifySegment')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifySegment <<<'
	drop procedure archChunkToVerifySegment
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifySegment')
	delete from GxQscripts where name = 'archChunkToVerifySegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifySegment')
	delete from GXDBVersions where aliasname = 'archChunkToVerifySegment'
GO
print '... Creating Procedure: archChunkToVerifySegment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerifySegment
  @i_adminJobId int,
  @i_archCopyId int,
  @i_maxConcurrency int,
  @i_minSegmentGB bigint
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
  DECLARE @o_segmentCount integer;
SET NOCOUNT ON
	IF object_id('tempdb.dbo.#tblChunkToVerify') IS NOT NULL DROP TABLE #tblChunkToVerify
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	DECLARE	@cursor	INTEGER = 0
	DECLARE	@errVal	INTEGER = 0
	DECLARE	@errStr	VARCHAR(1024) = 'NO ERROR'
	DECLARE @segmentId	INTEGER = 0
    DECLARE @multiplex	INTEGER = 0
	DECLARE @max_streamNum	INTEGER = 0
	DECLARE @min_segmentNum	INTEGER = 100
	DECLARE @segmentCount	INTEGER = 0
	DECLARE @smallSegment INTEGER = 0
	DECLARE @mpAffinityEnabled INT = 0
	-- Do not support dynamic stream allocation for snap copy
	IF EXISTS (SELECT * FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_archCopyId AND isSnapCopy = 1)
		GOTO FINISH
	-- Do not create new segments if there are segments created and not assigned to streams
	IF EXISTS	(	SELECT * FROM ArchChunkToVerify WITH (NOLOCK)
					WHERE adminJobId = @i_adminJobId
					AND archCopyId = @i_archCopyId
					AND segmentId > 0 AND streamNum = 0
				)
		GOTO FINISH
	DECLARE @l_currentPhase INTEGER = (SELECT currentPhase FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @i_adminJobId)
	DECLARE @dedupeValidate INT = 0
	DECLARE @defragment INT = 0
	DECLARE @orphanListing INT = 0
	DECLARE	@opId INT = 0
	SELECT	@opId = id
	FROM	JMOpTable WITH (READUNCOMMITTED)
	WHERE	operation=31 /*ARCHIVECHECK*/
	SELECT	 @dedupeValidate = phase
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId and name = 'Validate Dedupe Data'
	SELECT	 @orphanListing = phase
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId and name = 'Orphan Chunk listing'
	SELECT	 @defragment = phase
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId and name = 'Defragment Data'
	IF @l_currentPhase IN (@dedupeValidate, @orphanListing, @defragment)
	BEGIN
		SET @smallSegment = 1
	END
	ELSE
		SELECT @mpAffinityEnabled = value FROM MMConfigs WHERE name = 'MMCONFIG_ENABLE_MP_AFFINITY_FOR_DATA_VERIFICATION'
	IF @i_minSegmentGB = 0
		SET @i_minSegmentGB = 2
	create table #tblChunkToVerify (
		id					integer IDENTITY (1,1),
		archCopyId			integer,
		archChunkId			bigint,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		mountPathId			integer,
		physicalSize		bigint,
		segmentID			int,
		primary key (id)
	)
	create index ChunkToVerify_temp_idx_1 on #tblChunkToVerify (archFileId, commCellId)
	create index ChunkToVerify_temp_idx_2 on #tblChunkToVerify (archChunkId, commCellId)
	create index ChunkToVerify_temp_idx_3 on #tblChunkToVerify (archCopyId, mediaGroupId, commCellId, archFileId)
	create table #tblChunkInSegment (
		id					integer,
		archCopyId			integer,
		archChunkId			bigint,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		mountPathId			integer,
		physicalSize		bigint,
		segmentID			int,
		primary key (id)
	)
	create index ChunkInSegment_temp_idx_1 on #tblChunkInSegment (archFileId, commCellId)
	create index ChunkInSegment_temp_idx_2 on #tblChunkInSegment (archChunkId, commCellId)
	INSERT INTO #tblChunkToVerify
	SELECT a.archCopyId, a.archChunkId, a.archFileId, a.commCellId, a.mediaGroupId, CASE WHEN @mpAffinityEnabled > 0 THEN mp.mountPathId ELSE 0 END, a.physicalSize, 0
	FROM ArchChunkToVerify a WITH (NOLOCK), MMVolume b WITH (NOLOCK), MMMedia c WITH (NOLOCK), MMMountPath mp WITH (NOLOCK)
	WHERE a.adminJobId = @i_adminJobId
	AND a.archCopyId = @i_archCopyId
	AND a.volumeId = b.volumeId
	AND b.mediaId = c.mediaId
	AND c.mediaTypeId = 10001
	AND a.segmentId = 0
	AND mp.mediaSideId = b.mediaSideId
	IF @@ROWCOUNT = 0
		GOTO FINISH
	IF exists (
			select archcopyid, archchunkid
			from ArchChunkToVerify with (NOLock)
			where adminJobId = @i_adminJobId
			and archCopyId = @i_archCopyId
			group by archcopyid, archchunkid having count(archfileid) > 1
			)
		SET @multiplex = 1
	IF @i_maxConcurrency > 0
		SET @max_streamNum = @i_maxConcurrency
	ELSE
		SELECT	@max_streamNum = B.maxStreams
		FROM	archGroupCopy A WITH (NOLOCK), archGroup B WITH (NOLOCK)
		WHERE	A.id = @i_archCopyId
		AND		A.archGroupId = B.id
	-- Clear source stream and media group info
	UPDATE ArchChunkToVerify
	SET streamNum = 0
	FROM ArchChunkToVerify a, #tblChunkToVerify b
	WHERE a.archChunkId = b.archChunkId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.archCopyId = b.archCopyId
	AND a.streamNum <> 0
	AND a.adminJobId = @i_adminJobId
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to clear streams for ArchChunkToVerify: DB error!'
			GOTO FINISH
	END
	DECLARE @archFileId		INTEGER
	DECLARE @commCellId		INTEGER
	DECLARE @archCopyId		INTEGER
	DECLARE @mediaGroupId	INTEGER
	DECLARE @mountPathId	INTEGER
	DECLARE @volumeId	INTEGER
	DECLARE @mediaGroupId_prev INTEGER
	SET @mediaGroupId_prev = -1
	DECLARE @mountPathId_prev INTEGER
	SET @mountPathId_prev = -1
	DECLARE AFCursor CURSOR FOR
			SELECT DISTINCT archCopyId, archFileId, commCellId, mediaGroupId , mountPathId
			FROM #tblChunkToVerify
			ORDER BY archCopyId, mediaGroupId, mountPathId, commCellId, archFileId
	OPEN AFCursor
	SET @cursor = 1
	FETCH NEXT from AFCursor INTO @archCopyId, @archFileId, @commCellId, @mediaGroupId, @mountPathId
	WHILE (1 = 1)
	BEGIN
		DECLARE @fetchNext INTEGER
		SET @fetchNext = 1
		IF @@FETCH_STATUS <> 0
			GOTO CREATE_SEGMENT
		IF NOT EXISTS (select * from #tblChunkToVerify WITH (NOLOCK)
					where archFileId = @archFileId
					and commCellId = @commCellId
					and segmentId = 0
					)
			GOTO FETCH_NEXT
		IF @mediaGroupId_prev < 0 -- do we need to break a segment on MG change?  after all this is just used for stream to tape affinity which is insignificant for Mag media
			SET @mediaGroupId_prev = @mediaGroupId
		IF @mediaGroupId_prev <> @mediaGroupId
		BEGIN
			-- MediaGroupId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mediaGroupId_prev = @mediaGroupId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		IF @mountPathId_prev < 0
			SET @mountPathId_prev = @mountPathId
		IF @mountPathId_prev <> @mountPathId AND @mpAffinityEnabled = 1
		BEGIN
			-- mountPathId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mountPathId_prev = @mountPathId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		-- Set flag for all chunks of given archive file
		INSERT INTO #tblChunkInSegment
		SELECT a.*
		FROM #tblChunkToVerify a LEFT OUTER JOIN #tblChunkInSegment b ON a.id = b.id
		WHERE a.archFileId = @archFileId
		AND a.mountPathId = @mountPathId
		AND a.commCellId = @commCellId
		AND b.id IS NULL
		-- No new chunks of this archive file found
		IF @@ROWCOUNT = 0
			GOTO FETCH_NEXT
		IF @smallSegment = 1
			GOTO CREATE_SEGMENT
		WHILE (1 = 1)
		BEGIN
			DECLARE @sumSegmentSize bigint = 0
			DECLARE @numChunks integer = 0
			IF @multiplex > 0
			BEGIN
				-- Get linked chunks through multiplexing
				INSERT INTO #tblChunkInSegment
				SELECT DISTINCT b.*
				FROM #tblChunkInSegment a right outer join #tblChunkToVerify b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archChunkId = b.archChunkId AND c.commCellId = b.commCellId
				WHERE a.id is null
				SET @numChunks = @@ROWCOUNT
				IF @numChunks > 0
				BEGIN
					-- Add linked archive files.
					INSERT INTO #tblChunkInSegment
					SELECT DISTINCT b.*
					FROM #tblChunkInSegment a right outer join #tblChunkToVerify b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archFileId = b.archFileId AND c.commCellId = b.commCellId AND c.mountPathId = b.mountPathId
					WHERE a.id is null
					SET @numChunks = @@ROWCOUNT
				END
			END
			SET @sumSegmentSize = (SELECT SUM(physicalSize) FROM #tblChunkInSegment)
			IF @sumSegmentSize < @i_minSegmentGB * 1024 * 1024 * 1024
			BEGIN
				IF @numChunks = 0
					GOTO FETCH_NEXT
				ELSE
					CONTINUE
			END
			IF @numChunks = 0
				BREAK;
		END
CREATE_SEGMENT:
		IF EXISTS (SELECT * FROM #tblChunkInSegment)
		BEGIN
			INSERT INTO archChunkSegment
			SELECT @i_archCopyId, @archCopyId, 0
			SELECT @errVal = @@ERROR, @segmentId = @@IDENTITY
			IF @errVal <> 0 OR @segmentId = 0
			BEGIN
					SET @errStr = 'Failed to create new segment for aux copy: DB error!'
					GOTO FINISH
			END
			DELETE FROM archChunkSegment WITH (ROWLOCK)
			WHERE segmentId = @segmentId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to delete segment ID for aux copy: DB error!'
					GOTO FINISH
			END
			UPDATE #tblChunkToVerify
			SET segmentId = @segmentId
			FROM #tblChunkToVerify a, #tblChunkInSegment b
			WHERE a.archChunkId = b.archChunkId
			AND a.archFileId = b.archFileId
			AND a.commCellId = b.commCellId
			AND a.archCopyId = b.archCopyId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to update segmentId for ArchChunkToVerify: DB error!'
					GOTO FINISH
			END
			-- Clear temp table
			DELETE FROM #tblChunkInSegment
			SET @segmentCount = @segmentCount + 1
			IF @max_streamNum > 0 AND @segmentCount >= 5 * @max_streamNum AND @segmentCount >= @min_segmentNum
			BEGIN
				GOTO UPDATEDB
			END
		END
		IF @@FETCH_STATUS <> 0
			GOTO UPDATEDB
FETCH_NEXT:
		IF @fetchNext = 1
			FETCH NEXT from AFCursor INTO @archCopyId, @archFileId, @commCellId, @mediaGroupId, @mountPathId
	END
UPDATEDB:
	UPDATE ArchChunkToVerify
	SET segmentId = b.segmentID
	FROM ArchChunkToVerify a, #tblChunkToVerify b
	WHERE a.archChunkId = b.archChunkId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.archCopyId = b.archCopyId
	AND a.adminJobId = @i_adminJobId
FINISH:
	IF object_id('tempdb.dbo.#tblChunkToVerify') IS NOT NULL DROP TABLE #tblChunkToVerify
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	SELECT @errVal, @errStr, @segmentCount
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifySegment')
	delete from GxQscripts where name = 'archChunkToVerifySegment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifySegment')
	delete from GXDBVersions where aliasname = 'archChunkToVerifySegment'
GO

insert into GXDBVersions values(2, 'archChunkToVerifySegment',  '00010004004800090000', 'archChunkToVerifySegment', '00010004004800090000')
GO

