

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyPopulateMAsForDDBDataVerification.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyPopulateMAsForDDBDataVerification.sp,v $ $Id: archChunkToVerifyPopulateMAsForDDBDataVerification.sp,v 1.6.12.17 2020/12/24 01:27:15 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archChunkToVerifyPopulateMAsForDDBDataVerification')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyPopulateMAsForDDBDataVerification <<<'
	drop procedure archChunkToVerifyPopulateMAsForDDBDataVerification
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyPopulateMAsForDDBDataVerification')
	delete from GxQscripts where name = 'archChunkToVerifyPopulateMAsForDDBDataVerification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyPopulateMAsForDDBDataVerification')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyPopulateMAsForDDBDataVerification'
GO
print '... Creating Procedure: archChunkToVerifyPopulateMAsForDDBDataVerification'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archChunkToVerifyPopulateMAsForDDBDataVerification
  @i_adminJobId int,
  @i_onAllVolumes int = 0
AS
  DECLARE @retVal integer;
  DECLARE @allowBackup integer;
  DECLARE @allowDefragmentation INTEGER;
  DECLARE @pickV11SP20MAs INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
DECLARE @l_SIDBStoreId INTEGER = dbo.GetOptionInt(229570007, @i_adminJobId, 0, 0)
DECLARE @l_srcMediaAgentId INTEGER = dbo.GetOptionInt(1564054677, @i_adminJobId, 0, 0)
DECLARE @l_prunerMediaAgentId INTEGER = 0
DECLARE @l_useScalableResourceManagement INTEGER = dbo.GetOptionInt(449788653, @i_adminJobId, 0, 0)
DECLARE @l_currentPhase INTEGER = 0
DECLARE @l_currentAttemptNum INTEGER = 0
DECLARE @l_subOpType INTEGER = 0
SELECT @l_currentPhase = currentPhase, @l_currentAttemptNum = runAttempts, @l_subOpType = subOpType FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @i_adminJobId
IF (@l_subOpType != 106 /*ARCHIVECHECK2*/)
	SET @l_useScalableResourceManagement = 0
DECLARE @dedupeValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE @opId INT = 0
SELECT  @opId = id
FROM    JMOpTable WITH (READUNCOMMITTED)
WHERE   operation=31 /*ARCHIVECHECK*/
SELECT   @dedupeValidate = phase
FROM    JMPhase WITH (READUNCOMMITTED)
WHERE   opTableId = @opId and name = 'Validate Dedupe Data'
SELECT   @orphanListing = phase
FROM    JMPhase WITH (READUNCOMMITTED)
WHERE   opTableId = @opId and name = 'Orphan Chunk listing'
SELECT   @defragment = phase
FROM    JMPhase WITH (READUNCOMMITTED)
WHERE   opTableId = @opId and name = 'Defragment Data'
DECLARE @l_allowDefragmentation INTEGER = 0
SET		@retVal = 0
SET		@allowBackup = 0
SET		@pickV11SP20MAs = 0
DECLARE @clientTable TABLE (ClientId INTEGER, PhysicalClientId INTEGER, ReleaseId INTEGER, SPMajor INTEGER, SPMinor INTEGER, DDBVerificationSupported INTEGER, UseScalableResourceOptionSupported INTEGER)
DECLARE @copyMountPathTable TABLE (archCopyId INTEGER, MountPathId INTEGER, MountPathTypeId INT, MountPathAttribute INT)
DECLARE @copyClientTable TABLE (archCopyId INTEGER, ClientId INTEGER, DeviceAccessType INTEGER)
DECLARE @storeClientTable TABLE (storeId INTEGER, subStoreId INTEGER, ClientId INTEGER)
/*
IF (@i_onAllVolumes = 0)
BEGIN
	INSERT INTO @copyMountPathTable(archCopyId, MountPathId, MountPathTypeId, MountPathAttribute)
	SELECT	DISTINCT V.archCopyId, MP.MountPathId, MP.MountPathTypeId, MP.Attribute
	FROM	archChunkToVerify V WITH (NOLOCK), MMVolume MV WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	V.adminJobId = @i_adminJobId
			AND	V.VolumeId = MV.VolumeId
			AND MV.MediaSideId = MP.MediaSideId
END
ELSE
*/
--BEGIN
	INSERT INTO @copyMountPathTable(archCopyId, MountPathId, MountPathTypeId, MountPathAttribute)
	SELECT	DISTINCT S.archGroupCopyId,  MP.MountPathId, MP.MountPathTypeId, MP.Attribute
	FROM	MMVolume MV WITH (NOLOCK), archStream S WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	MV.SIDBStoreId = @l_SIDBStoreId
			AND MV.MediaGroupId = S.MediaGroupId
			AND MV.MediaSideId = MP.MediaSideId
--END
IF ((@l_currentPhase = @defragment) AND
	EXISTS (SELECT 1 FROM @copyMountPathTable WHERE MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/))
BEGIN
IF EXISTS (SELECT TOP 1 1 FROM @copyMountPathTable MP WHERE MP.MountPathAttribute & 32 = 0 )
	BEGIN
		-- Micropruning is not enabled on cloud mount path
		SET		@retVal = 64
		GOTO CX_EXIT
	END
	DECLARE @iCopyId INT = (SELECT	CS.CopyId
							FROM	archCopySIDBStore CS WITH (READUNCOMMITTED)
									INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED)  ON CS.CopyId = AGC.id
							WHERE	CS.SIDBStoreId = @l_SIDBStoreId
AND AGC.dedupeFlags & 134217728 = 0)
	INSERT INTO @copyClientTable (archCopyId, ClientId, DeviceAccessType)
	SELECT	DISTINCT CV.archCopyId, C.ClientId, C.DeviceAccessType
	FROM	MMDataPath DPath WITH (READUNCOMMITTED)
			INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED)  ON DPool.DrivePoolId = DPath.DrivePoolId
			INNER JOIN  MMMountPath MP WITH (READUNCOMMITTED)   ON MP.MasterPoolId = DPool.MasterPoolId
			INNER JOIN @copyMountPathTable CV ON MP.MountPathId = CV.MountPathId
			INNER JOIN MMMountPathToStorageDevice SD WITH (NOLOCK) ON CV.MountPathId = SD.MountPathId
			INNER JOIN MMDeviceController C WITH (NOLOCK) ON SD.DeviceId = C.DeviceId AND DPool.ClientId = C.ClientId
	WHERE   DPath.CopyId = @iCopyId
AND MP.Attribute & 256 > 0
AND MP.Attribute & 32 > 0
AND DPath.flag & (/*MMS2_PREFERRED_PRUNER |*/ 64 | 4) = (/*MMS2_PREFERRED_PRUNER |*/ 64 | 4)
			AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	IF NOT EXISTS(SELECT 1 FROM @copyClientTable)
	BEGIN
		INSERT INTO @copyClientTable (archCopyId, ClientId, DeviceAccessType)
		SELECT DISTINCT CV.archCopyId, DC.ClientId, DC.DeviceAccessType
		FROM   MMDeviceController DC WITH (READUNCOMMITTED)
						INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED)  ON DC.DeviceId = MSD.DeviceId
						INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)  ON MSD.MountPathId = MP.MountPathId
						INNER JOIN @copyMountPathTable CV ON MP.MountPathId = CV.MountPathId
						INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED)  ON MP.MasterPoolId = DPool.MasterPoolId AND DPool.ClientId = DC.ClientId
						INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED)  ON DPool.DrivePoolId = DPath.DrivePoolId AND DPath.CopyId = @iCopyId
		WHERE
MP.Attribute & 256 = 0
AND MP.Attribute & 32 > 0
						AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
AND (DC.UseCount & 1) > 0
	END
	/*If the pruner MA not found in the datapath, go across all the MA configured on mountpaths*/
	IF NOT EXISTS(SELECT 1 FROM @copyClientTable)
	BEGIN
		INSERT INTO @copyClientTable (archCopyId, ClientId, DeviceAccessType)
		SELECT DISTINCT CV.archCopyId, DC.ClientId, DC.DeviceAccessType
		FROM   MMDeviceController DC WITH (READUNCOMMITTED)
						INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED)  ON DC.DeviceId = MSD.DeviceId
						INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)  ON MSD.MountPathId = MP.MountPathId
						INNER JOIN @copyMountPathTable CV ON MP.MountPathId = CV.MountPathId
						INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED)  ON MP.MasterPoolId = DPool.MasterPoolId AND DPool.ClientId = DC.ClientId
		WHERE
MP.Attribute & 256 = 0
AND MP.Attribute & 32 > 0
						AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
AND (DC.UseCount & 1) > 0
	END
	IF NOT EXISTS(SELECT 1 FROM @copyClientTable)
	BEGIN
		-- Cloud Pruner MA not found
		SET		@retVal = 16
		GOTO CX_EXIT
	END
	IF (@l_srcMediaAgentId > 0 AND NOT EXISTS (SELECT 1 FROM @copyClientTable WHERE ClientId = @l_srcMediaAgentId))
	BEGIN
		-- Source MA is not Cloud Pruner MA
		SET		@retVal = 32
		GOTO CX_EXIT
	END
END
ELSE
BEGIN
	INSERT INTO @copyClientTable (archCopyId, ClientId, DeviceAccessType)
	SELECT	DISTINCT CV.archCopyId, C.ClientId, C.DeviceAccessType
	FROM	@copyMountPathTable CV, MMMountPathToStorageDevice SD WITH (NOLOCK), MMDeviceController C WITH (NOLOCK)
	WHERE	CV.MountPathId = SD.MountPathId
			AND SD.DeviceId = C.DeviceId
END
INSERT INTO @storeClientTable (storeId, subStoreId, ClientId)
SELECT DISTINCT SIDBStoreId, SubStoreId, ClientId
FROM	IdxSIDBSubStore WITH (NOLOCK)
WHERE	SIDBStoreId = @l_SIDBStoreId
INSERT INTO @clientTable
SELECT DISTINCT ClientId, 0, 0, 0, 0, 0, 0
FROM	@copyClientTable
UNION
SELECT DISTINCT ClientId, 0, 0, 0, 0, 0, 0
FROM	@storeClientTable;
WITH ClientSPLevel AS (
        SELECT
            C.ClientId AS ClientId,
            CLIENT.ReleaseId AS ReleaseId,
            PKG.HighestSP AS SPMajor,
            PKG.SpMinorVersion AS SPMinor,
            ROW_NUMBER() OVER (PARTITION BY C.ClientId
            ORDER BY C.ClientId, CLIENT.ReleaseId, PKG.HighestSP, PKG.SpMinorVersion) AS RowNum
        FROM
			@clientTable C
			LEFT OUTER JOIN APP_VMToPMMap MAP WITH (NOLOCK) ON MAP.VMClientId = C.ClientId
			INNER JOIN SimInstalledPackages PKG WITH (NOLOCK) ON PKG.ClientId = ISNULL(MAP.PMClientId, C.ClientId)
			INNER JOIN APP_Client CLIENT WITH (NOLOCK) ON CLIENT.id = ISNULL(MAP.PMClientId, C.ClientId)
        WHERE
PKG.simPackageID in (51, 1301, 54, 1305))
UPDATE	@clientTable
SET		ReleaseId = SPL.ReleaseId,
		SPMajor = SPL.SPMajor,
		SPMinor = SPL.SPMinor
FROM	@clientTable C, ClientSPLevel SPL WITH (NOLOCK)
WHERE	SPL.RowNum = 1
		AND C.ClientId = SPL.ClientId
IF NOT EXISTS (SELECT * FROM @clientTable C WHERE ReleaseId < 15
												  OR (ReleaseId = 15 AND SPMajor < 14)
												  OR (ReleaseId = 16 AND SPMajor < 5))
	SET	@l_allowDefragmentation = 1
IF	EXISTS (SELECT * FROM @clientTable C, @copyClientTable S WHERE C.clientId = S.ClientId AND (ReleaseId < 16 OR (ReleaseId = 16 AND SPMajor < 20)))
	AND EXISTS (SELECT * FROM @clientTable C, @copyClientTable S WHERE C.clientId = S.ClientId AND (ReleaseId > 16 OR (ReleaseId = 16 AND SPMajor >= 20)))
BEGIN
	SET @pickV11SP20MAs = 1
END
IF (@l_srcMediaAgentId != 0)
BEGIN
	DELETE	FROM @copyClientTable
	WHERE	clientId != @l_srcMediaAgentId
			AND @l_prunerMediaAgentId = 0
	IF NOT EXISTS(SELECT TOP 1 ClientId
				FROM @copyClientTable)
	BEGIN
		SET		@retVal = 4
		GOTO CX_EXIT
	END
	IF (@pickV11SP20MAs = 1) AND (EXISTS (SELECT * FROM @clientTable C, @copyClientTable S WHERE C.ClientId = @l_srcMediaAgentId AND C.clientId = S.ClientId AND (ReleaseId < 16 OR (ReleaseId = 16 AND SPMajor < 20))))
	BEGIN
		SET		@retVal = 5
		GOTO CX_EXIT
	END
END
UPDATE  C
SET		DDBVerificationSupported = (CASE
										WHEN ReleaseId > 15 THEN 2
										WHEN ReleaseId = 15 AND SPMajor > 6 THEN 1
										WHEN ReleaseId = 15 AND SPMajor = 6 AND SPMinor >= 2 THEN 1
										ELSE 0
									END),
		UseScalableResourceOptionSupported = (CASE
												WHEN ReleaseId > 16 THEN 1
												WHEN ReleaseId = 16 AND SPMajor >= 22 THEN 1
												ELSE 0
											  END)
FROM	@clientTable C
IF (@l_useScalableResourceManagement > 0)
	AND NOT EXISTS (SELECT TOP 1 1
					FROM	@copyClientTable CP, @clientTable C
					WHERE	CP.ClientId = C.ClientId
							AND UseScalableResourceOptionSupported = 1)
BEGIN
	SET		@retVal = 8
	GOTO CX_EXIT
END
IF	NOT EXISTS (SELECT * FROM @clientTable C, @storeClientTable S WHERE C.clientId = S.ClientId AND DDBVerificationSupported < 2)
	AND EXISTS (SELECT * FROM @clientTable C, @copyClientTable S WHERE C.clientId = S.ClientId AND DDBVerificationSupported = 2)
BEGIN
	SET @allowBackup = 1
END
-- MR 169245, During orphan chunk listing  and defrag phase do not use IP/SAN/iSCSI MAs
IF (@l_currentPhase IN (@orphanListing, @defragment) AND @l_currentAttemptNum = 1 AND EXISTS (SELECT * FROM @copyClientTable C WHERE C.DeviceAccessType & (16|32|128) > 0))
BEGIN
	DELETE FROM	JMJobOptions
	WHERE	jobId = @i_adminJobId
			AND commCellId = 2
AND attributeId = 41
END
-- if it was populated once, still need to calculate allowBackup
IF EXISTS ( SELECT	*
			FROM	JMJobOptions WITH (NOLOCK)
			WHERE	jobId = @i_adminJobId
					AND commCellId = 2
AND attributeId = 41)
BEGIN
	SET		@retVal = 0
	GOTO CX_EXIT
END
-- There is atleast one copy without all its MAs patched
IF EXISTS ( SELECT	archCopyId, SUM(C.DDBVerificationSupported)
			FROM	@copyClientTable CP, @clientTable C
			WHERE	CP.ClientId = C.ClientId
			GROUP BY archCopyId
			HAVING SUM(C.DDBVerificationSupported) = 0)
	SET @retVal = 1
-- There is atleast one substore without its MA patched
IF EXISTS (	SELECT	subStoreId, SUM(C.DDBVerificationSupported)
			FROM	@storeClientTable CP, @clientTable C
			WHERE	CP.ClientId = C.ClientId
			GROUP BY subStoreId
			HAVING SUM(C.DDBVerificationSupported) = 0)
	SET @retVal |= 2
-- Populate the media agent list only if
IF (@retVal = 0
	-- if source media agent not selected
	AND (@l_srcMediaAgentId = 0 OR ((@l_currentPhase = @defragment) AND (@l_prunerMediaAgentId > 0)))
	-- if there is at least one unpatched mediaagent exist
	AND ( EXISTS (SELECT *
				FROM	@copyClientTable CP, @clientTable C
				WHERE	CP.ClientId = C.ClientId
						AND (C.DDBVerificationSupported = 0 OR ((@l_useScalableResourceManagement > 0) AND c.UseScalableResourceOptionSupported = 0)))
		OR (@allowBackup = 1 AND EXISTS (SELECT * FROM @clientTable C, @copyClientTable S WHERE C.clientId = S.ClientId AND DDBVerificationSupported < 2))
OR ((@l_currentPhase IN (@orphanListing, @defragment) AND @l_currentAttemptNum = 1) AND EXISTS (SELECT * FROM @copyClientTable C WHERE C.DeviceAccessType & (16|32|128) > 0))
		OR ((@l_currentPhase = @defragment) AND EXISTS (SELECT 1 FROM @copyMountPathTable WHERE MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/))
		OR (@pickV11SP20MAs = 1)
		)
	)
BEGIN
	IF (@l_currentPhase IN (@orphanListing, @defragment) AND @l_currentAttemptNum = 1)
	BEGIN
		DELETE	@copyClientTable
WHERE	DeviceAccessType & (16|32|128) > 0
	END
	IF (@l_useScalableResourceManagement > 0)
	BEGIN
		DELETE	CP
		FROM	@copyClientTable CP, @clientTable C
		WHERE	CP.ClientId = C.ClientId
				AND UseScalableResourceOptionSupported = 0
	END
	IF (@pickV11SP20MAs = 1)
	BEGIN
		INSERT INTO JMJobOptions
SELECT	DISTINCT @i_adminJobId, 2, 41, 'Updated MediaAgent for DDB based Data Verification Job', CP.ClientId, ''
		FROM	@clientTable C, @copyClientTable CP
		WHERE	C.clientId = CP.ClientId
				AND (ReleaseId > 16 OR (ReleaseId = 16 AND SPMajor >= 20))
	END
	ELSE IF (@allowBackup = 1)
		INSERT INTO JMJobOptions
SELECT	DISTINCT @i_adminJobId, 2, 41, 'Updated MediaAgent for DDB based Data Verification Job', CP.ClientId, ''
		FROM	@copyClientTable CP, @clientTable C
		WHERE	CP.ClientId = C.ClientId
				AND C.DDBVerificationSupported = 2
	ELSE
		INSERT INTO JMJobOptions
SELECT	DISTINCT @i_adminJobId, 2, 41, 'Updated MediaAgent for DDB based Data Verification Job', CP.ClientId, ''
		FROM	@copyClientTable CP, @clientTable C
		WHERE	CP.ClientId = C.ClientId
				AND C.DDBVerificationSupported >= 1
END
CX_EXIT:
	SELECT @retVal, @allowBackup, @l_allowDefragmentation, @pickV11SP20MAs
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyPopulateMAsForDDBDataVerification')
	delete from GxQscripts where name = 'archChunkToVerifyPopulateMAsForDDBDataVerification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyPopulateMAsForDDBDataVerification')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyPopulateMAsForDDBDataVerification'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyPopulateMAsForDDBDataVerification',  '00010006001200170000', 'archChunkToVerifyPopulateMAsForDDBDataVerification', '00010006001200170000')
GO

