

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyIsOrphanChunkPruningAllowed.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archChunkToVerifyIsOrphanChunkPruningAllowed.sp            */
/*                                                                            */
/*  Description :  Stored procedure to get OCL flags for store		          */
/*				   						      								  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyIsOrphanChunkPruningAllowed.sp,v $ $Id: archChunkToVerifyIsOrphanChunkPruningAllowed.sp,v 1.1.6.5 2020/06/11 20:10:59 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerifyIsOrphanChunkPruningAllowed')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyIsOrphanChunkPruningAllowed <<<'
	drop procedure archChunkToVerifyIsOrphanChunkPruningAllowed
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyIsOrphanChunkPruningAllowed')
	delete from GxQscripts where name = 'archChunkToVerifyIsOrphanChunkPruningAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyIsOrphanChunkPruningAllowed')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyIsOrphanChunkPruningAllowed'
GO
print '... Creating Procedure: archChunkToVerifyIsOrphanChunkPruningAllowed'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerifyIsOrphanChunkPruningAllowed
  @i_sidbStoreId INTEGER,
  @i_adminJobId INTEGER
AS
  DECLARE @o_allowed INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	SET @o_allowed = 1 -- 0 - Not Allowed, 1 - Allowed As user selected option, 2 - Allowed after a full recon job
	DECLARE @l_lastFullReconJobId INTEGER = 0
	DECLARE @l_OCLFlags INTEGER = 0
	DECLARE @l_enableOCLJobOption INTEGER = ISNULL(dbo.GetOptionBool(1274956820/*ARCHIVECHECKOPTION_OCL*/, @i_adminJobId, 0, 0), 0)
	BEGIN TRY
		IF (@l_enableOCLJobOption = 0)
		BEGIN
			SELECT	@l_OCLFlags = CAST(value AS INT)
			FROM	GXGlobalParam
			WHERE	name = 'EnableOrphanChunkListing'
if ((@l_OCLFlags & 0x2) > 0)
			BEGIN
				SELECT	@l_lastFullReconJobId = MAX(AdminJobId)
				FROM	IdxSIDBRecoveryHistory WITH (READUNCOMMITTED)
				WHERE	SIDBStoreId = @i_sidbStoreId
AND (flags & 4) > 0
						AND Status IN (1, 3, 14)
				IF  ( (@l_lastFullReconJobId = 0)
					OR NOT EXISTS (	SELECT TOP 1 AdminJobID
								FROM	IdxSIDBRecoveryHistory WITH (READUNCOMMITTED)
								WHERE	AdminJobId = @l_lastFullReconJobId
AND (flags & (8) = 0)) )
					SET	@o_allowed = 0
				ELSE
					SET @o_allowed = 2
			END
			ELSE
			BEGIN
				SET	@o_allowed = 0
			END
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		;THROW
	END CATCH
	SELECT	@o_allowed
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyIsOrphanChunkPruningAllowed')
	delete from GxQscripts where name = 'archChunkToVerifyIsOrphanChunkPruningAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyIsOrphanChunkPruningAllowed')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyIsOrphanChunkPruningAllowed'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyIsOrphanChunkPruningAllowed',  '00010001000600050000', 'archChunkToVerifyIsOrphanChunkPruningAllowed', '00010001000600050000')
GO

