

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyIsDDBVerificationLevelAllowed.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archChunkToVerifyIsDDBVerificationLevelAllowed.sp                */
/*                                                                            */
/*  Description :  Stored procedure to check if Store is eligible		      */
/*				   DDB Verification or DDB AND Data Verification  			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyIsDDBVerificationLevelAllowed.sp,v $ $Id: archChunkToVerifyIsDDBVerificationLevelAllowed.sp,v 1.1.4.2 2019/02/07 14:37:55 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerifyIsDDBVerificationLevelAllowed')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyIsDDBVerificationLevelAllowed <<<'
	drop procedure archChunkToVerifyIsDDBVerificationLevelAllowed
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyIsDDBVerificationLevelAllowed')
	delete from GxQscripts where name = 'archChunkToVerifyIsDDBVerificationLevelAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyIsDDBVerificationLevelAllowed')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyIsDDBVerificationLevelAllowed'
GO
print '... Creating Procedure: archChunkToVerifyIsDDBVerificationLevelAllowed'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerifyIsDDBVerificationLevelAllowed
  @i_sidbStoreId INTEGER,
  @i_archCopyId INTEGER,
  @i_archCheckDDBOption INTEGER
AS
  DECLARE @o_allowed INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	SET @o_allowed = 1
	BEGIN TRY
		IF EXISTS
			(
				SELECT 	1
				FROM 	archGroupCopy AGC WITH (NOLOCK)
						INNER JOIN MMDataPath M WITH (NOLOCK) ON AGC.id = M.CopyId
						INNER JOIN MMDrivePool D WITH (NOLOCK) ON M.DrivePoolId = D.DrivePoolId
						INNER JOIN MMMountPath P WITH (NOLOCK) ON D.MasterPoolId = P.MasterPoolId
				WHERE 	AGC.id = @i_archCopyId AND P.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
				UNION
				SELECT	1
				FROM	archGroupCopy AGC WITH (NOLOCK)
						INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId = AG.id
				WHERE	AGC.id = @i_archCopyId
AND (AG.flags & 33554432) > 0
			)
			AND NOT EXISTS
			(
				SELECT	1
				FROM	MMConfigs
				WHERE	name = 'MMCONFIG_ALWAYS_ALLOW_DDB_VERIFICATION_JOB'
						AND Value = 1
			)
		BEGIN
			SET @o_allowed = 0
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		;THROW
	END CATCH
	SELECT	@o_allowed
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyIsDDBVerificationLevelAllowed')
	delete from GxQscripts where name = 'archChunkToVerifyIsDDBVerificationLevelAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyIsDDBVerificationLevelAllowed')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyIsDDBVerificationLevelAllowed'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyIsDDBVerificationLevelAllowed',  '00010001000400020000', 'archChunkToVerifyIsDDBVerificationLevelAllowed', '00010001000400020000')
GO

