

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyInsert.sp,v $ $Id: archChunkToVerifyInsert.sp,v 1.34.2.39.4.1 2021/03/12 09:01:27 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archChunkToVerifyInsert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyInsert <<<'
	drop procedure archChunkToVerifyInsert
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyInsert')
	delete from GxQscripts where name = 'archChunkToVerifyInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyInsert')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyInsert'
GO
print '... Creating Procedure: archChunkToVerifyInsert'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archChunkToVerifyInsert
  @i_adminJobId int,
  @i_archCopyId int,
  @i_mediaId int,
  @i_checkFlags int,
  @i_copyIdList VARCHAR(MAX) = '',
  @i_isIncr int = 0,
  @i_notPickNewData int,
  @i_deleteOnly int
AS
  DECLARE @retVal integer;
  DECLARE @numChunksAdded integer;
  DECLARE @totalChunksNeeded integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION
SET	@retVal = 0
SET @numChunksAdded = 0
SET @totalChunksNeeded = 0
DECLARE @MaxChunksPerBatch INT = 0
DECLARE @JMDVFlag INT = 0
SELECT	@JMDVFlag = intData
FROM	JMMisc
WHERE	jobId = @i_adminJobId
AND commCellId = 2
AND itemType = 78
DECLARE @CopyIdTable TABLE(CopyId INT)
DECLARE	@oneConstReal REAL = 1.0
DECLARE @l_SIDBStoreId INTEGER = ISNULL(dbo.GetOptionInt(229570007, @i_adminJobId, 0, 0), 0)
DECLARE @l_ddbVerificationLevel INTEGER = ISNULL(dbo.GetOptionInt(1616894445, @i_adminJobId, 0, 0), 0)
DECLARE @l_jobStartTime INTEGER = (SELECT servStart FROM JMAdminJobInfoTable WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
DECLARE @l_currentPhase INTEGER = (SELECT currentPhase FROM JMJobInfo WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
DECLARE @l_endTime INT = 0x7FFFFFFF
DECLARE @l_currentTime INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @l_totalSize bigint = 0
DECLARE @l_jobsFromTime INTEGER = ISNULL(dbo.GetOptionInt(1802027523, @i_adminJobId, 0, 0), 0)
DECLARE @l_jobsToTime INTEGER = ISNULL(dbo.GetOptionInt(458275378, @i_adminJobId, 0, 0), 0)
DECLARE @dedupeValidate INT = 0
DECLARE @dataValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE	@opId INT = 0
IF object_id('tempdb.dbo.#tempJobsToProcess') IS NOT null DROP TABLE #tempJobsToProcess
CREATE TABLE #tempJobsToProcess (archCopyId INTEGER, jobId INTEGER PRIMARY KEY(archCopyId, jobId))
IF object_id('tempdb.dbo.#tmpAgedChunks') IS NOT null DROP TABLE #tmpAgedChunks
CREATE TABLE #tmpAgedChunks (archFileId INTEGER, commCellId INTEGER, archChunkId BIGINT)
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	@dedupeValidate = [Validate Dedupe Data],
		@dataValidate =  [Verify Data],
		@orphanListing = [Orphan Chunk listing],
		@defragment = [Defragment Data]
FROM
	(SELECT	phase, name
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId) AS JP
	PIVOT
	(
	MAX(phase)
	FOR name IN ([Validate Dedupe Data], [Verify Data], [Orphan Chunk listing], [Defragment Data])
	) p;
IF  (@l_currentPhase = @dataValidate)
BEGIN
	SELECT  @MaxChunksPerBatch = value
	FROM	MMConfigs
	WHERE	name = 'MMCONFIG_DV_MAX_CHUNKS_PER_BATCH'
END
IF @i_archCopyId > 0
BEGIN
	WHILE 1 = 1
	BEGIN
		IF (@MaxChunksPerBatch = 0)
		BEGIN
			DELETE TOP (10000)
			FROM archChunkToVerify
			WHERE archCopyId = @i_archCopyId
		END
		ELSE
		BEGIN
			DELETE TOP (10000) V
			FROM archChunkToVerify V LEFT OUTER JOIN JMJobInfo J WITH (READUNCOMMITTED) ON J.JobId = V.adminJobId
			WHERE archCopyId = @i_archCopyId
					AND J.JobID IS NULL
		END
		IF @@ROWCOUNT = 0
			BREAK
	END
IF (((@JMDVFlag & 1) = 0) AND (@MaxChunksPerBatch > 0) AND (@l_currentPhase = @dataValidate))
	BEGIN
		WHILE 1 = 1
		BEGIN
			DELETE TOP (10000) V
			FROM	archChunkToVerifyHistory V
			WHERE	adminJobId = @i_adminJobId
					-- AND archCopyId = @i_archCopyId
			IF @@ROWCOUNT = 0
				BREAK
		END
	END
	if @i_deleteOnly > 0
		GOTO FINISH
END
DECLARE @mpAffinityEnabled INT = 0
DECLARE @smallSegment INT = 0
DECLARE @maxStreamForValidation int = 0
DECLARE @topHint bigint =  CAST(0x7FFFFFFFFFFFFFFF AS bigint)
DECLARE @l_xmlLastPopulatedJobIdList XML = NULL
DECLARE @l_lastPopulatedJobId INTEGER = 0
DECLARE @maxVolumeId INT = 2147483647
DECLARE @totalRowCount INT = 0
DECLARE @CurrentRowCount INT = 0
IF object_id('tempdb.dbo.#tblVolume') IS NOT null DROP TABLE #tblVolume
CREATE TABLE #tblVolume (VolumeId INT, MediaId INT, MediaGroupId INT PRIMARY KEY (VolumeId) )
IF object_id('tempdb.dbo.#tblAC') IS NOT null DROP TABLE #tblAC
CREATE TABLE #tblAC (archChunkId INT, chunkCommCellId INT, flags INT, createTime INT, VolumeId INT,  MediaId INT, MediaGroupId INT  PRIMARY KEY (archChunkId, chunkCommCellId) )
IF @MaxChunksPerBatch > 0
BEGIN
	SET @topHint = @MaxChunksPerBatch
	SELECT  @l_xmlLastPopulatedJobIdList = CAST(attributeValue AS XML)
	FROM    JMJobOptions WITH (READUNCOMMITTED)
	WHERE   jobId = @i_adminJobId
			AND CommCellId = 2
AND attributeId = 90
	IF (@l_xmlLastPopulatedJobIdList IS NOT NULL)
	BEGIN
		INSERT INTO #tempJobsToProcess
		SELECT  Jobs.Node.value('@cp', 'INTEGER') archCopyId,
				Jobs.Node.value('@j', 'INTEGER') jobId
		FROM    @l_xmlLastPopulatedJobIdList.nodes('//JobIds/I') Jobs(Node)
		SELECT  @l_lastPopulatedJobId = T.jobId
		FROM    #tempJobsToProcess T
		WHERE   T.archCopyId = @i_archCopyId
	END
END
IF @l_currentPhase IN (@dedupeValidate, @orphanListing, @defragment)
BEGIN
	SET @smallSegment = 1
	SELECT @maxStreamForValidation = value FROM MMConfigs WHERE name = 'MMCONFIG_THREAD_COUNT_DURING_VALIDATE_DDB'
	IF @l_currentPhase IN (@dedupeValidate, @defragment)
		SET @totalChunksNeeded = 5 * @maxStreamForValidation
	ELSE IF @l_currentPhase = @orphanListing
		SET @totalChunksNeeded = @maxStreamForValidation
	SET @topHint = @totalChunksNeeded
END
ELSE
BEGIN --set this only during data validate phase
	SELECT @mpAffinityEnabled = value FROM MMConfigs WHERE name = 'MMCONFIG_ENABLE_MP_AFFINITY_FOR_DATA_VERIFICATION'
END
IF @i_notPickNewData > 0
	SET @l_endTime = @l_jobStartTime
IF (LEN(@i_copyIdList) > 0)
BEGIN
	INSERT INTO @CopyIdTable
	SELECT DISTINCT _ID
	FROM	dbo.SplitIDs(@i_copyIdList)
END
IF @i_mediaId > 0
BEGIN
  WHILE 1 = 1
	BEGIN
		IF (@MaxChunksPerBatch = 0)
		BEGIN
			DELETE TOP (10000) AV
			FROM archChunkToVerify AV, @CopyIdTable C
			WHERE AV.archCopyId = C.CopyId
			AND AV.adminJobId <> @i_adminJobId
		END
		ELSE
		BEGIN
			DELETE TOP (10000) AV
			FROM archChunkToVerify AV LEFT OUTER JOIN JMJobInfo J WITH (READUNCOMMITTED) ON J.JobId = AV.adminJobId, @CopyIdTable C
			WHERE AV.archCopyId = C.CopyId
			AND J.JobId IS NULL
		END
      IF @@ROWCOUNT = 0
	 		   BREAK
  END
  WHILE 1 = 1
	BEGIN
		IF (@MaxChunksPerBatch = 0)
		BEGIN
			DELETE TOP (10000)
			FROM archChunkToVerify
			WHERE MediaId = @i_mediaId
		END
		ELSE
		BEGIN
			DELETE TOP (10000) V
			FROM archChunkToVerify V LEFT OUTER JOIN JMJobInfo J WITH (READUNCOMMITTED) ON J.JobId = V.adminJobId
			WHERE V.MediaId = @i_mediaId
					AND J.JobId IS NULL
		END
		  IF @@ROWCOUNT = 0
			  BREAK
  END
END
IF ((@MaxChunksPerBatch > 0) AND (@l_currentPhase = @dataValidate))
BEGIN
	DELETE  V
	OUTPUT  DELETED.archFileId, DELETED.commCellId, DELETED.archChunkId INTO #tmpAgedChunks
	FROM	archChunkToVerify V
			INNER JOIN MMVolume MV WITH (READUNCOMMITTED)
				ON V.VolumeId = MV.VolumeId
			LEFT OUTER JOIN archChunkMapping ACM WITH (READUNCOMMITTED)
				ON	ACM.archChunkId = V.archChunkId
					AND ACM.archFileId = V.archFileId
					AND ACM.commCellId = V.commCellId
					AND ACM.chunkCommCellId = MV.origCCcommCellID
					AND ACM.archCopyId = V.archCopyId
AND (ACM.flags & 256) = 0
	WHERE	V.adminJobId = @i_adminJobId
			AND ACM.archChunkId IS NULL
	IF @@ROWCOUNT > 0
	BEGIN
		CREATE CLUSTERED INDEX tmpAgedChunks_archFileId_commCellId_archChunkId_Idx ON #tmpAgedChunks (archFileId, commCellId, archChunkId)
		UPDATE	VH
SET		extraFlags |= 4
		FROM	archChunkToVerifyHistory VH WITH (READUNCOMMITTED)
				INNER JOIN #tmpAgedChunks ACM WITH (READUNCOMMITTED)
					ON	ACM.archChunkId = VH.archChunkId
						AND ACM.archFileId = VH.archFileId
						AND ACM.commCellId = VH.commCellId
		WHERE	VH.adminJobId = @i_adminJobId
AND (VH.extraFlags & (1 | 2 | 4)) = 0
		IF object_id('tempdb.dbo.#tmpAgedChunks') IS NOT null DROP TABLE #tmpAgedChunks
	END
END
IF @i_mediaId > 0
BEGIN
	IF (@MaxChunksPerBatch = 0)
	BEGIN
		INSERT INTO archChunkToVerify
		SELECT	@i_adminJobId, 0, 0, a.archChunkId, a.archFileId, a.commCellId, a.archCopyId, 0, 0, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize, b.volumeId, @i_mediaId, b.MediaGroupId,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, 0, 0, a.unCompSize, 0
		FROM	archChunkMapping a WITH (READUNCOMMITTED),
				(SELECT AC.*, V.MediaGroupId FROM archChunk AC WITH (READUNCOMMITTED),
					(SELECT VolumeId, MediaGroupId FROM MMVolume WITH (READUNCOMMITTED) WHERE MediaId = @i_mediaId) V WHERE AC.volumeId = V.VolumeId) b,
				@CopyIdTable c, archGroupCopy d WITH (READUNCOMMITTED),
				( SELECT archGrpCopyId, commCellId, jobId, MAX(copiedTime) endTime
					FROM JMJobDataStats J WITH (READUNCOMMITTED),  @CopyIdTable  C
					WHERE J.archgrpCopyId = C.CopyId
AND J.disabled & 256 = 0
					AND J.archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
					GROUP BY J.archGrpCopyId, J.commCellId, J.jobId ) e
		WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
			AND((@l_jobsFromTime = 0 AND @l_jobsToTime = 0) OR  e.endTime BETWEEN @l_jobsFromTime AND @l_jobsToTime)
			AND d.id = a.archCopyId
			AND e.jobId = a.jobId AND e.commCellId = a.commCellId AND e.archgrpCopyId = a.archCopyId
AND (a.flags & @i_checkFlags) <> 0 AND (a.flags & 256) = 0
			AND a.physicalSize > 0
			AND e.endTime < @l_endTime
			AND a.archCopyId = c.CopyId
	END
	ELSE
	BEGIN
		INSERT INTO archChunkToVerify
		SELECT	TOP (@topHint)  @i_adminJobId, 0, 0, a.archChunkId, a.archFileId, a.commCellId, a.archCopyId, 0, 0, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize, b.volumeId, @i_mediaId, b.MediaGroupId,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, 0, 0, a.unCompSize, 0
		FROM	archChunkMapping a WITH (READUNCOMMITTED)
					LEFT OUTER JOIN archChunkToVerify V WITH (READUNCOMMITTED) ON
							a.archChunkId = V.archChunkId AND a.archFileId = V.archFileId AND a.commCellId = V.commCellId AND a.archCopyId = V.archCopyId AND V.adminJobId = @i_adminJobId
					LEFT OUTER JOIN archChunkToVerifyHistory VH WITH (READUNCOMMITTED) ON
							a.archChunkId = VH.archChunkId AND a.archFileId = VH.archFileId AND a.commCellId = VH.commCellId AND a.archCopyId = VH.archCopyId AND VH.adminJobId = @i_adminJobId,
				(SELECT AC.*, V.MediaGroupId FROM archChunk AC WITH (READUNCOMMITTED),
					(SELECT VolumeId, MediaGroupId FROM MMVolume WITH (READUNCOMMITTED) WHERE MediaId = @i_mediaId) V WHERE AC.volumeId = V.VolumeId) b,
				@CopyIdTable c, archGroupCopy d WITH (READUNCOMMITTED),
				( SELECT archGrpCopyId, commCellId, jobId, MAX(copiedTime) endTime
					FROM JMJobDataStats J WITH (READUNCOMMITTED),  @CopyIdTable  C
					WHERE J.archgrpCopyId = C.CopyId
AND J.disabled & 256 = 0
					AND J.archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
					GROUP BY J.archGrpCopyId, J.commCellId, J.jobId ) e
		WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
			AND((@l_jobsFromTime = 0 AND @l_jobsToTime = 0) OR  e.endTime BETWEEN @l_jobsFromTime AND @l_jobsToTime)
			AND d.id = a.archCopyId
			AND e.jobId = a.jobId AND e.commCellId = a.commCellId AND e.archgrpCopyId = a.archCopyId
			AND (e.endTime < @l_endTime OR VH.adminJobId IS NOT NULL)
AND (a.flags & @i_checkFlags) <> 0 AND (a.flags & 256) = 0
			AND a.physicalSize > 0
			AND a.archCopyId = c.CopyId
			AND V.archChunkId IS NULL
AND (VH.archChunkId IS NULL OR (VH.extraFlags & (1 | 2 | 4)) = 0)
	END
	SELECT @retVal = @@ERROR, @numChunksAdded = @@ROWCOUNT
	IF  @retVal <> 0 GOTO FINISH
	UPDATE	archChunkToVerify
	SET		streamNum = b.streamNum, archFileCopyFlags = b.flags, lastChunkNumber = b.lastChunkNumber
	FROM	archChunkToVerify a, archFileCopy b WITH (READUNCOMMITTED)
	WHERE	a.adminJobId = @i_adminJobId AND a.mediaId = @i_mediaId
		AND b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.archCopyId
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	UPDATE	archChunkToVerify
	SET		fileType = b.fileType, appId = b.appId, backupJobId = b.jobId
	FROM	archChunkToVerify a, archFile b WITH (READUNCOMMITTED)
	WHERE	a.adminJobId = @i_adminJobId AND a.mediaId = @i_mediaId
		AND a.archFileId = b.id AND a.commCellId = b.commCellId
END
ELSE
IF @i_mediaId = 0 AND @l_SIDBStoreId = 0 AND @i_archCopyId > 0
BEGIN
	IF (@MaxChunksPerBatch = 0)
	BEGIN
		INSERT INTO archChunkToVerify
		SELECT	@i_adminJobId, 0, 0, a.archChunkId, a.archFileId, a.commCellId, a.archCopyId, 0, 0, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize, b.volumeId, 0, 0,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, 0, 0, a.unCompSize, 0
		FROM	(SELECT ACM.* FROM archChunkMapping ACM WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED), ( SELECT archGrpCopyId, commCellId, jobId, MAX(copiedTime) endTime
					FROM JMJobDataStats WITH (READUNCOMMITTED)
WHERE archgrpCopyId = @i_archCopyId AND disabled & 256 = 0
					AND archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
					GROUP BY archGrpCopyId, commCellId, jobId ) JBS
			WHERE ACM.archCopyId = @i_archCopyId
				AND AGC.id = ACM.archCopyId
				AND JBS.jobId = ACM.jobId AND JBS.commCellId = ACM.commCellId AND JBS.archgrpCopyId = ACM.archCopyId
AND ACM.physicalSize > 0 AND (ACM.flags & @i_checkFlags) <> 0 AND (ACM.flags & 256) = 0
				AND JBS.endTime < @l_endTime
				AND		((@l_jobsFromTime = 0 AND @l_jobsToTime = 0) OR  JBS.endTime BETWEEN @l_jobsFromTime AND @l_jobsToTime)
				) a,
				archChunk b WITH (READUNCOMMITTED ), MMVolume MV WITH (READUNCOMMITTED)
		WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
		AND		b.volumeId = MV.volumeId
	END
	ELSE
	BEGIN
		INSERT INTO archChunkToVerify
		SELECT	TOP (@topHint) @i_adminJobId, 0, 0, a.archChunkId, a.archFileId, a.commCellId, a.archCopyId, 0, 0, 0, 0,
				a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize, b.volumeId, 0, 0,
				b.fileMarkerNo,	b.createTime, b.version, b.physicalSize, b.logicalSize, b.hwEncKey, 0, 0, a.unCompSize, 0
		FROM	(SELECT ACM.* FROM archChunkMapping ACM WITH (READUNCOMMITTED)
					LEFT OUTER JOIN archChunkToVerify V WITH (READUNCOMMITTED) ON
							ACM.archChunkId = V.archChunkId AND ACM.archFileId = V.archFileId AND ACM.commCellId = V.commCellId AND ACM.archCopyId = V.archCopyId AND V.adminJobId = @i_adminJobId
					LEFT OUTER JOIN archChunkToVerifyHistory VH WITH (READUNCOMMITTED) ON
							ACM.archChunkId = VH.archChunkId AND ACM.archFileId = VH.archFileId AND ACM.commCellId = VH.commCellId AND ACM.archCopyId = VH.archCopyId AND VH.adminJobId = @i_adminJobId,
					archGroupCopy AGC WITH (READUNCOMMITTED),
					( SELECT archGrpCopyId, commCellId, jobId, MAX(copiedTime) endTime
					FROM JMJobDataStats WITH (READUNCOMMITTED)
WHERE archgrpCopyId = @i_archCopyId AND disabled & 256 = 0
					AND archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
					GROUP BY archGrpCopyId, commCellId, jobId
					) JBS
			WHERE ACM.archCopyId = @i_archCopyId
				AND AGC.id = ACM.archCopyId
				AND JBS.jobId = ACM.jobId AND JBS.commCellId = ACM.commCellId AND JBS.archgrpCopyId = ACM.archCopyId
				AND (JBS.endTime < @l_endTime OR VH.adminJobId IS NOT NULL)
AND ACM.physicalSize > 0 AND (ACM.flags & @i_checkFlags) <> 0 AND (ACM.flags & 256) = 0
				AND		((@l_jobsFromTime = 0 AND @l_jobsToTime = 0) OR  JBS.endTime BETWEEN @l_jobsFromTime AND @l_jobsToTime)
				AND V.archChunkId IS NULL
AND (VH.archChunkId IS NULL OR (VH.extraFlags & (1 | 2 | 4)) = 0)
				) a,
				archChunk b WITH (READUNCOMMITTED ), MMVolume MV WITH (READUNCOMMITTED)
		WHERE	b.id = a.archChunkId AND b.commCellId = a.chunkCommCellId
		AND		b.volumeId = MV.volumeId
	END
	SELECT @retVal = @@ERROR, @numChunksAdded = @@ROWCOUNT
	IF  @retVal <> 0 GOTO FINISH
	UPDATE	archChunkToVerify
	SET		streamNum = b.streamNum, archFileCopyFlags = b.flags, lastChunkNumber = b.lastChunkNumber
	FROM	archChunkToVerify a, archFileCopy b WITH (READUNCOMMITTED)
	WHERE	a.adminJobId = @i_adminJobId AND a.archCopyId = @i_archCopyId AND b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = @i_archCopyId
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	UPDATE	archChunkToVerify
	SET		fileType = b.fileType, appId = b.appId, backupJobId = b.jobId
	FROM	archChunkToVerify a, archFile b WITH (READUNCOMMITTED)
	WHERE	a.adminJobId = @i_adminJobId AND a.archCopyId = @i_archCopyId AND a.archFileId = b.id AND a.commCellId = b.commCellId
END
ELSE
IF (@l_SIDBStoreId > 0) AND @i_archCopyId > 0
BEGIN
	-- Skip Defragment phase where no chunks are eligible for degragmentation
    SELECT @l_totalSize = attributeValueInt
	FROM JMJobOptions WITH (READUNCOMMITTED)
    WHERE jobId = @i_adminJobId AND commcellId = 2
AND attributeId = 54
	IF (@l_ddbVerificationLevel = 4 /*TMMsg::DDBVerificationLevel_ DDB_DEFRAGMENTATION*/ AND @@ROWCOUNT > 0)
	BEGIN
		IF EXISTS (SELECT * FROM JMJobInfo WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND CommCellId = 2 AND currentPhase = @defragment /*DEFRAGMENT*/)
		BEGIN
			IF (@l_totalSize > 0)
			BEGIN
				UPDATE	MountP
SET		Attribute = Attribute | 512
				FROM	(SELECT DISTINCT MediaSideId FROM MMVolume WITH (READUNCOMMITTED) WHERE SIDBStoreId = @l_SIDBStoreId) AS V,
						MMMountPath MountP WITH (READUNCOMMITTED)
WHERE	MountP.MediaSideId = V.MediaSideId AND (MountP.Attribute & 512) = 0
			END
			ELSE
			BEGIN
				-- Do not populate any chunks if there is nothing to defrag
				GOTO FINISH
			END
		END
	END
	-- Populate all chunks of store id and copy id
	-- Populate chunks created before the job start time
	-- Populate chunks that are not aged and has some data
	DECLARE @chunkCreateTime BIGINT = 0
	DECLARE @returnTable TABLE (retVal INTEGER, allowBackup INTEGER, allowDefragmentation INTEGER, pickV11SP20MAs INTEGER)
	IF (@l_ddbVerificationLevel IN (1, 2, 3) /* QUICK_DDB_VERIFICATION, DDB_VERIFICATION, DDB_AND_DATA_VERIFICATION*/)
	BEGIN
		INSERT INTO @returnTable
		EXEC archChunkToVerifyPopulateMAsForDDBDataVerification @i_adminJobId, 1
		IF (@l_currentPhase = @dedupeValidate/*DEDUPVALIDATE*/)
		BEGIN
			IF (EXISTS(SELECT * FROM @returnTable WHERE allowBackup = 0) OR (@i_isIncr = 0))
			BEGIN
				SELECT @chunkCreateTime = 0
			END
			ELSE
				SELECT @chunkCreateTime = (CASE WHEN (@l_ddbVerificationLevel = 2) THEN LastDDBVerificationTime ELSE LastDataVerificationTime END)
				FROM	IdxSIDBStore I WITH (READUNCOMMITTED)
				WHERE	I.SIDBStoreId = @l_SIDBStoreId
		END
		ELSE
			SELECT @chunkCreateTime =  CASE WHEN @l_ddbVerificationLevel = 1 THEN CASE WHEN LastDataVerificationTime > LastQuickDDBVerificationTime AND @i_isIncr = 1 THEN LastDataVerificationTime ELSE LastQuickDDBVerificationTime END ELSE  (CASE WHEN (@l_ddbVerificationLevel = 2) THEN LastDDBVerificationTime ELSE LastDataVerificationTime END) END
			FROM	IdxSIDBStore I WITH (READUNCOMMITTED)
			WHERE	I.SIDBStoreId = @l_SIDBStoreId
	END
	IF ((@MaxChunksPerBatch > 0) AND (@l_currentPhase = @dataValidate))
	BEGIN
		INSERT INTO archChunkToVerify
		SELECT VH.adminJobId, VH.appId, VH.backupJobId, VH.archChunkId, VH.archFileId, VH.commCellId, VH.archCopyId, 0, VH.fileType, 0, 0,
                VH.chunkNumber, VH.physicalOffset, VH.logicalOffset, VH.physicalSize, VH.logicalSize, VH.volumeId, VH.MediaId, VH.MediaGroupId,
                VH.fileMarkerNo,    VH.chunkCreateTime, VH.chunkVersion, VH.physicalSize, VH.logicalSize, VH.chunkHwEncKey, 0, 0, VH.unCompBytesSize, 0
		FROM archChunkToVerifyHistory VH WITH(READUNCOMMITTED)
WHERE VH.adminJobId = @i_adminJobId AND VH.archCopyId = @i_archCopyId AND (VH.extraFlags & (1 | 2 | 4)) = 0
		AND NOT EXISTS (SELECT 1 FROM archChunkToVerify V WHERE V.adminjobId = @i_adminJobId AND V.archCopyId = @i_archCopyId AND V.archCHunkId = VH.archChunkID AND V.archFileId = VH.archFileId AND V.commcellId = VH.commCellID)
		DECLARE @MaxAFsPerBatch INTEGER = @MaxChunksPerBatch /10
		SET @MaxAFsPerBatch = @MaxAFsPerBatch - (SELECT COUNT(DISTINCT archFileId) FROM archCHunkToVerify WITH (READUNCOMMITTED) WHERE adminjobID = @i_adminJobId AND archCopyId = @i_archCopyId)
		IF @MaxAFsPerBatch > 0
		BEGIN
			IF (OBJECT_ID('tempdb.dbo.#tempAFsToBeVerified') IS NOT NULL) DROP TABLE #tempAFsToBeVerified
			CREATE TABLE #tempAFsToBeVerified(archFileId INTEGER, jobId INTEGER, commcellId INTEGER, appId INTEGER, fileType INTEGER)
			DECLARE @ind INTEGER = 0
			WHILE (1 = 1)
			BEGIN
				TRUNCATE TABLE #tempAFsToBeVerified
				INSERT INTO #tempAFsToBeVerified
				SELECT TOP(@MaxAFsPerBatch) AF.Id, JDS.jobID, AF.commCellId, AF.appId, AF.fileType
				FROM JMJobDataStats JDS  WITH(READUNCOMMITTED)
						INNER JOIN archFile AF WITH(READUNCOMMITTED)
							ON 	JDS.JobID = AF.JobId	AND JDS.CommCellId = AF.CommCellId
								AND JDS.dataType = AF.FileType
						INNER JOIN archFileCopyDedup AFCD WITH(READUNCOMMITTED)
							ON  AF.id = AFCD.archFileId AND AF.CommCellId = AFCD.CommCellId AND JDS.archGrpCopyId = AFCD.archCopyId
				WHERE JDS.Status = 100
AND (JDS.disabled & 256) = 0
						AND JDS.copiedTime <= @l_jobStartTime
						AND JDS.archGrpCopyId = @i_archCopyId
						AND AFCD.SIDBStoreId = @l_SIDBStoreId
						 AND ((JDS.copiedTime > @chunkCreateTime) OR
						 (JDS.archCheckStatus IN (3/*ACS_TOBECHECKED*/,4/*ACS_PARTCHECKED*/)))
						AND ( JDS.archCheckEndTime < @l_jobStartTime  OR  JDS.archCheckStatus NOT IN (5 /*ACS_CHECKED*/, 6/*ACS_FAILED*/ ))
						AND JDS.jobId > @l_lastPopulatedJobId
				ORDER BY JDS.jobId
				IF @@ROWCOUNT = 0
					BREAK
				IF @ind = 0
					CREATE CLUSTERED INDEX tempAFsToBeVErified_idx1 ON #tempAfsToBeVerified (jobId, archFileId, commcellId )
				SET @ind = @ind + 1
				/*Pick everything for the last job when number of archive files selected are greater or equal to max afs per batch
				  Also select only if it is fully copied for that datatype*/
				IF ((SELECT COUNT(*) FROM #tempAFsToBeVerified) >= @MaxAFsPerBatch)
				BEGIN
					INSERT INTO #tempAFsToBeVerified -- this to insert makes sure we are not inserting a job partially.
					SELECT  AF.Id, AF.jobID, AF.commCellId, AF.appId, AF.fileType
					FROM	(SELECT MAX(jobId) lastJob, MAX(commcellId) ccId FROM #tempAFsToBeVerified) t
							INNER JOIN JMJobDataStats JDS  WITH(READUNCOMMITTED) ON T.lastJob = JDS.JobId AND T.ccId = JDS.CommCellId
							INNER JOIN archFile AF WITH(READUNCOMMITTED)
								ON 	JDS.JobID = AF.JobId	AND JDS.CommCellId = AF.CommCellId
									AND JDS.dataType = AF.FileType
							INNER JOIN archFileCopyDedup AFCD WITH(READUNCOMMITTED)
								ON  AF.id = AFCD.archFileId AND AF.CommCellId = AFCD.CommCellId AND JDS.archGrpCopyId = AFCD.archCopyId
					WHERE JDS.Status = 100
AND (JDS.disabled & 256) = 0
							AND JDS.copiedTime <= @l_jobStartTime
							AND JDS.archGrpCopyId = @i_archCopyId
							AND AFCD.SIDBStoreId = @l_SIDBStoreId
								AND ((JDS.copiedTime > @chunkCreateTime) OR
								(JDS.archCheckStatus IN (3/*ACS_TOBECHECKED*/,4/*ACS_PARTCHECKED*/)))
							AND ( JDS.archCheckEndTime < @l_jobStartTime  OR  JDS.archCheckStatus NOT IN (5 /*ACS_CHECKED*/, 6/*ACS_FAILED*/ ))
							AND NOT EXISTS ( SELECT 1 FROM #tempAFsToBeVerified  TAF WHERE TAF.archFileId = AF.Id AND TAF.commCellID = AF.commcellId)
				END
				INSERT INTO archChunkToVerify
				SELECT	@i_adminJobId, T.appId, T.jobId, ACM.archChunkId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, 0, T.fileType, 0, 0,
						ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize, AC.volumeId, 0, 0,
						AC.fileMarkerNo,	AC.createTime, AC.version, AC.physicalSize, AC.logicalSize, AC.hwEncKey, 0, 0, ACM.unCompSize, 0
				FROM	#tempAFsToBeVerified t INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED)
								ON T.archFileId = ACM.archFileId
						AND T.CommCellId = ACM.CommCellId AND ACM.archCopyId =  @i_archCopyId
						INNER JOIN archChunk AC WITH (READUNCOMMITTED)
								ON AC.id = ACM.archCHunkID AND AC.commCellId = ACM.chunkCommCellID
WHERE ACM.physicalSize > 0 AND (ACM.flags & 256) = 0
AND (((AC.flags & (2048)) = 0 AND ACM.chunkNumber > 0) OR (AC.createTime < (@l_currentTime - 24 * 60 * 60)))
				UPDATE archChunkToVerify
				SET  mediaId = MV.MediaId , mediaGroupId = MV.MediaGroupId
				FROM archChunkToVerify V INNER JOIN MMVolume MV WITH (READUNCOMMITTED)
								ON V.VolumeId = MV.VolumeId AND MV.SIDBStoreId = @l_SIDBStoreId
				SELECT  @l_lastPopulatedJobId = ISNULL(MAX(JobId), @l_lastPopulatedJobId)
				FROM    #tempAFsToBeVerified J
				IF ((SELECT COUNT(*)
				FROM    (SELECT DISTINCT archFileId, CommCellId
						FROM    archChunkToVerify V WITH (READUNCOMMITTED)
						WHERE   V.adminJobId = @i_adminJobId
								AND V.archCopyId = @i_archCopyid
						) T
				) >= @MaxAFsPerBatch)
					BREAK
			END
			MERGE #tempJobsToProcess Target
			USING   (SELECT @i_archCopyId archCopyId, @l_lastPopulatedJobId jobId) AS Source
			ON (Target.archCopyId = Source.archCopyId)
			WHEN MATCHED THEN
				UPDATE SET  Target.JobId = Source.jobId
			WHEN NOT MATCHED THEN
				INSERT (archCopyId, jobId)
				VALUES (Source.archCopyId, Source.jobId);
			SET @l_xmlLastPopulatedJobIdList =  (SELECT JobId AS '@j', archCopyId AS '@cp'
                    FROM    #tempJobsToProcess
                    ORDER BY archCopyId, JobId
                    FOR XML PATH('I'), ROOT('JobIds'))
			MERGE  JMJobOptions as jobOptions
USING   (SELECT @i_adminJobId as inJobID, 2 as commCellID ,90 as attrid, 'Last Job Populated to Data Verification' as attributeName) as src
			ON jobOptions.commCellId = src.commCellID AND jobOptions.jobId = src.inJobID AND jobOptions.attributeId = src.attrid AND jobOptions.attributeName = src.attributeName
			WHEN MATCHED THEN
				UPDATE SET attributeValue =  ISNULL(CAST(@l_xmlLastPopulatedJobIdList AS VARCHAR(MAX)),'')
			WHEN NOT MATCHED THEN
				INSERT(jobId,commCellId,attributeId,attributeName,attributeValueInt,attributeValue)
				VALUES (Src.inJobID, src.commCellID, Src.attrid, Src.attributeName, 0,ISNULL(CAST(@l_xmlLastPopulatedJobIdList AS VARCHAR(MAX)), ''));
			if (OBJECT_ID('tempdb.dbo.#tempAFsToBeVerified') IS NOT NULL) DROP TABLE #tempAFsToBeVerified
		END
	END
	ELSE IF (@l_currentPhase = @dataValidate)
	BEGIN
		INSERT INTO archChunkToVerify
		SELECT	TOP (@topHint) @i_adminJobId, AF.appId, AF.jobId, ACM.archChunkId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, 0, AF.fileType, 0, 0,
				ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize, AC.volumeId, MV.MediaId, MV.MediaGroupId,
				AC.fileMarkerNo,	AC.createTime, AC.version, AC.physicalSize, AC.logicalSize, AC.hwEncKey, 0, 0, ACM.unCompSize, 0
		FROM	JMJobDataStats JDS WITH (READUNCOMMITTED),
				archFile AF WITH (READUNCOMMITTED),
				archChunkMapping ACM WITH (READUNCOMMITTED) ,
				archChunk AC WITH (READUNCOMMITTED), MMVolume MV WITH (READUNCOMMITTED)
		WHERE	JDS.JobID = AF.JobId
				AND JDS.CommCellId = AF.CommCellId
				AND JDS.dataType = AF.FileType
				AND JDS.Status = 100
AND (JDS.disabled & 256) = 0
				AND JDS.copiedTime <= @l_jobStartTime
				AND ((JDS.copiedTime > @chunkCreateTime) OR
						(JDS.archCheckStatus IN (3/*ACS_TOBECHECKED*/,4/*ACS_PARTCHECKED*/)))
				AND AF.id = ACM.archFileId
				AND AF.CommCellId = ACM.CommCellId
				AND JDS.archGrpCopyId = ACM.archCopyId
				AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId -- fix: join on chunkCommCellID
				AND AC.VolumeId = MV.VolumeId AND((@l_jobsFromTime = 0 AND @l_jobsToTime = 0) OR  JDS.copiedTime BETWEEN @l_jobsFromTime AND @l_jobsToTime)
				AND MV.SIDBStoreId = @l_SIDBStoreId
AND (((AC.flags & (2048)) = 0 AND ACM.chunkNumber > 0) OR (AC.createTime < (@l_currentTime - 24 * 60 * 60)))
				AND ACM.archCopyId = @i_archCopyId
AND ACM.physicalSize > 0 AND (ACM.flags & 256) = 0
	END
	ELSE
	BEGIN
		IF EXISTS (	SELECT	AC.id
					FROM	archChunk AC WITH (READUNCOMMITTED), MMVolume MV WITH (READUNCOMMITTED)
					WHERE	AC.VolumeId = MV.VolumeId AND AC.createTime > @chunkCreateTime AND MV.SIDBStoreId = @l_SIDBStoreId)
		BEGIN
			WHILE (1 = 1 )
			BEGIN
				TRUNCATE TABLE #tblVolume
				TRUNCATE TABLE #tblAC
				INSERT INTO #tblVolume
				SELECT	TOP (@topHint) MV.VolumeId, MV.MediaId, MV.MediaGroupId
				FROM	MMVolume MV WITH (READUNCOMMITTED)
						INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MV.MediaSideId = MP.MediaSideId AND MP.OfflineReason != 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/
						INNER JOIN archStream S WITH (READUNCOMMITTED) ON MV.MediaGroupId = S.mediaGroupId AND S.archGroupCopyId = @i_archCopyId
				WHERE	MV.SIDBStoreId = @l_SIDBStoreId
						AND MV.VolumeId < @maxVolumeId
				ORDER BY MV.VolumeId DESC
				INSERT INTO #tblAC
				SELECT	AC.id, AC.commCellId, AC.flags, AC.createTime, MV.VolumeId, MV.MediaId, MV.MediaGroupId
				FROM	archChunk AC WITH (READUNCOMMITTED)
						INNER JOIN #tblVolume MV ON AC.volumeId = MV.VolumeId
				WHERE	AC.physicalSize > 0
				;WITH TC(
						adminJobId, appId, backupJobId, archChunkId, archFileId, commCellId, archCopyId, streamNum, fileType,
						archFileCopyFlags, lastChunkNumber, chunkNumber, physicalOffset, logicalOffset, physicalSize, logicalSize,
						volumeId, mediaId, mediaGroupId, fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize,
						chunkHwEncKey, extraFlags, segmentId, unCompBytesSize, RN
						)
					AS
						(SELECT	TOP (@topHint * 100) @i_adminJobId, 0 AS appId, 0 AS jobId, ACM.archChunkId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, 0, 0 AS fileType, 0, 0,
								ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize, ACT.volumeId, ACT.MediaId, ACT.MediaGroupId,
								0, ACT.createTime, 0, 0, 0, '',  0, 0, ACM.unCompSize,
								ROW_NUMBER() OVER(PARTITION BY ACT.VolumeId ORDER BY ACT.archChunkId)
						FROM	#tblAC ACT
								INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON ACT.archChunkId = ACM.archChunkId AND ACT.chunkCommCellId = ACM.chunkCommCellId -- fix: join on chunkCommCellID
						WHERE
								ACM.chunkNumber = 1
								AND ACM.archCopyId = @i_archCopyId
AND ACM.physicalSize > 0 AND (ACM.flags & 256) = 0
AND (((ACT.flags & (2048)) = 0 AND ACM.chunkNumber > 0) OR (ACT.createTime < (@l_currentTime - 24 * 60 * 60)))
						)
					INSERT INTO archChunkToVerify
					SELECT	TOP (@topHint-@totalRowCount) adminJobId, AF.appId, AF.jobId, archChunkId, archFileId, TC.commCellId, archCopyId, streamNum, AF.fileType,
						archFileCopyFlags, lastChunkNumber, chunkNumber, physicalOffset, logicalOffset, TC.physicalSize, TC.logicalSize,
						TC.volumeId, mediaId, mediaGroupId, AC.fileMarkerNo, chunkCreateTime, AC.version, AC.physicalSize, AC.logicalSize,
						AC.hwEncKey, extraFlags, segmentId, unCompBytesSize, 0
					FROM	TC
							INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.id = TC.archFileId AND AF.CommCellId = TC.CommCellId
							INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON TC.archChunkId = AC.id AND TC.commCellId = AC.commCellId
					ORDER BY TC.RN
					OPTION (MAXDOP 2)
				SET @CurrentRowCount = @@ROWCOUNT
				IF (@CurrentRowCount = 0)
					BREAK;
				ELSE
				BEGIN
					SET @totalRowCount = @totalRowCount + @CurrentRowCount;
					SELECT	@maxVolumeId = MIN(VolumeId)
					FROM	#tblVolume MV
					IF (@totalRowCount >= @topHint)
						BREAK;
				END
			END
		END
	END
	SELECT @retVal = @@ERROR, @numChunksAdded = @@ROWCOUNT
	IF  @retVal <> 0 GOTO FINISH
	UPDATE	archChunkToVerify
	SET		streamNum = b.streamNum, archFileCopyFlags = b.flags, lastChunkNumber = b.lastChunkNumber
	FROM	archChunkToVerify a, archFileCopy b WITH (READUNCOMMITTED)
	WHERE	a.adminJobId = @i_adminJobId AND a.archCopyId = @i_archCopyId AND b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = @i_archCopyId
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	IF (EXISTS (SELECT * FROM JMJobInfo WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND CommCellId = 2 AND currentPhase NOT IN (@dedupeValidate, @orphanListing, @defragment) /*DEDUPVALIDATE, ORPHANLISTING, DEFRAGMENT*/)
		AND (@MaxChunksPerBatch = 0))
	BEGIN
		DELETE	archChunkToVerify
		FROM	archChunkToVerify V, JMJobDataStats J WITH (READUNCOMMITTED)
		WHERE	V.adminJobId = @i_adminJobId
				AND V.backupJobId = J.jobId
				AND V.commCellId = J.commCellId
				AND V.fileType = J.dataType
				AND V.archCopyId = J.archGrpCopyId
				AND J.archCheckEndTime >= @l_jobStartTime
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
	END
IF ((@JMDVFlag & 2) = 0)
	BEGIN
		IF (@l_ddbVerificationLevel IN (1, 2, 3) /* QUICK_DDB_VERIFICATION, DDB_VERIFICATION, DDB_AND_DATA_VERIFICATION*/)
		BEGIN
			IF (@l_currentPhase = @dedupeValidate/*DEDUPVALIDATE*/)
			BEGIN
				IF (EXISTS(SELECT * FROM @returnTable WHERE allowBackup = 0))
				BEGIN
					UPDATE	I
					SET		LastDDBVerificationTime = 0, LastDataVerificationTime = 0, LastQuickDDBVerificationTime = 0
					FROM	IdxSIDBStore I
					WHERE	I.SIDBStoreId = @l_SIDBStoreId
				END
				IF (@i_isIncr = 0)
				BEGIN
					IF (@l_ddbVerificationLevel IN (2)) /*DDB_VERIFICATION*/
						UPDATE	I
						SET		LastDDBVerificationTime = 0
						FROM	IdxSIDBStore I
						WHERE	I.SIDBStoreId = @l_SIDBStoreId
					ELSE IF (@l_ddbVerificationLevel IN (3))/*DDB_AND_DATA_VERIFICATION*/
						UPDATE	I
						SET		LastDDBVerificationTime = 0, LastDataVerificationTime = 0
						FROM	IdxSIDBStore I
						WHERE	I.SIDBStoreId = @l_SIDBStoreId
					ELSE IF (@l_ddbVerificationLevel IN (1))/*QUICK_DDB_VERIFICATION*/
						UPDATE	I
						SET		LastQuickDDBVerificationTime = 0
						FROM	IdxSIDBStore I
						WHERE	I.SIDBStoreId = @l_SIDBStoreId
				END
			END
SET @JMDVFlag |= 2
		END
	END
END
IF(@retVal = 0 AND (@l_SIDBStoreId = 0 OR @l_ddbVerificationLevel IN (1,3))) --TMMsg::DDBVerificationLevel_DDB_AND_DATA_VERIFICATION
BEGIN
UPDATE	JMJobDataStats	SET disabled  = (disabled  & ~2048),
								archCheckStatus = (CASE WHEN (@l_SIDBStoreId > 0 AND @l_ddbVerificationLevel  IN (1,3) AND @l_currentPhase = @dataValidate AND JMJobDataStats.archCheckEndTime < @l_jobStartTime) THEN 3 /*ACS_TOBECHECKED*/ ELSE archCheckStatus END)
	FROM	(SELECT DISTINCT backupJobId, archCopyId, commCellId, fileType FROM archChunkToVerify  WHERE adminJobId = @i_adminJobId ) ACV
	WHERE	JMJobDataStats.archGrpCopyId = ACV.archCopyId AND JMJobDataStats.commCellId = ACV.commCellId
			AND JMJobDataStats.jobId = ACV.backupJobId AND JMJobDataStats.dataType = ACV.fileType
			AND JMJobDataStats.archCheckEndTime <= @l_jobStartTime
	IF (@l_SIDBStoreId > 0 AND @l_ddbVerificationLevel IN (1,3) AND @l_currentPhase = @dataValidate)
	BEGIN
		UPDATE	ACM
SET		flags = ((flags & (~255)) | 1)
		FROM	archChunkMapping ACM, archChunkToVerify ACV
		WHERE	ACV.adminJobId = @i_adminJobId
				AND ACM.archChunkId = ACV.archChunkId
				AND ACM.archFileId = ACV.archFileId
				AND ACM.commCellId = ACV.CommCellid
	END
END
SET @retVal = @@ERROR
IF OBJECT_ID('tempdb.dbo.#tempJobsInput') IS NOT NULL DROP TABLE #tempJobsInput
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT backupJobId, CommCellId, 0, 0, 0
FROM archChunkToVerify
WHERE	adminJobId = @i_adminJobId
		AND ( @i_mediaId = 0 OR mediaId = @i_mediaId )
		AND ( @i_archCopyId = 0 OR archCopyId = @i_archCopyId)
		AND unCompBytesSize = -1
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	archChunkToVerify
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	adminJobId = @i_adminJobId
		AND ( @i_mediaId = 0 OR mediaId = @i_mediaId )
		AND ( @i_archCopyId = 0 OR archCopyId = @i_archCopyId)
		AND archChunkToVerify.backupJobId = J.JobId
		AND archChunkToVerify.CommCellId = J.CommCellId
		AND archChunkToVerify.unCompBytesSize = -1
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	archChunkToVerify R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.adminJobId = @i_adminJobId
		AND M.MediaTypeId != 10001
		AND R.MediaId = M.MediaId
		AND R.chunkHwEncKey = ''
		AND	R.ArchChunkId = chunk.Id
		AND	R.CommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
IF @l_currentPhase = @dataValidate AND @mpAffinityEnabled = 1
BEGIN
	-- Insert to archChunkToVerifyMPToMAMap
	DELETE archChunkToVerifyMPToMAMap
	WHERE ( @i_archCopyId = 0 OR CopyId = @i_archCopyId)
	AND ( @i_archCopyId > 0 OR CopyId IN ( SELECT CopyId FROM @CopyIdTable ))
	INSERT INTO archChunkToVerifyMPToMAMap
SELECT DISTINCT adminJobID, archCopyId, mp.mountPathId, DC.ClientId, (CASE WHEN DeviceAccessType & (16|32 | 128 ) > 0 THEN 0 ELSE 1 END)
	FROM archChunkToVerify av WITH (READUNCOMMITTED), MMVolume b WITH (READUNCOMMITTED), MMMedia c WITH (READUNCOMMITTED), MMMountPath mp WITH (READUNCOMMITTED), MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED), MMDeviceController DC WITH (READUNCOMMITTED)
		WHERE av.adminJobId = @i_adminJobId
		AND ( @i_archCopyId = 0 OR archCopyId = @i_archCopyId)
		AND av.volumeId = b.volumeId
		AND b.mediaId = c.mediaId
		AND c.mediaTypeId = 10001
		AND av.segmentId = 0
		AND mp.mediaSideId = b.mediaSideId
		AND mp.mountPathId = MSD. mountPathId
		AND DC.DeviceID = MSD.DeviceId
		--AND NOT EXISTS (SELECT 1 FROM archChunkToVerifyMPToMAMap t WHERE t.adminJobID = av.adminJobID AND mp.mountPathId = t.MPId AND t.copyId = av.archCopyId)
	--Set network paths as non-local if local path exists
	UPDATE MPMap
	SET isLocal = 0
	FROM archChunkToVerifyMPToMAMap MPMap
		JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MPMap.MPId = MSD.MountPathId
		JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON MSD.DeviceId = DC.DeviceId AND DC.ClientId = MPMap.MAId
		JOIN MMDeviceController DCL WITH (READUNCOMMITTED) ON MSD.DeviceId = DCL.DeviceId AND DCL.ClientId <> MPMap.MAId
	WHERE MPMap.adminJobId = @i_adminJobId
		AND (@i_archCopyId = 0 or MPMap.CopyId = @i_archCopyId)
		AND LEFT(DC.Folder, 2) = '\\'
		AND LEFT(DCL.Folder, 2) <> '\\'
		AND MPMap.isLocal = 1
END
SELECT	@retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
IF (((@JMDVFlag & 1) = 0) AND (@MaxChunksPerBatch > 0) AND (@l_currentPhase = @dataValidate))
BEGIN
	SET @JMDVFlag |= 1 /*CVA_DV_CLEANUP_ON_DVPHASESTART_SUCCESS_FLAG*/
END
IF  EXISTS (SELECT 1 FROM JMMisc WHERE jobId = @i_adminJobId AND commCellId = 2 AND itemType = 78)
BEGIN
	UPDATE	JMMisc
	SET		intData |= @JMDVFlag
	WHERE	jobId = @i_adminJobId
AND commCellId = 2
AND itemType = 78
			AND (intData & @JMDVFlag) != @JMDVFlag
END
ELSE
BEGIN
INSERT INTO JMMisc (jobId, selfRefId, itemType, attribute, intData, data, commCellId) VALUES (@i_adminJobId, 0, 78, 0, @JMDVFlag, '', 2)
END
SELECT	@retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
FINISH:
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF object_id('tempdb.dbo.#tmpAgedChunks') IS NOT null DROP TABLE #tmpAgedChunks
IF object_id('tempdb.dbo.#tblVolume') IS NOT null DROP TABLE #tblVolume
IF object_id('tempdb.dbo.#tblAC') IS NOT null DROP TABLE #tblAC
IF  @retVal = 0
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
SELECT @retVal, @numChunksAdded, @totalChunksNeeded
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyInsert')
	delete from GxQscripts where name = 'archChunkToVerifyInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyInsert')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyInsert'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyInsert',  'v1.34.2.39.4.1', 'archChunkToVerifyInsert', 'v1.34.2.39.4.1')
GO

