

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyGetOCLFlags.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archChunkToVerifyGetOCLFlags.sp                            */
/*                                                                            */
/*  Description :  Stored procedure to get OCL flags for store		          */
/*				   						      								  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyGetOCLFlags.sp,v $ $Id: archChunkToVerifyGetOCLFlags.sp,v 1.1.4.2 2019/02/07 14:37:55 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerifyGetOCLFlags')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyGetOCLFlags <<<'
	drop procedure archChunkToVerifyGetOCLFlags
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyGetOCLFlags')
	delete from GxQscripts where name = 'archChunkToVerifyGetOCLFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyGetOCLFlags')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyGetOCLFlags'
GO
print '... Creating Procedure: archChunkToVerifyGetOCLFlags'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerifyGetOCLFlags
  @i_sidbStoreId INTEGER
AS
  DECLARE @o_OCLFlags INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	SET @o_OCLFlags = 0
	DECLARE @l_lastFullReconJobId INTEGER = 0
	BEGIN TRY
		SELECT	@o_OCLFlags = CAST(value AS INT)
		FROM	GXGlobalParam
		WHERE	name = 'EnableOrphanChunkListing'
		-- Only 10 bits are allowed as of now
IF ((@o_OCLFlags & 0x3ff) > 0)
		BEGIN
			-- If reporting is ON then Pruning BITS should be OFF
IF ((@o_OCLFlags & 0x1) > 0)
			BEGIN
if ((@o_OCLFlags & (0x2 + 0x4)) > 0)
					SET @o_OCLFlags = 0
			END
		END
		IF (@o_OCLFlags > 0)
		BEGIN
			SELECT	@l_lastFullReconJobId = MAX(AdminJobId)
			FROM	IdxSIDBRecoveryHistory WITH (READUNCOMMITTED)
			WHERE	SIDBStoreId = @i_sidbStoreId
AND (flags & 4) > 0
					AND Status IN (1, 3, 14)
			IF  ( (@l_lastFullReconJobId = 0)
				OR NOT EXISTS (	SELECT TOP 1 AdminJobID
							FROM	IdxSIDBRecoveryHistory WITH (READUNCOMMITTED)
							WHERE	AdminJobId = @l_lastFullReconJobId
AND (flags & (8) = 0)) )
				SET	@o_OCLFlags = 0
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		;THROW
	END CATCH
	SELECT	@o_OCLFlags
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyGetOCLFlags')
	delete from GxQscripts where name = 'archChunkToVerifyGetOCLFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyGetOCLFlags')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyGetOCLFlags'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyGetOCLFlags',  '00010001000400020000', 'archChunkToVerifyGetOCLFlags', '00010001000400020000')
GO

