

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyGetNext.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyGetNext.sp,v $ $Id: archChunkToVerifyGetNext.sp,v 1.19.80.11 2020/12/19 05:13:23 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archChunkToVerifyGetNext')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyGetNext <<<'
	drop procedure archChunkToVerifyGetNext
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyGetNext')
	delete from GxQscripts where name = 'archChunkToVerifyGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyGetNext')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyGetNext'
GO
print '... Creating Procedure: archChunkToVerifyGetNext'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archChunkToVerifyGetNext
  @i_adminJobId int,
  @i_archCopyId int,
  @i_streamNum int,
  @i_volumeId int,
  @i_numOfChunks int
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_encType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_chunkHwEncKey varchar(2048);
  DECLARE @o_extraFlags integer;
  DECLARE @o_destPhysicalSize bigint;		
  DECLARE @o_destLogicalSize bigint;		
  DECLARE @o_destDrivePoolId integer;	
  DECLARE @o_destAFCopyFlags integer;	
  DECLARE @o_destEncKeyType integer;	
  DECLARE @o_encKeyCreated integer;	
  DECLARE @o_unCompBytesSize bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tmpAgedChunks') IS NOT null DROP TABLE #tmpAgedChunks
CREATE TABLE #tmpAgedChunks (archFileId INTEGER, commCellId INTEGER, archChunkId BIGINT)
DECLARE	@l_iJobPhaseNum INTEGER = ( SELECT	ISNULL(currentPhase, 0)
									FROM	JMJobInfo
									WHERE	JobId = @i_adminJobId)
DECLARE @tblNextChunks	TABLE (archChunkId bigint, archFileId integer, commCellId integer)
DECLARE @MaxChunksPerBatch INT = 0
DECLARE @dedupeValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE	@opId INT = 0
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	 @dedupeValidate = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Validate Dedupe Data'
SELECT	 @orphanListing = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Orphan Chunk listing'
SELECT	 @defragment = phase
FROM	JMPhase WITH (READUNCOMMITTED)
WHERE	opTableId = @opId and name = 'Defragment Data'
DECLARE @mountPathId INTEGER = 0
SELECT	@mountPathId = MP.MountPathId
FROM	MMVolume MV, MMMountPath MP
WHERE	MV.VolumeId = @i_volumeId
		AND MV.MediaSideId = MP.MediaSideId
-- For DDB Verification we will return one chunk to start the thread to verify primary entries
IF (@l_iJobPhaseNum IN (@dedupeValidate, @orphanListing, @defragment)) --DEDUPVALIDATE, ORPHANLISTING, DEFRAGMENT
BEGIN
	INSERT	INTO @tblNextChunks
	SELECT	DISTINCT TOP 1 archChunkId, archFileId, commCellId
	FROM	archChunkToVerify
	WHERE	volumeId = @i_volumeId
	AND		adminJobId = @i_adminJobId
	AND		archCopyId = @i_archCopyId
	AND		streamNum = @i_streamNum
	ORDER BY archChunkId
	SELECT	a.appId, 0, 0, @mountPathId /*fullCycleNum is overloaded with mountPathId*/, a.backupJobId, 0, 0,
			a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
			a.streamNum, a.fileType, a.archFileCopyFlags, 0, a.lastChunkNumber,
			a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
			a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
			a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags, 0, 0, 0, 0, 0, 0, a.physicalSize
	FROM	@tblNextChunks b, archChunkToVerify a
	WHERE	a.archChunkId = b.archChunkId AND a.volumeId = @i_volumeId -- fix: join with volumeID too
			AND a.adminJobId = @i_adminJobId -- fix: Due to GACP we are picking archive files from other copies
			AND a.archFileId = b.archFileId
			AND a.commCellId = b.commCellId
			AND a.archCopyId = @i_archCopyId
	ORDER BY a.archChunkId, a.archFileId, a.commCellId
END
ELSE
BEGIN
	SELECT  @MaxChunksPerBatch = value
	FROM	MMConfigs
	WHERE	name = 'MMCONFIG_DV_MAX_CHUNKS_PER_BATCH'
	IF (@MaxChunksPerBatch > 0)
	BEGIN
		DELETE  V
		OUTPUT  DELETED.archFileId, DELETED.commCellId, DELETED.archChunkId INTO #tmpAgedChunks
		FROM	archChunkToVerify V
				INNER JOIN MMVolume MV WITH (READUNCOMMITTED)
					ON V.VolumeId = MV.VolumeId
				LEFT OUTER JOIN archChunkMapping ACM WITH (READUNCOMMITTED)
					ON	ACM.archChunkId = V.archChunkId
						AND ACM.archFileId = V.archFileId
						AND ACM.commCellId = V.commCellId
						AND ACM.chunkCommCellId = MV.origCCcommCellID
						AND ACM.archCopyId = V.archCopyId
AND (ACM.flags & 256) = 0
		WHERE	V.adminJobId = @i_adminJobId
				AND ACM.archChunkId IS NULL
		IF @@ROWCOUNT > 0
		BEGIN
			CREATE CLUSTERED INDEX tmpAgedChunks_archFileId_commCellId_archChunkId_Idx ON #tmpAgedChunks (archFileId, commCellId, archChunkId)
			UPDATE	VH
SET		extraFlags |= 4
			FROM	archChunkToVerifyHistory VH WITH (READUNCOMMITTED)
					INNER JOIN #tmpAgedChunks ACM WITH (READUNCOMMITTED)
						ON	ACM.archChunkId = VH.archChunkId
							AND ACM.archFileId = VH.archFileId
							AND ACM.commCellId = VH.commCellId
			WHERE	VH.adminJobId = @i_adminJobId
AND (VH.extraFlags & (1 | 2 | 4)) = 0
			IF object_id('tempdb.dbo.#tmpAgedChunks') IS NOT null DROP TABLE #tmpAgedChunks
		END
	END
	INSERT	INTO @tblNextChunks
	SELECT	DISTINCT TOP(@i_numOfChunks) archChunkId, archFileId, commCellId
	FROM	archChunkToVerify
	WHERE	volumeId = @i_volumeId
	AND		adminJobId = @i_adminJobId
	AND		archCopyId = @i_archCopyId
	AND		streamNum = @i_streamNum
	ORDER BY archChunkId
	SELECT	a.appId, 0, 0, @mountPathId /*fullCycleNum is overloaded with mountPathId*/, a.backupJobId, 0, 0,
			a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
			a.streamNum, a.fileType, a.archFileCopyFlags, 0, a.lastChunkNumber,
			a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
			a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
			a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags, 0, 0, 0, 0, 0, 0, a.unCompBytesSize
	FROM	@tblNextChunks b, archChunkToVerify a
	WHERE	a.archChunkId = b.archChunkId AND a.volumeId = @i_volumeId -- fix: join with volumeID too
			AND a.adminJobId = @i_adminJobId -- fix: Due to GACP we are picking archive files from other copies
			AND a.archFileId = b.archFileId
			AND a.commCellId = b.commCellId
			AND a.archCopyId = @i_archCopyId
END
DELETE	archChunkToVerify
FROM	@tblNextChunks b, archChunkToVerify a
WHERE	a.archChunkId = b.archChunkId AND a.volumeId = @i_volumeId -- fix: join with volumeID too, else we may delete chunks with same ID from different volumes.
		AND a.adminJobId = @i_adminJobId -- fix: Due to GACP we are picking archive files from other copies
		AND a.archFileId = b.archFileId
		AND a.commCellId = b.commCellId
		AND a.archCopyId = @i_archCopyId
IF object_id('tempdb.dbo.#tmpAgedChunks') IS NOT null DROP TABLE #tmpAgedChunks
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyGetNext')
	delete from GxQscripts where name = 'archChunkToVerifyGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyGetNext')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyGetNext'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyGetNext',  '00010019008000110000', 'archChunkToVerifyGetNext', '00010019008000110000')
GO

