

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyGetJobStatus.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archChunkToVerifyGetJobStatus.sp                */
/*                                                                            */
/*  Description :  Stored procedure to check if subclient is eligible		  */
/*				   for selective copy						      			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyGetJobStatus.sp,v $ $Id: archChunkToVerifyGetJobStatus.sp,v 1.1.4.2 2019/02/28 19:22:11 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerifyGetJobStatus')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyGetJobStatus <<<'
	drop procedure archChunkToVerifyGetJobStatus
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyGetJobStatus')
	delete from GxQscripts where name = 'archChunkToVerifyGetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyGetJobStatus')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyGetJobStatus'
GO
print '... Creating Procedure: archChunkToVerifyGetJobStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerifyGetJobStatus
  @i_adminJobId int
AS
  DECLARE @o_errorCode integer;
  DECLARE @o_jobStatus integer;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @chunkSuccess INT = 0
	DECLARE @chunkFailed INT = 0
	DECLARE @chunkIgnored INT = 0
	DECLARE @chunkNotVerified INT = 0
	DECLARE @chunkAged INT = 0
	SET @o_errorCode = 0
	SET @o_jobStatus = 0
	BEGIN TRY
		IF EXISTS (SELECT TOP 1 adminJobId FROM archChunkToVerify WITH (READUNCOMMITTED) WHERE adminJobId = @i_adminJobId)
		BEGIN
			SET @o_jobStatus = 0 /*INCOMPLETE*/
		END
		ELSE
		BEGIN
			SELECT TOP 1 @chunkSuccess = 1
			FROM	archChunkToVerifyHistory WITH (READUNCOMMITTED)
			WHERE	adminJobId = @i_adminJobId
AND (extraFlags & 1) > 0
			SELECT TOP 1 @chunkFailed = 1
			FROM	archChunkToVerifyHistory WITH (READUNCOMMITTED)
			WHERE	adminJobId = @i_adminJobId
AND (extraFlags & 2) > 0
			SELECT TOP 1 @chunkAged = 1
			FROM	archChunkToVerifyHistory WITH (READUNCOMMITTED)
			WHERE	adminJobId = @i_adminJobId
AND (extraFlags & 4) > 0
			SELECT TOP 1 @chunkNotVerified = 1
			FROM	archChunkToVerifyHistory WITH (READUNCOMMITTED)
			WHERE	adminJobId = @i_adminJobId
					AND extraFlags = 0
			IF (@chunkNotVerified > 0)
				SET @o_jobStatus = 0 /*INCOMPLETE*/
			ELSE IF (@chunkSuccess = 1 AND @chunkFailed = 1)
				SET @o_jobStatus = 3 /*PARTIALSUCCESS*/
			ELSE IF ((@chunkSuccess = 1 OR @chunkAged = 1) AND @chunkFailed = 0)
				SET @o_jobStatus = 1 /*JMSUCCESS*/
			ELSE IF (@chunkSuccess = 0 AND @chunkFailed = 1)
				SET @o_jobStatus = 2 /*FAIL*/
			ELSE IF ((@chunkNotVerified = 0) AND (@chunkSuccess = 0) AND (@chunkFailed = 0) AND (@chunkAged = 0))
				SET @o_jobStatus = 1 /*JMSUCCESS*/
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = ERROR_NUMBER( )
		;THROW
	END CATCH
	SELECT @o_errorCode, @o_jobStatus
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyGetJobStatus')
	delete from GxQscripts where name = 'archChunkToVerifyGetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyGetJobStatus')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyGetJobStatus'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyGetJobStatus',  '00010001000400020000', 'archChunkToVerifyGetJobStatus', '00010001000400020000')
GO

