

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerifyCheckConflictingJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerifyCheckConflictingJob.sp,v $ $Id: archChunkToVerifyCheckConflictingJob.sp,v 1.6.12.10 2020/12/19 15:05:06 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archChunkToVerifyCheckConflictingJob')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerifyCheckConflictingJob <<<'
	drop procedure archChunkToVerifyCheckConflictingJob
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerifyCheckConflictingJob')
	delete from GxQscripts where name = 'archChunkToVerifyCheckConflictingJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyCheckConflictingJob')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyCheckConflictingJob'
GO
print '... Creating Procedure: archChunkToVerifyCheckConflictingJob'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archChunkToVerifyCheckConflictingJob
  @i_archGroupId int,
  @i_archGroupCopyId int,
  @i_SIDBStoreId int = 0,
  @i_subOpType INT = 0
AS
  DECLARE @conflictingJobID integer;
  DECLARE @conflictingJobOptype integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
DECLARE	@l_dedupeFlags INTEGER = 0
DECLARE @t_ConflictingJobIds TABLE (JobID INTEGER, JobOptype INTEGER, JobSubOpType INTEGER, SIDBStoreId INTEGER)
SELECT	@l_dedupeFlags = dedupeFlags
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	id = @i_archGroupCopyId
DECLARE @tblCopyStoreList TABLE
(
	SIDBStoreId		integer,
	flags				integer,
	PRIMARY KEY(SIDBStoreId)
)
INSERT INTO @tblCopyStoreList
SELECT	SIDBStoreId, flags
FROM	archCopySIDBStore WITH (READUNCOMMITTED)
WHERE	copyId = @i_archGroupCopyId
AND (flags & 4) > 0
INSERT INTO @t_ConflictingJobIds
SELECT	J.JobId, J.optype, JI.subOpType, J.cloudId
FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
		INNER JOIN JMJobInfo JI WITH (READUNCOMMITTED) ON J.jobId = JI.jobId AND J.commCellId = JI.commCellId
WHERE	(J.opType = 31 /*ARCHIVECHECK*/ AND (J.archGrpID = @i_archGroupId AND (J.archGrpCopyId = 0 OR J.archGrpCopyId = @i_archGroupCopyId OR @i_archGroupCopyId = 0)))
		OR (@i_SIDBStoreId > 0 AND J.opType = 80 /*DEDUPDBSYNC*/ AND J.archGrpID = @i_archGroupId AND (J.archGrpCopyId = @i_archGroupCopyId OR @i_archGroupCopyId = 0)
AND dbo.GetJobOption(J.jobId, 1777365717) = @i_SIDBStoreId)
-- If copy is use GDSP, then check if there DV job running on the store
IF (@i_archGroupCopyId != 0 AND (@l_dedupeFlags & 134217728) != 0)
BEGIN
	INSERT INTO @t_ConflictingJobIds
	SELECT	J.JobId, J.optype, JI.subOpType, J.cloudId
	FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
			INNER JOIN JMJobInfo JI WITH (READUNCOMMITTED) ON J.jobId = JI.jobId AND J.commCellId = JI.commCellId, @tblCopyStoreList C
	WHERE	J.opType = 31 /*ARCHIVECHECK*/
            AND J.cloudId = C.SIDBStoreID
    --StoreId in stored in JMAdminJobInfoTable->cloudId for dv2 jobs.
END
-- If copy is GDSP Copy, then check if there DV job running on dependent copy or on storage policy of dependent copy  for this store
ELSE IF (@i_archGroupCopyId != 0 AND (@l_dedupeFlags & 268435456) != 0 AND @i_SIDBStoreId > 0)
BEGIN
	INSERT INTO @t_ConflictingJobIds
	SELECT	J.JobId, J.optype, JI.subOpType, J.cloudId
	FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
			INNER JOIN JMJobInfo JI WITH (READUNCOMMITTED) ON J.jobId = JI.jobId AND J.commCellId = JI.commCellId, archGroupCopy AGC WITH (READUNCOMMITTED), archCopySIDBStore S WITH (READUNCOMMITTED)
	WHERE	J.opType = 31 /*ARCHIVECHECK*/
			AND S.SIDBStoreId = @i_SIDBStoreId
			AND S.CopyId = AGC.id
AND (AGC.dedupeFlags & 134217728) != 0
			AND J.archGrpID = AGC.archGroupId
			AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = S.CopyId)
END
-- If we are running dv on storage policy, make sure no dv2 job is running on the Stores for the copies of this storage policy
ELSE IF (@i_archGroupCopyId = 0)
BEGIN
	INSERT INTO @t_ConflictingJobIds
	SELECT	J.JobId, J.optype, JI.subOpType, J.cloudId
	FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
			INNER JOIN JMJobInfo JI WITH (READUNCOMMITTED) ON J.jobId = JI.jobId AND J.commCellId = JI.commCellId
	WHERE	J.opType = 31 /*ARCHIVECHECK*/
			AND J.cloudId IN
                                (SELECT	S1.SIDBStoreId
								  FROM	    archGroupCopy AGC1 WITH (READUNCOMMITTED), archCopySIDBStore S1 WITH (READUNCOMMITTED)
								  WHERE		AGC1.archGroupId = @i_archGroupId
AND (AGC1.dedupeFlags & 134217728) != 0
											AND AGC1.id = S1.CopyId)
END
/* MR: 303807, Queue the scalable DV2 jobs also
IF (@i_SIDBStoreId > 0 AND @i_subOpType = 106 /*ARCHIVECHECK2*/)
BEGIN
	DELETE FROM @t_ConflictingJobIds
	WHERE	JobSubOpType = 106 /*ARCHIVECHECK2*/
			AND SIDBStoreId > 0
			AND SIDBStoreId != @i_SIDBStoreId
END
*/
CX_EXIT:
	SELECT	JobId, JobOptype
	FROM	@t_ConflictingJobIds
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerifyCheckConflictingJob')
	delete from GxQscripts where name = 'archChunkToVerifyCheckConflictingJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerifyCheckConflictingJob')
	delete from GXDBVersions where aliasname = 'archChunkToVerifyCheckConflictingJob'
GO

insert into GXDBVersions values(2, 'archChunkToVerifyCheckConflictingJob',  '00010006001200100000', 'archChunkToVerifyCheckConflictingJob', '00010006001200100000')
GO

