

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerify2Segment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerify2Segment.sp,v $ $Id: archChunkToVerify2Segment.sp,v 1.3.54.7 2020/05/07 19:45:42 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerify2Segment')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerify2Segment <<<'
	drop procedure archChunkToVerify2Segment
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerify2Segment')
	delete from GxQscripts where name = 'archChunkToVerify2Segment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2Segment')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2Segment'
GO
print '... Creating Procedure: archChunkToVerify2Segment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerify2Segment
  @i_adminJobId int,
  @i_archCopyId int,
  @i_minSegmentGB bigint
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
  DECLARE @o_lastSegmentId integer;
SET NOCOUNT ON
DECLARE @l_currentPhase INTEGER = (SELECT currentPhase FROM JMJobInfo WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
DECLARE @dedupeValidate INT = 0
DECLARE @dataValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE	@opId INT = 0
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	@dedupeValidate = [Validate Dedupe Data],
		@dataValidate =  [Verify Data],
		@orphanListing = [Orphan Chunk listing],
		@defragment = [Defragment Data]
FROM
	(SELECT	phase, name
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId) AS JP
	PIVOT
	(
	MAX(phase)
	FOR name IN ([Validate Dedupe Data], [Verify Data], [Orphan Chunk listing], [Defragment Data])
	) p;
BEGIN TRAN archChunkToVerify2Segment_tran
	IF object_id('tempdb.dbo.#tblChunkToVerify2') IS NOT NULL DROP TABLE #tblChunkToVerify2
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	DECLARE	@cursor	INTEGER
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	DECLARE @segmentId	INTEGER
	SET @segmentId = 0
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	SET @cursor = 0
	create table #tblChunkToVerify2 (
		id					integer IDENTITY (1,1),
		SrcCopyId			integer,
		archChunkId			bigint,
		ChunkCommCellId		integer,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		srcStreamNum		integer,
		physicalSize		bigint,
		segmentID			integer,
		primary key (id)
	)
	create index ChunkToCopy_temp_idx_1 on #tblChunkToVerify2 (archFileId, commCellId)
	create index ChunkToCopy_temp_idx_2 on #tblChunkToVerify2 (archChunkId, ChunkCommCellId)
	create table #tblChunkInSegment (
		id					integer,
		SrcCopyId			integer,
		archChunkId			bigint,
		ChunkCommCellId		integer,
		archFileId			integer,
		commCellId			integer,
		mediaGroupId		integer,
		srcStreamNum		integer,
		physicalSize		bigint,
		segmentID			integer,
		primary key (id)
	)
	create index ChunkInSegment_temp_idx_1 on #tblChunkInSegment (archFileId, commCellId)
	create index ChunkInSegment_temp_idx_2 on #tblChunkInSegment (archChunkId, ChunkCommCellId)
	-- If DSA flag is not set on the copy, set segment as the source copy archstream
	IF EXISTS (SELECT * FROM ArchGroup sp WITH (NOLOCK), ArchGroupCopy copy WITH (NOLOCK)
				WHERE copy.Id = @i_archCopyId
				AND		copy.ArchGroupId = sp.Id
AND		(sp.flags & 131072/*CVA_SP_DYNAMIC_STREAM_ALLOCATION_FLAG*/) = 0)
	   AND @l_currentPhase NOT IN (@dedupeValidate, @orphanListing, @defragment) /*DEDUPVALIDATE, ORPHANLISTING, DEFRAGMENT*/
	BEGIN
		INSERT INTO archChunkToVerify2SegmentTable (ArchCopyId, MediaGroupId)
		SELECT	T.SrcCopyId, T.MediaGroupId
		FROM	(SELECT DISTINCT A.SrcCopyId, A.MediaGroupId
				FROM ArchChunkToVerify2 a WITH (NOLOCK)
				WHERE a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
				AND a.segmentId = 0) T LEFT OUTER JOIN archChunkToVerify2SegmentTable S
					ON	T.SrcCopyId = S.ArchCopyId
						AND T.MediaGroupId = S.MediaGroupId
		WHERE	S.ArchCopyId IS NULL
		UPDATE ArchChunkToVerify2
		SET	segmentId = S.SegmentId
		FROM ArchChunkToVerify2 a, archChunkToVerify2SegmentTable S
		WHERE a.adminJobId = @i_adminJobId
		AND a.SrcCopyId = @i_archCopyId
		AND a.segmentId = 0
		AND S.ArchCopyId = A.SrcCopyId
		AND S.MediaGroupId = A.MediaGroupId
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToVerify2 a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
		GOTO CX_EXIT
	END
	IF @i_minSegmentGB = 0
		SET @i_minSegmentGB = 2
	-- Do not support dynamic stream allocation for snap copy
	IF EXISTS (SELECT * FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_archCopyId AND isSnapCopy = 1)
		GOTO CX_EXIT
	DECLARE @multiplex         INTEGER = 0
    if exists (
            select SrcCopyId, archChunkId
            from ArchChunkToVerify2 with (NOLock)
            where SrcCopyId = @i_archCopyId AND adminJobId = @i_adminJobId
            group by SrcCopyId, archChunkId having count(archFileId) > 1
            )
    SET @multiplex = 1
	INSERT INTO #tblChunkToVerify2
	SELECT a.SrcCopyId, a.archChunkId, a.ChunkCommCellId, a.archFileId, a.commCellId, a.mediaGroupId, a.srcStreamNum, a.physicalSize, 0
	FROM ArchChunkToVerify2 a WITH (NOLOCK)
	WHERE a.adminJobId = @i_adminJobId
	AND a.srcCopyId = @i_archCopyId
	AND a.MediaType != 10001
	AND a.segmentId = 0
	-- For tape copy source ignore DSA
	IF EXISTS (SELECT * FROM #tblChunkToVerify2)
	BEGIN
		INSERT INTO ArchChunkToVerify2SegmentTable (ArchCopyId, MediaGroupId)
		SELECT	T.SrcCopyId, T.MediaGroupId
		FROM	(SELECT DISTINCT A.SrcCopyId, A.MediaGroupId
				FROM ArchChunkToVerify2 a WITH (NOLOCK), #tblChunkToVerify2 T
				WHERE a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
				AND A.SrcCopyId = T.SrcCopyId
				AND A.archChunkId = T.archChunkId
				AND A.ChunkCommCellId = T.ChunkCommCellId) T LEFT OUTER JOIN ArchChunkToVerify2SegmentTable S
					ON	T.SrcCopyId = S.ArchCopyId
						AND T.MediaGroupId = S.MediaGroupId
		WHERE	S.ArchCopyId IS NULL
		UPDATE ArchChunkToVerify2
		SET	segmentId = S.SegmentId
		FROM ArchChunkToVerify2 a, ArchChunkToVerify2SegmentTable S
		WHERE a.adminJobId = @i_adminJobId
		AND a.srcCopyId = @i_archCopyId
		AND a.segmentId = 0
		AND S.ArchCopyId = A.SrcCopyId
		AND S.MediaGroupId = A.MediaGroupId
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToVerify2 a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.destCopyId = @i_archCopyId
	END
	DELETE FROM #tblChunkToVerify2
	INSERT INTO #tblChunkToVerify2
	SELECT a.SrcCopyId, a.archChunkId, a.ChunkCommCellId, a.archFileId, a.commCellId, a.mediaGroupId, a.srcStreamNum, a.physicalSize, 0
	FROM ArchChunkToVerify2 a WITH (NOLOCK)
	WHERE a.adminJobId = @i_adminJobId
	AND a.srcCopyId = @i_archCopyId
	AND a.mediaType = 10001
	AND a.segmentId = 0
	IF @@ROWCOUNT = 0
		GOTO CX_EXIT
	UPDATE #tblChunkToVerify2
	SET srcStreamNum = 0
	FROM #tblChunkToVerify2 a, ArchFileCopy b WITH (NOLOCK)
	WHERE a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND b.archCopyId = @i_archCopyId
AND b.flags & 2048 = 0
	and b.lastChunkNumber = 0 AND b.physicalSize = 0
	-- Clear source stream and media group info
	UPDATE ArchChunkToVerify2
	SET SrcStreamNum = 0
	FROM ArchChunkToVerify2 a, #tblChunkToVerify2 b
	WHERE  a.adminJobId = @i_adminJobId
	AND a.archChunkId = b.archChunkId
	AND a.ChunkCommCellId = b.ChunkCommCellId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.SrcCopyId = @i_archCopyId
	AND a.SrcCopyId = b.SrcCopyId
	SELECT @errVal = @@ERROR
	IF @errVal <> 0
	BEGIN
			SET @errStr = 'Failed to clear streams for ArchChunkToVerify2: DB error!'
			GOTO CX_EXIT_ERROR
	END
	DECLARE @archFileId		INTEGER
	DECLARE @commCellId		INTEGER
	DECLARE @SrcCopyId		INTEGER
	DECLARE @mediaGroupId	INTEGER
	DECLARE @srcStreamNum		INTEGER
	DECLARE @mediaGroupId_prev INTEGER
	SET @mediaGroupId_prev = -1
	DECLARE @srcStream_prev INTEGER
	SET @srcStream_prev = -1
	DECLARE AFCursor CURSOR FOR
			SELECT DISTINCT SrcCopyId, archFileId, commCellId, mediaGroupId, srcStreamNum
			FROM #tblChunkToVerify2
			ORDER BY SrcCopyId, mediaGroupId, commCellId, archFileId
	OPEN AFCursor
	SET @cursor = 1
	FETCH NEXT from AFCursor INTO @SrcCopyId, @archFileId, @commCellId, @mediaGroupId, @srcStreamNum
	WHILE (1 = 1)
	BEGIN
		DECLARE @fetchNext INTEGER
		SET @fetchNext = 1
		IF @@FETCH_STATUS <> 0
			GOTO CREATE_SEGMENT
		IF EXISTS (select * from #tblChunkToVerify2 WITH (NOLOCK)
					where  archFileId = @archFileId
					and commCellId = @commCellId
					and SrcCopyId = @SrcCopyId
					and segmentId > 0
					)
			GOTO FETCH_NEXT
		IF @mediaGroupId_prev < 0
			SET @mediaGroupId_prev = @mediaGroupId
		IF @srcStream_prev < 0
			SET @srcStream_prev = @srcStreamNum
		IF @mediaGroupId_prev <> @mediaGroupId
		BEGIN
			-- MediaGroupId changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @mediaGroupId_prev = @mediaGroupId
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		IF @srcStream_prev <> @srcStreamNum
		BEGIN
			-- destStreamNum changed, needs to group previous chunks
			-- This archive file will be processed again
			SET @srcStream_prev = @srcStreamNum
			SET @fetchNext = 0
			GOTO CREATE_SEGMENT
		END
		-- Set flag for all chunks of given archive file
		INSERT INTO #tblChunkInSegment
		SELECT a.*
		FROM #tblChunkToVerify2 a LEFT OUTER JOIN #tblChunkInSegment b ON a.id = b.id
		WHERE a.archFileId = @archFileId
		AND a.commCellId = @commCellId
		AND b.id IS NULL
		-- No new chunks of this archive file found
		IF @@ROWCOUNT = 0
			GOTO FETCH_NEXT
		WHILE (1 = 1)
		BEGIN
			DECLARE @sumSegmentSize bigint = 0
			DECLARE @numChunks integer = 0
			IF @multiplex > 0
			BEGIN
				-- Get linked chunks through multiplexing
				INSERT INTO #tblChunkInSegment
				SELECT DISTINCT b.*
				FROM #tblChunkInSegment a right outer join #tblChunkToVerify2 b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archChunkId = b.archChunkId AND c.ChunkCommCellId = b.ChunkCommCellId
				WHERE a.id is null
				SET @numChunks = @@ROWCOUNT
				IF @numChunks > 0
				BEGIN
					-- Add linked archive files.
					INSERT INTO #tblChunkInSegment
					SELECT DISTINCT b.*
					FROM #tblChunkInSegment a right outer join #tblChunkToVerify2 b on a.id = b.id INNER JOIN #tblChunkInSegment c ON c.archFileId = b.archFileId AND c.commCellId = b.commCellId
					WHERE a.id is null
					SET @numChunks = @@ROWCOUNT
				END
			END
			SET @sumSegmentSize = (SELECT SUM(physicalSize) FROM #tblChunkInSegment)
			IF @sumSegmentSize < @i_minSegmentGB * 1024 * 1024 * 1024
			BEGIN
				IF @numChunks = 0
					GOTO FETCH_NEXT
				ELSE
					CONTINUE
			END
			IF @numChunks = 0
				BREAK;
		END
CREATE_SEGMENT:
		IF EXISTS (SELECT * FROM #tblChunkInSegment)
		BEGIN
			INSERT INTO archChunkToVerify2SegmentTable (ArchCopyId, MediaGroupId)
			SELECT @i_archCopyId, 0
			SELECT @errVal = @@ERROR, @segmentId = @@IDENTITY
			IF @errVal <> 0 OR @segmentId = 0
			BEGIN
					SET @errStr = 'Failed to create new segment for data verification: DB error!'
					GOTO CX_EXIT_ERROR
			END
            DELETE FROM archChunkToVerify2SegmentTable WITH (ROWLOCK)
            WHERE segmentId = @segmentId
            SELECT @errVal = @@ERROR
            IF @errVal <> 0
            BEGIN
                SET @errStr = 'Failed to delete segment ID for data verification: DB error!'
                GOTO CX_EXIT_ERROR
            END
			UPDATE #tblChunkToVerify2
			SET segmentId = @segmentId
			FROM #tblChunkToVerify2 a, #tblChunkInSegment b
			WHERE  a.archChunkId = b.archChunkId
			AND a.ChunkCommCellId = b.ChunkCommCellId
			AND a.archFileId = b.archFileId
			AND a.commCellId = b.commCellId
			AND a.SrcCopyId = b.SrcCopyId
			SELECT @errVal = @@ERROR
			IF @errVal <> 0
			BEGIN
					SET @errStr = 'Failed to update segmentId for ArchChunkToVerify2: DB error!'
					GOTO CX_EXIT_ERROR
			END
			-- Clear temp table
			DELETE FROM #tblChunkInSegment
		END
		IF @@FETCH_STATUS <> 0
			GOTO CX_EXIT
FETCH_NEXT:
		IF @fetchNext = 1
			FETCH NEXT from AFCursor INTO @SrcCopyId, @archFileId, @commCellId, @mediaGroupId, @srcStreamNum
	END
CX_EXIT:
	UPDATE ArchChunkToVerify2
	SET segmentId = b.segmentId
	FROM ArchChunkToVerify2 a, #tblChunkToVerify2 b
	WHERE  a.adminJobId = @i_adminJobId
	AND a.archChunkId = b.archChunkId
	AND a.ChunkCommCellId = b.ChunkCommCellId
	AND a.archFileId = b.archFileId
	AND a.commCellId = b.commCellId
	AND a.SrcCopyId = b.SrcCopyId
	IF object_id('tempdb.dbo.#tblChunkToVerify2') IS NOT NULL DROP TABLE #tblChunkToVerify2
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	-- for parallel copy i might have reused segment id from other parallel copy
	IF (@segmentId = 0)
	BEGIN
		SELECT	@segmentId = MAX(segmentId)
		FROM	ArchChunkToVerify2 a
		WHERE	a.adminJobId = @i_adminJobId
				AND a.srcCopyId = @i_archCopyId
	END
	COMMIT TRAN archChunkToVerify2Segment_tran
	SELECT 0, '', @segmentId
	RETURN
CX_EXIT_ERROR:
	IF object_id('tempdb.dbo.#tblChunkToVerify2') IS NOT NULL DROP TABLE #tblChunkToVerify2
	IF object_id('tempdb.dbo.#tblChunkInSegment') IS NOT NULL DROP TABLE #tblChunkInSegment
	IF @cursor = 1
	BEGIN
		CLOSE AFCursor
		DEALLOCATE AFCursor
	END
	ROLLBACK TRAN archChunkToVerify2Segment_tran
	SELECT @errVal, @errStr, @segmentId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerify2Segment')
	delete from GxQscripts where name = 'archChunkToVerify2Segment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2Segment')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2Segment'
GO

insert into GXDBVersions values(2, 'archChunkToVerify2Segment',  '00010003005400070000', 'archChunkToVerify2Segment', '00010003005400070000')
GO

