

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerify2IsRepopulateRequired.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerify2IsRepopulateRequired')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerify2IsRepopulateRequired <<<'
	drop procedure archChunkToVerify2IsRepopulateRequired
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerify2IsRepopulateRequired')
	delete from GxQscripts where name = 'archChunkToVerify2IsRepopulateRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2IsRepopulateRequired')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2IsRepopulateRequired'
GO
print '... Creating Procedure: archChunkToVerify2IsRepopulateRequired'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerify2IsRepopulateRequired
  @i_adminJobId int,
  @i_notPickNewData int
AS
  DECLARE @retCode int
  DECLARE @repopulate int
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- repopulate [ 0 : No ]  [ 1 : Yes ]
BEGIN TRY
	DECLARE @l_retCode INT = 0
	DECLARE @l_repopulate INT = 0
	DECLARE @l_archGroupId INT = 0
	DECLARE @l_archGroupCopyId INT = 0
	DECLARE @l_SIDBStoreId INTEGER = 0
	DECLARE @l_endTime INT = 0x7FFFFFFF
	DECLARE @l_ddbVerificationLevel INTEGER = 0
	DECLARE @l_jobStartTime INTEGER = (SELECT servStart FROM JMAdminJobInfoTable WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
	DECLARE @l_totalJobsToProcess INTEGER = 1000
	DECLARE @l_jobsFromTime INTEGER = 0
	DECLARE @l_jobsToTime INTEGER = 0
	DECLARE @l_lastPopulatedJobId INTEGER = 0
	DECLARE @mediaTable TABLE (mediaId INTEGER)
	DECLARE @jobOptionXML XML = NULL
	SET @jobOptionXML = (SELECT dbo.GetXMLJobOptions(@i_AdminJobId))
	IF (@jobOptionXML IS NULL OR LEN(CAST(@jobOptionXML AS NVARCHAR(MAX))) = 0)
	BEGIN
SET @l_retCode = 5
		SELECT @l_retCode, 0
		RETURN
	END
	SELECT @l_lastPopulatedJobId = attributeValueInt
	FROM JMJobOptions WITH (READUNCOMMITTED)
	WHERE jobId = @i_adminJobId AND commcellId = 2
AND attributeId = 90
SELECT	@l_ddbVerificationLevel = (CASE WHEN optionId = 2064661278  THEN CAST(value AS INT) ELSE @l_ddbVerificationLevel END),
@l_SIDBStoreId = (CASE WHEN optionId = 229570007 THEN CAST(value AS INT) ELSE @l_SIDBStoreId END),
@l_totalJobsToProcess = (CASE WHEN optionId = 1654993746 THEN CAST(value AS INT) ELSE @l_totalJobsToProcess END),
@l_jobsFromTime = (CASE WHEN optionId = 1802027523  THEN CAST(value AS INT) ELSE @l_jobsFromTime END),
@l_jobsToTime = (CASE WHEN optionId = 458275378 THEN CAST(value AS INT) ELSE @l_jobsToTime END)
	FROM	dbo.GetAllJobOptions(@i_adminJobId)
WHERE	optionId IN (1616894445, 229570007, 1654993746, 1802027523, 458275378)
	IF (@l_jobsFromTime = 0)
		SET @l_jobsFromTime = -1
	IF (@l_jobsToTime = 0)
		SET @l_jobsToTime = 2147483647
	IF @i_notPickNewData > 0
		SET @l_endTime = @l_jobStartTime
	IF OBJECT_ID('tempdb.dbo.#archVerifyCopy') IS NOT NULL DROP TABLE #archVerifyCopy
	CREATE TABLE #archVerifyCopy ( archCopyId INT PRIMARY KEY (archCopyId))
	SELECT @l_archGroupId = archGrpId, @l_archGroupCopyId = archGrpCopyId
	FROM JMAdminJobInfoTable WITH (NOLOCK)
	WHERE jobId = @i_adminJobId
	INSERT #archVerifyCopy
	SELECT AGC.id
	FROM JMAdminJobInfoTable  JA WITH (NOLOCK), archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE jobId = @i_adminJobId
		AND (JA.archGrpCopyId = 0 OR (JA.archGrpCopyId > 0  AND JA.archGrpCopyId = AGC.id ))
		AND JA.archGrpId = AG.id
		AND AGC.archGroupId = AG.id
AND AGC.type <> 5
AND AGC.flags & 524288   = 0    --SILO copy
AND AGC.extendedflags & 8  = 0
		AND AGC.isSnapCopy = 0      -- Snap Copy
	IF @l_archGroupCopyId = 0
	BEGIN
		DELETE	DC
		FROM	#archVerifyCopy DC, JMAdminJobInfoTable  JA WITH (NOLOCK) INNER JOIN JMJobInfo J WITH (NOLOCK) ON JA.JobID = J.JobID AND JA.CommCellId = JA.CommCellId
		WHERE	JA.jobId != @i_adminJobId
				AND JA.opType IN (31) /*ARCHIVECHECK*/
				AND JA.archGrpId = @l_archGroupId
				AND DC.archCopyId = JA.archGrpCopyId
				AND J.State NOT IN (4,5,6,7,8,9,10,11,12,13,19)   -- COMPLETED,STOPPED,KILLPENDING,STOPPENDING,INTERRUPTPENDING,COMPLETEDSUCCESS, COMPLETEDFAIL,STATEKILLED,COMPLETEDPARTIAL,COMPLETEDWITHWARNINGS
	END
	INSERT @mediaTable
	SELECT mediaToVerify.Col.value('(@mediaId)[1]','INTEGER') AS MediaId
	FROM  @jobOptionXML.nodes('/TMMsg_JobOption/adminOpts/archiveCheckOption/mediaToVerify') AS mediaToVerify(Col)
	IF EXISTS (SELECT TOP 1 * FROM @mediaTable)
	BEGIN
		IF (EXISTS (	SELECT TOP 1 JDS.archGrpCopyId, JDS.jobId, JDS.commCellId
					FROM	#archVerifyCopy C
							INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON C.archCopyId = JDS.archGrpCopyId
							LEFT OUTER JOIN archChunkToVerify2 ACV WITH (READUNCOMMITTED)
										ON	ACV.adminJobId = @i_adminJobId
											AND ACV.BackupJobId = JDS.jobId
											AND ACV.commCellId = JDS.commCellId
											AND ACV.SrcCopyId = JDS.archGrpCopyId
											AND ACV.fileType = JDS.dataType
WHERE	JDS.disabled & 256 = 0
							AND	JDS.archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
							AND JDS.copiedTime < @l_endTime
							AND JDS.copiedTime BETWEEN @l_jobsFromTime AND @l_jobsToTime
							AND JDS.JobId > @l_lastPopulatedJobId
							AND ACV.adminJobId IS NULL
					))
			SET @l_repopulate = 1
	END
	ELSE IF @l_SIDBStoreId = 0
	BEGIN
		IF (EXISTS (SELECT TOP (@l_totalJobsToProcess) JDS.archGrpCopyId, JDS.jobId, JDS.commCellId
					FROM	#archVerifyCopy C
							INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON C.archCopyId = JDS.archGrpCopyId
							LEFT OUTER JOIN archChunkToVerify2 ACV WITH (READUNCOMMITTED)
										ON	ACV.adminJobId = @i_adminJobId
											AND ACV.BackupJobId = JDS.jobId
											AND ACV.commCellId = JDS.commCellId
											AND ACV.SrcCopyId = JDS.archGrpCopyId
											AND ACV.fileType = JDS.dataType
WHERE	JDS.disabled & 256 = 0
							AND	JDS.archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
							AND JDS.copiedTime < @l_endTime
							AND JDS.copiedTime BETWEEN @l_jobsFromTime AND @l_jobsToTime
							AND ACV.adminJobId IS NULL
							AND JDS.jobId > @l_lastPopulatedJobId
					GROUP BY JDS.archGrpCopyId, JDS.commCellId, JDS.jobId
					ORDER BY JDS.JobId, JDS.CommCellId
					))
			SET @l_repopulate = 1
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT	@l_retCode = ERROR_NUMBER()
	;THROW
END CATCH
IF OBJECT_ID('tempdb.dbo.#archVerifyCopy') IS NOT NULL DROP TABLE #archVerifyCopy
SELECT @l_retCode, @l_repopulate
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerify2IsRepopulateRequired')
	delete from GxQscripts where name = 'archChunkToVerify2IsRepopulateRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2IsRepopulateRequired')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2IsRepopulateRequired'
GO

insert into GXDBVersions values(2, 'archChunkToVerify2IsRepopulateRequired',  '00000000000000000000', 'archChunkToVerify2IsRepopulateRequired', '00000000000000000000')
GO

