

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerify2IsReaderAvailableForReservation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerify2IsReaderAvailableForReservation.sp,v $ $Id: archChunkToVerify2IsReaderAvailableForReservation.sp,v 1.1.4.7 2020/08/28 18:57:06 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerify2IsReaderAvailableForReservation')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerify2IsReaderAvailableForReservation <<<'
	drop procedure archChunkToVerify2IsReaderAvailableForReservation
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerify2IsReaderAvailableForReservation')
	delete from GxQscripts where name = 'archChunkToVerify2IsReaderAvailableForReservation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2IsReaderAvailableForReservation')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2IsReaderAvailableForReservation'
GO
print '... Creating Procedure: archChunkToVerify2IsReaderAvailableForReservation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archChunkToVerify2IsReaderAvailableForReservation
  @i_AdminJobId integer,
  @i_includeAttemptState integer
AS
  DECLARE @IsReaderAvailableForReservation integer;
  DECLARE @errorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@IsReaderAvailableForReservation = 0
SET	@errorCode = 0
DECLARE @dedupeValidate INT = 0
DECLARE @dataValidate	INT = 0
DECLARE @defragment		INT = 0
DECLARE @orphanListing	INT = 0
DECLARE	@opId			INT = 0
DECLARE @jobPhase		INT = 0
SELECT  @jobPhase = ISNULL(currentPhase, 0)
FROM	JMJobInfo WITH (NOLOCK)
WHERE	jobId = @i_adminJobId
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	@dedupeValidate = [Validate Dedupe Data],
		@dataValidate =  [Verify Data],
		@orphanListing = [Orphan Chunk listing],
		@defragment = [Defragment Data]
FROM
	(SELECT	phase, name
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId) AS JP
	PIVOT
	(
	MAX(phase)
	FOR name IN ([Validate Dedupe Data], [Verify Data], [Orphan Chunk listing], [Defragment Data])
	) p;
/*DEDUPVALIDATE, ORPHANLISTING, DEFRAGMENT*/
IF (@jobPhase = @dedupeValidate OR
	@jobPhase = @orphanListing OR
	@jobPhase = @defragment)
BEGIN
	SET	@IsReaderAvailableForReservation = 1
	GOTO ERR_EXIT
END
ELSE IF EXISTS (	SELECT	TOP 1 segmentid
			FROM	ArchChunkToVerify2 WITH (READUNCOMMITTED)
			WHERE	adminJobID = @i_AdminJobId
AND Status IN (0, 1)
			GROUP BY segmentId
HAVING (SUM(CASE WHEN Status = 0 THEN 1 ELSE 0 END) > 0 AND SUM(CASE WHEN Status = 1 THEN 1 ELSE 0 END) = 0)
		  )
BEGIN
	SET	@IsReaderAvailableForReservation = 1
	GOTO ERR_EXIT
END
ELSE IF EXISTS (	SELECT TOP 1 *
			FROM	archChunkToVerify2 AR WITH (READUNCOMMITTED)
			WHERE	AR.adminJobId = @i_AdminJobId
AND AR.Status IN (1, 5, 3)) AND
		EXISTS (	SELECT *
					FROM	JMJobInfo WITH (READUNCOMMITTED)
					WHERE	JobId = @i_AdminJobId
							AND (State = 3 OR displayState = 3) /*WAINTING*/)
BEGIN
	DECLARE @archChunkToVerify2GetJobStatusResultTable TABLE (
		errorCode	integer,
		jobStatus	integer,
		agedChunksSkipped	integer)
	INSERT INTO @archChunkToVerify2GetJobStatusResultTable
	EXEC archChunkToVerify2GetJobStatus @i_AdminJobId, @i_includeAttemptState
	IF (EXISTS (	SELECT TOP 1 *
			FROM	@archChunkToVerify2GetJobStatusResultTable
			WHERE	jobStatus IN (3 /*DASHCOPY_ARCHMGR_MORE_TO_COPY*/,
								  10 /*DASHCOPY_ARCHMGR_MORE_TO_COPY_ALL_SKIPPED*/,
								  11 /*DASHCOPY_ARCHMGR_MORE_TO_COPY_PARTIAL_SUCCESS*/,
								  12 /*DASHCOPY_ARCHMGR_MORE_TO_COPY_FAILED*/
								  )
					AND errorCode = 0))
	BEGIN
		SET	@IsReaderAvailableForReservation = 1
		GOTO ERR_EXIT
	END
END
ERR_EXIT:
	SELECT @IsReaderAvailableForReservation, @errorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerify2IsReaderAvailableForReservation')
	delete from GxQscripts where name = 'archChunkToVerify2IsReaderAvailableForReservation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2IsReaderAvailableForReservation')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2IsReaderAvailableForReservation'
GO

insert into GXDBVersions values(2, 'archChunkToVerify2IsReaderAvailableForReservation',  '00010001000400070000', 'archChunkToVerify2IsReaderAvailableForReservation', '00010001000400070000')
GO

