

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerify2Insert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerify2Insert.sp,v $ $Id: archChunkToVerify2Insert.sp,v 1.8.2.14 2020/10/27 17:57:40 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerify2Insert')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerify2Insert <<<'
	drop procedure archChunkToVerify2Insert
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerify2Insert')
	delete from GxQscripts where name = 'archChunkToVerify2Insert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2Insert')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2Insert'
GO
print '... Creating Procedure: archChunkToVerify2Insert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerify2Insert
  @i_adminJobId int,
  @i_archCopyId int,
  @i_checkFlags int,
  @i_isNewAttempt int,
  @i_notPickNewData int,
  @i_isForNewData int
AS
  DECLARE @retVal integer;
  DECLARE @nInsertedChunks int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION
DECLARE	@oneConstReal REAL = 1.0
DECLARE @l_SIDBStoreId INTEGER = 0
DECLARE @mediaTable TABLE (mediaId INTEGER)
DECLARE @jobOptionXML XML = NULL
DECLARE	@l_insertedChunksCount int = 0
DECLARE @l_endTime INT = 0x7FFFFFFF
DECLARE @l_currentTime INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @rowCount INT = 0
DECLARE @JMDVFlag INT = 0
SELECT	@JMDVFlag = intData
FROM	JMMisc
WHERE	jobId = @i_adminJobId
AND commCellId = 2
AND itemType = 78
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
SET @jobOptionXML = (SELECT dbo.GetXMLJobOptions(@i_AdminJobId))
IF (@jobOptionXML IS NULL OR LEN(CAST(@jobOptionXML AS NVARCHAR(MAX))) = 0)
BEGIN
SET @retVal = 5
	IF  @retVal <> 0 GOTO FINISH
END
DECLARE @l_ddbVerificationLevel INTEGER = 0
DECLARE @l_jobStartTime INTEGER = (SELECT servStart FROM JMAdminJobInfoTable WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
DECLARE @l_currentPhase INTEGER = (SELECT currentPhase FROM JMJobInfo WITH (READUNCOMMITTED) WHERE	jobId = @i_adminJobId)
DECLARE @l_totalJobsToProcess INTEGER = 1000
DECLARE @l_jobsFromTime INTEGER = 0
DECLARE @l_jobsToTime INTEGER = 0
DECLARE @l_lastPopulatedJobId INTEGER = 0
DECLARE @l_xmlLastPopulatedJobIdList XML = NULL
DECLARE @l_archGroupId INTEGER = 0
DECLARE @l_totalSize bigint = 0
DECLARE @l_isIncr INTEGER = 0
DECLARE @l_backupLevel INTEGER = 0
DECLARE @l_currentPopulatedJobCount INTEGER = 0
IF object_id('tempdb.dbo.#tempJobsToProcess') IS NOT null DROP TABLE #tempJobsToProcess
CREATE TABLE #tempJobsToProcess (archCopyId INTEGER, jobId INTEGER PRIMARY KEY(archCopyId, jobId))
SELECT	@l_archGroupId = archGroupId
FROM	archGroupCopy AGC WITH (READUNCOMMITTED)
WHERE	id = @i_archCopyId
SELECT	@l_xmlLastPopulatedJobIdList = CAST(attributeValue AS XML)
FROM	JMJobOptions WITH (READUNCOMMITTED)
WHERE	jobId = @i_adminJobId
		AND CommCellId = 2
AND attributeId = 90
IF (@l_xmlLastPopulatedJobIdList IS NOT NULL)
BEGIN
	INSERT INTO #tempJobsToProcess
	SELECT	Jobs.Node.value('@cp', 'INTEGER') archCopyId,
			Jobs.Node.value('@j', 'INTEGER') jobId
	FROM	@l_xmlLastPopulatedJobIdList.nodes('//JobIds/I') Jobs(Node)
	SELECT	@l_lastPopulatedJobId = T.jobId
	FROM	#tempJobsToProcess T
	WHERE	T.archCopyId = @i_archCopyId
END
SELECT	@l_ddbVerificationLevel = (CASE WHEN optionId = 1616894445  THEN CAST(value AS INT) ELSE @l_ddbVerificationLevel END),
@l_SIDBStoreId = (CASE WHEN optionId = 229570007 THEN CAST(value AS INT) ELSE @l_SIDBStoreId END),
@l_totalJobsToProcess = (CASE WHEN optionId = 1654993746 THEN CAST(value AS INT) ELSE @l_totalJobsToProcess END),
@l_jobsFromTime = (CASE WHEN optionId = 1802027523  THEN CAST(value AS INT) ELSE @l_jobsFromTime END),
@l_jobsToTime = (CASE WHEN optionId = 458275378 THEN CAST(value AS INT) ELSE @l_jobsToTime END),
@l_backupLevel = (CASE WHEN optionId = 1492218294 THEN CAST(value AS INT) ELSE @l_backupLevel END)
FROM	dbo.GetAllJobOptions(@i_adminJobId)
WHERE	optionId IN (1616894445, 229570007, 1654993746,
1802027523, 458275378, 1492218294)
IF (@l_backupLevel = 2 /*TMMsg::BackupLevel_INCREMENTAL*/)
	SET @l_isIncr = 1
IF (@l_jobsFromTime = 0)
	SET @l_jobsFromTime = -1
IF (@l_jobsToTime = 0)
	SET @l_jobsToTime = 2147483647
IF @i_notPickNewData > 0
	SET @l_endTime = @l_jobStartTime
IF (@l_totalJobsToProcess <= 0)
	SET @l_totalJobsToProcess = 2147483647
DECLARE @dedupeValidate INT = 0
DECLARE @dataValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE	@opId INT = 0
SELECT	@opId = id
FROM	JMOpTable WITH (READUNCOMMITTED)
WHERE	operation=31 /*ARCHIVECHECK*/
SELECT	@dedupeValidate = [Validate Dedupe Data],
		@dataValidate =  [Verify Data],
		@orphanListing = [Orphan Chunk listing],
		@defragment = [Defragment Data]
FROM
	(SELECT	phase, name
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId) AS JP
	PIVOT
	(
	MAX(phase)
	FOR name IN ([Validate Dedupe Data], [Verify Data], [Orphan Chunk listing], [Defragment Data])
	) p;
IF object_id('tempdb.dbo.#tempJobs') IS NOT null DROP TABLE #tempJobs
CREATE TABLE #tempJobs (
	archCopyId int, jobId int, commCellId int PRIMARY KEY(archCopyId, jobId, commcellId)
)
IF object_id('tempdb.dbo.#tempJobsAF') IS NOT null DROP TABLE #tempJobsAF
CREATE TABLE #tempJobsAF (
	archFileId INT, commCellId INT, archCopyId INT, fileType INT, appId INT PRIMARY KEY(archFileId, commcellId, archCopyId)
)
IF (@i_isNewAttempt = 1 AND @i_isForNewData = 0)
BEGIN
	UPDATE	ArchChunkToVerify2
SET		Status = 0,
			Modified = @l_currentTime
	WHERE	ArchChunkToVerify2.adminjobId = @i_adminJobId
			AND ArchChunkToVerify2.SrcCopyId = @i_archCopyId
AND (Status = 1
OR (ArchChunkToVerify2.Status = 3 AND ArchChunkToVerify2.SkippedCount < @MAX_FAILURE_COUNT))
				-- OR (ArchChunkToVerify2.Status = CVA_CHUNK_SKIPPED AND ArchChunkToVerify2.SkippedCount < @MAX_FAILURE_COUNT AND ArchChunkToVerify2.SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR))
				--  OR (ArchChunkToVerify2.Status = CVA_CHUNK_SKIPPED AND ArchChunkToVerify2.SkippedCount < 12 AND ArchChunkToVerify2.SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)))
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
END
UPDATE	ArchChunkToVerify2
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
FROM	ArchChunkToVerify2 R, JMJobDataStats JDS WITH (READUNCOMMITTED)
WHERE	R.AdminJobId = @i_adminJobId
		AND		R.SrcCopyId =  @i_archCopyId
ANd		R.Status IN ( 3, 5, 0)
		AND		R.BackupJobId = JDS.JobID
		AND		R.SrcCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
UPDATE	ArchChunkToVerify2
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
FROM	ArchChunkToVerify2 R, JMJobDataStats JDS WITH (READUNCOMMITTED)
WHERE	R.AdminJobId = @i_adminJobId
		AND		R.DestCopyId =  @i_archCopyId
ANd		R.Status IN ( 3, 5, 0)
		AND		R.BackupJobId = JDS.JobID
		AND		R.SrcCopyId = JDS.archGrpCopyId
		AND		R.fileType = JDS.dataType
		AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
INSERT @mediaTable
SELECT mediaToVerify.Col.value('(@mediaId)[1]','INTEGER') AS MediaId
FROM  @jobOptionXML.nodes('/TMMsg_JobOption/adminOpts/archiveCheckOption/mediaToVerify') AS mediaToVerify(Col)
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
IF EXISTS (SELECT TOP 1 * FROM @mediaTable)
BEGIN
	IF ((SELECT COUNT(*)
			FROM	(SELECT DISTINCT BackupJobId, CommCellId
					FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
					WHERE	V.adminJobId = @i_adminJobId
							AND V.SrcCopyId = @i_archCopyid
AND ((V.Status = 0)
OR (V.Status = 3 AND (V.SkippedCount < @MAX_FAILURE_COUNT OR V.ExtraFlags & 64 > 0))
OR (V.Status = 5))
					) T
			) >= @l_totalJobsToProcess)
			GOTO FINISH
	WHILE (1 = 1)
	BEGIN
		TRUNCATE TABLE #tempJobs
		INSERT INTO #tempJobs
		SELECT TOP (@l_totalJobsToProcess - @l_currentPopulatedJobCount) T.archGrpCopyId, T.jobId, T.commCellId
		FROM
			(SELECT TOP (@l_totalJobsToProcess - @l_currentPopulatedJobCount) JDS.archGrpCopyId, JDS.jobId, JDS.commCellId
			FROM	JMJobDataStats JDS WITH (READUNCOMMITTED)
					INNER JOIN JMBkpStats JBS WITH (READUNCOMMITTED) ON JDS.jobId = JBS.JobId AND JDS.CommCellId = JBS.CommCellId
					LEFT OUTER JOIN archChunkToVerify2 ACV WITH (READUNCOMMITTED)
								ON	ACV.adminJobId = @i_adminJobId
									AND ACV.BackupJobId = JDS.jobId
									AND ACV.commCellId = JDS.commCellId
									AND ACV.SrcCopyId = JDS.archGrpCopyId
									AND ACV.fileType = JDS.dataType
WHERE	JDS.archgrpCopyId = @i_archCopyId AND JDS.disabled & 256 = 0
					AND	JDS.archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
					AND JDS.copiedTime < @l_endTime
					AND JBS.servStartDate BETWEEN @l_jobsFromTime AND @l_jobsToTime
					AND JDS.JobId > @l_lastPopulatedJobId
					AND ACV.adminJobId IS NULL
			GROUP BY JDS.archGrpCopyId, JDS.commCellId, JDS.jobId
			UNION
			SELECT TOP (@l_totalJobsToProcess - @l_currentPopulatedJobCount) JDS.archGrpCopyId, JDS.jobId, JDS.commCellId
			FROM	JMJobDataStats JDS WITH (READUNCOMMITTED)
					INNER JOIN JMAdminJobStatsTable JBS WITH (READUNCOMMITTED) ON JDS.jobId = JBS.JobId AND JDS.CommCellId = JBS.CommCellId
					LEFT OUTER JOIN archChunkToVerify2 ACV WITH (READUNCOMMITTED)
								ON	ACV.adminJobId = @i_adminJobId
									AND ACV.BackupJobId = JDS.jobId
									AND ACV.commCellId = JDS.commCellId
									AND ACV.SrcCopyId = JDS.archGrpCopyId
									AND ACV.fileType = JDS.dataType
WHERE	JDS.archgrpCopyId = @i_archCopyId AND JDS.disabled & 256 = 0
					AND	JDS.archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
					AND JDS.copiedTime < @l_endTime
					AND JBS.servStart BETWEEN @l_jobsFromTime AND @l_jobsToTime
					AND JDS.JobId > @l_lastPopulatedJobId
					AND ACV.adminJobId IS NULL
			GROUP BY JDS.archGrpCopyId, JDS.commCellId, JDS.jobId
			ORDER BY JDS.JobId, JDS.CommCellId) T
		ORDER BY T.JobId, T.CommCellId
		SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
		IF  @retVal <> 0 GOTO FINISH
		IF @rowCount = 0 BREAK
		INSERT	INTO archChunkToVerify2 (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
				ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
				PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
				VolumeId, MediaId, MediaGroupId, MediaType,
				SrcMAId, SrcDrivePoolId,
				Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
				appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
				chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
				extraFlags, segmentId, IsParallelCopy, streamReaderID)
		SELECT
				DISTINCT @i_adminJobId, ACM.JobId, ACM.ArchFileId, ACM.CommCellId, ACM.ArchChunkId, ACM.ChunkCommCellId, ACM.ChunkNumber, 0,
				AGC.archGroupId, ACM.archCopyId, 0, 0, 0,
				0 /*PhysicalStartOffset*/, ACM.PhysicalOffset, ACM.LogicalOffset, ACM.PhysicalSize, ACM.LogicalSize, ACM.unCompSize,
				AC.VolumeId, MV.MediaId, MV.MediaGroupId, 0,
				0, 0,
				0, @l_currentTime, 0, 0, 0, 0,
				0, 0, 0, 0, AC.fileMarkerNo,
				AC.createTime, AC.version, AC.physicalSize, AC.logicalSize, AC.hwEncKey, '',
				0, 0, 0, 0
		FROM	#tempJobs JBS
				INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON JBS.jobId = ACM.jobId AND JBS.commCellId = ACM.commCellId AND JBS.archCopyId = ACM.archCopyId
				INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON ACM.archChunkId = AC.id AND ACM.ChunkCommCellId = AC.CommCellId
				INNER JOIN MMVolume MV WITH (READUNCOMMITTED) ON AC.VolumeId = MV.VolumeId
				INNER JOIN @mediaTable M ON MV.MediaId = M.mediaId
				INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AGC.id = ACM.archCopyId
		WHERE	ACM.archCopyId = @i_archCopyId
AND ACM.physicalSize > 0 AND (ACM.flags & @i_checkFlags) <> 0 AND (ACM.flags & 256) = 0
		SELECT	@retVal = @@ERROR, @l_insertedChunksCount = @l_insertedChunksCount + @@rowCount
		IF  @retVal <> 0 GOTO FINISH
		UPDATE	archChunkToVerify2
		SET		SrcStreamNum = b.streamNum, archFileCopyFlags = b.flags, lastChunkNumber = b.lastChunkNumber, encKeyType = b.encKeyType, archFileEncKey = b.encKey
		FROM	archChunkToVerify2 a, archFileCopy b WITH (READUNCOMMITTED)
		WHERE	a.adminJobId = @i_adminJobId
			AND a.SrcCopyid = @i_archCopyid
			AND b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.SrcCopyId
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		UPDATE	archChunkToVerify2
		SET		fileType = b.fileType, appId = b.appId, backupJobId = b.jobId
		FROM	archChunkToVerify2 a, archFile b WITH (READUNCOMMITTED)
		WHERE	a.adminJobId = @i_adminJobId
			AND a.SrcCopyid = @i_archCopyid
			AND a.archFileId = b.id AND a.commCellId = b.commCellId
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		SELECT  @l_currentPopulatedJobCount += COUNT(*)
		FROM	(SELECT DISTINCT BackupJobId, CommCellId
				FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
				WHERE	V.adminJobId = @i_adminJobId
						AND V.SrcCopyId = @i_archCopyid
						AND V.BackupJobId > @l_lastPopulatedJobId) T
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		SELECT	@l_lastPopulatedJobId = ISNULL(MAX(JobId), @l_lastPopulatedJobId)
		FROM	#tempJobs J
		IF ((SELECT COUNT(*)
			FROM	(SELECT DISTINCT BackupJobId, CommCellId
					FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
					WHERE	V.adminJobId = @i_adminJobId
							AND V.SrcCopyId = @i_archCopyid
AND ((V.Status = 0)
OR (V.Status = 3 AND (V.SkippedCount < @MAX_FAILURE_COUNT OR V.ExtraFlags & 64 > 0))
OR (V.Status = 5))
					) T
			) >= @l_totalJobsToProcess OR (@l_totalJobsToProcess = 2147483647))
			BREAK
	END
END
ELSE
IF ((@l_SIDBStoreId = 0) AND (@i_archCopyId > 0))
BEGIN
	IF ((SELECT COUNT(*)
			FROM	(SELECT DISTINCT BackupJobId, CommCellId
					FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
					WHERE	V.adminJobId = @i_adminJobId
							AND V.SrcCopyId = @i_archCopyid
AND ((V.Status = 0)
OR (V.Status = 3 AND (V.SkippedCount < @MAX_FAILURE_COUNT OR V.ExtraFlags & 64 > 0))
OR (V.Status = 5))
					) T
			) >= @l_totalJobsToProcess)
			GOTO FINISH
	WHILE (1 = 1)
	BEGIN
		TRUNCATE TABLE #tempJobs
		INSERT INTO #tempJobs
		SELECT TOP (@l_totalJobsToProcess - @l_currentPopulatedJobCount) T.archGrpCopyId, T.jobId, T.commCellId
		FROM
			(SELECT TOP (@l_totalJobsToProcess - @l_currentPopulatedJobCount) JDS.archGrpCopyId, JDS.jobId, JDS.commCellId
			FROM	JMJobDataStats JDS WITH (READUNCOMMITTED)
					INNER JOIN JMBkpStats JBS WITH (READUNCOMMITTED) ON JDS.jobId = JBS.JobId AND JDS.CommCellId = JBS.CommCellId
					LEFT OUTER JOIN archChunkToVerify2 ACV WITH (READUNCOMMITTED)
								ON	ACV.adminJobId = @i_adminJobId
									AND ACV.BackupJobId = JDS.jobId
									AND ACV.commCellId = JDS.commCellId
									AND ACV.SrcCopyId = JDS.archGrpCopyId
									AND ACV.fileType = JDS.dataType
WHERE	JDS.archgrpCopyId = @i_archCopyId AND JDS.disabled & 256 = 0
					AND	JDS.archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
					AND JDS.copiedTime < @l_endTime
					AND JBS.servStartDate BETWEEN @l_jobsFromTime AND @l_jobsToTime
					AND ACV.adminJobId IS NULL
					AND JDS.jobId > @l_lastPopulatedJobId
			GROUP BY JDS.archGrpCopyId, JDS.commCellId, JDS.jobId
			UNION
			SELECT TOP (@l_totalJobsToProcess - @l_currentPopulatedJobCount) JDS.archGrpCopyId, JDS.jobId, JDS.commCellId
			FROM	JMJobDataStats JDS WITH (READUNCOMMITTED)
					INNER JOIN JMAdminJobStatsTable JBS WITH (READUNCOMMITTED) ON JDS.jobId = JBS.JobId AND JDS.CommCellId = JBS.CommCellId
					LEFT OUTER JOIN archChunkToVerify2 ACV WITH (READUNCOMMITTED)
								ON	ACV.adminJobId = @i_adminJobId
									AND ACV.BackupJobId = JDS.jobId
									AND ACV.commCellId = JDS.commCellId
									AND ACV.SrcCopyId = JDS.archGrpCopyId
									AND ACV.fileType = JDS.dataType
WHERE	JDS.archgrpCopyId = @i_archCopyId AND JDS.disabled & 256 = 0
					AND	JDS.archCheckStatus IN (1 /*ACS_EXPIRED*/ , 3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/ , 6 /*ACS_FAILED */)
					AND JDS.copiedTime < @l_endTime
					AND JBS.servStart BETWEEN @l_jobsFromTime AND @l_jobsToTime
					AND ACV.adminJobId IS NULL
					AND JDS.jobId > @l_lastPopulatedJobId
			GROUP BY JDS.archGrpCopyId, JDS.commCellId, JDS.jobId
			ORDER BY JDS.JobId, JDS.CommCellId) T
		ORDER BY T.JobId, T.CommCellId
		SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
		IF  @retVal <> 0 GOTO FINISH
		IF @rowCount = 0 BREAK
		INSERT	INTO archChunkToVerify2 (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
				ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
				PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
				VolumeId, MediaId, MediaGroupId, MediaType,
				SrcMAId, SrcDrivePoolId,
				Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
				appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
				chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
				extraFlags, segmentId, IsParallelCopy, streamReaderID)
		SELECT	DISTINCT
				@i_adminJobId, ACM.JobId, ACM.ArchFileId, ACM.CommCellId, ACM.ArchChunkId, ACM.ChunkCommCellId, ACM.ChunkNumber, 0,
				AGC.archGroupId, ACM.archCopyId, 0, 0, 0,
				0 /*PhysicalStartOffset*/, ACM.PhysicalOffset, ACM.LogicalOffset, ACM.PhysicalSize, ACM.LogicalSize, ACM.unCompSize,
				AC.VolumeId, 0, 0, 0,
				0, 0,
				0, @l_currentTime, 0, 0, 0, 0,
				0, 0, 0, 0, AC.fileMarkerNo,
				AC.createTime, AC.version, AC.physicalSize, AC.logicalSize, AC.hwEncKey, '',
				0, 0, 0, 0
		FROM	#tempJobs J
				INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON J.jobId = ACM.jobId AND J.commCellId = ACM.commCellId AND J.archCopyId = ACM.archCopyId
				INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON ACM.archChunkId = AC.id AND ACM.ChunkCommCellId = AC.CommCellId
				INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AGC.id = ACM.archCopyId
		WHERE	ACM.archCopyId = @i_archCopyId
AND ACM.physicalSize > 0 AND (ACM.flags & @i_checkFlags) <> 0 AND (ACM.flags & 256) = 0
		SELECT	@retVal = @@ERROR, @l_insertedChunksCount = @l_insertedChunksCount + @@rowCount
		IF  @retVal <> 0 GOTO FINISH
		UPDATE	V
		SET		mediaId = MV.MediaId, mediaGroupId = MV.MediaGroupId
		FROM	archChunkToVerify2 V, MMVolume MV WITH (READUNCOMMITTED)
		WHERE	V.adminJobId = @i_adminJobId
			AND V.SrcCopyid = @i_archCopyid
			AND V.volumeId = MV.VolumeId
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		UPDATE	archChunkToVerify2
		SET		SrcStreamNum = b.streamNum, archFileCopyFlags = b.flags, lastChunkNumber = b.lastChunkNumber, encKeyType = b.encKeyType, archFileEncKey = b.encKey
		FROM	archChunkToVerify2 a, archFileCopy b WITH (READUNCOMMITTED)
		WHERE	a.adminJobId = @i_adminJobId
			AND a.SrcCopyid = @i_archCopyid
			AND b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.SrcCopyId
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		UPDATE	archChunkToVerify2
		SET		fileType = b.fileType, appId = b.appId, backupJobId = b.jobId
		FROM	archChunkToVerify2 a, archFile b WITH (READUNCOMMITTED)
		WHERE	a.adminJobId = @i_adminJobId
			AND a.SrcCopyid = @i_archCopyid
			AND a.archFileId = b.id AND a.commCellId = b.commCellId
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		SELECT  @l_currentPopulatedJobCount += COUNT(*)
		FROM	(SELECT DISTINCT BackupJobId, CommCellId
				FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
				WHERE	V.adminJobId = @i_adminJobId
						AND V.SrcCopyId = @i_archCopyid
						AND V.BackupJobId > @l_lastPopulatedJobId) T
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		SELECT	@l_lastPopulatedJobId = ISNULL(MAX(JobId), @l_lastPopulatedJobId)
		FROM	#tempJobs J
		IF ((SELECT COUNT(*)
			FROM	(SELECT DISTINCT BackupJobId, CommCellId
					FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
					WHERE	V.adminJobId = @i_adminJobId
							AND V.SrcCopyId = @i_archCopyid
AND ((V.Status = 0)
OR (V.Status = 3 AND (V.SkippedCount < @MAX_FAILURE_COUNT OR V.ExtraFlags & 64 > 0))
OR (V.Status = 5))
					) T
			) >= @l_totalJobsToProcess OR (@l_totalJobsToProcess = 2147483647))
			BREAK
	END
END
ELSE
IF ((@l_SIDBStoreId > 0) AND (@i_archCopyId > 0))
BEGIN
	-- Skip Defragment phase where no chunks are eligible for degragmentation
    SELECT @l_totalSize = attributeValueInt
	FROM JMJobOptions WITH (READUNCOMMITTED)
    WHERE jobId = @i_adminJobId AND commcellId = 2
AND attributeId = 54
	IF (@l_ddbVerificationLevel = 4 /*TMMsg::DDBVerificationLevel_ DDB_DEFRAGMENTATION*/ AND @@ROWCOUNT > 0)
	BEGIN
		IF EXISTS (SELECT * FROM JMJobInfo WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND CommCellId = 2 AND currentPhase = @defragment /*DEFRAGMENT*/)
		BEGIN
			IF (@l_totalSize > 0)
			BEGIN
				UPDATE	MountP
SET		Attribute = Attribute | 512
				FROM	(SELECT DISTINCT MediaSideId FROM MMVolume WITH (READUNCOMMITTED) WHERE SIDBStoreId = @l_SIDBStoreId) AS V,
						MMMountPath MountP WITH (READUNCOMMITTED)
WHERE	MountP.MediaSideId = V.MediaSideId AND (MountP.Attribute & 512) = 0
			END
			ELSE
			BEGIN
				-- Do not populate any chunks if there is nothing to defrag
				GOTO FINISH
			END
		END
	END
	DECLARE @chunkCreateTime BIGINT = 0
	DECLARE @returnTable TABLE (retVal INTEGER, allowBackup INTEGER, allowDefragmentation INTEGER, pickV11SP20MAs INTEGER)
	IF (@l_ddbVerificationLevel IN (1, 2, 3) /* QUICK_DDB_VERIFICATION, DDB_VERIFICATION, DDB_AND_DATA_VERIFICATION*/)
	BEGIN
		INSERT INTO @returnTable
		EXEC archChunkToVerifyPopulateMAsForDDBDataVerification @i_adminJobId, 1
		IF (@l_currentPhase = @dedupeValidate/*DEDUPVALIDATE*/)
		BEGIN
			IF (EXISTS(SELECT * FROM @returnTable WHERE allowBackup = 0) OR (@l_isIncr = 0))
			BEGIN
				SELECT @chunkCreateTime = 0
			END
			ELSE
				SELECT @chunkCreateTime = (CASE WHEN (@l_ddbVerificationLevel = 2) THEN LastDDBVerificationTime ELSE LastDataVerificationTime END)
				FROM	IdxSIDBStore I WITH (READUNCOMMITTED)
				WHERE	I.SIDBStoreId = @l_SIDBStoreId
		END
		ELSE
			SELECT @chunkCreateTime =  CASE WHEN @l_ddbVerificationLevel = 1 THEN (CASE WHEN LastDataVerificationTime > LastQuickDDBVerificationTime AND @l_isIncr = 1 THEN LastDataVerificationTime ELSE LastQuickDDBVerificationTime END) ELSE  (CASE WHEN (@l_ddbVerificationLevel = 2) THEN LastDDBVerificationTime ELSE LastDataVerificationTime END) END
			FROM	IdxSIDBStore I WITH (READUNCOMMITTED)
			WHERE	I.SIDBStoreId = @l_SIDBStoreId
	END
	IF @l_currentPhase NOT IN (@dedupeValidate, @orphanListing, @defragment) /*DEDUPVALIDATE, ORPHANLISTING, DEFRAGMENT*/
	BEGIN
		IF ((SELECT COUNT(*)
				FROM	(SELECT DISTINCT BackupJobId, CommCellId
						FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
						WHERE	V.adminJobId = @i_adminJobId
								AND V.SrcCopyId = @i_archCopyid
AND ((V.Status = 0)
OR (V.Status = 3 AND (V.SkippedCount < @MAX_FAILURE_COUNT OR V.ExtraFlags & 64 > 0))
OR (V.Status = 5))
						) T
				) >= @l_totalJobsToProcess)
				GOTO FINISH
		WHILE (1 = 1)
		BEGIN
			TRUNCATE TABLE #tempJobs
			TRUNCATE TABLE #tempJobsAF
			INSERT INTO #tempJobs
			SELECT TOP (@l_totalJobsToProcess - @l_currentPopulatedJobCount) JDS.archGrpCopyId, JDS.jobId, JDS.commCellId
			FROM	JMJobDataStats JDS WITH (READUNCOMMITTED)
					INNER JOIN archFile AF WITH (READCOMMITTED) ON JDS.JobId = AF.JobId AND JDS.CommCellId = AF.CommCellid AND JDS.dataType = AF.fileType
					INNER JOIN archFileCopyDedup AFCD WITH (READUNCOMMITTED) ON AF.id = AFCD.archFileId AND AF.CommCellId = AFCD.CommCellId AND JDS.archGrpCopyId = AFCD.archCopyId
					LEFT OUTER JOIN archChunkToVerify2 ACV WITH (READUNCOMMITTED)
								ON	ACV.adminJobId = @i_adminJobId
									AND ACV.BackupJobId = JDS.jobId
									AND ACV.commCellId = JDS.commCellId
									AND ACV.SrcCopyId = JDS.archGrpCopyId
									AND ACV.fileType = JDS.dataType
			WHERE	JDS.archgrpCopyId = @i_archCopyId
					AND AFCD.SIDBStoreId = @l_SIDBStoreId
					AND AFCD.archCopyId = @i_archCopyId
					AND JDS.Status = 100
AND JDS.disabled & 256 = 0
					AND JDS.copiedTime < @l_jobStartTime
					AND ((JDS.copiedTime > @chunkCreateTime) OR
							(JDS.archCheckStatus IN (3/*ACS_TOBECHECKED*/,4/*ACS_PARTCHECKED*/)))
					AND ACV.adminJobId IS NULL
					AND JDS.jobId > @l_lastPopulatedJobId
			GROUP BY JDS.archGrpCopyId, JDS.commCellId, JDS.jobId
			ORDER BY JDS.JobId, JDS.CommCellId
			SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
			IF  @retVal <> 0 GOTO FINISH
			IF @rowCount = 0 BREAK
			INSERT INTO #tempJobsAF
			SELECT	AF.id, AF.CommCellId, JDS.archGrpCopyId, AF.fileType, AF.AppId
			FROM	#tempJobs J
					INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED)  ON J.JobId = JDS.JobId AND J.commCellId = JDS.commCellId AND j.archCopyId = JDS.archGrpCopyId
					INNER JOIN archFile AF WITH (READUNCOMMITTED) ON JDS.JobId = AF.JobId AND JDS.CommCellId = AF.CommCellId AND JDS.dataType = AF.fileType
			WHERE	JDS.Status = 100
					AND JDS.copiedTime < @l_jobStartTime
					AND ((JDS.copiedTime > @chunkCreateTime) OR
							(JDS.archCheckStatus IN (3/*ACS_TOBECHECKED*/,4/*ACS_PARTCHECKED*/)))
			SET @retVal = @@ERROR
			IF  @retVal <> 0 GOTO FINISH
			INSERT	INTO archChunkToVerify2 (AdminJobId, BackupJobId, ArchFileId, CommCellId, ArchChunkId, ChunkCommCellId, ChunkNumber, lastChunkNumber,
					ArchGroupId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum,
					PhysicalStartOffset, PhysicalOffset, LogicalOffset, PhysicalSize, LogicalSize, unCompBytesSize,
					VolumeId, MediaId, MediaGroupId, MediaType,
					SrcMAId, SrcDrivePoolId,
					Status, Modified, SkippedReason, SkippedCount, SkippedForSeconds, ErrorCode,
					appId, fileType, archFileCopyFlags, encKeyType, fileMarkerNo,
					chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey, archFileEncKey,
					extraFlags, segmentId, IsParallelCopy, streamReaderID)
			SELECT	DISTINCT
					@i_adminJobId, ACM.JobId, ACM.ArchFileId, ACM.CommCellId, ACM.ArchChunkId, ACM.ChunkCommCellId, ACM.ChunkNumber, 0,
					AGC.archGroupId, ACM.archCopyId, 0, 0, 0,
					0 /*PhysicalStartOffset*/, ACM.PhysicalOffset, ACM.LogicalOffset, ACM.PhysicalSize, ACM.LogicalSize, ACM.unCompSize,
					AC.VolumeId, 0, 0, 0,
					0, 0,
					0, @l_currentTime, 0, 0, 0, 0,
					AF.appId, AF.fileType, 0, 0, AC.fileMarkerNo,
					AC.createTime, AC.version, AC.physicalSize, AC.logicalSize, AC.hwEncKey, '',
					0, 0, 0, 0
			FROM	#tempJobsAF AF
					INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AF.archFileId = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.archCopyId = ACM.archCopyId
					INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON ACM.archChunkId = AC.id AND ACM.ChunkCommCellId = AC.CommCellId
					INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AGC.id = ACM.archCopyId
			WHERE	ACM.physicalSize > 0
AND (((AC.flags & (2048)) = 0 AND ACM.chunkNumber > 0) OR (AC.createTime < (@l_currentTime - 24 * 60 * 60)))
AND (ACM.flags & 256) = 0
			SELECT	@retVal = @@ERROR, @l_insertedChunksCount = @l_insertedChunksCount + @@rowCount
			IF  @retVal <> 0 GOTO FINISH
			UPDATE	V
			SET		mediaId = MV.MediaId, mediaGroupId = MV.MediaGroupId
			FROM	archChunkToVerify2 V, MMVolume MV WITH (READUNCOMMITTED)
			WHERE	V.adminJobId = @i_adminJobId
				AND V.SrcCopyid = @i_archCopyid
				AND V.volumeId = MV.VolumeId
			SET @retVal = @@ERROR
			IF  @retVal <> 0 GOTO FINISH
			UPDATE	archChunkToVerify2
			SET		SrcStreamNum = b.streamNum, archFileCopyFlags = b.flags, lastChunkNumber = b.lastChunkNumber, encKeyType = b.encKeyType, archFileEncKey = b.encKey
			FROM	archChunkToVerify2 a, archFileCopy b WITH (READUNCOMMITTED)
			WHERE	a.adminJobId = @i_adminJobId
				AND a.SrcCopyid = @i_archCopyid
				AND b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.SrcCopyId
			SET @retVal = @@ERROR
			IF  @retVal <> 0 GOTO FINISH
			SELECT  @l_currentPopulatedJobCount += COUNT(*)
			FROM	(SELECT DISTINCT BackupJobId, CommCellId
					FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
					WHERE	V.adminJobId = @i_adminJobId
							AND V.SrcCopyId = @i_archCopyid
							AND V.BackupJobId > @l_lastPopulatedJobId) T
			SET @retVal = @@ERROR
			IF  @retVal <> 0 GOTO FINISH
			SELECT	@l_lastPopulatedJobId = ISNULL(MAX(JobId), @l_lastPopulatedJobId)
			FROM	#tempJobs J
			IF(@retVal = 0 AND (@l_SIDBStoreId = 0 OR @l_ddbVerificationLevel IN (1,3))) --TMMsg::DDBVerificationLevel_DDB_AND_DATA_VERIFICATION
			BEGIN
				UPDATE	JDS
SET		disabled  = (disabled  & ~2048),
						archCheckStatus = (CASE WHEN (@l_SIDBStoreId > 0 AND @l_ddbVerificationLevel  IN (1,3) AND @l_currentPhase = @dataValidate AND JDS.archCheckEndTime < @l_jobStartTime) THEN 3 /*ACS_TOBECHECKED*/ ELSE archCheckStatus END)
				FROM	JMJobDataStats JDS
						INNER JOIN #tempJobs J ON JDS.JobId = J.JobId AND JDS.CommCellId = JDS.CommCellId AND JDS.archGrpCopyId = J.archCopyId ,
(SELECT DISTINCT backupJobId, SrcCopyId, commCellId, fileType FROM archChunkToVerify2  WHERE adminJobId = @i_adminJobId AND Status = 0) ACV
				WHERE	JDS.archGrpCopyId = ACV.SrcCopyId AND JDS.commCellId = ACV.commCellId
						AND JDS.jobId = ACV.backupJobId AND JDS.dataType = ACV.fileType
						AND JDS.archCheckEndTime <= @l_jobStartTime
				IF (@l_SIDBStoreId > 0 AND @l_ddbVerificationLevel IN (1,3) AND @l_currentPhase = @dataValidate)
				BEGIN
					UPDATE	ACM
SET		flags = ((flags & (~255)) | 1)
					FROM	archChunkMapping ACM, archChunkToVerify2 ACV
					WHERE	ACV.adminJobId = @i_adminJobId
							AND ACM.archChunkId = ACV.archChunkId
							AND ACM.archFileId = ACV.archFileId
							AND ACM.commCellId = ACV.CommCellid
AND ACV.Status = 0
				END
			END
			IF ((SELECT COUNT(*)
				FROM	(SELECT DISTINCT BackupJobId, CommCellId
						FROM	archChunkToVerify2 V WITH (READUNCOMMITTED)
						WHERE	V.adminJobId = @i_adminJobId
								AND V.SrcCopyId = @i_archCopyid
AND ((V.Status = 0)
OR (V.Status = 3 AND (V.SkippedCount < @MAX_FAILURE_COUNT OR V.ExtraFlags & 64 > 0))
OR (V.Status = 5))
						) T
				) >= @l_totalJobsToProcess OR (@l_totalJobsToProcess = 2147483647))
				BREAK
		END
	END
	ELSE
	BEGIN
		IF ( @l_currentPhase = @dedupeValidate/*DEDUPVALIDATE*/)
			AND NOT	EXISTS (	SELECT	TOP 1 1
					FROM	archChunk AC WITH (READUNCOMMITTED), MMVolume MV WITH (READUNCOMMITTED)
					WHERE	AC.VolumeId = MV.VolumeId AND AC.createTime > @chunkCreateTime AND MV.SIDBStoreId = @l_SIDBStoreId)
		BEGIN
			SET	@l_insertedChunksCount = 0
		END
		ELSE
			SET	@l_insertedChunksCount = 1
	END
IF ((@JMDVFlag & 2) = 0)
	BEGIN
		IF (@l_ddbVerificationLevel IN (1, 2, 3) /* QUICK_DDB_VERIFICATION, DDB_VERIFICATION, DDB_AND_DATA_VERIFICATION*/)
		BEGIN
			IF (@l_currentPhase = @dedupeValidate/*DEDUPVALIDATE*/)
			BEGIN
				IF (EXISTS(SELECT * FROM @returnTable WHERE allowBackup = 0))
				BEGIN
					UPDATE	I
					SET		LastDDBVerificationTime = 0, LastDataVerificationTime = 0, LastQuickDDBVerificationTime = 0
					FROM	IdxSIDBStore I
					WHERE	I.SIDBStoreId = @l_SIDBStoreId
				END
				IF (@l_isIncr = 0)
				BEGIN
					IF (@l_ddbVerificationLevel IN (2)) /*DDB_VERIFICATION*/
						UPDATE	I
						SET		LastDDBVerificationTime = 0
						FROM	IdxSIDBStore I
						WHERE	I.SIDBStoreId = @l_SIDBStoreId
					ELSE IF (@l_ddbVerificationLevel IN (3))/*DDB_AND_DATA_VERIFICATION*/
						UPDATE	I
						SET		LastDDBVerificationTime = 0, LastDataVerificationTime = 0
						FROM	IdxSIDBStore I
						WHERE	I.SIDBStoreId = @l_SIDBStoreId
					ELSE IF (@l_ddbVerificationLevel IN (1))/*QUICK_DDB_VERIFICATION*/
						UPDATE	I
						SET		LastQuickDDBVerificationTime = 0
						FROM	IdxSIDBStore I
						WHERE	I.SIDBStoreId = @l_SIDBStoreId
				END
			END
SET @JMDVFlag |= 2
		END
	END
END
UPDATE	archChunkToVerify2
SET		MediaType = MediaTypeId
FROM	archChunkToVerify2 a, MMMedia b WITH (READUNCOMMITTED)
WHERE	a.adminJobId = @i_adminJobId
	AND a.SrcCopyid = @i_archCopyid
	AND a.MediaId = b.MediaId
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
SET @retVal = @@ERROR
IF OBJECT_ID('tempdb.dbo.#tempJobsInput') IS NOT NULL DROP TABLE #tempJobsInput
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT	DISTINCT backupJobId, CommCellId, 0, 0, 0
FROM archChunkToVerify2
WHERE	adminJobId = @i_adminJobId
		AND SrcCopyId = @i_archCopyId
		AND unCompBytesSize = -1
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
EXEC  @retVal = archGetJobSizeInfo 0
UPDATE	archChunkToVerify2
SET		unCompBytesSize = (CASE WHEN totalBackupSize > 0 THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
FROM	#tmpJobSizeInfo J
WHERE	adminJobId = @i_adminJobId
		AND SrcCopyId = @i_archCopyId
		AND archChunkToVerify2.backupJobId = J.JobId
		AND archChunkToVerify2.CommCellId = J.CommCellId
		AND archChunkToVerify2.unCompBytesSize = -1
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	archChunkToVerify2 R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.adminJobId = @i_adminJobId
		AND M.MediaTypeId != 10001
		AND R.MediaId = M.MediaId
		AND R.chunkHwEncKey = ''
		AND	R.ArchChunkId = chunk.Id
		AND	R.ChunkCommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
MERGE #tempJobsToProcess Target
USING	(SELECT @i_archCopyId archCopyId, @l_lastPopulatedJobId jobId) AS Source
ON (Target.archCopyId = Source.archCopyId)
WHEN MATCHED THEN
	UPDATE SET	Target.JobId = Source.jobId
WHEN NOT MATCHED THEN
	INSERT (archCopyId, jobId)
	VALUES (Source.archCopyId, Source.jobId);
SET @l_xmlLastPopulatedJobIdList =	(SELECT	JobId AS '@j', archCopyId AS '@cp'
					FROM	#tempJobsToProcess
					ORDER BY archCopyId, JobId
					FOR XML PATH('I'), ROOT('JobIds'))
MERGE  JMJobOptions as jobOptions
USING	(SELECT @i_adminJobId as inJobID, 2 as commCellID ,90 as attrid, 'Last Job Populated to Data Verification' as attributeName) as src
ON jobOptions.commCellId = src.commCellID AND jobOptions.jobId = src.inJobID AND jobOptions.attributeId = src.attrid AND jobOptions.attributeName = src.attributeName
WHEN MATCHED THEN
	UPDATE SET attributeValue =  ISNULL(CAST(@l_xmlLastPopulatedJobIdList AS VARCHAR(MAX)),'')
WHEN NOT MATCHED THEN
    INSERT(jobId,commCellId,attributeId,attributeName,attributeValueInt,attributeValue)
	VALUES (Src.inJobID, src.commCellID, Src.attrid, Src.attributeName, 0,ISNULL(CAST(@l_xmlLastPopulatedJobIdList AS VARCHAR(MAX)), ''));
IF  EXISTS (SELECT 1 FROM JMMisc WHERE jobId = @i_adminJobId AND commCellId = 2 AND itemType = 78)
BEGIN
	UPDATE	JMMisc
	SET		intData |= @JMDVFlag
	WHERE	jobId = @i_adminJobId
AND commCellId = 2
AND itemType = 78
			AND (intData & @JMDVFlag) != @JMDVFlag
END
ELSE
BEGIN
INSERT INTO JMMisc (jobId, selfRefId, itemType, attribute, intData, data, commCellId) VALUES (@i_adminJobId, 0, 78, 0, @JMDVFlag, '', 2)
END
FINISH:
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF OBJECT_ID('tempdb.dbo.#tempJobs') IS NOT null DROP TABLE #tempJobs
IF OBJECT_ID('tempdb.dbo.#tempJobsAF') IS NOT null DROP TABLE #tempJobsAF
IF OBJECT_ID('tempdb.dbo.#tempJobsToProcess') IS NOT null DROP TABLE #tempJobsToProcess
IF  @retVal = 0
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
SELECT @retVal, @l_insertedChunksCount
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerify2Insert')
	delete from GxQscripts where name = 'archChunkToVerify2Insert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2Insert')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2Insert'
GO

insert into GXDBVersions values(2, 'archChunkToVerify2Insert',  '00010008000200140000', 'archChunkToVerify2Insert', '00010008000200140000')
GO

