

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archChunkToVerify2HandleFailedReportStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archChunkToVerify2HandleFailedReportStatus.sp,v $ $Id: archChunkToVerify2HandleFailedReportStatus.sp,v 1.5.12.5 2020/09/26 02:33:42 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archChunkToVerify2HandleFailedReportStatus')
BEGIN
	print '>>> Drop Stored Procedure: archChunkToVerify2HandleFailedReportStatus <<<'
	drop procedure archChunkToVerify2HandleFailedReportStatus
END
IF EXISTS (select * from GxQscripts where name='archChunkToVerify2HandleFailedReportStatus')
	delete from GxQscripts where name = 'archChunkToVerify2HandleFailedReportStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2HandleFailedReportStatus')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2HandleFailedReportStatus'
GO
print '... Creating Procedure: archChunkToVerify2HandleFailedReportStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archChunkToVerify2HandleFailedReportStatus
  @i_adminJobId int,
  @i_chunkId bigint,
  @i_chunkCommCellId int,
  @i_srcCopyId int,
  @i_srcStreamNum int,
  @i_readerId int,
  @i_errorCode int,
  @i_mmErrorCode int,
  @i_type int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(2048);
  DECLARE @o_barcode varchar(256);
  DECLARE @o_libraryName NVARCHAR(128);
  DECLARE @o_mediaTypeId integer;
  DECLARE @o_mountPathName NVARCHAR(1024); 
  DECLARE @o_policyName NVARCHAR(144);
  DECLARE @o_copyName NVARCHAR(64);
  DECLARE @o_mediaAgentName NVARCHAR(255);
  DECLARE @o_jobIdString varchar(1024);
SET NOCOUNT ON
DECLARE @error			integer = 0
DECLARE @errorString	varchar(1024) = ''
DECLARE @barcode		varchar(256) = ''
DECLARE @libraryName	NVARCHAR(128) = ''
DECLARE @mediaTypeId	integer = 0
DECLARE @mountPathName	NVARCHAR(1024) = ''
DECLARE @policyName		NVARCHAR(144) = ''
DECLARE @copyName		NVARCHAR(64) = ''
DECLARE @mediaAgentName	NVARCHAR(255) = ''
DECLARE @jobIdString	varchar(1024) = ''
DECLARE @srcMAId		integer = 0
DECLARE @srcDPId		integer = 0
DECLARE @segmentId		integer = 0
DECLARE @segmentIdFromStream		integer = 0
DECLARE	@volumeId integer = 0
DECLARE	@mediaId integer = 0
DECLARE	@skipSourceMedia INTEGER = 0
DECLARE @jobId INTEGER = 0
DECLARE @commCellid INTEGER = 0
DECLARE @retCode INTEGER = 0
DECLARE @l_SIDBStoreId INTEGER = dbo.GetOptionInt(229570007, @i_adminJobId, 0, 0)
DECLARE @l_archCheckJobOptions INTEGER = dbo.GetOptionInt(1296526582, @i_adminJobId, 0, 0)
DECLARE @l_archCheckOptions INTEGER = (CASE WHEN @l_archCheckJobOptions = 1 THEN (1 | 8)
WHEN @l_archCheckJobOptions = 2 THEN (8)
WHEN @l_archCheckJobOptions = 0 THEN (1)
										   ELSE 0
									  END)
IF OBJECT_ID('tempdb.dbo.#UpdatedChunks') IS NOT NULL DROP TABLE #UpdatedChunks
CREATE TABLE #UpdatedChunks (AdminJobId			integer,
							ArchFileId			integer,
							CommCellId			integer,
							ArchChunkId			bigint,
							ChunkCommCellId		integer,
							SrcCopyId			integer,
							PhysicalSize		bigint,
							unCompBytesSize		bigint
							PRIMARY KEY (archChunkId, archFileId, commCellId, chunkCommcellId)
							WITH (IGNORE_DUP_KEY = ON))
IF OBJECT_ID('tempdb.dbo.#tblChunksToReset') IS NOT NULL DROP TABLE #tblChunksToReset
CREATE TABLE  #tblChunksToReset  (segmentId integer, ArchChunkId BIGINT, ChunkCommCellId integer, ArchFileId integer, CommCellId integer)
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS	INT = 60
SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 10)
DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS	INT = 10
SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
SELECT	@srcMAId	= SrcMAId,
		@srcDPId	= SrcDrivePoolId,
		@segmentIdFromStream = S.SegmentId
FROM	ArchJobStreamStatus S  WITH (NOLOCK)
WHERE	S.JobId = @i_adminJobId
		AND S.SrcCopyId = @i_srcCopyId
		AND S.SrcStreamNum = @i_srcStreamNum
		AND S.StreamReaderId = @i_readerId
SELECT	TOP 1 @segmentId = segmentId
FROM	archChunkToVerify2 WITH (NOLOCK)
WHERE	adminJobId = @i_adminJobId
		AND archChunkId = @i_chunkId
		AND chunkCommCellId = @i_chunkCommCellId
		AND SrcCopyId = @i_srcCopyId
IF EXISTS (SELECT * FROM MMConfigs  WITH (NOLOCK) WHERE	name = 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA' and Value > 0)
	SET	@skipSourceMedia = 1
SELECT	@mediaAgentName = name
FROM	APP_Client C  WITH (NOLOCK)
WHERE	C.Id = @srcMAId
IF (@skipSourceMedia = 1
AND 273 = @i_mmErrorCode
	AND	EXISTS (SELECT	1
			FROM	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
			WHERE	DP.DrivePoolId = @srcDPId
					AND DP.MasterPoolId = MP.MasterPoolId
					AND MP.LibraryId = L.LibraryId
AND L.LibraryTypeId NOT IN (4, 5)))
SET @i_errorCode = 0x10;
IF OBJECT_ID('tempdb.dbo.#archFileToSkip') IS NOT NULL DROP TABLE #archFileToSkip
CREATE TABLE  #archFileToSkip  (archFileId integer, commCellId integer, minChunkNumber integer, backupJobId integer, segmentId integer, StreamReaderId integer PRIMARY KEY (archfileId, CommCellId, backupJobid))
-- if chunk is corrupted mark the job as bad on (@i_mmErrorCode != E_MM_ERROR_PATH_NOT_FOUND AND @i_mmErrorCode != E_MM_ERROR_FILE_NOT_FOUND ) or  CVA_DV_FAILED_NON_CORRUPT_ERROR
INSERT INTO #archFileToSkip
SELECT	V.archFileId, V.CommCellId, MIN(V.chunkNumber), V.BackupJobId, MIN(V.SegmentId), MIN(V.StreamReaderId)
FROM	ArchChunkToVerify2 V WITH (READUNCOMMITTED)
WHERE	V.adminJobId = @i_adminJobId
		AND V.archChunkId = @i_chunkId
		AND V.chunkCommCellId = @i_chunkCommCellId
		AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
GROUP BY V.archFileId, V.CommCellId, V.BackupJobId
IF( @i_mmErrorCode = 30017 OR @i_mmErrorCode = 30032 OR
@i_mmErrorCode = 30074   OR @i_mmErrorCode = 1208 OR
@i_mmErrorCode = 65103  OR
((@i_mmErrorCode >= 68005) AND (@i_mmErrorCode <= 68013)) OR
(@i_type = 6 AND (@i_mmErrorCode = 993 OR @i_mmErrorCode = 1005 )) )
BEGIN
	-- Mark the chunks as failed with MMErrorCode
	-- Mark the job as bad on JMJobDataStats table based on config param
IF (@i_type != 6)
	BEGIN
		UPDATE	V
SET		Status = 4,
				ErrorCode = @i_mmErrorCode,
				Modified = @now
		OUTPUT  INSERTED.adminJobId, INSERTED.archFileId, INSERTED.commCellId, INSERTED.archChunkId, INSERTED.chunkCommCellId, INSERTED.SrcCopyId,
			INSERTED.PhysicalSize, INSERTED.unCompBytesSize
		INTO	#UpdatedChunks
		FROM	ArchChunkToVerify2 V, #archFileToSkip S
		WHERE	V.adminJobId = @i_adminJobID
				--AND V.backupJobId = S.backupJobId
				AND V.archFileId = S.archFileId
				AND V.CommCellId = S.commCellId
				AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
	END
	ELSE
	BEGIN
		UPDATE	V
SET		Status = 4,
				ErrorCode = @i_mmErrorCode,
				Modified = @now
		OUTPUT  INSERTED.adminJobId, INSERTED.archFileId, INSERTED.commCellId, INSERTED.archChunkId, INSERTED.chunkCommCellId, INSERTED.SrcCopyId,
			INSERTED.PhysicalSize, INSERTED.unCompBytesSize
		INTO	#UpdatedChunks
		FROM	ArchChunkToVerify2 V
		WHERE	V.adminJobId = @i_adminJobID
				AND V.archChunkId = @i_chunkId
				AND V.chunkCommCellId = @i_chunkCommCellId
				AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
	END
IF (@i_mmErrorCode != 993 AND @i_mmErrorCode != 1005 )
	BEGIN
		IF EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'MMS2_CONFIG_STRING_MARK_JOBS_BAD' AND Value = 1)
		BEGIN
			UPDATE	J
SET		disabled |= (64 | 1)
			FROM	JMJobDataStats J, #archFileToSkip S
			WHERE	J.JobID = S.backupJobId
					AND J.CommCellId = S.CommCellId
					AND J.archGrpCopyId = @i_SrcCopyId
			DECLARE BadJobsCursor CURSOR
				FOR SELECT	DISTINCT backupJobId, CommCellId
					FROM	#archFileToSkip
			OPEN BadJobsCursor
			FETCH NEXT FROM BadJobsCursor INTO @jobId, @commCellid
			WHILE @@FETCH_STATUS = 0
			BEGIN
				EXEC @retCode = archDisallowJobForCopy @jobId, @commCellid, @i_SrcCopyId, @now
IF (@i_type != 6)
				BEGIN
						UPDATE	archChunkToVerify2
SET		Status = 4,
								ErrorCode = @i_mmErrorCode,
								Modified = @now
						OUTPUT  INSERTED.adminJobId, INSERTED.archFileId, INSERTED.commCellId, INSERTED.archChunkId, INSERTED.chunkCommCellId, INSERTED.SrcCopyId,
							INSERTED.PhysicalSize, INSERTED.unCompBytesSize
						INTO	#UpdatedChunks
						WHERE	adminJobId = @i_adminJobId
								AND backupJobId = @jobId
								AND commCellId = @commCellid
								AND SrcCopyId = @i_srcCopyId
				END
				FETCH NEXT FROM BadJobsCursor INTO @jobId, @commCellid
			END
			CLOSE BadJobsCursor
			DEALLOCATE BadJobsCursor
		END
	END
ELSE IF (@i_mmErrorCode = 993 OR @i_mmErrorCode = 1005 )
	BEGIN
			UPDATE	J
SET		disabled |= (2048)
			FROM	JMJobDataStats J, #archFileToSkip S
			WHERE	J.JobID = S.backupJobId
					AND J.CommCellId = S.CommCellId
					AND J.archGrpCopyId = @i_SrcCopyId
IF (@i_type != 6)
			BEGIN
				DECLARE BadJobsCursor CURSOR
					FOR SELECT	DISTINCT backupJobId, CommCellId
						FROM	#archFileToSkip
				OPEN BadJobsCursor
				FETCH NEXT FROM BadJobsCursor INTO @jobId, @commCellid
				WHILE @@FETCH_STATUS = 0
				BEGIN
					UPDATE	archChunkToVerify2
SET		Status = 4,
							ErrorCode = @i_mmErrorCode,
							Modified = @now
					OUTPUT  INSERTED.adminJobId, INSERTED.archFileId, INSERTED.commCellId, INSERTED.archChunkId, INSERTED.chunkCommCellId, INSERTED.SrcCopyId,
						INSERTED.PhysicalSize, INSERTED.unCompBytesSize
					INTO	#UpdatedChunks
					WHERE	adminJobId = @i_adminJobId
							AND backupJobId = @jobId
							AND commCellId = @commCellid
							AND SrcCopyId = @i_srcCopyId
					FETCH NEXT FROM BadJobsCursor INTO @jobId, @commCellid
				END
				CLOSE BadJobsCursor
				DEALLOCATE BadJobsCursor
			END
	END
	UPDATE	ACM
SET		flags = ((flags & (~255)) | 4)
	FROM	archChunkMapping ACM, #UpdatedChunks UC
	WHERE	ACM.archChunkId = UC.archChunkId
			AND ACM.chunkCommCellId = UC.chunkCommCellId
			AND ACM.archFileId = UC.archFileId
			AND ACM.commCellId = UC.commCellId
			AND ACM.archCopyId = UC.SrcCopyId
			AND (@l_SIDBStoreId != 0 OR (@l_archCheckOptions & flags) != 0)
END
ELSE IF (@i_mmErrorCode = 68041)
BEGIN
	UPDATE	V
SET		Status = 4,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	OUTPUT  INSERTED.adminJobId, INSERTED.archFileId, INSERTED.commCellId, INSERTED.archChunkId, INSERTED.chunkCommCellId, INSERTED.SrcCopyId,
		INSERTED.PhysicalSize, INSERTED.unCompBytesSize
	INTO	#UpdatedChunks
	FROM	ArchChunkToVerify2 V, #archFileToSkip S
	WHERE	V.adminJobId = @i_adminJobID
			--AND V.backupJobId = S.backupJobId
			AND V.archFileId = S.archFileId
			AND V.CommCellId = S.commCellId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
	UPDATE	archChunkMapping
SET		flags = ((flags & (~255)) | 4)
	FROM	archChunkMapping ACM, #UpdatedChunks UC
	WHERE	ACM.archChunkId = UC.archChunkId
			AND ACM.chunkCommCellId = UC.chunkCommCellId
			AND ACM.archFileId = UC.archFileId
			AND ACM.commCellId = UC.commCellId
			AND ACM.archCopyId = UC.SrcCopyId
			AND (@l_SIDBStoreId != 0 OR (@l_archCheckOptions & flags) != 0)
	UPDATE	J
	SET		archCheckStatus = 3, /*ACS_TOBECHECKED*/
			archCheckEndTime = @now
	FROM	JMJobDataStats J, #archFileToSkip S
	WHERE	J.JobID = S.backupJobId
			AND J.CommCellId = S.CommCellId
			AND J.archGrpCopyId = @i_SrcCopyId
END
IF (@i_errorCode = 0x6)
BEGIN
	DELETE FROM #UpdatedChunks
	DELETE FROM #archFileToSkip
	INSERT INTO #archFileToSkip
	SELECT	V.archFileId, V.CommCellId, MIN(V.chunkNumber), V.BackupJobId, MIN(V.SegmentId), MIN(V.StreamReaderId)
	FROM	ArchChunkToVerify2 V WITH (READUNCOMMITTED)
	WHERE	V.adminJobId = @i_adminJobId
			AND V.archChunkId = @i_chunkId
			AND V.chunkCommCellId = @i_chunkCommCellId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
	GROUP BY V.archFileId, V.CommCellId, V.BackupJobId
	-- Skip the chunk
	UPDATE	V
SET		Status = 4,
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	OUTPUT  INSERTED.adminJobId, INSERTED.archFileId, INSERTED.commCellId, INSERTED.archChunkId, INSERTED.chunkCommCellId, INSERTED.SrcCopyId,
		INSERTED.PhysicalSize, INSERTED.unCompBytesSize
	INTO	#UpdatedChunks
	FROM	ArchChunkToVerify2 V
	WHERE	V.adminJobId = @i_adminJobId
			AND V.archChunkId = @i_chunkId
			AND V.chunkCommCellId = @i_chunkCommCellId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
	UPDATE	archChunkMapping
SET		flags = ((flags & (~255)) | 4)
	FROM	archChunkMapping ACM, #UpdatedChunks UC
	WHERE	ACM.archChunkId = UC.archChunkId
			AND ACM.chunkCommCellId = UC.chunkCommCellId
			AND ACM.archFileId = UC.archFileId
			AND ACM.commCellId = UC.commCellId
			AND ACM.archCopyId = UC.SrcCopyId
			AND (@l_SIDBStoreId != 0 OR (@l_archCheckOptions & flags) != 0)
END
-- TODO: Skip entire volume and it's AF when you get CVA_AUXCOPY_SOURCE_MEDIA_ERROR
ELSE IF (@i_errorCode = 0x10)
BEGIN
	DELETE FROM #archFileToSkip
	INSERT INTO #archFileToSkip
	SELECT	V.archFileId, V.CommCellId, MIN(V.chunkNumber), V.BackupJobId, MIN(V.SegmentId), MIN(V.StreamReaderId)
	FROM	ArchChunkToVerify2 V WITH (READUNCOMMITTED)
	WHERE	V.adminJobId = @i_adminJobId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
			AND V.VolumeId = (SELECT TOP 1 I.VolumeId FROM 	ArchChunkToVerify2 I WITH (READUNCOMMITTED)
								WHERE	I.adminJobId = @i_adminJobId
									AND I.SrcCopyId = @i_srcCopyId
									AND I.archChunkId = @i_chunkId
									AND I.chunkCommCellId = @i_chunkCommCellId)
	GROUP BY V.archFileId, V.CommCellId, V.BackupJobId
	-- Logic to update the src and dest stream numbers
	-- Volume we are skipping might belong to different segments
	--	1. Segment currently reported error - Skip the chunks and Assign the same src and dest stream number
	--  2. Segments that are assigned to other streams and active - Do not skip chunks or update the src and dest stream number
	--  3. Segments that are not assigned to other streams - Skip the chunks but do not Assign the src and dest stream number
	-- Volume we are skipping might belong to different readers
	--	1. Reader currently reported error - Skip the chunks
	--  2. Other Active Reader - Do not skip chunks
	--  3. Non Active readers or reader id is 0 - Skip the chunks
	--  2. Reader that are assigned to other streams and active - Do not skip chunks
	DELETE FROM #archFileToSkip
	WHERE	StreamReaderId IN (SELECT StreamReaderId FROM ArchJobStreamStatus WHERE JobId = @i_adminJobId AND StreamReaderId != @i_readerId)
	-- Skip the archive files here
	--	1. Reader currently reported error - Skip the chunks
	UPDATE	V
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	FROM	ArchChunkToVerify2 V WITH (NOLOCK), #archFileToSkip S
	WHERE	V.adminJobId = @i_adminJobId
			AND V.archFileId = S.archFileId
			AND V.CommCellId = S.commCellId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
			AND V.StreamReaderId = @i_readerId
	--  3. Segments that are not assigned to other streams - Skip the chunks but do not Assign the src and dest stream number
	UPDATE	V
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	FROM	ArchChunkToVerify2 V, #archFileToSkip S
	WHERE	V.adminJobId = @i_adminJobID
			AND V.archFileId = S.archFileId
			AND V.CommCellId = S.commCellId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
			AND V.StreamReaderId NOT IN (SELECT StreamReaderId FROM ArchJobStreamStatus WHERE JobId = @i_adminJobId AND StreamReaderId = @i_readerId)
END
-- WHEN REPLICATOR CONTROLLER STOPPED OBRUPTLY
ELSE IF (@i_errorCode = 0x3 AND @i_mmErrorCode IN (67001,	67007,
67012, 67013))
BEGIN
	DELETE FROM #archFileToSkip
	INSERT INTO #archFileToSkip
	SELECT	V.archFileId, V.CommCellId, MIN(V.chunkNumber), V.BackupJobId, MIN(V.SegmentId), MIN(V.StreamReaderId)
	FROM	ArchChunkToVerify2 V WITH (READUNCOMMITTED)
	WHERE	V.adminJobId = @i_adminJobId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
			AND (V.SrcStreamNum = @i_srcStreamNum OR V.segmentId = @segmentIdFromStream)
			AND (V.StreamReaderId = @i_readerId OR V.StreamReaderId = 0)
	GROUP BY V.archFileId, V.CommCellId, V.BackupJobId
	-- Skip the archive files here, Update the Src and Dest Stream Number for all chunks getting skipped
	UPDATE	V
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	FROM	ArchChunkToVerify2 V, #archFileToSkip S
	WHERE	V.adminJobId = @i_adminJobID
			-- AND V.backupJobId = S.backupJobId
			AND V.archFileId = S.archFileId
			AND V.CommCellId = S.commCellId
			AND V.srcCopyId = @i_srcCopyId
AND Status IN (0, 1)
END
ELSE IF ((@i_type = 6) AND (@i_errorCode NOT IN (0x1, 0x5, 0x2, 0x3,
0x7, 0x8, 0x9, 0x11)))
BEGIN
	DELETE FROM #archFileToSkip
	INSERT INTO #archFileToSkip
	SELECT	V.archFileId, V.CommCellId, MIN(V.chunkNumber), V.BackupJobId, MIN(V.SegmentId), MIN(V.StreamReaderId)
	FROM	ArchChunkToVerify2 V WITH (READUNCOMMITTED)
	WHERE	V.adminJobId = @i_adminJobId
			AND V.archChunkId = @i_chunkId
			AND V.chunkCommCellId = @i_chunkCommCellId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
	GROUP BY V.archFileId, V.CommCellId, V.BackupJobId
	DELETE FROM #UpdatedChunks
	-- Skip the chunk
	UPDATE	V
SET		Status = 4,
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	OUTPUT  INSERTED.adminJobId, INSERTED.archFileId, INSERTED.commCellId, INSERTED.archChunkId, INSERTED.chunkCommCellId, INSERTED.SrcCopyId,
		INSERTED.PhysicalSize, INSERTED.unCompBytesSize
	INTO	#UpdatedChunks
	FROM	ArchChunkToVerify2 V
	WHERE	V.adminJobId = @i_adminJobId
			AND V.archChunkId = @i_chunkId
			AND V.chunkCommCellId = @i_chunkCommCellId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
	UPDATE	ACM
SET		flags = ((flags & (~255)) | 4)
	FROM	archChunkMapping ACM, #UpdatedChunks UC
	WHERE	ACM.archChunkId = UC.archChunkId
			AND ACM.chunkCommCellId = UC.chunkCommCellId
			AND ACM.archFileId = UC.archFileId
			AND ACM.commCellId = UC.commCellId
			AND ACM.archCopyId = UC.SrcCopyId
			AND (@l_SIDBStoreId != 0 OR (@l_archCheckOptions & flags) != 0)
END
ELSE
BEGIN
	DELETE FROM #archFileToSkip
	INSERT INTO #archFileToSkip
	SELECT	V.archFileId, V.CommCellId, MIN(V.chunkNumber), V.BackupJobId, MIN(V.SegmentId), MIN(V.StreamReaderId)
	FROM	ArchChunkToVerify2 V WITH (READUNCOMMITTED)
	WHERE	V.adminJobId = @i_adminJobId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
			AND V.StreamReaderId = (SELECT TOP 1 I.StreamReaderId FROM 	ArchChunkToVerify2 I WITH (READUNCOMMITTED)
								WHERE	I.adminJobId = @i_adminJobId
									AND I.srcCopyId = @i_srcCopyId
									AND I.archChunkId = @i_chunkId
									AND I.chunkCommCellId = @i_chunkCommCellId)
	GROUP BY V.archFileId, V.CommCellId, V.BackupJobId
	-- Skip the chunk
	UPDATE	V
SET		Status = 3,
			SkippedCount += 1,
			SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
			SkippedReason = @i_errorCode,
			ErrorCode = @i_mmErrorCode,
			Modified = @now
	FROM	ArchChunkToVerify2 V, #archFileToSkip S
	WHERE	V.adminJobId = @i_adminJobId
			AND V.archFileId = S.archFileId
			AND V.CommCellId = S.commCellId
			AND V.SrcCopyId = @i_srcCopyId
AND V.Status IN (0, 1)
END
-- SET @jobIdString = ' Backup Job ['
-- SELECT	@jobIdString = @jobIdString + ' ' + CAST(backupJobId AS VARCHAR(10))
-- FROM	(SELECT DISTINCT backupJobId, CommCellId FROM #archFileToSkip) S
-- ORDER BY backupJobId, CommCellId
-- SET		@jobIdString += ' ]'
SELECT	TOP 1 @volumeId = VolumeId, @mediaId = mediaId, @mediaTypeId = MediaType
FROM	ArchChunkToVerify2 WITH (NOLOCK)
WHERE	adminJobId = @i_adminJobId
		AND archChunkId = @i_chunkId
		AND chunkCommCellId = @i_chunkCommCellId
		AND srcCopyId = @i_srcCopyId
-- SELECT	@jobIdString = @jobIdString + (CASE WHEN (LEN(@JobIdString) > 0) THEN ', ' ELSE '' END) + CAST(backupJobId AS varchar(10))
-- FROM	(SELECT DISTINCT TOP 50  BackupJobId FROM #archFileToSkip) T
SELECT	@jobIdString = @jobIdString + (CASE WHEN (LEN(@JobIdString) > 0) THEN ', ' ELSE '' END) + CAST(backupJobId AS varchar(10))
FROM	ArchChunkToVerify2 WITH (NOLOCK)
WHERE	adminJobId = @i_adminJobId
		AND archChunkId = @i_chunkId
		AND chunkCommCellId = @i_chunkCommCellId
		AND srcCopyId = @i_srcCopyId
SET	 @jobIdString = ' Backup Job [' + @jobIdString + ']'
SELECT	@barCode = barcode, @libraryName = L.AliasName
FROM	MMMedia M WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
WHERE	M.MediaId = @mediaId
		AND M.LibraryId = L.LibraryId
SELECT	@policyName = AG.name, @copyName = AGC.name
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = AGC.archGroupId
		AND AGC.id = @i_srcCopyId
IF (@mediaTypeId = 10001)
BEGIN
	SELECT	@barCode = VolumeName
	FROM	MMVolume
	WHERE	VolumeId = @volumeId
	SELECT	@mountPathName = MountPathName
	FROM	MMS2getMountPathNameGUIView
	WHERE	MediaId = @mediaId
END
-- Move the chunks in sent state back to populated state to send them again
INSERT INTO #tblChunksToReset -- fetching all the remaining clustered index columns so that SQL server doesn't over shoots the page locks for read
SELECT /*AdminJobId, SrcCopyId,*/ segmentId, ArchChunkId, ChunkCommCellId, ArchFileId, CommCellId
FROM	ArchChunkToVerify2 V WITH (READUNCOMMITTED)
WHERE	V.adminJobId = @i_adminJobId
		AND V.srcCopyId = @i_srcCopyId
		AND V.SrcStreamNum = @i_srcStreamNum
		AND V.StreamReaderId = @i_readerId
AND V.Status = 1
--AND @i_type = 6
UPDATE	ArchChunkToVerify2
SET		Status = 0
FROM	ArchChunkToVerify2 V, #tblChunksToReset t
WHERE	V.adminJobId = @i_adminJobId
		AND V.srcCopyId = @i_srcCopyId
		AND V.SrcStreamNum = @i_srcStreamNum
		AND V.StreamReaderId = @i_readerId
AND V.Status = 1
		AND t.segmentId = V.segmentId AND t.archCHunkId = V.archChunkId AND t.chunkCommCellId = V.ChunkCommCellId AND t.archFileId = V.archFileId AND t.commCellId = V.commCellId
SELECT	@error, @errorString, @barcode, @libraryName, @mediaTypeId, @mountPathName,
		@policyName, @copyName, @mediaAgentName, @jobIdString
IF OBJECT_ID('tempdb.dbo.#archFileToSkip') IS NOT NULL DROP TABLE #archFileToSkip
IF OBJECT_ID('tempdb.dbo.#UpdatedChunks') IS NOT NULL DROP TABLE #UpdatedChunks
IF OBJECT_ID('tempdb.dbo.#tblChunksToReset') IS NOT NULL DROP TABLE #tblChunksToReset
GO

IF EXISTS (select * from GxQscripts where name = 'archChunkToVerify2HandleFailedReportStatus')
	delete from GxQscripts where name = 'archChunkToVerify2HandleFailedReportStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archChunkToVerify2HandleFailedReportStatus')
	delete from GXDBVersions where aliasname = 'archChunkToVerify2HandleFailedReportStatus'
GO

insert into GXDBVersions values(2, 'archChunkToVerify2HandleFailedReportStatus',  '00010005001200050000', 'archChunkToVerify2HandleFailedReportStatus', '00010005001200050000')
GO

